/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import spacecraftEditor.SourceTableListEditPanel;
import spacecraftEditor.SourcesTableModel;

public class SpacecraftEditPanel
extends JPanel
implements ActionListener,
ItemListener,
FocusListener,
MouseListener {
    JTextField id;
    JTextField displayName;
    JTextField name;
    JTextField series;
    JComboBox<String> priority;
    JComboBox<String> layoutType;
    JTextField telemetryDownlinkFreqkHz;
    JTextField minFreqBoundkHz;
    JTextField maxFreqBoundkHz;
    JTextField rssiLookUpTableFileName;
    JTextField ihuTempLookUpTableFileName;
    JTextField ihuVBattLookUpTableFileName;
    JTextField BATTERY_CURRENT_ZERO;
    JTextField mpptResistanceError;
    JTextField mpptSensorOffThreshold;
    JTextField memsRestValueX;
    JTextField memsRestValueY;
    JTextField memsRestValueZ;
    JTextField[] T0;
    JTextField localServer;
    JTextField localServerPort;
    JTextField IHU_SN;
    JTextField model;
    JCheckBox[] sendLayoutToServer;
    JCheckBox hasImprovedCommandReceiver;
    JCheckBox hasImprovedCommandReceiverII;
    JCheckBox hasModeInHeader;
    JCheckBox hasFrameCrc;
    JCheckBox hasGPSTime;
    JCheckBox useGPSTimeForT0;
    JTextArea taDesc;
    JCheckBox useIHUVBatt;
    JCheckBox track;
    JCheckBox hasFOXDB_V3;
    JCheckBox useConversionCoeffs;
    JComboBox<String> cbMode;
    JComboBox<String> cbModel;
    JComboBox<String>[] cbExperiments;
    JButton btnCancel;
    JButton btnSave;
    Spacecraft sat;
    JPanel leftSourcesPanel;
    JPanel leftPanel;
    JPanel rightPanel;
    public int sourceFormatSelected = 0;
    int headerSize = 12;

    public SpacecraftEditPanel(Spacecraft sat) {
        this.sat = sat;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 0));
        this.leftPanel = this.addLeftPanel();
        this.add((Component)this.leftPanel, "West");
        this.rightPanel = this.addRightPanel();
        this.add((Component)this.rightPanel, "Center");
        JPanel footer = this.bottomPanel();
        this.add((Component)footer, "South");
    }

    private JPanel addTitlePanel() {
        JPanel mainTitlePanel = new JPanel();
        mainTitlePanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        mainTitlePanel.add((Component)titlePanel, "West");
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        JPanel titlePanel0 = new JPanel();
        titlePanel.add((Component)titlePanel0, "North");
        titlePanel0.setLayout(new FlowLayout(0));
        JPanel titlePanel1 = new JPanel();
        titlePanel.add((Component)titlePanel1, "North");
        titlePanel1.setLayout(new BoxLayout(titlePanel1, 1));
        JPanel titlePanel2 = new JPanel();
        titlePanel.add((Component)titlePanel2, "North");
        titlePanel2.setLayout(new FlowLayout(0));
        TitledBorder heading0 = SpacecraftEditPanel.title("Identification");
        titlePanel.setBorder(heading0);
        this.id = this.addSettingsRow(titlePanel0, 6, "Sat ID", "This number is sent in the header of all telemetry frames", "" + this.sat.foxId);
        titlePanel0.add(this.id);
        JLabel lblPriority = new JLabel("    Priority");
        titlePanel0.add(lblPriority);
        String tip = "The highest priority spacecraft is tracked if more than one is above the horizon";
        lblPriority.setToolTipText(tip);
        String[] nums = new String[20];
        int i = 0;
        while (i < nums.length) {
            nums[i] = "" + i;
            ++i;
        }
        this.priority = new JComboBox<String>(nums);
        this.priority.setSelectedIndex(this.sat.user_priority);
        titlePanel0.add(this.priority);
        this.name = this.addSettingsRow(titlePanel1, 8, "Name (for Keps)", "The name must be the same as the name in your TLE/Keps file if you want to calculate positions or sync with SatPC32", this.sat.user_keps_name);
        this.displayName = this.addSettingsRow(titlePanel1, 15, "Display Name", "This name is use used as a label on Graphs and Tabs", this.sat.user_display_name);
        this.series = this.addSettingsRow(titlePanel1, 8, "Series", "This name is used as the prefix for saved files in FOXDB and elsewhere", this.sat.series);
        this.hasFOXDB_V3 = this.addCheckBoxRow("Use V3 Telem Database (recommended)", "This is true for all new spacecraft", this.sat.hasFOXDB_V3, titlePanel1);
        this.hasFOXDB_V3.setEnabled(false);
        this.useConversionCoeffs = this.addCheckBoxRow("Use conversion coefficients (recommended)", "This is true for all new spacecraft", this.sat.useConversionCoeffs, titlePanel1);
        this.useConversionCoeffs.setEnabled(false);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        TitledBorder heading9 = SpacecraftEditPanel.title("Description");
        descPanel.setBorder(heading9);
        this.taDesc = new JTextArea(7, 45);
        this.taDesc.setText(this.sat.description);
        this.taDesc.setLineWrap(true);
        this.taDesc.setWrapStyleWord(true);
        this.taDesc.setEditable(true);
        this.taDesc.setFont(new Font("SansSerif", 0, 12));
        descPanel.add((Component)this.taDesc, "Center");
        titlePanel1.add(descPanel);
        return mainTitlePanel;
    }

    private JPanel addLeftPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel titlePanel = this.addTitlePanel();
        leftPanel.add(titlePanel);
        this.leftSourcesPanel = new JPanel();
        leftPanel.add(this.leftSourcesPanel);
        TitledBorder headingSources = SpacecraftEditPanel.title("Sources and Formats");
        this.leftSourcesPanel.setBorder(headingSources);
        this.leftSourcesPanel.setLayout(new BoxLayout(this.leftSourcesPanel, 0));
        SourcesTableModel sourcesListTableModel = new SourcesTableModel();
        SourcesTableModel sourceTableModel = new SourcesTableModel();
        SourceTableListEditPanel sourceTableListEditPanel = new SourceTableListEditPanel(this.sat, "Sources", sourcesListTableModel, sourceTableModel, this);
        this.leftSourcesPanel.add(sourceTableListEditPanel);
        return leftPanel;
    }

    private JPanel addRightPanel() {
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        JPanel leftFixedPanel = new JPanel();
        JPanel leftFixedPanelf = new JPanel();
        leftFixedPanelf.setLayout(new BorderLayout());
        leftFixedPanel.setLayout(new BoxLayout(leftFixedPanel, 1));
        rightPanel.add(leftFixedPanelf);
        leftFixedPanelf.add((Component)leftFixedPanel, "North");
        TitledBorder heading = SpacecraftEditPanel.title("Fixed Paramaters");
        leftFixedPanel.setBorder(heading);
        this.cbModel = this.addComboBoxRow(leftFixedPanel, "Model", "", Spacecraft.modelNames);
        this.setSelection(this.cbModel, Spacecraft.modelNames, Spacecraft.modelNames[this.sat.model]);
        this.IHU_SN = this.addSettingsRow(leftFixedPanel, 15, "Computer (IHU) S/N)", "The serial number of the onboard computer", "" + this.sat.IHU_SN);
        this.hasModeInHeader = this.addCheckBoxRow("Mode in header", "Every recevied frame will include the mode in the header", this.sat.hasModeInHeader, leftFixedPanel);
        this.hasFrameCrc = this.addCheckBoxRow("Frame CRC", "The last two bytes of the (BPSK) frame contain a CRC checksum", this.sat.hasFrameCrc, leftFixedPanel);
        this.hasImprovedCommandReceiver = this.addCheckBoxRow("Improved Command Receiver", "Set to true if this has the Improved Command Receiver", this.sat.hasImprovedCommandReceiver, leftFixedPanel);
        this.hasImprovedCommandReceiverII = this.addCheckBoxRow("Improved Command Receiver II", "Set to true if this has Version 2 of the Improved Command Receiver", this.sat.hasImprovedCommandReceiverII, leftFixedPanel);
        this.hasGPSTime = this.addCheckBoxRow("Has GPS Time", "Set to true if one of the payloads contains a GPS timebase", this.sat.hasGPSTime, leftFixedPanel);
        this.useGPSTimeForT0 = this.addCheckBoxRow("Use GPS Time for T0", "Set to true if the GPS time should be used for T0. Can be changed by the user", this.sat.user_useGPSTimeForT0, leftFixedPanel);
        this.cbExperiments = new JComboBox[4];
        int i = 0;
        while (i < 4) {
            this.cbExperiments[i] = this.addComboBoxRow(leftFixedPanel, "Experiment " + (i + 1), "This tells FoxTelem that a custom tab is required, such as a Camera Image decoder. Contact the developer to add a new feature.", Spacecraft.expNames);
            if (this.sat.experiments[i] < Spacecraft.expNames.length) {
                this.setSelection(this.cbExperiments[i], Spacecraft.expNames, Spacecraft.expNames[this.sat.experiments[i]]);
            }
            ++i;
        }
        this.leftPanel.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        JPanel leftPane1 = new JPanel();
        rightPanel.add(leftPane1);
        leftPane1.setLayout(new BoxLayout(leftPane1, 1));
        TitledBorder heading4 = SpacecraftEditPanel.title("Frequency and Tracking");
        leftPane1.setBorder(heading4);
        this.cbMode = this.addComboBoxRow(leftPane1, "Default Format", "The default format to use when FoxTelem is in auto start mode.  The user can override this.", Config.satManager.getFormats());
        this.cbMode.setSelectedItem(this.sat.user_format);
        this.telemetryDownlinkFreqkHz = this.addSettingsRow(leftPane1, 15, "Downlink Freq (kHz)", "The nominal downlink frequency of the spacecraft", "" + this.sat.user_telemetryDownlinkFreqkHz);
        this.minFreqBoundkHz = this.addSettingsRow(leftPane1, 15, "Lower Freq Bound (kHz)", "The lower frequency boundry when we are searching for the spacecraft signal", "" + this.sat.user_minFreqBoundkHz);
        this.maxFreqBoundkHz = this.addSettingsRow(leftPane1, 15, "Upper Freq Bound (kHz)", "The upper frequency boundry when we are searching for the spacecraft signal", "" + this.sat.user_maxFreqBoundkHz);
        this.track = this.addCheckBoxRow("Track this spacecraft", "When Doppler tracking or Find Signal is enabled include this satellite", this.sat.user_track, leftPane1);
        leftPane1.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        JPanel leftPane2 = new JPanel();
        rightPanel.add(leftPane2);
        leftPane2.setLayout(new BoxLayout(leftPane2, 1));
        if (!this.sat.hasFOXDB_V3) {
            TitledBorder heading5 = SpacecraftEditPanel.title("Calibration");
            leftPane2.setBorder(heading5);
            this.BATTERY_CURRENT_ZERO = this.addSettingsRow(leftPane2, 25, "Battery Current Zero", "The calibration paramater for zero battery current", "" + this.sat.user_BATTERY_CURRENT_ZERO);
            this.rssiLookUpTableFileName = this.addSettingsRow(leftPane2, 25, "RSSI Lookup Table", "The file containing the lookup table for Received Signal Strength", this.sat.getLookupTableFileNameByName("RSSI"));
            this.ihuTempLookUpTableFileName = this.addSettingsRow(leftPane2, 25, "IHU Temp Lookup Table", "The file containing the lookup table for the IHU Temperature", this.sat.getLookupTableFileNameByName("IHU_TEMP"));
            this.ihuVBattLookUpTableFileName = this.addSettingsRow(leftPane2, 25, "VBatt Lookup Table", "The file containing the lookup table for the Battery Voltage", this.sat.getLookupTableFileNameByName("IHU_VBATT"));
            this.useIHUVBatt = this.addCheckBoxRow("Use Bus Voltage as VBatt", "Read the Bus Voltage from the IHU rather than the Battery Voltage from the battery card using I2C", this.sat.useIHUVBatt, leftPane2);
            if (this.sat.hasMpptSettings) {
                this.mpptResistanceError = this.addSettingsRow(leftPane2, 25, "MPPT Resistance Error", "The extra resistance in the RTD temperature measurement circuit", "" + this.sat.user_mpptResistanceError);
                this.mpptSensorOffThreshold = this.addSettingsRow(leftPane2, 25, "MPPT Sensor Off Threshold", "The ADC value when the temperature sensor is considered off", "" + this.sat.user_mpptSensorOffThreshold);
            }
            if (this.sat.hasMemsRestValues) {
                this.memsRestValueX = this.addSettingsRow(leftPane2, 25, "MEMS Rest Value X", "The rest value for the MEMS X rotation sensor", "" + this.sat.user_memsRestValueX);
                this.memsRestValueY = this.addSettingsRow(leftPane2, 25, "MEMS Rest Value Y", "The rest value for the MEMS Y rotation sensor", "" + this.sat.user_memsRestValueY);
                this.memsRestValueZ = this.addSettingsRow(leftPane2, 25, "MEMS Rest Value Z", "The rest value for the MEMS Z rotation sensor", "" + this.sat.user_memsRestValueZ);
            }
        }
        return rightPanel;
    }

    private JPanel bottomPanel() {
        JPanel footerPanel = new JPanel();
        this.btnSave = new JButton("Save");
        this.btnSave.addActionListener(this);
        footerPanel.add(this.btnSave);
        this.btnSave.setEnabled(true);
        return footerPanel;
    }

    private void setSelection(JComboBox<String> comboBox, String[] values, String value) {
        int i = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String rate = stringArray[n2];
            if (rate.equalsIgnoreCase(value)) break;
            ++i;
            ++n2;
        }
        if (i >= values.length) {
            i = 0;
        }
        comboBox.setSelectedIndex(i);
    }

    private JComboBox<String> addComboBoxRow(JPanel parent, String name, String tip, String[] values) {
        JPanel row = new JPanel();
        row.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lbl = new JLabel(name);
        JComboBox<String> checkBox = new JComboBox<String>(values);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        lbl.setToolTipText(tip);
        row.add(lbl);
        row.add(checkBox);
        parent.add(row);
        parent.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return checkBox;
    }

    public static TitledBorder title(String s) {
        TitledBorder title = new TitledBorder(null, s, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        return title;
    }

    private JCheckBox addCheckBoxRow(String name, String tip, boolean value, JPanel parent) {
        JPanel box = new JPanel();
        box.setLayout(new FlowLayout(0));
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        box.add(checkBox);
        parent.add(box);
        if (value) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        return checkBox;
    }

    private JTextField addSettingsRow(JPanel column, int length, String name, String tip, String value) {
        JPanel panel = new JPanel();
        column.add(panel);
        panel.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lblDisplayModuleFont = new JLabel(name);
        lblDisplayModuleFont.setToolTipText(tip);
        panel.add(lblDisplayModuleFont);
        JTextField textField = new JTextField(value);
        textField.setToolTipText(tip);
        panel.add(textField);
        textField.setColumns(length);
        textField.addActionListener(this);
        textField.addFocusListener(this);
        column.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return textField;
    }

    public boolean save() {
        boolean dispose = true;
        double downlinkFreq = 0.0;
        double minFreq = 0.0;
        double maxFreq = 0.0;
        try {
            String m;
            this.sat.foxId = Integer.parseInt(this.id.getText());
            this.sat.hasFOXDB_V3 = this.hasFOXDB_V3.isSelected();
            this.sat.useConversionCoeffs = this.useConversionCoeffs.isSelected();
            this.sat.description = this.taDesc.getText();
            this.sat.model = this.cbModel.getSelectedIndex();
            try {
                this.sat.IHU_SN = Integer.parseInt(this.IHU_SN.getText());
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException("The Serial number must be an integer value");
            }
            this.sat.hasModeInHeader = this.hasModeInHeader.isSelected();
            if (this.hasImprovedCommandReceiver.isSelected() && this.hasImprovedCommandReceiverII.isSelected()) {
                throw new NumberFormatException("Can not select ICR II if ICR is already selected");
            }
            this.sat.hasImprovedCommandReceiver = this.hasImprovedCommandReceiver.isSelected();
            this.sat.hasImprovedCommandReceiverII = this.hasImprovedCommandReceiverII.isSelected();
            this.sat.hasGPSTime = this.hasGPSTime.isSelected();
            this.sat.user_useGPSTimeForT0 = this.useGPSTimeForT0.isSelected();
            this.sat.hasFrameCrc = this.hasFrameCrc.isSelected();
            int i = 0;
            while (i < 4) {
                this.sat.experiments[i] = this.cbExperiments[i].getSelectedIndex();
                ++i;
            }
            try {
                downlinkFreq = (double)Math.round(Double.parseDouble(this.telemetryDownlinkFreqkHz.getText()) * 1000.0) / 1000.0;
                minFreq = (double)Math.round(Double.parseDouble(this.minFreqBoundkHz.getText()) * 1000.0) / 1000.0;
                maxFreq = (double)Math.round(Double.parseDouble(this.maxFreqBoundkHz.getText()) * 1000.0) / 1000.0;
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException("The Frequency fields must contain a valid frequency in kHz");
            }
            if (minFreq < maxFreq) {
                this.sat.user_telemetryDownlinkFreqkHz = downlinkFreq;
                this.sat.user_minFreqBoundkHz = minFreq;
                this.sat.user_maxFreqBoundkHz = maxFreq;
            } else {
                Log.errorDialog("ERROR", "Lower Frequency Bound must be less than Upper Frequency Bound");
                dispose = false;
            }
            this.sat.user_format = m = (String)this.cbMode.getSelectedItem();
            if (!this.sat.hasFOXDB_V3) {
                if (this.sat.user_BATTERY_CURRENT_ZERO != Double.parseDouble(this.BATTERY_CURRENT_ZERO.getText())) {
                    this.sat.user_BATTERY_CURRENT_ZERO = Double.parseDouble(this.BATTERY_CURRENT_ZERO.getText());
                }
                if (this.sat.hasMpptSettings) {
                    if (this.sat.user_mpptResistanceError != Double.parseDouble(this.mpptResistanceError.getText())) {
                        this.sat.user_mpptResistanceError = Double.parseDouble(this.mpptResistanceError.getText());
                    }
                    if (this.sat.user_mpptSensorOffThreshold != Integer.parseInt(this.mpptSensorOffThreshold.getText())) {
                        this.sat.user_mpptSensorOffThreshold = Integer.parseInt(this.mpptSensorOffThreshold.getText());
                    }
                }
                if (this.sat.hasMemsRestValues) {
                    if (this.sat.user_memsRestValueX != Integer.parseInt(this.memsRestValueX.getText())) {
                        this.sat.user_memsRestValueX = Integer.parseInt(this.memsRestValueX.getText());
                    }
                    if (this.sat.user_memsRestValueY != Integer.parseInt(this.memsRestValueY.getText())) {
                        this.sat.user_memsRestValueY = Integer.parseInt(this.memsRestValueY.getText());
                    }
                    if (this.sat.user_memsRestValueZ != Integer.parseInt(this.memsRestValueZ.getText())) {
                        this.sat.user_memsRestValueZ = Integer.parseInt(this.memsRestValueZ.getText());
                    }
                }
                if (this.sat.useIHUVBatt != this.useIHUVBatt.isSelected()) {
                    this.sat.useIHUVBatt = this.useIHUVBatt.isSelected();
                }
            }
            if (!this.sat.series.equalsIgnoreCase(this.series.getText())) {
                this.sat.series = this.series.getText();
            }
            if (!this.sat.user_keps_name.equalsIgnoreCase(this.name.getText())) {
                this.sat.user_keps_name = this.name.getText();
            }
            if (!this.sat.user_display_name.equalsIgnoreCase(this.displayName.getText())) {
                this.sat.user_display_name = this.displayName.getText();
            }
            int pri = 9;
            try {
                pri = this.priority.getSelectedIndex();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.sat.user_priority = pri;
            if (this.localServer != null) {
                this.sat.user_localServer = this.localServer.getText();
                this.sat.user_localServerPort = this.localServerPort.getText().equalsIgnoreCase("") ? 0 : Integer.parseInt(this.localServerPort.getText());
            }
            this.sat.user_track = this.track.isSelected();
            this.sat.save_master_params();
            this.sat.save();
        }
        catch (NumberFormatException Ex) {
            Log.errorDialog("Invalid Paramaters", Ex.getMessage());
        }
        return dispose;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnSave) {
            System.out.println("Saving ...");
            this.save();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

