/*
 * Decompiled with CFR 0.152.
 */
package measure;

import common.Config;
import common.Log;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import measure.Measurement;
import telemetry.FramePart;

public class PassMeasurement
extends Measurement {
    public long[] fieldValue = null;
    int endReset = 0;
    long endUptime = 0L;
    public static final String AOS = "AOS";
    public static final String LOS = "LOS";
    public static final String TCA = "TCA";
    public static final String TCA_FREQ = "TCA_FREQ";
    public static final String START_AZIMUTH = "START_AZIMUTH";
    public static final String END_AZIMUTH = "END_AZIMUTH";
    public static final String MAX_ELEVATION = "MAX_ELEVATION";
    public static final String TOTAL_PAYLOADS = "TOTAL_PAYLOADS";
    public static final String CRC_FAILURES = "CRC_FAILURES";
    public static final long ERR = -99999L;
    public static final String DEFAULT_VALUE = "-----";

    public PassMeasurement(int foxid, String dt, int reset, long uptime, int type, StringTokenizer st) {
        this.id = foxid;
        this.reset = reset;
        this.uptime = uptime;
        this.type = type;
        try {
            this.date = FramePart.fileDateFormat.parse(dt);
        }
        catch (ParseException e) {
            e.printStackTrace(Log.getWriter());
        }
        this.layout = Config.satManager.getPassMeasurementLayout(foxid);
        this.fieldValue = new long[this.layout.NUMBER_OF_FIELDS];
        if (st != null) {
            this.load(st);
        }
    }

    public PassMeasurement(int foxid, int type) {
        this.id = foxid;
        this.type = -2;
        this.date = Calendar.getInstance().getTime();
        this.layout = Config.satManager.getPassMeasurementLayout(foxid);
        if (this.layout == null) {
            Log.println("FoxId: " + this.id + " is not setup in the measurement store.  Can not create pass measurement");
            return;
        }
        this.fieldValue = new long[this.layout.NUMBER_OF_FIELDS];
        this.setRawValue(AOS, this.date.getTime());
    }

    public int getEndReset() {
        return this.endReset;
    }

    public long getEndUptime() {
        return this.endUptime;
    }

    public void setStartResetUptime(int reset, long uptime) {
        this.reset = reset;
        this.uptime = uptime;
    }

    public void setEndResetUptime(int reset, long uptime) {
        this.endReset = reset;
        this.endUptime = uptime;
    }

    public String getDateFromLong(long dt) {
        FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = FramePart.fileDateFormat.format(dt);
        return date;
    }

    public long getRawValue(String name) {
        if (this.layout == null) {
            Log.println("FoxId: " + this.id + " is not setup in the measurement store.  Can not create pass measurement");
            return 0L;
        }
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                return this.fieldValue[i];
            }
            ++i;
        }
        return -99999L;
    }

    public String getStringValue(String name) {
        if (this.layout == null) {
            Log.println("FoxId: " + this.id + " is not setup in the measurement store.  Can not create pass measurement");
            return null;
        }
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                if (this.layout.getIntConversionByPos(i) == 33) {
                    if (this.fieldValue[i] == 0L) {
                        return DEFAULT_VALUE;
                    }
                    String dt = this.getDateFromLong(this.fieldValue[i]);
                    return dt;
                }
                if (this.layout.getIntConversionByPos(i) == 26) {
                    if (this.fieldValue[i] == 0L) {
                        return DEFAULT_VALUE;
                    }
                    return "" + this.fieldValue[i];
                }
                return "" + this.fieldValue[i];
            }
            ++i;
        }
        return null;
    }

    public void setRawValue(String name, long value) {
        if (this.layout == null) {
            Log.println("FoxId: " + this.id + " is not setup in the measurement store.  Can not create pass measurement");
            return;
        }
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                this.fieldValue[i] = value;
            }
            ++i;
        }
    }

    public void setLOS() {
        Date losDate = Calendar.getInstance().getTime();
        this.setRawValue(LOS, losDate.getTime());
    }

    public void setTCA(Long dateMills) {
        Date dt = new Date(dateMills);
        this.setRawValue(TCA, dt.getTime());
    }

    protected void load(StringTokenizer st) {
        try {
            int i = 0;
            while (i < this.layout.NUMBER_OF_FIELDS) {
                this.fieldValue[i] = Long.valueOf(st.nextToken());
                ++i;
            }
        }
        catch (NoSuchElementException i) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.println("ERROR: Too many fields:  Could not load measurement " + this.id + " " + this.getRawValue(AOS));
        }
        catch (NumberFormatException n) {
            Log.println("ERROR: Invalid number:  Could not load measurement " + this.id + " " + this.getRawValue(AOS));
        }
    }

    protected void load103(StringTokenizer st) {
        try {
            try {
                this.loadDate(st, 0);
                this.loadDate(st, 1);
                this.loadDate(st, 2);
            }
            catch (ParseException e) {
                e.printStackTrace(Log.getWriter());
            }
            int i = 3;
            while (i < this.layout.NUMBER_OF_FIELDS - 1) {
                String tok = st.nextToken();
                this.fieldValue[i] = tok != null && !tok.equalsIgnoreCase("null") ? Long.valueOf(tok) : 0L;
                ++i;
            }
            String tok = st.nextToken();
            long decodes = 0L;
            if (tok != null && !tok.equalsIgnoreCase("null")) {
                decodes = Long.valueOf(tok);
            }
            if (decodes > 900L) {
                decodes = 0L;
            }
            this.fieldValue[this.layout.NUMBER_OF_FIELDS - 1] = decodes;
        }
        catch (NoSuchElementException tok) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.println("ERROR: Too many fields:  Could not load measurement " + this.id + " " + this.getRawValue(AOS));
        }
        catch (NumberFormatException n) {
            Log.println("ERROR: Invalid number:  Could not load measurement " + this.id + " " + this.getRawValue(AOS));
        }
    }

    private void loadDate(StringTokenizer st, int i) throws ParseException {
        String dt1 = st.nextToken();
        FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date1 = FramePart.fileDateFormat.parse(dt1);
        this.fieldValue[i] = date1.getTime();
    }

    @Override
    public String toFile() {
        String s = new String();
        FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String captureDate = FramePart.fileDateFormat.format(this.date);
        s = String.valueOf(s) + captureDate + "," + this.id + "," + this.reset + "," + this.uptime + "," + this.type + ",";
        int i = 0;
        while (i < this.layout.NUMBER_OF_FIELDS - 1) {
            s = String.valueOf(s) + this.fieldValue[i] + ",";
            ++i;
        }
        s = String.valueOf(s) + this.fieldValue[this.layout.NUMBER_OF_FIELDS - 1];
        return s;
    }
}

