/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.graph.GraphFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.legacyPayloads.RadiationPacket;
import telemetry.payloads.PayloadWOD;

public class DisplayModule
extends JPanel
implements ActionListener,
MouseListener {
    int size = 0;
    Spacecraft fox;
    int foxId;
    double scale;
    String[] fieldName = null;
    JLabel[] rtValue = null;
    JLabel[] maxValue = null;
    JComponent[] minValue = null;
    JLabel[] label = null;
    JPanel[] row = null;
    int[] display;
    String title = null;
    GraphFrame[][] graph = null;
    String noValue = "0000";
    FramePart rtPayload;
    FramePart maxPayload;
    FramePart minPayload;
    private static final int DEFAULT_FONT_SIZE = 11;
    private int VAL_WIDTH = 40;
    private int SINGLE_VAL_WIDTH = 120;
    private int VULCAN_WIDTH = 70;
    private int VULCAN_NAME_WIDTH = 140;
    private int MEASUREMENT_WIDTH = 80;
    private int MEASUREMENT_NAME_WIDTH = 140;
    private int HERCI_MICRO_PKT_NAME_WIDTH = 80;
    private int HERCI_MICRO_PKT_VALUE_WIDTH = 310;
    private int NAME_WIDTH = 110;
    private int ROW_HEIGHT = 16;
    private static final int MAC_VAL_WIDTH = 44;
    private static final int MAC_SINGLE_VAL_WIDTH = 132;
    private static final int MAC_VULCAN_WIDTH = 55;
    private static final int MAC_VULCAN_NAME_WIDTH = 154;
    private static final int MAC_NAME_WIDTH = 121;
    private static final int MAC_ROW_HEIGHT = 16;
    private static final int MAC_HERCI_MICRO_PKT_NAME_WIDTH = 88;
    private static final int MAC_HERCI_MICRO_PKT_VALUE_WIDTH = 341;
    private static final int MAC_MEASUREMENT_WIDTH = 88;
    private static final int MAC_MEASUREMENT_NAME_WIDTH = 154;
    private static final int LIN_VAL_WIDTH = 48;
    private static final int LIN_SINGLE_VAL_WIDTH = 144;
    private static final int LIN_VULCAN_WIDTH = 60;
    private static final int LIN_VULCAN_NAME_WIDTH = 168;
    private static final int LIN_NAME_WIDTH = 132;
    private static final int LIN_ROW_HEIGHT = 16;
    private static final int LIN_HERCI_MICRO_PKT_NAME_WIDTH = 92;
    private static final int LIN_HERCI_MICRO_PKT_VALUE_WIDTH = 382;
    private static final int LIN_MEASUREMENT_WIDTH = 96;
    private static final int LIN_MEASUREMENT_NAME_WIDTH = 168;
    public static final int DISPLAY_RT_ONLY = 0;
    public static final int DISPLAY_MAX_ONLY = 1;
    public static final int DISPLAY_MIN_ONLY = 2;
    public static final int DISPLAY_ALL = 3;
    public static final int DISPLAY_ALL_SWAP_MINMAX = 4;
    public static final int DISPLAY_EXPERIMENT = 5;
    public static final int DISPLAY_WOD_EXPERIMENT = 8;
    public static final int DISPLAY_WOD = 16;
    public static final int DISPLAY_MEASURES = 9;
    public static final int DISPLAY_PASS_MEASURES = 10;
    public static final int DISPLAY_LEP = 6;
    public static final int DISPLAY_LEP_EXPOSURE = 7;
    public static final int DISPLAY_UW = 11;
    public static final int DISPLAY_WOD_UW = 12;
    public static final int DISPLAY_MIN_AND_MAX_ONLY = 15;
    public static final int DISPLAY_HERCI = 20;
    public static final int DISPLAY_HERCI_HK = 21;
    public static final int DISPLAY_HERCI_MICRO_PKT = 22;
    public static final Color vulcanFontColor = new Color(153, 0, 0);
    public static final Color herciFontColor = new Color(240, 154, 21);
    public static final Color wodFontColor = new Color(70, 146, 32);
    int moduleType = 3;
    BitArrayLayout telemLayout = null;

    public DisplayModule(Spacecraft fox2, String title, int size, BitArrayLayout lay, int modType, Color color) {
        this.fox = fox2;
        this.foxId = this.fox.foxId;
        this.size = size;
        this.title = title;
        this.telemLayout = lay;
        TitledBorder border = new TitledBorder(null, title, 4, 2, null, null);
        this.scale = (double)Config.displayModuleFontSize / 11.0;
        this.setDefaultSizes();
        this.moduleType = modType;
        border.setTitleFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 12 / 10));
        border.setTitleColor(Color.BLUE);
        if (color != null) {
            border.setTitleColor(color);
        }
        if (this.moduleType == 20 || this.moduleType == 21 || this.moduleType == 22) {
            border.setTitleColor(herciFontColor);
        } else if (this.moduleType == 9) {
            border.setTitleColor(vulcanFontColor);
            this.minValue = new JButton[size];
        } else if (this.moduleType >= 16) {
            border.setTitleColor(wodFontColor);
            this.minValue = new JButton[size];
        } else if (this.moduleType >= 5) {
            border.setTitleColor(vulcanFontColor);
        } else {
            this.maxValue = new JLabel[size];
            this.minValue = new JLabel[size];
        }
        this.setBorder(border);
        this.fieldName = new String[size];
        this.rtValue = new JLabel[size];
        this.label = new JLabel[size];
        this.row = new JPanel[size];
        this.graph = new GraphFrame[3][size];
        this.display = new int[size];
        this.initGui();
    }

    public void setLayout(BitArrayLayout lay) {
        this.telemLayout = lay;
    }

    public BitArrayLayout getTelemLayout() {
        return this.telemLayout;
    }

    public void addName(int i, String name, String fieldName, int display) {
        String desc = null;
        this.addName(i, name, fieldName, desc, display);
    }

    public void addName(int i, String name, String fieldName, String desc, int display) {
        this.label[i].setText(name);
        if (desc != null) {
            this.row[i].setToolTipText(String.valueOf(desc) + " | click for graph | right-click for EarthPlot");
        }
        this.label[i].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
        this.fieldName[i] = fieldName;
        this.display[i] = display;
        int w = this.SINGLE_VAL_WIDTH;
        if (display == 0) {
            w = this.SINGLE_VAL_WIDTH;
        } else if (display == 1 || display == 2 || display == 15) {
            w = 0;
        } else if (display == 9) {
            w = this.MEASUREMENT_WIDTH;
        } else if (display == 3 || display == 4) {
            w = this.VAL_WIDTH;
        } else if (display >= 5 && display < 22) {
            w = this.VULCAN_WIDTH;
        } else if (display == 20 || display == 21 || display == 22) {
            w = this.HERCI_MICRO_PKT_NAME_WIDTH;
            this.label[i].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            w = this.HERCI_MICRO_PKT_VALUE_WIDTH;
        }
        this.rtValue[i].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
        this.rtValue[i].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
        this.rtValue[i].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
        if (display < 5 && this.minValue != null && this.maxValue != null) {
            w = 0;
            if (display == 2 || display == 15) {
                w = this.SINGLE_VAL_WIDTH;
            } else if (display == 1) {
                w = 0;
            } else if (display == 3 || display == 4) {
                w = this.VAL_WIDTH;
            }
            this.minValue[i].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.minValue[i].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.minValue[i].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            w = 0;
            if (display == 1 || display == 15) {
                w = this.SINGLE_VAL_WIDTH;
            } else if (display == 2) {
                w = 0;
            } else if (display == 3 || display == 4) {
                w = this.VAL_WIDTH;
            }
            this.maxValue[i].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.maxValue[i].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.maxValue[i].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
        }
    }

    public void updateRtValues(FramePart rt) {
        this.rtPayload = rt;
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.rtValue[i].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
                if (rt.hasFieldName(this.fieldName[i])) {
                    if (Config.displayRawValues) {
                        this.rtValue[i].setText(Integer.toString(rt.getRawValue(this.fieldName[i])));
                    } else {
                        this.rtValue[i].setText(rt.getStringValue(this.fieldName[i], this.fox));
                    }
                    int p = 0;
                    while (p < 3) {
                        if (this.graph[p][i] != null) {
                            this.graph[p][i].updateGraphData("DisplayModule.updateRtValues");
                        }
                        ++p;
                    }
                }
            }
            ++i;
        }
    }

    public void updateMaxValues(FramePart maxPayload2) {
        this.maxPayload = maxPayload2;
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.maxValue[i].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
                if (maxPayload2.hasFieldName(this.fieldName[i])) {
                    if (Config.displayRawValues) {
                        if (this.display[i] == 0) {
                            this.rtValue[i].setText(Integer.toString(maxPayload2.getRawValue(this.fieldName[i])));
                        } else if (this.display[i] == 4) {
                            ((JLabel)this.minValue[i]).setText(Integer.toString(maxPayload2.getRawValue(this.fieldName[i])));
                        } else {
                            this.maxValue[i].setText(Integer.toString(maxPayload2.getRawValue(this.fieldName[i])));
                        }
                    } else if (this.display[i] == 0) {
                        this.rtValue[i].setText(maxPayload2.getStringValue(this.fieldName[i], this.fox));
                    } else if (this.display[i] == 4) {
                        ((JLabel)this.minValue[i]).setText(maxPayload2.getStringValue(this.fieldName[i], this.fox));
                    } else {
                        this.maxValue[i].setText(maxPayload2.getStringValue(this.fieldName[i], this.fox));
                    }
                    int p = 0;
                    while (p < 3) {
                        if (this.display[i] == 0 && this.graph[p][i] != null) {
                            this.graph[p][i].updateGraphData("DisplayModule.updateMaxValues");
                        }
                        ++p;
                    }
                }
            }
            ++i;
        }
    }

    public void updateMinValues(FramePart minPayload2) {
        this.minPayload = minPayload2;
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.minValue[i].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
                if (minPayload2.hasFieldName(this.fieldName[i])) {
                    if (Config.displayRawValues) {
                        if (this.display[i] == 0) {
                            this.rtValue[i].setText(Integer.toString(minPayload2.getRawValue(this.fieldName[i])));
                        } else if (this.display[i] == 4) {
                            this.maxValue[i].setText(Integer.toString(minPayload2.getRawValue(this.fieldName[i])));
                        } else {
                            ((JLabel)this.minValue[i]).setText(Integer.toString(minPayload2.getRawValue(this.fieldName[i])));
                        }
                    } else if (this.display[i] == 0) {
                        this.rtValue[i].setText(minPayload2.getStringValue(this.fieldName[i], this.fox));
                    } else if (this.display[i] == 4) {
                        this.maxValue[i].setText(minPayload2.getStringValue(this.fieldName[i], this.fox));
                    } else {
                        ((JLabel)this.minValue[i]).setText(minPayload2.getStringValue(this.fieldName[i], this.fox));
                    }
                    int p = 0;
                    while (p < 3) {
                        if (this.display[i] == 0 && this.graph[p][i] != null) {
                            this.graph[p][i].updateGraphData("DisplayModule.updateMinValues");
                        }
                        ++p;
                    }
                }
            }
            ++i;
        }
    }

    public void updateVulcanValues(RadiationPacket rad) {
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.rtValue[i].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
                if (Config.displayRawValues) {
                    this.rtValue[i].setText(Integer.toString(rad.getRawValue(this.fieldName[i])));
                } else {
                    this.rtValue[i].setText(rad.getStringValue(this.fieldName[i]));
                }
            }
            ++i;
        }
    }

    public void updateSingleValue(int line, String value) {
        this.rtValue[line].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
        this.rtValue[line].setText(value);
        int p = 0;
        while (p < 3) {
            if (this.graph[p][line] != null) {
                this.graph[p][line].updateGraphData("DisplayModule.updateSingleValue");
            }
            ++p;
        }
    }

    private void initGui() {
        JLabel rtTitle;
        this.setLayout(new BoxLayout(this, 1));
        int i = 0;
        while (i < this.size) {
            JPanel r = new JPanel();
            r.setLayout(new BorderLayout());
            this.row[i] = new JPanel();
            this.row[i].setLayout(new BoxLayout(this.row[i], 0));
            r.add((Component)this.row[i], "Center");
            this.add(r);
            this.row[i].addMouseListener(this);
            this.row[i].setBackground(Color.lightGray);
            ++i;
        }
        int w = this.NAME_WIDTH;
        if (this.moduleType == 9 || this.moduleType == 16) {
            w = this.MEASUREMENT_NAME_WIDTH;
        } else if (this.moduleType >= 5 && this.moduleType < 22) {
            w = this.VULCAN_NAME_WIDTH;
        } else if (this.moduleType == 20 || this.moduleType == 21 || this.moduleType == 22) {
            w = this.HERCI_MICRO_PKT_NAME_WIDTH;
        }
        int i2 = 0;
        while (i2 < this.size) {
            this.label[i2] = new JLabel();
            this.label[i2].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i2].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i2].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            this.row[i2].add(this.label[i2]);
            ++i2;
        }
        w = this.VAL_WIDTH;
        if (this.moduleType == 9 || this.moduleType == 16) {
            w = this.MEASUREMENT_WIDTH;
        } else if (this.moduleType >= 5 && this.moduleType < 22) {
            w = this.VULCAN_WIDTH;
        } else if (this.moduleType == 20 || this.moduleType == 21 || this.moduleType == 22) {
            w = this.HERCI_MICRO_PKT_VALUE_WIDTH;
        }
        if (this.moduleType < 5) {
            rtTitle = new JLabel("  RT");
            rtTitle.setToolTipText("The most current realtime value of the telemetry is in this column");
        } else {
            rtTitle = new JLabel("Last");
            rtTitle.setToolTipText("The most current value of the telemetry is in this column");
        }
        rtTitle.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize));
        rtTitle.setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
        rtTitle.setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
        rtTitle.setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
        this.row[0].add(rtTitle);
        int i3 = 1;
        while (i3 < this.size) {
            this.rtValue[i3] = new JLabel(this.noValue);
            this.rtValue[i3].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
            this.row[i3].add(this.rtValue[i3]);
            ++i3;
        }
        if (this.moduleType == 9) {
            i3 = 1;
            while (i3 < this.size) {
                this.minValue[i3] = this.createIconButton("/images/skyPlot.png", "Sky", "Plot sky chart");
                this.minValue[i3].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
                this.row[i3].add(this.minValue[i3]);
                ++i3;
            }
        }
        if (this.moduleType < 5) {
            JLabel minTitle = new JLabel("MIN");
            minTitle.setToolTipText("The minimum realtime value since the min telemetry was reset is in this column");
            minTitle.setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            minTitle.setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            minTitle.setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            minTitle.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize));
            this.row[0].add(minTitle);
            int i4 = 1;
            while (i4 < this.size) {
                this.minValue[i4] = new JLabel(this.noValue);
                this.minValue[i4].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
                this.row[i4].add(this.minValue[i4]);
                ++i4;
            }
            JLabel maxTitle = new JLabel("MAX");
            maxTitle.setToolTipText("The maximum realtime value since the max telemetry was reset is in this column");
            maxTitle.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize));
            maxTitle.setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            maxTitle.setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            maxTitle.setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            this.row[0].add(maxTitle);
            int i5 = 1;
            while (i5 < this.size) {
                this.maxValue[i5] = new JLabel(this.noValue);
                this.maxValue[i5].setFont(new Font("SansSerif", 0, Config.displayModuleFontSize));
                this.row[i5].add(this.maxValue[i5]);
                ++i5;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = 1;
        while (i < this.size) {
            if (!this.rtValue[i].getText().equalsIgnoreCase(this.noValue)) {
                if (this.moduleType == 9 && e.getSource() == this.minValue[i]) {
                    this.displayGraph(i, 1);
                } else if (this.moduleType == 16 && e.getSource() == this.minValue[i]) {
                    this.displayGraph(i, 2);
                }
            }
            ++i;
        }
    }

    public void displayGraph(int i, int plotType) {
        try {
            if (this.graph[plotType][i] == null) {
                if (this.moduleType == 10) {
                    String conversion = this.fox.passMeasurementLayout.getConversionNameByName(this.fieldName[i]);
                    String units = this.fox.passMeasurementLayout.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, -2, null, this.fox, plotType);
                } else if (this.moduleType == 9) {
                    String conversion = this.fox.measurementLayout.getConversionNameByName(this.fieldName[i]);
                    String units = this.fox.measurementLayout.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, -1, null, this.fox, plotType);
                } else if (this.rtPayload != null && this.rtPayload.hasFieldName(this.fieldName[i])) {
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], this.telemLayout, this.fox, plotType);
                } else if (this.minPayload != null && this.minPayload.hasFieldName(this.fieldName[i])) {
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], this.minPayload.getLayout(), this.fox, plotType);
                } else if (this.maxPayload != null && this.maxPayload.hasFieldName(this.fieldName[i])) {
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], this.maxPayload.getLayout(), this.fox, plotType);
                } else {
                    return;
                }
                this.graph[plotType][i].setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/fox.jpg")));
            }
            this.graph[plotType][i].setVisible(true);
        }
        catch (Exception ex) {
            Log.println("MOUSE CLICKED EXCEPTION");
            ex.printStackTrace();
            ex.printStackTrace(Log.getWriter());
        }
    }

    public void displayOLDGraph(int i, int plotType) {
        try {
            if (this.graph[plotType][i] == null) {
                String conversion = "";
                String units = "";
                if ((this.moduleType == 3 || this.moduleType == 16 || this.moduleType == 4) && this.rtPayload != null && this.rtPayload.hasFieldName(this.fieldName[i])) {
                    conversion = this.rtPayload.getConversionNameByName(this.fieldName[i]);
                    units = this.rtPayload.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = this.rtPayload instanceof PayloadWOD ? new GraphFrame("WOD: " + this.title + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 10, this.rtPayload.getLayout(), this.fox, plotType) : new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 1, this.rtPayload.getLayout(), this.fox, plotType);
                } else if (this.moduleType == 10) {
                    conversion = this.fox.passMeasurementLayout.getConversionNameByName(this.fieldName[i]);
                    units = this.fox.passMeasurementLayout.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, -2, null, this.fox, plotType);
                } else if (this.moduleType == 9) {
                    conversion = this.fox.measurementLayout.getConversionNameByName(this.fieldName[i]);
                    units = this.fox.measurementLayout.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, -1, null, this.fox, plotType);
                } else if (this.moduleType == 5 || this.moduleType == 8) {
                    this.graph[plotType][i] = this.moduleType == 8 ? new GraphFrame("WOD: " + this.title + " - " + this.label[i].getText(), this.fieldName[i], this.telemLayout, this.fox, plotType) : new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], this.telemLayout, this.fox, plotType);
                } else if (this.moduleType == 11) {
                    conversion = this.telemLayout.getConversionNameByName(this.fieldName[i]);
                    units = this.telemLayout.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 13, this.telemLayout, this.fox, plotType);
                } else if (this.moduleType == 12) {
                    BitArrayLayout lay = this.fox.getLayoutByName("wodcantelemetry");
                    conversion = lay.getConversionNameByName(this.fieldName[i]);
                    units = lay.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 15, this.telemLayout, this.fox, plotType);
                } else if (this.moduleType == 20) {
                    BitArrayLayout lay = this.fox.getLayoutByName("herciHSheader");
                    conversion = lay.getConversionNameByName(this.fieldName[i]);
                    units = lay.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 8, null, this.fox, plotType);
                } else if (this.moduleType == 21) {
                    BitArrayLayout lay = this.fox.getLayoutByName("radtelemetry2");
                    conversion = lay.getConversionNameByName(this.fieldName[i]);
                    units = lay.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 7, null, this.fox, plotType);
                } else if (this.minPayload != null && this.minPayload.hasFieldName(this.fieldName[i])) {
                    conversion = this.minPayload.getConversionNameByName(this.fieldName[i]);
                    units = this.minPayload.getUnitsByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 3, null, this.fox, plotType);
                } else if (this.maxPayload != null && this.maxPayload.hasFieldName(this.fieldName[i])) {
                    conversion = this.maxPayload.getConversionNameByName(this.fieldName[i]);
                    conversion = this.maxPayload.getConversionNameByName(this.fieldName[i]);
                    this.graph[plotType][i] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i].getText(), this.fieldName[i], units, conversion, 2, null, this.fox, plotType);
                } else {
                    return;
                }
                this.graph[plotType][i].setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/fox.jpg")));
            }
            this.graph[plotType][i].setVisible(true);
        }
        catch (Exception ex) {
            Log.println("MOUSE CLICKED EXCEPTION");
            ex.printStackTrace();
            ex.printStackTrace(Log.getWriter());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i = 1;
        while (i < this.size) {
            if (e.getSource() == this.row[i]) {
                if (this.rtValue[i].getText().equalsIgnoreCase(this.noValue)) break;
                if (e.isControlDown() || e.getButton() == 3) {
                    this.displayGraph(i, 2);
                    break;
                }
                this.displayGraph(i, 0);
                break;
            }
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int i = 1;
        while (i < this.size) {
            if (e.getSource() == this.row[i]) {
                this.row[i].setBackground(Color.BLUE);
                if (this.label[i] != null) {
                    this.label[i].setForeground(Color.WHITE);
                }
                if (this.rtValue[i] != null) {
                    this.rtValue[i].setForeground(Color.WHITE);
                }
                if (this.maxValue != null && this.maxValue[i] != null) {
                    this.maxValue[i].setForeground(Color.WHITE);
                }
                if (this.minValue != null && this.minValue[i] != null) {
                    this.minValue[i].setForeground(Color.WHITE);
                }
            }
            ++i;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        int i = 0;
        while (i < this.size) {
            if (e.getSource() == this.row[i]) {
                this.row[i].setBackground(Color.lightGray);
                if (this.label[i] != null) {
                    this.label[i].setForeground(Color.BLACK);
                }
                if (this.rtValue[i] != null) {
                    this.rtValue[i].setForeground(Color.BLACK);
                }
                if (this.maxValue != null && this.maxValue[i] != null) {
                    this.maxValue[i].setForeground(Color.BLACK);
                }
                if (this.minValue != null && this.minValue[i] != null) {
                    this.minValue[i].setForeground(Color.BLACK);
                }
                this.repaint();
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void closeGraphs() {
        int p = 0;
        while (p < 3) {
            int i = 0;
            while (i < this.graph[p].length) {
                if (this.graph[p][i] != null) {
                    if (this.graph[p][i].isVisible()) {
                        this.graph[p][i].saveProperties(true);
                    }
                    this.graph[p][i].dispose();
                }
                ++i;
            }
            ++p;
        }
    }

    public void showGraphs() {
        int p = 0;
        while (p < 3) {
            int i = 0;
            while (i < this.graph[p].length) {
                if (this.graph[p][i] != null && this.graph[p][i].isVisible()) {
                    this.graph[p][i].toFront();
                }
                ++i;
            }
            ++p;
        }
    }

    public void openGraphs(int payloadType) {
        int i = 0;
        while (i < this.fieldName.length) {
            this.openPlot(i, 0, payloadType);
            this.openPlot(i, 1, payloadType);
            this.openPlot(i, 2, payloadType);
            ++i;
        }
    }

    private void openPlot(int i, int plotType, int payloadType) {
        boolean open = Config.loadGraphBooleanValue(this.fox.getIdString(), plotType, payloadType, this.fieldName[i], "open");
        if (open) {
            this.displayGraph(i, plotType);
        }
    }

    private void setDefaultSizes() {
        if (Config.isMacOs()) {
            this.VAL_WIDTH = 44;
            this.SINGLE_VAL_WIDTH = 132;
            this.VULCAN_WIDTH = 55;
            this.VULCAN_NAME_WIDTH = 154;
            this.NAME_WIDTH = 121;
            this.ROW_HEIGHT = 16;
            this.HERCI_MICRO_PKT_NAME_WIDTH = 88;
            this.HERCI_MICRO_PKT_VALUE_WIDTH = 341;
            this.MEASUREMENT_WIDTH = 88;
            this.MEASUREMENT_NAME_WIDTH = 154;
        }
        if (Config.isLinuxOs()) {
            this.VAL_WIDTH = 48;
            this.SINGLE_VAL_WIDTH = 144;
            this.VULCAN_WIDTH = 60;
            this.VULCAN_NAME_WIDTH = 168;
            this.NAME_WIDTH = 132;
            this.ROW_HEIGHT = 16;
            this.HERCI_MICRO_PKT_NAME_WIDTH = 92;
            this.HERCI_MICRO_PKT_VALUE_WIDTH = 382;
            this.MEASUREMENT_WIDTH = 96;
            this.MEASUREMENT_NAME_WIDTH = 168;
        }
        this.VAL_WIDTH = (int)((double)this.VAL_WIDTH * this.scale);
        this.SINGLE_VAL_WIDTH = (int)((double)this.SINGLE_VAL_WIDTH * this.scale);
        this.VULCAN_WIDTH = (int)((double)this.VULCAN_WIDTH * this.scale);
        this.VULCAN_NAME_WIDTH = (int)((double)this.VULCAN_NAME_WIDTH * this.scale);
        this.NAME_WIDTH = (int)((double)this.NAME_WIDTH * this.scale);
        this.MEASUREMENT_WIDTH = (int)((double)this.MEASUREMENT_WIDTH * this.scale);
        this.MEASUREMENT_NAME_WIDTH = (int)((double)this.MEASUREMENT_NAME_WIDTH * this.scale);
        this.ROW_HEIGHT = (int)((double)this.ROW_HEIGHT * this.scale);
        this.HERCI_MICRO_PKT_NAME_WIDTH = (int)((double)this.HERCI_MICRO_PKT_NAME_WIDTH * this.scale);
        this.HERCI_MICRO_PKT_VALUE_WIDTH = (int)((double)this.HERCI_MICRO_PKT_VALUE_WIDTH * this.scale);
    }

    public JButton createIconButton(String icon, String name, String toolTip) {
        JButton btn;
        BufferedImage wPic = null;
        try {
            wPic = ImageIO.read(this.getClass().getResource(icon));
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        if (wPic != null) {
            btn = new JButton(new ImageIcon(wPic));
            btn.setMargin(new Insets(0, 0, 0, 0));
        } else {
            btn = new JButton(name);
        }
        btn.setToolTipText(toolTip);
        btn.addActionListener(this);
        return btn;
    }

    @Override
    public String toString() {
        String s = "Mod: " + this.title;
        return s;
    }
}

