/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.tabs.CanPacketRawTableModel;
import gui.tabs.DisplayModule;
import gui.tabs.ExperimentLayoutTableModel;
import gui.tabs.ExperimentTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.payloads.CanPacket;

public class CanExperimentTab
extends ExperimentTab
implements ItemListener,
Runnable,
MouseListener {
    private static final String DECODED = "Payloads Decoded: ";
    public final int DEFAULT_DIVIDER_LOCATION = 350;
    JLabel lblName;
    private String NAME;
    JLabel lblFramesDecoded;
    ExperimentLayoutTableModel expTableModel;
    ExperimentLayoutTableModel expTableModel2;
    CanPacketRawTableModel canPacketRawTableModel;
    JTable canPacketRawTable;
    JPanel healthPanel;
    boolean displayTelem = true;
    BitArrayLayout layout;
    BitArrayLayout layout2;
    BitArrayLayout canPktLayout;
    int total;
    long[][] noKeys = new long[][]{new long[3]};
    String[][] noData = new String[][]{{"", "", "", "", "", "", "", "", "", "", ""}};

    public CanExperimentTab(Spacecraft sat, String displayName, BitArrayLayout displayLayout, BitArrayLayout canPktLayout, int displayType) {
        this.fox = sat;
        this.foxId = this.fox.foxId;
        this.NAME = String.valueOf(this.fox.toString()) + " " + displayName;
        this.canPktLayout = canPktLayout;
        this.layout2 = this.layout = displayLayout;
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, this.layout.name, "splitPaneHeight");
        this.lblName = new JLabel(this.NAME);
        this.lblName.setMaximumSize(new Dimension(1600, 20));
        this.lblName.setMinimumSize(new Dimension(1600, 20));
        this.lblName.setFont(new Font("SansSerif", 1, 14));
        this.topPanel.add(this.lblName);
        this.lblFramesDecoded = new JLabel(DECODED);
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, 14));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.topPanel.add(this.lblFramesDecoded);
        this.healthPanel = new JPanel();
        this.healthPanel.setLayout(new BoxLayout(this.healthPanel, 0));
        this.healthPanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.healthPanel.setBackground(Color.DARK_GRAY);
        this.initDisplayHalves(this.healthPanel);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        BitArrayLayout none = null;
        try {
            this.analyzeModules(this.layout2, none, none, displayType);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("FATAL - Load Aborted", e.getMessage());
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
        this.splitPane = new JSplitPane(0, this.healthPanel, this.centerPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(350);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    CanExperimentTab.this.splitPaneHeight = CanExperimentTab.this.splitPane.getDividerLocation();
                    Config.saveGraphIntParam(CanExperimentTab.this.fox.getIdString(), 99, 1, CanExperimentTab.this.layout.name, "splitPaneHeight", CanExperimentTab.this.splitPaneHeight);
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        this.healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.showRawBytes = new JCheckBox("Show Raw Bytes", Config.displayRawRadData);
        this.bottomPanel.add(this.showRawBytes);
        this.showRawBytes.addItemListener(this);
        this.addCanPacketTables();
        this.addBottomFilter();
        this.expTableModel = new ExperimentLayoutTableModel(this.layout);
        this.expTableModel2 = new ExperimentLayoutTableModel(this.layout2);
        this.addTables(this.expTableModel, this.expTableModel2);
        this.parseExperimentFrames();
    }

    protected void displayFramesDecoded(int u) {
        this.total = u;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CanExperimentTab.this.lblFramesDecoded.setText(CanExperimentTab.DECODED + CanExperimentTab.this.total);
                CanExperimentTab.this.lblFramesDecoded.invalidate();
                CanExperimentTab.this.topPanel.validate();
            }
        });
    }

    void addCanPacketTables() {
        this.canPacketRawTableModel = new CanPacketRawTableModel();
        this.canPacketRawTable = new JTable(this.canPacketRawTableModel);
        this.canPacketRawTable.setAutoCreateRowSorter(true);
        this.canPacketRawTable.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.canPacketRawTable, 22, 32);
        this.canPacketRawTable.setFillsViewportHeight(true);
        this.canPacketRawTable.setAutoResizeMode(0);
        String PREV = "prev";
        String NEXT = "next";
        InputMap inMap = this.canPacketRawTable.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMap = this.canPacketRawTable.getActionMap();
        actMap.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = CanExperimentTab.this.canPacketRawTable.getSelectedRow();
                if (row > 0) {
                    CanExperimentTab.this.displayRow(CanExperimentTab.this.canPacketRawTable, -1, row - 1);
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = CanExperimentTab.this.canPacketRawTable.getSelectedRow();
                if (row < CanExperimentTab.this.canPacketRawTable.getRowCount() - 1) {
                    CanExperimentTab.this.displayRow(CanExperimentTab.this.canPacketRawTable, -1, row + 1);
                }
            }
        });
        this.healthPanel.add(scrollPane);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        TableColumn column = null;
        column = this.canPacketRawTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.canPacketRawTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        column = this.canPacketRawTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(55);
        column = this.canPacketRawTable.getColumnModel().getColumn(3);
        column.setPreferredWidth(55);
        column = this.canPacketRawTable.getColumnModel().getColumn(4);
        column.setPreferredWidth(55);
        int i = 0;
        while (i < this.canPacketRawTable.getColumnCount() - 5) {
            column = this.canPacketRawTable.getColumnModel().getColumn(i + 5);
            column.setPreferredWidth(30);
            ++i;
        }
    }

    @Override
    protected void addTables(AbstractTableModel expTableModel, AbstractTableModel expTableModel2) {
        int w;
        super.addTables(expTableModel, expTableModel2);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        int i = 0;
        while (i < this.table.getColumnCount() - 2) {
            column = this.table.getColumnModel().getColumn(i + 2);
            w = this.layout.fieldName[i].length();
            column.setPreferredWidth(10 + 7 * w);
            ++i;
        }
        column = this.table2.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table2.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        i = 0;
        while (i < this.table2.getColumnCount() - 2) {
            column = this.table2.getColumnModel().getColumn(i + 2);
            w = this.layout2.fieldName[i].length();
            column.setPreferredWidth(10 + 7 * w);
            ++i;
        }
    }

    protected void parseCanPackets(String[][] data, CanPacketRawTableModel tableModel, int resets, long uptime) {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        int i = 0;
        while (i < data.length) {
            int r = Integer.parseInt(data[i][0]);
            long u = Long.parseLong(data[i][1]);
            if (r == resets && u == uptime) {
                rows.add(data[i]);
            }
            ++i;
        }
        if (rows.size() == 0) {
            tableModel.setData(this.noKeys, this.noData);
            return;
        }
        long[][] keyRawData = new long[rows.size()][2];
        String[][] rawData = new String[rows.size()][data[0].length - 1];
        int i2 = 0;
        while (i2 < rows.size()) {
            try {
                keyRawData[i2][0] = Long.parseLong(((String[])rows.get(i2))[0]);
                keyRawData[i2][1] = Long.parseLong(((String[])rows.get(i2))[1]);
                rawData[i2][0] = ((String[])rows.get(i2))[2];
                int rawid = CanPacket.getRawIdFromRawBytes(Integer.valueOf(((String[])rows.get(i2))[3]), Integer.valueOf(((String[])rows.get(i2))[4]));
                int id = CanPacket.getIdfromRawID(rawid);
                rawData[i2][1] = "" + id;
                rawData[i2][2] = Long.toHexString(id);
                int len = CanPacket.getLengthfromRawID(rawid);
                rawData[i2][3] = "" + len;
                int k = 5;
                while (k < ((String[])rows.get(i2)).length) {
                    rawData[i2][k - 1] = Integer.toHexString(Integer.valueOf(((String[])rows.get(i2))[k]));
                    ++k;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i2;
        }
        tableModel.setData(keyRawData, rawData);
    }

    @Override
    protected void parseExperimentFrames() {
        if (Config.payloadStore == null) {
            return;
        }
        if (!Config.payloadStore.initialized()) {
            return;
        }
        String[][] data = null;
        if (Config.displayRawRadData) {
            data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, false, this.reverse, this.layout.name);
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.expTableModel);
            }
        } else {
            data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, false, this.reverse, this.layout2.name);
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.expTableModel2);
            }
        }
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        this.displayFramesDecoded(Config.payloadStore.getNumberOfFrames(this.foxId, this.layout.name));
        MainWindow.frame.repaint();
    }

    public void updateTab(FramePart rad, boolean refreshTable) {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        if (rad == null) {
            return;
        }
        String[][] data = null;
        boolean RETURN_TYPE = true;
        boolean REVERSE = false;
        if (Config.payloadStore != null && this.canPktLayout != null && (data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, rad.resets, rad.uptime, RETURN_TYPE, REVERSE, this.canPktLayout.name)) != null && data.length > 0) {
            this.parseCanPackets(data, this.canPacketRawTableModel, rad.resets, rad.uptime);
        }
        if (rad != null) {
            DisplayModule mod;
            DisplayModule[] displayModuleArray = this.topModules;
            int n = this.topModules.length;
            int n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateRtValues(rad);
                }
                ++n2;
            }
            if (this.bottomModules != null) {
                displayModuleArray = this.bottomModules;
                n = this.bottomModules.length;
                n2 = 0;
                while (n2 < n) {
                    mod = displayModuleArray[n2];
                    if (mod != null) {
                        mod.updateRtValues(rad);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ExpTab: " + this.layout.name);
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized()) continue;
            int frames = Config.payloadStore.getNumberOfFrames(this.foxId, this.layout.name);
            if (frames != currentFrames) {
                currentFrames = frames;
                this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
                this.displayFramesDecoded(Config.payloadStore.getNumberOfFrames(this.foxId, this.layout.name));
                Config.payloadStore.setUpdated(this.foxId, this.layout.name, false);
                MainWindow.setTotalDecodes();
                this.parseExperimentFrames();
                if (justStarted) {
                    this.openGraphs();
                    justStarted = false;
                }
                MainWindow.frame.repaint();
            }
            if (Config.displayRawRadData != this.showRawBytes.isSelected()) {
                this.showRawBytes.setSelected(Config.displayRawRadData);
                this.parseExperimentFrames();
                this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
            }
            if (Config.displayRawValues == this.showRawValues.isSelected()) continue;
            this.showRawValues.setSelected(Config.displayRawValues);
            this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
        }
        if (source == this.cbUTC) {
            this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
        }
    }

    @Override
    public void parseFrames() {
        this.parseExperimentFrames();
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        long reset_l = (Long)table.getValueAt(row, 0);
        long uptime = (Long)table.getValueAt(row, 1);
        int reset = (int)reset_l;
        if (!(table.getModel() instanceof CanPacketRawTableModel)) {
            this.updateTab(Config.payloadStore.getFramePart(this.foxId, reset, uptime, this.layout2.name, false), false);
        }
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }
}

