/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Spacecraft;
import gui.MainWindow;
import gui.SpacecraftPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SpacecraftFrame
extends JDialog
implements ItemListener,
ActionListener,
FocusListener,
WindowListener {
    private SpacecraftPanel contentPanel;
    JButton btnCancel;
    JButton btnSave;
    Spacecraft sat;

    public SpacecraftFrame(Spacecraft sat, JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setTitle("Spacecraft paramaters");
        this.sat = sat;
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel = new SpacecraftPanel(sat);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.addButtons();
    }

    private void addButtons() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnSave = new JButton("Save");
        this.btnSave.setActionCommand("Save");
        buttonPane.add(this.btnSave);
        this.btnSave.addActionListener(this);
        this.getRootPane().setDefaultButton(this.btnSave);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        this.btnCancel.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean dispose;
        boolean refreshTabs = false;
        boolean rebuildMenu = false;
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
        if (e.getSource() == this.btnSave && (dispose = this.contentPanel.save())) {
            this.sat.save();
            Config.initSatelliteManager();
            if (rebuildMenu) {
                Config.mainWindow.initSatMenu();
                MainWindow.frame.repaint();
            }
            this.dispose();
            if (refreshTabs) {
                MainWindow.refreshTabs(false);
            }
        }
    }

    public void saveProperties() {
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowHeight", this.getHeight());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowWidth", this.getWidth());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowX", this.getX());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowY", this.getY());
    }

    public void loadProperties() {
        int windowX = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowX");
        int windowY = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowY");
        int windowWidth = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowWidth");
        int windowHeight = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowHeight");
        if (windowX == 0 || windowY == 0 || windowWidth == 0 || windowHeight == 0) {
            this.setBounds(100, 100, 600, 700);
        } else {
            this.setBounds(windowX, windowY, windowWidth, windowHeight);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

