/*
 * Decompiled with CFR 0.152.
 */
package filter;

import common.Log;
import decoder.SourceSoundCardAudio;
import filter.Filter;
import javax.sound.sampled.AudioFormat;

public class RootRaisedCosineFilter
extends Filter {
    protected double[] xv;
    int M = 0;
    double GAIN = 1.0;
    double alpha = 0.5;
    double Fc = 0.0;
    double[] xcoeffs;

    public RootRaisedCosineFilter(AudioFormat af, int size) {
        super(af, size);
    }

    @Override
    public void init(double sampleRate, double freq, int len) {
        this.M = len;
        this.xcoeffs = new double[this.M + 1];
        this.Fc = freq / sampleRate;
        this.xv = new double[this.M + 1];
        double Ts = 1.0 / freq;
        double sum = 0.0;
        this.xcoeffs = new double[this.M + 1];
        int i = 0;
        while (i <= this.M) {
            double t = (double)(i - this.M / 2) / sampleRate;
            double sin = Math.sin((1.0 - this.alpha) * Math.PI * t / Ts);
            double cos = 4.0 * this.alpha * t / Ts * Math.cos((1.0 + this.alpha) * Math.PI * t / Ts);
            double det = Math.PI * t / Ts * (1.0 - Math.pow(4.0 * this.alpha * t / Ts, 2.0));
            this.xcoeffs[i] = t == 0.0 ? 1.0 / Math.sqrt(Ts) * (1.0 - this.alpha + 4.0 * this.alpha / Math.PI) : (t == Ts / (4.0 * this.alpha) || t == -Ts / (4.0 * this.alpha) ? this.alpha / Math.sqrt(2.0 * Ts) * (1.6366197723675815 * Math.sin(Math.PI / (4.0 * this.alpha)) + 0.3633802276324186 * Math.cos(Math.PI / (4.0 * this.alpha))) : 1.0 / Math.sqrt(Ts) * ((sin + cos) / det));
            sum += this.xcoeffs[i] * this.xcoeffs[i];
            ++i;
        }
        i = 0;
        while (i <= this.M) {
            this.xcoeffs[i] = this.xcoeffs[i] / Math.sqrt(sum);
            ++i;
        }
        this.GAIN = Math.sqrt(sum);
        Log.println("Root Raised Cosine Filter GAIN: " + this.GAIN);
        super.init(sampleRate, freq, len);
        this.name = "RootRaisedCosine (" + this.cutoffFreq + " " + this.xcoeffs.length + " stereo:" + this.stereo + " Rate: " + this.SAMPLERATE + ")";
    }

    @Override
    public double filterDouble(double in) {
        int i = 0;
        while (i < this.M) {
            this.xv[i] = this.xv[i + 1];
            ++i;
        }
        this.xv[this.M] = in;
        if (this.calculateNow()) {
            double sum = 0.0;
            i = 0;
            while (i <= this.M) {
                sum += this.xcoeffs[i] * this.xv[i];
                ++i;
            }
            return sum;
        }
        return 0.0;
    }

    @Override
    protected int getFilterLength() {
        return this.xcoeffs.length;
    }

    @Override
    public double[] getKernal() {
        return this.xcoeffs;
    }

    public static void main(String[] args) {
        AudioFormat af = SourceSoundCardAudio.makeAudioFormat(48000);
        RootRaisedCosineFilter rrc = new RootRaisedCosineFilter(af, 452);
        rrc.init(48000.0, 1200.0, 452);
    }
}

