/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.Complex;
import filter.CosOscillator;
import filter.Oscillator;
import filter.SinOscillator;

public class ComplexOscillator {
    private Oscillator cosOsc;
    private Oscillator sinOsc;

    public ComplexOscillator(int samples, int freq) {
        this.cosOsc = new CosOscillator(samples, freq);
        this.sinOsc = new SinOscillator(samples, freq);
    }

    public void setFrequency(double freq) {
        this.cosOsc.setFrequency(freq);
        this.sinOsc.setFrequency(freq);
    }

    public Complex nextSample() {
        double i = this.cosOsc.nextSample();
        double q = this.sinOsc.nextSample();
        Complex c = new Complex(i, q);
        return c;
    }

    public Complex nextSample(Complex c) {
        double i = this.cosOsc.nextSample();
        double q = this.sinOsc.nextSample();
        c.i = i;
        c.q = q;
        return c;
    }

    public void changePhase(double phaseIncrement) {
        this.cosOsc.changePhase(phaseIncrement);
        this.sinOsc.changePhase(phaseIncrement);
    }

    public void setPhaseIncrement(double phaseInc) {
        this.cosOsc.setPhaseIncrement(phaseInc);
        this.sinOsc.setPhaseIncrement(phaseInc);
    }

    public void setPhase(double phase) {
        this.cosOsc.setPhase(phase);
        this.sinOsc.setPhase(phase);
    }

    public double getFrequency() {
        return this.cosOsc.getFrequency();
    }

    public double getPhase() {
        return this.cosOsc.getPhase();
    }
}

