/*
 * Decompiled with CFR 0.152.
 */
package device.fcd;

import common.Config;
import common.Log;
import device.DeviceException;
import device.DevicePanel;
import device.TunerController;
import device.fcd.FCD2TunerController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FcdProPlusPanel
extends DevicePanel
implements ItemListener,
ActionListener,
Runnable,
ChangeListener {
    int NUM_OF_PARAMS = 15;
    JCheckBox cbMixerGain;
    JCheckBox cbLnaGain;
    JCheckBox cbBiasTee;
    JTextField rfFilterValue;
    JTextField ifFilterValue;
    JSpinner ifSpinner;
    boolean checkingSettings = false;

    public FcdProPlusPanel() throws IOException {
        TitledBorder title = new TitledBorder(null, "Funcube Dongle Pro Plus", 4, 2, null, null);
        this.setBorder(title);
        try {
            this.initializeGui();
        }
        catch (DeviceException e) {
            Log.println("ERROR setting the inital settings for the FCD");
            e.printStackTrace(Log.getWriter());
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.cbMixerGain.setEnabled(b);
        this.cbLnaGain.setEnabled(b);
        this.cbBiasTee.setEnabled(b);
    }

    public void initializeGui() throws IOException, DeviceException {
        this.setLayout(new BorderLayout(3, 3));
        JPanel center = new JPanel();
        JPanel top = new JPanel();
        this.add((Component)top, "North");
        top.setLayout(new BoxLayout(top, 0));
        this.cbMixerGain = new JCheckBox("Mixer Gain");
        top.add(this.cbMixerGain);
        this.cbMixerGain.addItemListener(this);
        this.cbLnaGain = new JCheckBox("LNA Gain");
        top.add(this.cbLnaGain);
        this.cbLnaGain.addItemListener(this);
        top.add(new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)));
        this.add((Component)center, "Center");
        center.setLayout(new BoxLayout(center, 0));
        JLabel rfFilter = new JLabel("    RF Filter");
        top.add(rfFilter);
        this.rfFilterValue = new JTextField();
        this.rfFilterValue.setColumns(35);
        this.rfFilterValue.setEnabled(false);
        this.rfFilterValue.setMinimumSize(new Dimension(70, 10));
        top.add(this.rfFilterValue);
        JLabel ifFilter = new JLabel("    IF Filter");
        top.add(ifFilter);
        this.ifFilterValue = new JTextField();
        this.ifFilterValue.setColumns(30);
        this.ifFilterValue.setEnabled(false);
        this.ifFilterValue.setMinimumSize(new Dimension(40, 10));
        top.add(this.ifFilterValue);
        top.add(new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)));
        this.cbBiasTee = new JCheckBox("Bias T");
        top.add(this.cbBiasTee);
        this.cbBiasTee.addItemListener(this);
        top.add(new Box.Filler(new Dimension(10, 10), new Dimension(500, 10), new Dimension(1000, 10)));
    }

    @Override
    public void setDevice(TunerController fcd) throws IOException, DeviceException {
        this.setFcd((FCD2TunerController)fcd);
    }

    public void setFcd(FCD2TunerController f) throws IOException, DeviceException {
        this.device = f;
        this.getSettings();
    }

    @Override
    public void updateFilter() throws IOException, DeviceException {
        this.rfFilterValue.setText(((FCD2TunerController)this.device).getRfFilter());
        this.ifFilterValue.setText(((FCD2TunerController)this.device).getIfFilter());
    }

    private void checkSettings() throws DeviceException {
        boolean mixerGain;
        this.checkingSettings = true;
        boolean lnaGain = ((FCD2TunerController)this.device).getLnaGain();
        if (lnaGain != this.cbLnaGain.isSelected()) {
            this.cbLnaGain.setSelected(lnaGain);
        }
        if ((mixerGain = ((FCD2TunerController)this.device).getMixerGain()) != this.cbMixerGain.isSelected()) {
            this.setMixerGain(mixerGain);
        }
        this.checkingSettings = false;
    }

    public void getSettings() throws IOException, DeviceException {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (Config.saveFcdParams) {
            this.loadParam(this.cbLnaGain, "cbLnaGain");
            this.setLnaGain(this.cbLnaGain.isSelected());
            this.loadParam(this.cbMixerGain, "cbMixerGain");
            this.setMixerGain(this.cbMixerGain.isSelected());
            this.loadParam(this.cbBiasTee, "cbBiasTee");
            this.setBiasTee(this.cbBiasTee.isSelected());
        } else {
            this.cbLnaGain.setSelected(((FCD2TunerController)this.device).getLnaGain());
            this.cbMixerGain.setSelected(((FCD2TunerController)this.device).getMixerGain());
            this.cbBiasTee.setSelected(((FCD2TunerController)this.device).getBiasTee());
        }
        this.rfFilterValue.setText(((FCD2TunerController)this.device).getRfFilter());
        this.ifFilterValue.setText(((FCD2TunerController)this.device).getIfFilter());
    }

    @Override
    public void run() {
        this.done = false;
        this.running = true;
        Thread.currentThread().setName("FcdProPlusPanel");
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: FCD thread interrupted");
            }
            if (this.device == null) continue;
            try {
                this.getSettings();
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void setMixerGain(boolean b) {
        try {
            if (!b) {
                ((FCD2TunerController)this.device).setMixerGain(false);
            } else {
                ((FCD2TunerController)this.device).setMixerGain(true);
            }
        }
        catch (DeviceException e1) {
            Log.println("Error setting Mixer Gain on FCD");
            e1.printStackTrace(Log.getWriter());
        }
        if (Config.saveFcdParams) {
            this.saveParam(this.cbMixerGain.isSelected(), "cbMixerGain");
            Config.save();
        }
    }

    private void setLnaGain(boolean b) {
        try {
            if (!b) {
                ((FCD2TunerController)this.device).setLnaGain(false);
            } else {
                ((FCD2TunerController)this.device).setLnaGain(true);
            }
        }
        catch (DeviceException e1) {
            Log.println("Error setting LNA Gain on FCD");
            e1.printStackTrace(Log.getWriter());
        }
        if (Config.saveFcdParams) {
            this.saveParam(this.cbLnaGain.isSelected(), "cbLnaGain");
            Config.save();
        }
    }

    private void setBiasTee(boolean b) {
        try {
            if (!b) {
                ((FCD2TunerController)this.device).setBiasTee(false);
            } else {
                ((FCD2TunerController)this.device).setBiasTee(true);
            }
        }
        catch (DeviceException e1) {
            Log.println("Error setting Bias Tee on FCD");
            e1.printStackTrace(Log.getWriter());
        }
        if (Config.saveFcdParams) {
            this.saveParam(this.cbBiasTee.isSelected(), "cbBiasTee");
            Config.save();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.checkingSettings) {
            return;
        }
        if (e.getSource() == this.cbMixerGain) {
            if (e.getStateChange() == 2) {
                this.setMixerGain(false);
            } else {
                this.setMixerGain(true);
            }
        }
        if (e.getSource() == this.cbLnaGain) {
            if (e.getStateChange() == 2) {
                this.setLnaGain(false);
            } else {
                this.setLnaGain(true);
            }
        }
        if (e.getSource() == this.cbBiasTee) {
            if (e.getStateChange() == 2) {
                this.setBiasTee(false);
            } else {
                this.setBiasTee(true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public int getSampleRate() {
        return 192000;
    }

    @Override
    public int getDecimationRate() {
        return 1;
    }
}

