/*
 * Decompiled with CFR 0.152.
 */
package device;

import common.Log;
import decoder.ComplexBuffer;
import decoder.Listener;
import decoder.RealBuffer;
import device.Filters;
import java.util.Arrays;

public class HilbertTransform
implements Listener<RealBuffer> {
    private float[] mHilbertFilter;
    private Listener<ComplexBuffer> mListener;
    private float[] mBuffer;
    private int mBufferSize;
    private int mBufferPointer;
    private int[][] mIndexMap;
    private int mMapHeight;
    private int mCenterTapIndex;
    private boolean mInvertFlag = false;

    public HilbertTransform() {
        this.convertHalfBandToHilbert(Filters.HALF_BAND_FILTER_47T.getCoefficients());
        this.mBufferSize = this.mHilbertFilter.length + 1;
        this.mBuffer = new float[this.mBufferSize];
        this.generateIndexMap(this.mHilbertFilter.length);
    }

    @Override
    public void receive(RealBuffer buffer) {
        if (this.mListener != null) {
            this.mListener.receive(this.filter(buffer));
        }
    }

    public void setListener(Listener<ComplexBuffer> listener) {
        this.mListener = listener;
    }

    public ComplexBuffer filter(RealBuffer buffer) {
        return new ComplexBuffer(this.filter(buffer.getSamples()));
    }

    public float[] filter(float[] samples) {
        int y = 0;
        while (y < samples.length) {
            this.insert(samples[y]);
            this.insert(samples[y + 1]);
            float accumulator = 0.0f;
            int index = this.mBufferPointer / 2;
            int x = 0;
            while (x < this.mHilbertFilter.length / 2) {
                accumulator += this.mHilbertFilter[x] * (this.mBuffer[this.mIndexMap[index][x + 1]] - this.mBuffer[this.mIndexMap[index][x]]);
                x += 2;
            }
            if (this.mInvertFlag) {
                samples[y] = -this.mBuffer[this.mIndexMap[index][this.mCenterTapIndex]];
                samples[y + 1] = -accumulator;
            } else {
                samples[y] = this.mBuffer[this.mIndexMap[index][this.mCenterTapIndex]];
                samples[y + 1] = accumulator;
            }
            this.mInvertFlag = !this.mInvertFlag;
            y += 2;
        }
        return samples;
    }

    private void insert(float sample) {
        this.mBuffer[this.mBufferPointer++] = sample;
        this.mBufferPointer %= this.mBufferSize;
    }

    private void generateIndexMap(int size) {
        this.mMapHeight = size / 2 + 1;
        int mapWidth = this.mMapHeight + 1;
        this.mIndexMap = new int[this.mMapHeight][mapWidth];
        int x = 0;
        while (x < mapWidth - 1) {
            this.mIndexMap[0][x] = size - 1 - x;
            this.mIndexMap[0][x + 1] = x;
            x += 2;
        }
        this.mCenterTapIndex = mapWidth - 1;
        this.mIndexMap[0][this.mCenterTapIndex] = size / 2;
        x = 1;
        while (x < this.mMapHeight) {
            int y = 0;
            while (y < mapWidth) {
                this.mIndexMap[x][y] = this.mIndexMap[x - 1][y] + 2;
                if (this.mIndexMap[x][y] >= size) {
                    int[] nArray = this.mIndexMap[x];
                    int n = y;
                    nArray[n] = nArray[n] - (size + 1);
                    if (y == this.mCenterTapIndex && this.mIndexMap[x][y] < 0) {
                        this.mIndexMap[x][y] = size;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    public void logIndexMap() {
        int[][] nArray = this.mIndexMap;
        int n = this.mIndexMap.length;
        int n2 = 0;
        while (n2 < n) {
            int[] indexSet = nArray[n2];
            Log.println("Row:" + Arrays.toString(indexSet));
            ++n2;
        }
    }

    private void convertHalfBandToHilbert(float[] coefficients) {
        this.mHilbertFilter = new float[coefficients.length];
        int middle = coefficients.length / 2;
        int x = 0;
        while (x < coefficients.length) {
            this.mHilbertFilter[x] = x < middle ? 2.0f * -Math.abs(coefficients[x]) : (x > middle ? 2.0f * Math.abs(coefficients[x]) : 2.0f * coefficients[x]);
            ++x;
        }
    }
}

