/*
 * Decompiled with CFR 0.152.
 */
package device;

import common.Config;
import common.Log;
import device.DeviceException;
import device.TunerController;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.usb.UsbException;

public abstract class DevicePanel
extends JPanel
implements Runnable {
    protected TunerController device;
    protected boolean running = true;
    protected boolean done = false;

    public abstract void setDevice(TunerController var1) throws IOException, DeviceException, UsbException;

    public abstract void updateFilter() throws IOException, DeviceException;

    @Override
    public abstract void setEnabled(boolean var1);

    public abstract int getSampleRate();

    public abstract int getDecimationRate();

    public void stopProcessing() {
        this.running = false;
    }

    protected void saveParam(JComboBox box, String key) {
        int g = box.getSelectedIndex();
        Log.println("SAVED " + key + ": " + g);
        Config.saveGraphIntParam("SDR", 0, 0, this.device.name, key, g);
    }

    protected void loadParam(JComboBox box, String key) {
        int g = Config.loadGraphIntValue("SDR", 0, 0, this.device.name, key);
        Log.println("Loaded " + key + ": " + g);
        box.setSelectedIndex(g);
    }

    protected void saveParam(boolean b, String key) {
        Log.println("SAVED " + key + ": " + b);
        Config.saveGraphBooleanParam("SDR", 0, 0, this.device.name, key, b);
    }

    protected void loadParam(JCheckBox b, String key) {
        boolean g = Config.loadGraphBooleanValue("SDR", 0, 0, this.device.name, key);
        Log.println("Loaded " + key + ": " + g);
        b.setSelected(g);
    }

    protected void saveParam(JSpinner spinner, String key) {
        int g = (Integer)spinner.getValue();
        Log.println("SAVED " + key + ": " + g);
        Config.saveGraphIntParam("SDR", 0, 0, this.device.name, key, g);
    }

    protected void loadParam(JSpinner spinner, String key) {
        int g = Config.loadGraphIntValue("SDR", 0, 0, this.device.name, key);
        Log.println("Loaded " + key + ": " + g);
        spinner.setValue(g);
    }
}

