/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Log;
import decoder.SourceAudio;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class SinkAudio {
    SourceDataLine sourceDataLine;
    static Mixer[] mixerList;
    AudioFormat audioFormat;

    public SinkAudio(AudioFormat af) {
        this.audioFormat = af;
        this.initializeOutput();
        Log.println("SETUP AUDIO SINK: " + af);
    }

    private static String getMixerIdString(Mixer appMixer) {
        Mixer.Info info = appMixer.getMixerInfo();
        return String.valueOf(info.getName()) + info.getDescription() + info.getVendor() + info.getVersion();
    }

    public static String getDeviceName(int position) {
        Mixer appMixer = mixerList[position];
        return SinkAudio.getMixerIdString(appMixer);
    }

    public static int getDeviceIdByName(String name) {
        int i = 1;
        while (i < mixerList.length) {
            if (mixerList[i] != null && name.equalsIgnoreCase(SinkAudio.getMixerIdString(mixerList[i]))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void setDevice(int position) throws LineUnavailableException, IllegalArgumentException {
        if (position == 0 || position == -1) {
            this.initializeOutput();
        } else {
            Mixer appMixer = mixerList[position];
            DataLine.Info sdlLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            this.sourceDataLine = (SourceDataLine)appMixer.getLine(sdlLineInfo);
            this.sourceDataLine.open(this.audioFormat);
            this.sourceDataLine.start();
        }
    }

    void initializeOutput() {
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
        try {
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
            this.sourceDataLine.open(this.audioFormat);
            this.sourceDataLine.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace(Log.getWriter());
        }
    }

    public static String[] getAudioSinks() {
        int device = 1;
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        mixerList = new Mixer[mixers.length + 1];
        String[] devices = new String[mixers.length + 1];
        Mixer.Info[] infoArray = mixers;
        int n = mixers.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info info = infoArray[n2];
            Mixer mixer = AudioSystem.getMixer(info);
            try {
                DataLine.Info sdlLineInfo = new DataLine.Info(SourceDataLine.class, SinkAudio.getAudioFormat());
                SourceDataLine sdl = (SourceDataLine)mixer.getLine(sdlLineInfo);
                sdl.close();
                SinkAudio.mixerList[device] = mixer;
                String name = info.getName();
                if (name.length() > 50) {
                    name = name.substring(0, 50);
                }
                devices[device++] = name;
            }
            catch (LineUnavailableException lineUnavailableException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
        String[] result = new String[device];
        int i = 0;
        while (i < device) {
            result[i] = devices[i];
            ++i;
        }
        return result;
    }

    public void flush() {
        this.sourceDataLine.flush();
    }

    public void closeOutput() {
        this.sourceDataLine.drain();
        this.sourceDataLine.close();
    }

    public void write(double[] f) {
        byte[] audioData = new byte[f.length * this.audioFormat.getFrameSize()];
        boolean stereo = false;
        if (this.audioFormat.getChannels() == 2) {
            stereo = true;
        }
        SourceAudio.getBytesFromDoubles(f, f.length, stereo, audioData);
        this.write(audioData);
    }

    public void write(byte[] myData) {
        this.sourceDataLine.write(myData, 0, myData.length);
    }

    public void resetChannels() {
        this.sourceDataLine.getFormat().getChannels();
    }

    private static AudioFormat getAudioFormat() {
        float sampleRate = 48000.0f;
        int sampleSizeInBits = 16;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }
}

