/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.FoxBitStream;
import decoder.LookupException;
import fec.RsCodeWord;
import java.util.Date;
import telemetry.frames.Frame;
import telemetry.frames.FrameProcessException;
import telemetry.frames.HighSpeedFrame;

public class HighSpeedBitStream
extends FoxBitStream {
    public static int FOX_HIGH_SPEED_SYNC_WORD_DISTANCE = 52730;
    public static final int NUMBER_OF_RS_CODEWORDS = 21;
    protected int numberOfRsCodeWords = 21;
    public static final int[] RS_PADDING = new int[]{3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    protected int[] rsPadding = RS_PADDING;
    protected int maxBytes = HighSpeedFrame.getMaxBytes();
    protected int dataLength = 4600;
    protected int totalRsErrors = 0;
    protected int totalRsErasures = 0;

    public HighSpeedBitStream(Decoder dec, int syncWordDistance, int wordLength, int syncWordLength, int bitRate) {
        super(syncWordDistance * 5, dec, syncWordDistance, wordLength, syncWordLength, 1000.0 / (double)bitRate);
        this.PURGE_THRESHOLD = syncWordDistance * 3;
        SYNC_WORD_BIT_TOLERANCE = 0;
    }

    @Override
    public Frame decodeFrame(int start, int end, int missedBits, int repairPosition, Date timeOfStartSync) {
        this.totalRsErrors = 0;
        this.totalRsErasures = 0;
        byte[] rawFrame = this.decodeBytes(start, end, missedBits, repairPosition);
        if (rawFrame == null) {
            return null;
        }
        HighSpeedFrame highSpeedFrame = new HighSpeedFrame();
        try {
            highSpeedFrame.addRawFrame(rawFrame);
            highSpeedFrame.rsErrors = this.totalRsErrors;
            highSpeedFrame.rsErasures = this.totalRsErasures;
            highSpeedFrame.setStpDate(timeOfStartSync);
        }
        catch (FrameProcessException e) {
            return null;
        }
        return highSpeedFrame;
    }

    /*
     * Unable to fully structure code
     */
    protected byte[] decodeBytes(int start, int end, int missedBits, int repairPosition) {
        codeWords = new RsCodeWord[this.numberOfRsCodeWords];
        insertedMissedBits = false;
        bytesInFrame = 0;
        rawFrame = new byte[this.maxBytes];
        erasurePositions = new int[this.numberOfRsCodeWords][];
        q = 0;
        while (q < this.numberOfRsCodeWords) {
            codeWords[q] = new RsCodeWord(this.rsPadding[q]);
            erasurePositions[q] = new int[223];
            ++q;
        }
        numberOfErasures = new int[this.numberOfRsCodeWords];
        if (rawFrame.length != (this.SYNC_WORD_DISTANCE - this.SYNC_WORD_LENGTH) / 10) {
            Log.println("WARNING: Frame length " + rawFrame.length + " bytes is different to default SYNC word distance " + (this.SYNC_WORD_DISTANCE / 10 - 1));
        }
        f = 0;
        rsNum = 0;
        if (Config.debugRS) {
            Log.println("RS BYTES IN UNCORRECTED FRAME: ");
        }
        j = start;
        while (j < end - this.SYNC_WORD_LENGTH) {
            block38: {
                block39: {
                    if (Config.insertMissingBits && !insertedMissedBits && missedBits > 0 && j >= repairPosition) {
                        if (Config.debugFrames) {
                            Log.println("INSERTED " + missedBits + " missed bits at " + repairPosition);
                            Log.println("RS Codeword: " + rsNum + " byte: " + f);
                            Log.println("Byte num: " + bytesInFrame);
                        }
                        j -= missedBits;
                        insertedMissedBits = true;
                    }
                    b8 = -1;
                    try {
                        b8 = this.processWord(j);
                        break block38;
                    }
                    catch (LookupException e) {
                        if (!Config.useRSerasures) break block38;
                        if (numberOfErasures[rsNum] < 15) {
                            erasurePositions[rsNum][numberOfErasures[rsNum]] = f;
                            v0 = rsNum;
                            numberOfErasures[v0] = numberOfErasures[v0] + 1;
                            break block38;
                        }
                        if (!Config.debugFrames && !Config.debugRS) break block39;
                        total = 0;
                        var20_24 = numberOfErasures;
                        var19_25 = numberOfErasures.length;
                        var18_26 = 0;
                        ** while (var18_26 < var19_25)
                    }
lbl-1000:
                    // 1 sources

                    {
                        e1 = var20_24[var18_26];
                        total += e1;
                        ++var18_26;
                        continue;
                    }
lbl49:
                    // 1 sources

                    Log.println("MAX ERASURES HIT: RS Decode Abandoned. Total: " + total);
                }
                return null;
            }
            if (++bytesInFrame == this.dataLength + 1 && rsNum != 0) {
                rsNum = 0;
                ++f;
            }
            try {
                if (Config.debugRS) {
                    Log.print(String.valueOf(bytesInFrame - 1) + ": RS[" + rsNum + "," + f + "]=" + Decoder.plainhex(b8) + " | ");
                }
                codeWords[rsNum++].addByte(b8);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace(Log.getWriter());
            }
            if (rsNum == this.numberOfRsCodeWords) {
                rsNum = 0;
                if (++f > 255) {
                    Log.println("ERROR: Allocated more high speed data than fits in an RSCodeWord");
                }
            }
            j += 10;
        }
        if (Config.debugFrames || Config.debugRS) {
            Log.println("CAPTURED " + bytesInFrame + " high speed bytes");
        }
        i = 0;
        while (i < this.numberOfRsCodeWords) {
            if (numberOfErasures[i] < 15) {
                this.totalRsErasures += numberOfErasures[i];
                if (Config.useRSfec) {
                    if (Config.useRSerasures) {
                        codeWords[i].setErasurePositions(erasurePositions[i], numberOfErasures[i]);
                    }
                    codeWords[i].decode();
                    this.totalRsErrors += codeWords[i].getNumberOfCorrections();
                    if (!codeWords[i].validDecode()) {
                        if (Config.debugFrames || Config.debugRS) {
                            Log.println("FAILED RS DECODE FOR HS WORD " + i);
                        }
                        return null;
                    }
                }
            } else {
                if (Config.debugFrames || Config.debugRS) {
                    total = 0;
                    var18_27 = numberOfErasures;
                    e1 = numberOfErasures.length;
                    total = 0;
                    while (total < e1) {
                        e = var18_27[total];
                        total += e;
                        ++total;
                    }
                    Log.println("Too many erasures, failure to decode.  Total:" + total);
                }
                return null;
            }
            ++i;
        }
        if (Config.debugRS) {
            Log.println("RS CORRECTED BYTES IN FRAME: " + bytesInFrame);
        }
        f = 0;
        rsNum = 0;
        needsPaddingOffset = false;
        readingParity = false;
        i = 0;
        rsNum = 0;
        while (i < bytesInFrame) {
            if (readingParity && needsPaddingOffset && this.rsPadding[0] != this.rsPadding[rsNum]) {
                rawFrame[i] = codeWords[rsNum].getByte(f - 1);
                if (Config.debugRS) {
                    Log.print(String.valueOf(i) + ": RS OFF[" + rsNum + "," + (f - 1) + "]=" + Decoder.plainhex(codeWords[rsNum].getByte(f - 1)) + " | ");
                }
            } else {
                rawFrame[i] = codeWords[rsNum].getByte(f);
                if (Config.debugRS) {
                    Log.print(String.valueOf(i) + ": RS[" + rsNum + "," + f + "]=" + Decoder.plainhex(codeWords[rsNum].getByte(f)) + " | ");
                }
            }
            ++i;
            if (++rsNum == this.numberOfRsCodeWords) {
                rsNum = 0;
                ++f;
            }
            if (i != this.dataLength) continue;
            rsNum = 0;
            if (Config.debugRS) {
                Log.println("\nPARITY: at " + i);
            }
            readingParity = true;
            firstPad = this.rsPadding[0];
            p = 0;
            while (p < this.rsPadding.length) {
                if (this.rsPadding[p] != firstPad) {
                    needsPaddingOffset = true;
                }
                ++p;
            }
            if (needsPaddingOffset) {
                if (Config.debugRS) {
                    Log.println("WE NEED OFFSET to padding");
                }
                ++f;
            }
            if (!Config.debugRS) continue;
            Log.println("CHECK BYTES:");
        }
        return rawFrame;
    }
}

