/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Config;
import common.FoxTime;
import common.Log;
import common.SatelliteManager;
import common.SpacecraftPositionCache;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import predict.FoxTLE;
import predict.PositionCalcException;
import predict.SortedTleList;
import telemetry.BitArrayLayout;
import telemetry.Format.TelemFormat;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.SortedFramePartArrayList;
import telemetry.conversion.Conversion;
import telemetry.conversion.ConversionCurve;
import telemetry.conversion.ConversionFormat;
import telemetry.conversion.ConversionInvalidCheck;
import telemetry.conversion.ConversionLegacy;
import telemetry.conversion.ConversionLookUpTable;
import telemetry.conversion.ConversionMathExpression;
import telemetry.conversion.ConversionStringLookUpTable;
import telemetry.conversion.ConversionTimestamp;
import telemetry.frames.FrameLayout;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;
import telemetry.uw.CanFrames;
import uk.me.g4dpz.satellite.SatPos;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.SatelliteFactory;
import uk.me.g4dpz.satellite.TLE;

public class Spacecraft
implements Comparable<Spacecraft> {
    public Properties properties;
    public File propertiesFile;
    SatelliteManager satManager;
    public static String SPACECRAFT_DIR = "spacecraft";
    public static final int ERROR_IDX = -1;
    @Deprecated
    public static final int FOX1A = 1;
    @Deprecated
    public static final int FOX1B = 2;
    @Deprecated
    public static final int FOX1C = 3;
    @Deprecated
    public static final int FOX1D = 4;
    public static final int FIRST_FOXID_WITH_MODE_IN_HEADER = 6;
    public static final int MAX_FOXID = 256;
    @Deprecated
    public static final String DEBUG_LAYOUT = "DEBUG";
    @Deprecated
    public static final String REAL_TIME_LAYOUT = "rttelemetry";
    @Deprecated
    public static final String MAX_LAYOUT = "maxtelemetry";
    @Deprecated
    public static final String MIN_LAYOUT = "mintelemetry";
    @Deprecated
    public static final String RAD_LAYOUT = "radtelemetry";
    @Deprecated
    public static final String RAD2_LAYOUT = "radtelemetry2";
    @Deprecated
    public static final String HERCI_HS_LAYOUT = "herciHSdata";
    @Deprecated
    public static final String HERCI_HS_HEADER_LAYOUT = "herciHSheader";
    @Deprecated
    public static final String HERCI_HS_PKT_LAYOUT = "herciHSpackets";
    @Deprecated
    public static final String WOD_LAYOUT = "wodtelemetry";
    @Deprecated
    public static final String WOD_RAD_LAYOUT = "wodradtelemetry";
    @Deprecated
    public static final String WOD_RAD2_LAYOUT = "wodradtelemetry2";
    @Deprecated
    public static final String RAD_LEPF_LAYOUT = "radtelemLEPF";
    @Deprecated
    public static final String RAD_LEP_LAYOUT = "radtelemLEP";
    @Deprecated
    public static final String RAD_REM_LAYOUT = "radtelemREM";
    @Deprecated
    public static final String CAN_LAYOUT = "cantelemetry";
    @Deprecated
    public static final String WOD_CAN_LAYOUT = "wodcantelemetry";
    @Deprecated
    public static final String CAN_PKT_LAYOUT = "canpacket";
    @Deprecated
    public static final String WOD_CAN_PKT_LAYOUT = "wodcanpacket";
    @Deprecated
    public static final String RSSI_LOOKUP = "RSSI";
    @Deprecated
    public static final String IHU_VBATT_LOOKUP = "IHU_VBATT";
    @Deprecated
    public static final String IHU_TEMP_LOOKUP = "IHU_TEMP";
    @Deprecated
    public static final String HUSKY_SAT_ISIS_ANT_TEMP = "HUSKY_ISIS_ANT_TEMP";
    public static final int EM = 0;
    public static final int FM = 1;
    public static final int FS = 2;
    public static String[] modelNames = new String[]{"Engineering Model", "Flight Model", "Flight Spare"};
    public static String[] models = new String[]{"EM", "FM", "FS"};
    public int foxId = 0;
    public int catalogNumber = 0;
    public String series = "FOX";
    public String description = "";
    public int model;
    public String canFileDir = "HuskySat";
    public String user_format = "DUV_FSK";
    public boolean telemetryMSBfirst = true;
    public boolean ihuLittleEndian = true;
    public int numberOfLayouts = 0;
    public int numberOfDbLayouts = 0;
    public String[] layoutFilename;
    public BitArrayLayout[] layout;
    private boolean[] sendLayoutLocally;
    public CanFrames canFrames;
    public int numberOfLookupTables = 0;
    public String[] lookupTableFilename;
    public ConversionLookUpTable[] lookupTable;
    public int numberOfStringLookupTables = 0;
    public String[] stringLookupTableFilename;
    public ConversionStringLookUpTable[] stringLookupTable;
    public int numberOfSources = 1;
    public String[] sourceName = new String[]{"amsat.fox-1a.ihu.duv"};
    public String[] sourceFormatName;
    public TelemFormat[] sourceFormat;
    public String measurementsFileName = "measurements.csv";
    public String passMeasurementsFileName = "passmeasurements.csv";
    public BitArrayLayout measurementLayout;
    public BitArrayLayout passMeasurementLayout;
    public static final String MEASUREMENTS = "measurements";
    public static final String PASS_MEASUREMENTS = "passmeasurements";
    public int numberOfFrameLayouts = 0;
    public String[] frameLayoutFilename;
    public FrameLayout[] frameLayout;
    public static final String USER_ = "user_";
    public Properties user_properties;
    public File userPropertiesFile;
    public String user_display_name = "Amsat-1";
    public String user_keps_name = "Amsat-1";
    public int user_priority = 9;
    public boolean user_track = true;
    public double user_telemetryDownlinkFreqkHz = 145980.0;
    public double user_minFreqBoundkHz = 145970.0;
    public double user_maxFreqBoundkHz = 145990.0;
    public String user_localServer = "";
    public int user_localServerPort = 8587;
    public SatPos satPos;
    public double satPosErrorCode;
    public boolean hasCanBus;
    public boolean hasFrameCrc = false;
    private SortedTleList tleList;
    public boolean useConversionCoeffs = false;
    private HashMap<String, Conversion> conversions;
    public String conversionCurvesFileName;
    public String conversionExpressionsFileName;
    public boolean hasFOXDB_V3 = false;
    public static final int EXP_EMPTY = 0;
    public static final int EXP_VANDERBILT_LEP = 1;
    public static final int EXP_VT_CAMERA = 2;
    public static final int EXP_IOWA_HERCI = 3;
    public static final int EXP_RAD_FX_SAT = 4;
    public static final int EXP_VT_CAMERA_LOW_RES = 5;
    public static final int EXP_VANDERBILT_VUC = 6;
    public static final int EXP_VANDERBILT_REM = 7;
    public static final int EXP_VANDERBILT_LEPF = 8;
    public static final int EXP_UW = 9;
    public static final int RAG_ADAC = 10;
    public static final int LBAND_DOWNSHIFTER = 11;
    public static final int EXP_UMAINE_CAMERA = 12;
    public static final String SAFE_MODE_IND = "SafeModeIndication";
    public static final String SCIENCE_MODE_IND = "ScienceModeActive";
    @Deprecated
    public static final String MEMS_REST_VALUE_X = "SatelliteXAxisAngularVelocity";
    @Deprecated
    public static final String MEMS_REST_VALUE_Y = "SatelliteYAxisAngularVelocity";
    @Deprecated
    public static final String MEMS_REST_VALUE_Z = "SatelliteZAxisAngularVelocity";
    public static final int NO_MODE = 0;
    public static final int SAFE_MODE = 1;
    public static final int TRANSPONDER_MODE = 2;
    public static final int DATA_MODE = 3;
    public static final int SCIENCE_MODE = 4;
    public static final int HEALTH_MODE = 5;
    public static final int CAMERA_MODE = 6;
    public static final String[] modeNames = new String[]{"UNKNOWN", "SAFE", "TRANSPONDER", "DATA", "SCIENCE", "HEALTH", "CAMERA"};
    public static final String[] expNames = new String[]{"Empty", "Vanderbilt LEP", "Virginia Tech Camera", "University of Iowa HERCI", "Rad FX Sat", "Virginia Tech Low-res Camera", "Vanderbilt VUC", "Vanderbilt REM", "Vanderbilt LEPF", "CAN Packet Interface", "Ragnaroc ADAC", "L-Band Downshifter", "University of Maine multi-spectral camera"};
    public int IHU_SN = 0;
    public int[] experiments = new int[4];
    public boolean hasImprovedCommandReceiver = false;
    public boolean hasImprovedCommandReceiverII = false;
    public boolean hasModeInHeader = false;
    @Deprecated
    public boolean hasMpptSettings = false;
    @Deprecated
    public boolean hasMemsRestValues = false;
    public boolean hasFixedReset = false;
    public boolean hasGPSTime = false;
    public boolean user_useGPSTimeForT0 = true;
    @Deprecated
    public double user_BATTERY_CURRENT_ZERO = 0.0;
    @Deprecated
    public double user_mpptResistanceError = 6.58;
    @Deprecated
    public int user_mpptSensorOffThreshold = 1600;
    @Deprecated
    public int user_memsRestValueX = 0;
    @Deprecated
    public int user_memsRestValueY = 0;
    @Deprecated
    public int user_memsRestValueZ = 0;
    @Deprecated
    public boolean useIHUVBatt = false;
    ArrayList<Long> timeZero = null;
    SpacecraftPositionCache positionCache;
    public static final DateFormat timeDateFormat = new SimpleDateFormat("HH:mm:ss");
    public static final DateFormat dateDateFormat = new SimpleDateFormat("dd MMM yy");

    public Spacecraft(SatelliteManager satManager, File masterFileName, File userFileName) throws LayoutLoadException, FileNotFoundException {
        this.satManager = satManager;
        this.properties = new Properties();
        this.propertiesFile = masterFileName;
        this.userPropertiesFile = userFileName;
        this.tleList = new SortedTleList(10);
        try {
            this.load();
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            Log.errorDialog("ERROR", "Can't fully load spacecraft file: " + masterFileName + "\nPerhaps one of the files is corrupt? " + "\n" + e1.getMessage());
            e1.printStackTrace();
            return;
        }
        try {
            this.loadTimeZeroSeries(null);
        }
        catch (FileNotFoundException e) {
            this.timeZero = null;
        }
        catch (IndexOutOfBoundsException e) {
            this.timeZero = null;
        }
        try {
            this.measurementLayout = new BitArrayLayout(String.valueOf(System.getProperty("user.dir")) + File.separator + SPACECRAFT_DIR + File.separator + this.measurementsFileName);
            this.measurementLayout.name = MEASUREMENTS;
            if (this.passMeasurementsFileName != null) {
                this.passMeasurementLayout = new BitArrayLayout(String.valueOf(System.getProperty("user.dir")) + File.separator + SPACECRAFT_DIR + File.separator + this.passMeasurementsFileName);
                this.passMeasurementLayout.name = PASS_MEASUREMENTS;
            }
        }
        catch (IOException e) {
            throw new LayoutLoadException("Could not load measurement layout.  Make sure it is installed\nin folder:" + Config.spacecraftDir + "\n" + e.getMessage());
        }
        this.loadTleHistory();
        this.positionCache = new SpacecraftPositionCache(this.foxId);
    }

    public Spacecraft(SatelliteManager satManager, File masterFileName, File userFileName, int foxId) {
        this.satManager = satManager;
        this.properties = new Properties();
        this.propertiesFile = masterFileName;
        this.userPropertiesFile = userFileName;
        this.tleList = new SortedTleList(10);
        this.foxId = foxId;
        this.hasFOXDB_V3 = true;
        this.store_master_params();
    }

    @Deprecated
    public boolean isFox1() {
        return true;
    }

    public int getLayoutIdxByName(String name) {
        int i = 0;
        while (i < this.numberOfLayouts) {
            if (this.layout[i].name.equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLookupIdxByName(String name) {
        int i = 0;
        while (i < this.numberOfLookupTables) {
            if (this.lookupTable[i].getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public BitArrayLayout getLayoutByName(String name) {
        int i = this.getLayoutIdxByName(name);
        if (i != -1) {
            return this.layout[i];
        }
        return null;
    }

    public String getLayoutNameByType(String type) {
        int i = 0;
        while (i < this.numberOfLayouts) {
            if (this.layout[i].typeStr.equalsIgnoreCase(type)) {
                return this.layout[i].name;
            }
            ++i;
        }
        return null;
    }

    public BitArrayLayout getLayoutByType(String type) {
        int i = 0;
        while (i < this.numberOfLayouts) {
            if (this.layout[i].typeStr.equalsIgnoreCase(type)) {
                return this.layout[i];
            }
            ++i;
        }
        return null;
    }

    public BitArrayLayout getSecondaryLayoutFromPrimaryName(String name) {
        int i = 0;
        while (i < this.numberOfLayouts) {
            if (this.layout[i].parentLayout != null && this.layout[i].parentLayout.equalsIgnoreCase(name)) {
                return this.layout[i];
            }
            ++i;
        }
        return null;
    }

    public BitArrayLayout getLayoutByCanId(int canId) {
        int i;
        if (!this.hasCanBus) {
            return null;
        }
        if (this.canFrames == null) {
            return null;
        }
        String name = this.canFrames.getNameByCanId(canId);
        if (name != null && (i = this.getLayoutIdxByName(name)) != -1) {
            return this.layout[i];
        }
        return this.getLayoutByName(CAN_PKT_LAYOUT);
    }

    public String[] getPayloadList() {
        String[] payloadList = new String[this.numberOfLayouts];
        int i = 0;
        while (i < this.numberOfLayouts) {
            payloadList[i] = this.layout[i].name;
            ++i;
        }
        return payloadList;
    }

    public String[] getConversionsArray() {
        if (this.conversions == null) {
            return new String[0];
        }
        String[] conv = new String[this.conversions.size()];
        int i = 0;
        for (String key : this.conversions.keySet()) {
            conv[i++] = key;
        }
        return conv;
    }

    public Conversion getConversionByName(String name) {
        name = name.trim();
        if (this.useConversionCoeffs) {
            if (this.conversions == null) {
                return null;
            }
            Conversion conv = this.conversions.get(name);
            if (conv != null) {
                return conv;
            }
        }
        try {
            int convInt = Integer.parseInt(name);
            if (convInt >= 0 && convInt <= 63) {
                return new ConversionLegacy(name, this);
            }
        }
        catch (NumberFormatException convInt) {
            // empty catch block
        }
        try {
            if (name.equalsIgnoreCase("INT")) {
                return new ConversionFormat(name, this);
            }
            if (name.equalsIgnoreCase("FLOAT1")) {
                return new ConversionFormat(name, this);
            }
            if (name.equalsIgnoreCase("FLOAT2")) {
                return new ConversionFormat(name, this);
            }
            if (name.equalsIgnoreCase("FLOAT3")) {
                return new ConversionFormat(name, this);
            }
            if (name.equalsIgnoreCase("FLOAT4")) {
                return new ConversionFormat(name, this);
            }
            if (name.equalsIgnoreCase("FLOAT5")) {
                return new ConversionFormat(name, this);
            }
            if (name.equalsIgnoreCase("FLOAT6")) {
                return new ConversionFormat(name, this);
            }
            if (name.substring(0, "HEX".length()).equalsIgnoreCase("HEX")) {
                return new ConversionFormat(name, this);
            }
            if (name.substring(0, "BIN".length()).equalsIgnoreCase("BIN")) {
                return new ConversionFormat(name, this);
            }
            if (name.substring(0, "FLOAT".length()).equalsIgnoreCase("FLOAT")) {
                return new ConversionFormat(name, this);
            }
            if (name.substring(0, "TIMESTAMP".length()).equalsIgnoreCase("TIMESTAMP")) {
                return new ConversionTimestamp(name, this);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        try {
            if (name.substring(0, "invalid_check".length()).equalsIgnoreCase("invalid_check")) {
                return new ConversionInvalidCheck(name, this);
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        return null;
    }

    public ConversionLookUpTable getLookupTableByName(String name) {
        int i = this.getLookupIdxByName(name);
        if (i != -1) {
            return this.lookupTable[i];
        }
        return null;
    }

    public String getLayoutFileNameByName(String name) {
        int i = this.getLayoutIdxByName(name);
        if (i != -1) {
            return this.layoutFilename[i];
        }
        return null;
    }

    public String getLookupTableFileNameByName(String name) {
        int i = this.getLookupIdxByName(name);
        if (i != -1) {
            return this.lookupTableFilename[i];
        }
        return null;
    }

    protected void loadTleHistory() {
        String file = String.valueOf(SPACECRAFT_DIR) + File.separator + this.series + this.foxId + ".tle";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            file = String.valueOf(Config.logFileDirectory) + File.separator + file;
        }
        File f = new File(file);
        InputStream is = null;
        try {
            try {
                Log.println("Loading TLE file: " + file);
                is = new FileInputStream(f);
                this.tleList = FoxTLE.importFoxSat(is);
            }
            catch (IOException e) {
                Log.println("... TLE file not loaded: " + file);
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveTleHistory() throws IOException {
        String file = String.valueOf(SPACECRAFT_DIR) + File.separator + this.series + this.foxId + ".tle";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            file = String.valueOf(Config.logFileDirectory) + File.separator + file;
        }
        File f = new File(file);
        BufferedWriter output = new BufferedWriter(new FileWriter(f, false));
        for (FoxTLE tle : this.tleList) {
            output.write(tle.toFileString());
        }
        ((Writer)output).flush();
        ((Writer)output).close();
    }

    public boolean addTLE(FoxTLE tle) throws IOException {
        this.tleList.add(tle);
        this.saveTleHistory();
        return true;
    }

    protected TLE getTLEbyDate(DateTime dateTime) throws PositionCalcException {
        if (this.tleList == null) {
            return null;
        }
        FoxTLE t = this.tleList.getTleByDate(dateTime);
        if (t == null) {
            this.satPosErrorCode = -997.0;
            throw new PositionCalcException(-997.0);
        }
        return t;
    }

    public SatPos calcSatellitePosition(DateTime timeNow) throws PositionCalcException {
        TLE tle = this.getTLEbyDate(timeNow);
        if (tle == null) {
            this.satPosErrorCode = -997.0;
            throw new PositionCalcException(-997.0);
        }
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        SatPos satellitePosition = satellite.getPosition(Config.GROUND_STATION, timeNow.toDate());
        return satellitePosition;
    }

    protected SatPos calcualteCurrentPosition() throws PositionCalcException {
        DateTime timeNow = new DateTime(DateTimeZone.UTC);
        SatPos pos = null;
        this.satPos = pos = this.calcSatellitePosition(timeNow);
        if (Config.debugSignalFinder) {
            Log.println("Fox at: " + FramePart.latRadToDeg(pos.getAzimuth()) + " : " + FramePart.lonRadToDeg(pos.getElevation()));
        }
        return pos;
    }

    public SatPos getCurrentPosition() throws PositionCalcException {
        if (this.satPos == null) {
            throw new PositionCalcException(-999.0);
        }
        return this.satPos;
    }

    public boolean aboveHorizon() {
        if (this.satPos == null) {
            return false;
        }
        return FramePart.radToDeg(this.satPos.getElevation()) >= 0.0;
    }

    public boolean setT0FromGPSTime(int resetToAdd, long uptime, ZonedDateTime timestamp) {
        int reset = 0;
        if (this.hasTimeZero()) {
            reset = this.timeZero.size();
        } else {
            this.timeZero = new ArrayList(100);
        }
        long T0Seconds = (timestamp.toEpochSecond() - uptime) * 1000L;
        int i = reset;
        while (i <= resetToAdd) {
            this.timeZero.add(i, T0Seconds);
            ++i;
        }
        try {
            this.saveTimeZeroSeries();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
            return false;
        }
        if (Config.debugFrames) {
            Log.println("SAVING RESET: " + resetToAdd + " as " + timestamp);
        }
        return true;
    }

    public int getCurrentReset(int resetOnFrame, long uptime) {
        if (!this.hasFixedReset) {
            return resetOnFrame;
        }
        if (this.hasTimeZero()) {
            int reset = this.timeZero.size() - 1;
            long T0Seconds = this.timeZero.get(reset) / 1000L;
            Date now = new Date();
            long nowSeconds = now.getTime() / 1000L;
            long newT0estimate = (nowSeconds - uptime) * 1000L;
            if (resetOnFrame == reset + 1) {
                this.timeZero.add(newT0estimate);
                try {
                    this.saveTimeZeroSeries();
                }
                catch (IOException e) {
                    e.printStackTrace(Log.getWriter());
                }
                if (Config.debugFrames) {
                    Log.println("SAVING RESET: " + resetOnFrame);
                }
                return resetOnFrame;
            }
            long diff = Math.abs(nowSeconds - (T0Seconds + uptime));
            if (uptime < (long)Config.newResetCheckUptimeMax && diff > (long)Config.newResetCheckThreshold) {
                Log.println("*** HUSKY RESET DETECTED ...." + diff);
                this.timeZero.add(newT0estimate);
                try {
                    this.saveTimeZeroSeries();
                }
                catch (IOException e) {
                    e.printStackTrace(Log.getWriter());
                }
                if (Config.debugFrames) {
                    Log.println("SAVING RESET: " + (reset + 1));
                }
                return reset + 1;
            }
            if (Config.debugFrames) {
                Log.println("SAVING RESET: " + reset);
            }
            return reset;
        }
        if (Config.debugFrames) {
            Log.println("SAVING RESET: " + resetOnFrame);
        }
        return resetOnFrame;
    }

    public boolean hasTimeZero() {
        if (this.timeZero == null) {
            return false;
        }
        return this.timeZero.size() != 0;
    }

    public boolean hasTimeZero(int reset) {
        if (this.timeZero == null) {
            return false;
        }
        return reset < this.timeZero.size();
    }

    public String[][] getT0TableData() {
        if (this.timeZero == null) {
            return null;
        }
        if (this.timeZero.size() == 0) {
            return null;
        }
        String[][] data = new String[this.timeZero.size()][];
        int i = 0;
        while (i < this.timeZero.size()) {
            data[i] = new String[2];
            data[i][0] = "" + i;
            data[i][1] = String.valueOf(this.getUtcDateForReset(i, 0L)) + " " + this.getUtcTimeForReset(i, 0L);
            ++i;
        }
        return data;
    }

    public String getUtcTimeForReset(int reset, long uptime) {
        if (this.timeZero == null) {
            return null;
        }
        if (reset >= this.timeZero.size()) {
            return null;
        }
        Date dt = new Date(this.timeZero.get(reset) + uptime * 1000L);
        timeDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = timeDateFormat.format(dt);
        return time;
    }

    public String getUtcDateForReset(int reset, long uptime) {
        if (this.timeZero == null) {
            return null;
        }
        if (reset >= this.timeZero.size()) {
            return null;
        }
        Date dt = new Date(this.timeZero.get(reset) + uptime * 1000L);
        dateDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = dateDateFormat.format(dt);
        return time;
    }

    public Date getUtcForReset(int reset, long uptime) {
        if (this.timeZero == null) {
            return null;
        }
        if (reset >= this.timeZero.size()) {
            return null;
        }
        Date dt = new Date(this.timeZero.get(reset) + uptime * 1000L);
        return dt;
    }

    public DateTime getUtcDateTimeForReset(int reset, long uptime) {
        if (this.timeZero == null) {
            return null;
        }
        if (reset < 0 || reset >= this.timeZero.size()) {
            return null;
        }
        if (uptime < 0L) {
            return null;
        }
        Date dt = new Date(this.timeZero.get(reset) + uptime * 1000L);
        DateTime dateTime = new DateTime(dt);
        return dateTime;
    }

    public FoxTime getUptimeForUtcDate(Date fromDate) {
        if (this.timeZero == null) {
            return null;
        }
        if (fromDate == null) {
            return null;
        }
        if (this.timeZero.size() == 0) {
            return null;
        }
        long dateTime = fromDate.getTime();
        long T0 = -1L;
        int reset = 0;
        long uptime = 0L;
        int i = 0;
        while (i < this.timeZero.size()) {
            if (this.timeZero.get(i) > dateTime) {
                if (i == 0) break;
                reset = i - 1;
                T0 = this.timeZero.get(reset);
                break;
            }
            ++i;
        }
        if (T0 == -1L) {
            reset = this.timeZero.size() - 1;
            T0 = this.timeZero.get(reset);
        }
        uptime = dateTime - T0;
        FoxTime ft = new FoxTime(reset, uptime /= 1000L);
        return ft;
    }

    public SatPos getSatellitePosition(int reset, long uptime) throws PositionCalcException {
        DateTime timeNow = this.getUtcDateTimeForReset(reset, uptime);
        if (timeNow == null) {
            throw new PositionCalcException(-998.0);
        }
        SatPos satellitePosition = this.positionCache.getPosition(timeNow.getMillis());
        if (satellitePosition != null) {
            return satellitePosition;
        }
        TLE tle = this.getTLEbyDate(timeNow);
        if (tle == null) {
            throw new PositionCalcException(-997.0);
        }
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        satellitePosition = satellite.getPosition(Config.GROUND_STATION, timeNow.toDate());
        this.positionCache.storePosition(timeNow.getMillis(), satellitePosition);
        return satellitePosition;
    }

    public boolean sendToLocalServer() {
        if (this.user_localServer == null) {
            return false;
        }
        return !this.user_localServer.equalsIgnoreCase("");
    }

    public boolean shouldSendLayout(String name) {
        int i = 0;
        while (i < this.numberOfLayouts) {
            if (this.layout[i].name.equals(name) && this.sendLayoutLocally[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isValidConversion(String conv) {
        Conversion c = this.getConversionByName(conv);
        return c != null;
    }

    public void loadConversions() throws LayoutLoadException, FileNotFoundException, IOException {
        if (this.useConversionCoeffs) {
            String sNumberOfStringLookupTables;
            this.conversions = new HashMap();
            if (this.conversionCurvesFileName != null) {
                this.loadConversionCurves(String.valueOf(Config.spacecraftDir) + File.separator + this.conversionCurvesFileName);
            }
            if (this.conversionExpressionsFileName != null) {
                this.loadConversionExpresions(String.valueOf(Config.spacecraftDir) + File.separator + this.conversionExpressionsFileName);
            }
            if ((sNumberOfStringLookupTables = this.getOptionalProperty("numberOfStringLookupTables")) != null) {
                this.numberOfStringLookupTables = Integer.parseInt(sNumberOfStringLookupTables);
                this.stringLookupTableFilename = new String[this.numberOfStringLookupTables];
                this.stringLookupTable = new ConversionStringLookUpTable[this.numberOfStringLookupTables];
                int i = 0;
                while (i < this.numberOfStringLookupTables) {
                    this.stringLookupTableFilename[i] = this.getProperty("stringLookupTable" + i + ".filename");
                    String tableName = this.getProperty("stringLookupTable" + i);
                    this.stringLookupTable[i] = new ConversionStringLookUpTable(tableName, this.stringLookupTableFilename[i], this);
                    if (this.conversions.containsKey(this.stringLookupTable[i].getName())) {
                        Log.errorDialog("DUPLICATE STRING TABLE NAME", String.valueOf(this.user_keps_name) + ": Lookup table or Curve already defined and will not be stored: " + tableName);
                    } else {
                        this.conversions.put(tableName, this.stringLookupTable[i]);
                        Log.println("Stored: " + this.stringLookupTable[i]);
                    }
                    ++i;
                }
            }
        }
        this.numberOfLookupTables = Integer.parseInt(this.getProperty("numberOfLookupTables"));
        this.lookupTableFilename = new String[this.numberOfLookupTables];
        this.lookupTable = new ConversionLookUpTable[this.numberOfLookupTables];
        int i = 0;
        while (i < this.numberOfLookupTables) {
            this.lookupTableFilename[i] = this.getProperty("lookupTable" + i + ".filename");
            String tableName = this.getProperty("lookupTable" + i);
            this.lookupTable[i] = new ConversionLookUpTable(tableName, this.lookupTableFilename[i], this);
            if (this.useConversionCoeffs) {
                if (this.conversions.containsKey(this.lookupTable[i].getName())) {
                    Log.errorDialog("DUPLICATE TABLE NAME", String.valueOf(this.user_keps_name) + ": Lookup table already defined and will not be stored: " + tableName);
                } else {
                    this.conversions.put(tableName, this.lookupTable[i]);
                    Log.println("Stored: " + this.lookupTable[i]);
                }
            }
            ++i;
        }
    }

    protected void load() throws LayoutLoadException {
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.propertiesFile);
            this.properties.load(f);
            f.close();
        }
        catch (IOException e) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new LayoutLoadException("Could not load spacecraft.  File is missing: " + this.propertiesFile.getAbsolutePath());
        }
        try {
            String crc;
            String t;
            this.foxId = Integer.parseInt(this.getProperty("foxId"));
            this.catalogNumber = Integer.parseInt(this.getProperty("catalogNumber"));
            this.user_keps_name = this.getProperty("name");
            this.description = this.getProperty("description");
            this.model = Integer.parseInt(this.getProperty("model"));
            this.user_telemetryDownlinkFreqkHz = Double.parseDouble(this.getProperty("telemetryDownlinkFreqkHz"));
            this.user_minFreqBoundkHz = Double.parseDouble(this.getProperty("minFreqBoundkHz"));
            this.user_maxFreqBoundkHz = Double.parseDouble(this.getProperty("maxFreqBoundkHz"));
            this.useConversionCoeffs = this.getOptionalBooleanProperty("useConversionCoeffs");
            String frames = this.getOptionalProperty("numberOfFrameLayouts");
            if (frames == null) {
                this.numberOfFrameLayouts = 0;
            } else {
                this.numberOfFrameLayouts = Integer.parseInt(frames);
                this.frameLayoutFilename = new String[this.numberOfFrameLayouts];
                this.frameLayout = new FrameLayout[this.numberOfFrameLayouts];
                int i = 0;
                while (i < this.numberOfFrameLayouts) {
                    this.frameLayoutFilename[i] = this.getProperty("frameLayout" + i + ".filename");
                    this.frameLayout[i] = new FrameLayout(this.foxId, this.frameLayoutFilename[i]);
                    this.frameLayout[i].name = this.getProperty("frameLayout" + i + ".name");
                    ++i;
                }
            }
            if (this.useConversionCoeffs) {
                this.conversionCurvesFileName = this.getOptionalProperty("conversionCurvesFileName");
                this.conversionExpressionsFileName = this.getOptionalProperty("conversionExpressionsFileName");
            }
            this.loadConversions();
            String V3DB = this.getOptionalProperty("hasFOXDB_V3");
            this.hasFOXDB_V3 = V3DB == null ? false : Boolean.parseBoolean(V3DB);
            this.numberOfDbLayouts = this.numberOfLayouts = Integer.parseInt(this.getProperty("numberOfLayouts"));
            this.layoutFilename = new String[this.numberOfLayouts];
            this.layout = new BitArrayLayout[this.numberOfLayouts];
            this.sendLayoutLocally = new boolean[this.numberOfLayouts];
            int i = 0;
            while (i < this.numberOfLayouts) {
                this.layoutFilename[i] = this.getProperty("layout" + i + ".filename");
                this.layout[i] = new BitArrayLayout(String.valueOf(Config.spacecraftDir) + File.separator + this.layoutFilename[i]);
                if (this.useConversionCoeffs) {
                    int c = 0;
                    while (c < this.layout[i].NUMBER_OF_FIELDS) {
                        String[] conversions;
                        String convName = this.layout[i].getConversionNameByPos(c);
                        String[] stringArray = conversions = convName.split("\\|");
                        int n = conversions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block52: {
                                String singleConv = stringArray[n2];
                                singleConv = singleConv.trim();
                                try {
                                    int convInt = Integer.parseInt(singleConv);
                                    if (convInt > 63 && !Config.ignoreSpacecraftLoadErrors) {
                                        throw new LayoutLoadException("Conversion number " + convInt + " is not defined. " + "Error in row for field: " + this.layout[i].fieldName[c] + " on row: " + c + "\nwhen processing layout: " + this.layoutFilename[i]);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    Conversion conv = this.getConversionByName(singleConv);
                                    if (conv != null) break block52;
                                    String stem3 = "";
                                    if (singleConv.length() >= 3) {
                                        stem3 = singleConv.substring(0, 3);
                                    }
                                    String stem5 = "";
                                    if (singleConv.length() >= 5) {
                                        stem5 = singleConv.substring(0, 5);
                                    }
                                    String stem9 = "";
                                    if (singleConv.length() >= 9) {
                                        stem9 = singleConv.substring(0, 9);
                                    }
                                    if (stem3.equalsIgnoreCase("INT") || stem3.equalsIgnoreCase("BIN") || stem3.equalsIgnoreCase("HEX") || stem5.equalsIgnoreCase("FLOAT") || stem9.equalsIgnoreCase("TIMESTAMP") || Config.ignoreSpacecraftLoadErrors) break block52;
                                    throw new LayoutLoadException("Conversion '" + convName + "' is not defined. " + "Error in row for field: " + this.layout[i].fieldName[c] + " on row: " + c + "\nwhen processing layout: " + this.layoutFilename[i]);
                                }
                            }
                            ++n2;
                        }
                        ++c;
                    }
                }
                this.layout[i].name = this.getProperty("layout" + i + ".name");
                this.layout[i].parentLayout = this.getOptionalProperty("layout" + i + ".parentLayout");
                this.layout[i].hasGPSTime = Boolean.parseBoolean(this.getOptionalProperty("layout" + i + ".hasGPSTime"));
                if (this.hasFOXDB_V3) {
                    this.layout[i].number = i;
                    this.layout[i].typeStr = this.getProperty("layout" + i + ".type");
                    if (!Config.ignoreSpacecraftLoadErrors && !BitArrayLayout.isValidType(this.layout[i].typeStr)) {
                        throw new LayoutLoadException("Invalid payload type found: " + this.layout[i].typeStr + "\nfor payload: " + this.layout[i].name + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
                    }
                    this.layout[i].title = this.getOptionalProperty("layout" + i + ".title");
                    this.layout[i].shortTitle = this.getOptionalProperty("layout" + i + ".shortTitle");
                }
                ++i;
            }
            this.numberOfSources = Integer.parseInt(this.getProperty("numberOfSources"));
            this.sourceName = new String[this.numberOfSources];
            i = 0;
            while (i < this.numberOfSources) {
                this.sourceName[i] = this.getProperty("source" + i + ".name");
                ++i;
            }
            String format = this.getOptionalProperty("source0.formatName");
            if (format != null) {
                this.sourceFormat = new TelemFormat[this.numberOfSources];
                this.sourceFormatName = new String[this.numberOfSources];
                int i2 = 0;
                while (i2 < this.numberOfSources) {
                    this.sourceFormatName[i2] = this.getProperty("source" + i2 + ".formatName");
                    this.sourceFormat[i2] = this.satManager.getFormatByName(this.sourceFormatName[i2]);
                    ++i2;
                }
            }
            this.user_track = (t = this.getOptionalProperty("track")) == null ? true : Boolean.parseBoolean(t);
            String s = this.getOptionalProperty("series");
            this.series = s == null ? "FOX" : s;
            String serv = this.getOptionalProperty("localServer");
            this.user_localServer = serv == null ? null : serv;
            String p = this.getOptionalProperty("localServerPort");
            this.user_localServerPort = p == null ? 0 : Integer.parseInt(p);
            String pri = this.getOptionalProperty("priority");
            this.user_priority = pri == null ? 1 : Integer.parseInt(pri);
            String c = this.getOptionalProperty("hasCanBus");
            this.hasCanBus = c == null ? false : Boolean.parseBoolean(c);
            if (this.hasCanBus) {
                this.canFileDir = this.getProperty("canFileDir");
                this.loadCanLayouts();
            }
            this.user_format = this.getProperty("user_format");
            if (this.user_format == null) {
                this.user_format = "DUV_FSK";
            }
            this.user_display_name = this.getProperty("displayName");
            if (this.user_display_name == null) {
                this.user_display_name = this.user_keps_name;
            }
            this.hasFrameCrc = (crc = this.getOptionalProperty("hasFrameCrc")) == null ? false : Boolean.parseBoolean(crc);
        }
        catch (NumberFormatException nf) {
            nf.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("Corrupt data found: " + nf.getMessage() + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("File not found: " + e.getMessage() + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("File load error: " + e.getMessage() + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        try {
            String mems_z;
            String mems_y;
            String mems_x;
            String gpsTime;
            String fixedReset;
            String mode;
            String icr2;
            String icr;
            String threshold;
            block55: {
                block54: {
                    this.IHU_SN = Integer.parseInt(this.getProperty("IHU_SN"));
                    int i = 0;
                    while (i < this.experiments.length) {
                        block53: {
                            try {
                                int num;
                                this.experiments[i] = num = Integer.parseInt(this.getProperty("EXP" + (i + 1)));
                            }
                            catch (LayoutLoadException nf) {
                                if (this.hasFOXDB_V3) break block53;
                                throw nf;
                            }
                        }
                        ++i;
                    }
                    try {
                        this.user_BATTERY_CURRENT_ZERO = Double.parseDouble(this.getProperty("BATTERY_CURRENT_ZERO"));
                    }
                    catch (LayoutLoadException nf) {
                        if (this.hasFOXDB_V3) break block54;
                        throw nf;
                    }
                }
                try {
                    this.useIHUVBatt = Boolean.parseBoolean(this.getProperty("useIHUVBatt"));
                }
                catch (LayoutLoadException nf) {
                    if (this.hasFOXDB_V3) break block55;
                    throw nf;
                }
            }
            this.measurementsFileName = this.getProperty("measurementsFileName");
            this.passMeasurementsFileName = this.getProperty("passMeasurementsFileName");
            String error = this.getOptionalProperty("mpptResistanceError");
            if (error != null) {
                this.user_mpptResistanceError = Double.parseDouble(error);
                this.hasMpptSettings = true;
            }
            if ((threshold = this.getOptionalProperty("mpptSensorOffThreshold")) != null) {
                this.user_mpptSensorOffThreshold = Integer.parseInt(threshold);
                this.hasMpptSettings = true;
            }
            if ((icr = this.getOptionalProperty("hasImprovedCommandReceiver")) != null) {
                this.hasImprovedCommandReceiver = Boolean.parseBoolean(icr);
            }
            if ((icr2 = this.getOptionalProperty("hasImprovedCommandReceiverII")) != null) {
                this.hasImprovedCommandReceiverII = Boolean.parseBoolean(icr2);
            }
            if ((mode = this.getOptionalProperty("hasModeInHeader")) != null) {
                this.hasModeInHeader = Boolean.parseBoolean(this.getProperty("hasModeInHeader"));
            }
            if ((fixedReset = this.getOptionalProperty("hasFixedReset")) != null) {
                this.hasFixedReset = Boolean.parseBoolean(this.getProperty("hasFixedReset"));
            }
            if ((gpsTime = this.getOptionalProperty("hasGPSTime")) != null) {
                this.hasGPSTime = Boolean.parseBoolean(this.getProperty("hasGPSTime"));
            }
            if ((mems_x = this.getOptionalProperty("memsRestValueX")) != null) {
                this.user_memsRestValueX = Integer.parseInt(mems_x);
            }
            if ((mems_y = this.getOptionalProperty("memsRestValueY")) != null) {
                this.user_memsRestValueY = Integer.parseInt(mems_y);
            }
            if ((mems_z = this.getOptionalProperty("memsRestValueZ")) != null) {
                this.user_memsRestValueZ = Integer.parseInt(mems_z);
            }
            if (this.user_memsRestValueX != 0 && this.user_memsRestValueY != 0 & this.user_memsRestValueZ != 0) {
                this.hasMemsRestValues = true;
            }
        }
        catch (NumberFormatException nf) {
            nf.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("Corrupt FOX data found when loading Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        catch (NullPointerException nf) {
            nf.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("Missing FOX data value when loading Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        this.load_user_params();
    }

    protected void load_user_params() throws LayoutLoadException {
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.userPropertiesFile);
            this.user_properties = new Properties();
            this.user_properties.load(f);
            f.close();
        }
        catch (IOException e) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.save_user_params();
        }
        try {
            this.user_keps_name = this.getUserProperty("name");
            this.user_telemetryDownlinkFreqkHz = Double.parseDouble(this.getUserProperty("telemetryDownlinkFreqkHz"));
            this.user_minFreqBoundkHz = Double.parseDouble(this.getUserProperty("minFreqBoundkHz"));
            this.user_maxFreqBoundkHz = Double.parseDouble(this.getUserProperty("maxFreqBoundkHz"));
            String t = this.getOptionalUserProperty("track");
            this.user_track = t == null ? true : Boolean.parseBoolean(t);
            String serv = this.getOptionalUserProperty("localServer");
            this.user_localServer = serv == null ? null : serv;
            String p = this.getOptionalUserProperty("localServerPort");
            this.user_localServerPort = p == null ? 0 : Integer.parseInt(p);
            String pri = this.getOptionalUserProperty("priority");
            this.user_priority = pri == null ? 1 : Integer.parseInt(pri);
            if (this.user_format == null) {
                this.user_format = "DUV_FSK";
            }
            String tmp_user_format = this.getUserProperty("user_format");
            TelemFormat selectedFormat = this.satManager.getFormatByName(Config.format);
            if (selectedFormat != null) {
                this.user_format = tmp_user_format;
            }
            this.user_display_name = this.getUserProperty("displayName");
            String gpsTime = this.getOptionalProperty("useGPSTimeForT0");
            if (gpsTime != null) {
                this.user_useGPSTimeForT0 = Boolean.parseBoolean(this.getProperty("user_useGPSTimeForT0"));
            }
        }
        catch (NumberFormatException nf) {
            nf.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("Corrupt data found: " + nf.getMessage() + "\nwhen processing Spacecraft user settings: " + this.userPropertiesFile.getAbsolutePath());
        }
        catch (LayoutLoadException L) {
            Log.infoDialog("Paramater Missing when loading User Spacecraft Properties", "For: " + this.user_keps_name + ". If this is a new Spacecraft file or an upgrade then new values will be initialized.");
            this.save_user_params();
        }
        catch (NullPointerException nf) {
            Log.errorDialog("Initialization Corruption for User Properties", "For: " + this.user_keps_name + ". If this is a new Spacecraft file then new values will be initialized.");
            this.save_user_params();
        }
        try {
            String mems_z;
            String mems_y;
            String mems_x;
            String threshold;
            String error;
            if (!this.hasFOXDB_V3) {
                this.user_BATTERY_CURRENT_ZERO = Double.parseDouble(this.getUserProperty("BATTERY_CURRENT_ZERO"));
            }
            if ((error = this.getOptionalUserProperty("mpptResistanceError")) != null) {
                this.user_mpptResistanceError = Double.parseDouble(error);
                this.hasMpptSettings = true;
            }
            if ((threshold = this.getOptionalUserProperty("mpptSensorOffThreshold")) != null) {
                this.user_mpptSensorOffThreshold = Integer.parseInt(threshold);
                this.hasMpptSettings = true;
            }
            if ((mems_x = this.getOptionalUserProperty("memsRestValueX")) != null) {
                this.user_memsRestValueX = Integer.parseInt(mems_x);
            }
            if ((mems_y = this.getOptionalUserProperty("memsRestValueY")) != null) {
                this.user_memsRestValueY = Integer.parseInt(mems_y);
            }
            if ((mems_z = this.getOptionalUserProperty("memsRestValueZ")) != null) {
                this.user_memsRestValueZ = Integer.parseInt(mems_z);
            }
            if (this.user_memsRestValueX != 0 && this.user_memsRestValueY != 0 & this.user_memsRestValueZ != 0) {
                this.hasMemsRestValues = true;
            }
        }
        catch (NumberFormatException nf) {
            nf.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("Corrupt FOX data found when loading Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        catch (NullPointerException nf) {
            nf.printStackTrace(Log.getWriter());
            throw new LayoutLoadException("Missing FOX data value when loading Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
    }

    private void loadCanLayouts() {
        try {
            this.canFrames = new CanFrames(String.valueOf(this.canFileDir) + File.separator + "frames.csv");
            int canLayoutNum = this.canFrames.NUMBER_OF_FIELDS;
            Log.println("Loading " + canLayoutNum + " CAN Layouts");
            BitArrayLayout[] existingLayouts = this.layout;
            this.layout = new BitArrayLayout[this.layout.length + canLayoutNum];
            int i = 0;
            Object[] objectArray = existingLayouts;
            int n = existingLayouts.length;
            int n2 = 0;
            while (n2 < n) {
                BitArrayLayout l = objectArray[n2];
                this.layout[i++] = l;
                ++n2;
            }
            objectArray = this.canFrames.frame;
            n = this.canFrames.frame.length;
            n2 = 0;
            while (n2 < n) {
                Object frameName = objectArray[n2];
                this.layout[i] = new BitArrayLayout(String.valueOf(Config.spacecraftDir) + File.separator + this.canFileDir + File.separator + (String)frameName + ".csv");
                this.layout[i].name = frameName;
                this.layout[i].parentLayout = CAN_LAYOUT;
                ++i;
                ++n2;
            }
            this.numberOfLayouts = this.layout.length;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (LayoutLoadException e) {
            e.printStackTrace();
        }
    }

    protected String getOptionalProperty(String key) throws LayoutLoadException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return null;
        }
        return value;
    }

    protected boolean getOptionalBooleanProperty(String key) throws LayoutLoadException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return false;
        }
        boolean b = Boolean.parseBoolean(value);
        return b;
    }

    protected String getOptionalUserProperty(String key) throws LayoutLoadException {
        String value = this.user_properties.getProperty(key);
        if (value == null) {
            return null;
        }
        return value;
    }

    protected String getProperty(String key) throws LayoutLoadException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            throw new LayoutLoadException("Missing data value: " + key + " when loading Spacecraft file: \n" + this.propertiesFile.getAbsolutePath());
        }
        return value;
    }

    protected String getUserProperty(String key) throws LayoutLoadException {
        String value = this.user_properties.getProperty(key);
        if (value == null) {
            throw new LayoutLoadException("Missing user data value: " + key + " when loading Spacecraft file: \n" + this.userPropertiesFile.getAbsolutePath());
        }
        return value;
    }

    public void save() {
        this.save_user_params();
    }

    protected void store_user_params() {
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(this.userPropertiesFile);
            this.user_properties.store(f, "Fox 1 Telemetry Decoder User Spacecraft Properties");
            f.close();
        }
        catch (FileNotFoundException e1) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Log.errorDialog("ERROR", "Could not write spacecraft user properties file. Check permissions on run directory or on the file");
            e1.printStackTrace(Log.getWriter());
        }
        catch (IOException e1) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Log.errorDialog("ERROR", "Error writing spacecraft user properties file");
            e1.printStackTrace(Log.getWriter());
        }
    }

    protected void save_user_params() {
        this.user_properties = new Properties();
        this.user_properties.setProperty("name", this.user_keps_name);
        this.user_properties.setProperty("displayName", this.user_display_name);
        this.user_properties.setProperty("telemetryDownlinkFreqkHz", Double.toString(this.user_telemetryDownlinkFreqkHz));
        this.user_properties.setProperty("minFreqBoundkHz", Double.toString(this.user_minFreqBoundkHz));
        this.user_properties.setProperty("maxFreqBoundkHz", Double.toString(this.user_maxFreqBoundkHz));
        this.user_properties.setProperty("track", Boolean.toString(this.user_track));
        if (this.user_format != null) {
            this.user_properties.setProperty("user_format", this.user_format);
        }
        this.user_properties.setProperty("user_useGPSTimeForT0", Boolean.toString(this.user_useGPSTimeForT0));
        if (this.user_localServer != null) {
            this.user_properties.setProperty("localServer", this.user_localServer);
            this.user_properties.setProperty("localServerPort", Integer.toString(this.user_localServerPort));
        }
        this.user_properties.setProperty("priority", Integer.toString(this.user_priority));
        if (!this.hasFOXDB_V3) {
            this.user_properties.setProperty("BATTERY_CURRENT_ZERO", Double.toString(this.user_BATTERY_CURRENT_ZERO));
        }
        if (this.hasMpptSettings) {
            this.user_properties.setProperty("mpptResistanceError", Double.toString(this.user_mpptResistanceError));
            this.user_properties.setProperty("mpptSensorOffThreshold", Integer.toString(this.user_mpptSensorOffThreshold));
        }
        if (this.hasMemsRestValues) {
            this.user_properties.setProperty("memsRestValueX", Integer.toString(this.user_memsRestValueX));
            this.user_properties.setProperty("memsRestValueY", Integer.toString(this.user_memsRestValueY));
            this.user_properties.setProperty("memsRestValueZ", Integer.toString(this.user_memsRestValueZ));
        }
        this.user_properties.setProperty("hasModeInHeader", Boolean.toString(this.hasModeInHeader));
        this.store_user_params();
    }

    protected void store_master_params() {
        SortedProperties tmp = new SortedProperties(this.properties);
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(this.propertiesFile);
            tmp.store(f, "AMSAT Spacecraft Properties");
            f.close();
        }
        catch (FileNotFoundException e1) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Log.errorDialog("ERROR", "Could not write spacecraft MASTER file. Check permissions on run directory or on the file");
            e1.printStackTrace(Log.getWriter());
        }
        catch (IOException e1) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Log.errorDialog("ERROR", "Error writing spacecraft MASTER file");
            e1.printStackTrace(Log.getWriter());
        }
    }

    public void save_master_params() {
        this.properties = new Properties();
        this.properties.setProperty("foxId", String.valueOf(this.foxId));
        this.properties.setProperty("series", String.valueOf(this.series));
        this.properties.setProperty("IHU_SN", String.valueOf(this.IHU_SN));
        this.properties.setProperty("catalogNumber", String.valueOf(this.catalogNumber));
        this.properties.setProperty("name", this.user_keps_name);
        this.properties.setProperty("description", this.description);
        this.properties.setProperty("model", String.valueOf(this.model));
        this.properties.setProperty("numberOfLookupTables", String.valueOf(this.numberOfLookupTables));
        int i = 0;
        while (i < this.numberOfLookupTables) {
            if (this.lookupTable[i] != null) {
                this.properties.setProperty("lookupTable" + i, this.lookupTable[i].getName());
            }
            if (this.lookupTableFilename[i] != null) {
                this.properties.setProperty("lookupTable" + i + ".filename", this.lookupTableFilename[i]);
            }
            ++i;
        }
        this.properties.setProperty("numberOfLayouts", String.valueOf(this.numberOfLayouts));
        i = 0;
        while (i < this.numberOfLayouts) {
            if (this.layoutFilename[i] != null) {
                this.properties.setProperty("layout" + i + ".filename", this.layoutFilename[i]);
            }
            if (this.layout[i] != null) {
                this.properties.setProperty("layout" + i + ".name", this.layout[i].name);
                if (!this.layout[i].typeStr.equalsIgnoreCase("")) {
                    this.properties.setProperty("layout" + i + ".type", this.layout[i].typeStr);
                }
                if (this.layout[i].title != null) {
                    this.properties.setProperty("layout" + i + ".title", this.layout[i].title);
                }
                if (this.layout[i].shortTitle != null) {
                    this.properties.setProperty("layout" + i + ".shortTitle", this.layout[i].shortTitle);
                }
                if (this.layout[i].parentLayout != null && !this.layout[i].parentLayout.equalsIgnoreCase("")) {
                    this.properties.setProperty("layout" + i + ".parentLayout", this.layout[i].parentLayout);
                }
                this.properties.setProperty("layout" + i + ".hasGPSTime", String.valueOf(this.layout[i].hasGPSTime));
            }
            ++i;
        }
        this.properties.setProperty("numberOfSources", String.valueOf(this.numberOfSources));
        i = 0;
        while (i < this.numberOfSources) {
            if (this.sourceName[i] != null) {
                this.properties.setProperty("source" + i + ".name", this.sourceName[i]);
            }
            if (this.sourceFormatName != null && this.sourceFormatName[i] != null) {
                this.properties.setProperty("source" + i + ".formatName", this.sourceFormatName[i]);
            }
            ++i;
        }
        this.properties.setProperty("measurementsFileName", this.measurementsFileName);
        this.properties.setProperty("passMeasurementsFileName", this.passMeasurementsFileName);
        this.properties.setProperty("useConversionCoeffs", String.valueOf(this.useConversionCoeffs));
        if (this.useConversionCoeffs) {
            if (this.conversionCurvesFileName != null) {
                this.properties.setProperty("conversionCurvesFileName", String.valueOf(this.conversionCurvesFileName));
            }
            if (this.conversionExpressionsFileName != null) {
                this.properties.setProperty("conversionExpressionsFileName", String.valueOf(this.conversionExpressionsFileName));
            }
        }
        this.properties.setProperty("numberOfStringLookupTables", String.valueOf(this.numberOfStringLookupTables));
        i = 0;
        while (i < this.numberOfStringLookupTables) {
            if (this.stringLookupTable[i] != null) {
                this.properties.setProperty("stringLookupTable" + i, this.stringLookupTable[i].getName());
                this.properties.setProperty("stringLookupTable" + i + ".filename", this.stringLookupTableFilename[i]);
            }
            ++i;
        }
        this.properties.setProperty("hasFOXDB_V3", String.valueOf(this.hasFOXDB_V3));
        this.properties.setProperty("telemetryDownlinkFreqkHz", String.valueOf(this.user_telemetryDownlinkFreqkHz));
        this.properties.setProperty("minFreqBoundkHz", String.valueOf(this.user_minFreqBoundkHz));
        this.properties.setProperty("maxFreqBoundkHz", String.valueOf(this.user_maxFreqBoundkHz));
        this.properties.setProperty("track", String.valueOf(this.user_track));
        this.properties.setProperty("priority", String.valueOf(this.user_priority));
        if (this.user_format != null) {
            this.properties.setProperty("user_format", this.user_format);
        }
        this.properties.setProperty("displayName", this.user_display_name);
        this.properties.setProperty("numberOfFrameLayouts", String.valueOf(this.numberOfFrameLayouts));
        i = 0;
        while (i < this.numberOfFrameLayouts) {
            if (this.frameLayout[i] != null) {
                this.properties.setProperty("frameLayout" + i + ".name", this.frameLayout[i].name);
                this.properties.setProperty("frameLayout" + i + ".filename", this.frameLayoutFilename[i]);
            }
            ++i;
        }
        if (this.user_localServer != null) {
            this.properties.setProperty("localServer", this.user_localServer);
            this.properties.setProperty("localServerPort", Integer.toString(this.user_localServerPort));
        }
        if (!this.hasFOXDB_V3) {
            this.properties.setProperty("BATTERY_CURRENT_ZERO", Double.toString(this.user_BATTERY_CURRENT_ZERO));
        }
        if (this.hasMpptSettings) {
            this.properties.setProperty("mpptResistanceError", Double.toString(this.user_mpptResistanceError));
            this.properties.setProperty("mpptSensorOffThreshold", Integer.toString(this.user_mpptSensorOffThreshold));
        }
        if (this.hasMemsRestValues) {
            this.properties.setProperty("memsRestValueX", Integer.toString(this.user_memsRestValueX));
            this.properties.setProperty("memsRestValueY", Integer.toString(this.user_memsRestValueY));
            this.properties.setProperty("memsRestValueZ", Integer.toString(this.user_memsRestValueZ));
        }
        this.properties.setProperty("useIHUVBatt", Boolean.toString(this.useIHUVBatt));
        this.properties.setProperty("hasModeInHeader", Boolean.toString(this.hasModeInHeader));
        this.properties.setProperty("hasImprovedCommandReceiver", Boolean.toString(this.hasImprovedCommandReceiver));
        this.properties.setProperty("hasImprovedCommandReceiverII", Boolean.toString(this.hasImprovedCommandReceiverII));
        this.properties.setProperty("hasCanBus", Boolean.toString(this.hasCanBus));
        this.properties.setProperty("hasFrameCrc", Boolean.toString(this.hasFrameCrc));
        i = 0;
        while (i < 4) {
            this.properties.setProperty("EXP" + (i + 1), Integer.toString(this.experiments[i]));
            ++i;
        }
        this.properties.setProperty("hasGPSTime", Boolean.toString(this.hasGPSTime));
        this.store_master_params();
    }

    private void loadConversionCurves(String conversionCurvesFileName) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(conversionCurvesFileName));){
            String line = null;
            int linenum = 0;
            while ((line = br.readLine()) != null) {
                String[] values = line.split(",");
                if (values.length < 8) continue;
                try {
                    ConversionCurve conversion = new ConversionCurve(values, this);
                    if (this.conversions.containsKey(conversion.getName())) {
                        Log.errorDialog("DUPLICATE CURVE NAME", String.valueOf(this.user_keps_name) + "- Conversion Curve already defined. This duplicate name will not be stored: " + conversion.getName());
                    } else {
                        this.conversions.put(conversion.getName(), conversion);
                        Log.println("Stored: " + conversion);
                    }
                    ++linenum;
                }
                catch (IllegalArgumentException e) {
                    if (linenum == 0) continue;
                    Log.println("Could not load conversion: " + e);
                    Log.errorDialog("CORRUPT CONVERSION: ", e.toString());
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void loadConversionExpresions(String conversionExpressionsFileName) throws FileNotFoundException, IOException, LayoutLoadException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(conversionExpressionsFileName));){
            String line = null;
            int linenum = 0;
            while ((line = br.readLine()) != null) {
                String[] values = line.split(",");
                try {
                    ConversionMathExpression conversion = new ConversionMathExpression(values[0], values[1], this);
                    if (this.conversions.containsKey(conversion.getName())) {
                        Log.errorDialog("DUPLICATE CONVERSION EXPRESSION NAME", String.valueOf(this.user_keps_name) + "- A Curve, expression or table is already defined called " + conversion.getName() + "\nThis duplicate name will not be stored.");
                    } else {
                        this.conversions.put(conversion.getName(), conversion);
                        Log.println("Expression loaded: " + conversion);
                    }
                    ++linenum;
                }
                catch (IllegalArgumentException e) {
                    if (linenum == 0) continue;
                    Log.println("Could not load conversion: " + e);
                    Log.errorDialog("CORRUPT CONVERSION: ", e.toString());
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void saveTimeZeroSeries() throws IOException {
        String log = String.valueOf(this.series) + this.foxId + Config.t0UrlFile;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
            Log.println("Loading: " + log);
        }
        File aFile = new File(log);
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, false));
        int r = 0;
        try {
            for (long l : this.timeZero) {
                output.write(String.valueOf(r) + "," + l + "\n");
                ((Writer)output).flush();
                ++r;
            }
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    /*
     * Loose catch block
     */
    public boolean loadTimeZeroSeries(String log) throws FileNotFoundException {
        this.timeZero = new ArrayList(100);
        String line = null;
        if (log == null) {
            log = String.valueOf(this.series) + this.foxId + Config.t0UrlFile;
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                log = String.valueOf(Config.logFileDirectory) + File.separator + log;
                Log.println("Loading: " + log);
            }
        }
        boolean hasContent = false;
        BufferedReader dis = new BufferedReader(new FileReader(log));
        try {
            try {
                while ((line = dis.readLine()) != null) {
                    if (line == null) continue;
                    StringTokenizer st = new StringTokenizer(line, ",");
                    int reset = Integer.valueOf(st.nextToken());
                    long uptime = Long.valueOf(st.nextToken());
                    if (reset == this.timeZero.size()) {
                        this.timeZero.add(uptime);
                        hasContent = true;
                        continue;
                    }
                    throw new IndexOutOfBoundsException("Reset in T0 file is missing or out of sequence: " + reset);
                }
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                try {
                    dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            catch (NumberFormatException n) {
                n.printStackTrace(Log.getWriter());
                try {
                    dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            catch (NoSuchElementException m) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException iOException) {}
        }
        return hasContent;
    }

    public boolean hasCamera() {
        int i = 0;
        while (i < this.experiments.length) {
            if (this.experiments[i] == 2) {
                return true;
            }
            if (this.experiments[i] == 5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasLowResCamera() {
        int i = 0;
        while (i < this.experiments.length) {
            if (this.experiments[i] == 5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasMesatCamera() {
        int i = 0;
        while (i < this.experiments.length) {
            if (this.experiments[i] == 12) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasHerci() {
        int i = 0;
        while (i < this.experiments.length) {
            if (this.experiments[i] == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasExperiment(int e) {
        int i = 0;
        while (i < this.experiments.length) {
            if (this.experiments[i] == e) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getIdString() {
        String id = "??";
        id = this.foxId == 1 ? "1A" : (this.foxId == 2 ? "1B" : (this.foxId == 3 ? "1Cliff" : (this.foxId == 4 ? "1D" : (this.foxId == 5 ? "1E" : Integer.toString(this.foxId)))));
        return id;
    }

    public static String getModeString(int mode) {
        return modeNames[mode];
    }

    public static int determine1A1DMode(PayloadRtValues realTime, PayloadMaxValues maxPayload, PayloadMinValues minPayload, FramePart radPayload) {
        if (realTime != null && minPayload != null && maxPayload != null && realTime.uptime == minPayload.uptime && minPayload.uptime == maxPayload.uptime) {
            return 3;
        }
        if (radPayload != null && realTime != null && radPayload.compareTo(realTime) > 0) {
            if (maxPayload == null && minPayload == null) {
                return 2;
            }
            if (maxPayload != null && radPayload.compareTo(maxPayload) > 0) {
                if (minPayload == null) {
                    return 2;
                }
                if (radPayload.compareTo(minPayload) > 0) {
                    return 2;
                }
            }
        }
        if (minPayload == null && maxPayload != null || maxPayload != null && minPayload != null && maxPayload.compareTo(minPayload) >= 0) {
            if (maxPayload.getRawValue(SCIENCE_MODE_IND) == 1) {
                return 4;
            }
            if (maxPayload.getRawValue(SAFE_MODE_IND) == 1) {
                return 1;
            }
            return 2;
        }
        if (minPayload != null) {
            if (minPayload.getRawValue(SCIENCE_MODE_IND) == 1) {
                return 4;
            }
            if (minPayload.getRawValue(SAFE_MODE_IND) == 1) {
                return 1;
            }
            return 2;
        }
        return 2;
    }

    public String determineModeFromHeader() {
        SortedFramePartArrayList payloads = new SortedFramePartArrayList(this.numberOfLayouts);
        int maxLayouts = 10;
        int i = 0;
        while (i <= maxLayouts && i < this.layout.length) {
            FramePart part = Config.payloadStore.getLatest(this.foxId, this.layout[i].name);
            if (part != null) {
                payloads.add(part);
            }
            ++i;
        }
        int mode = 0;
        if (payloads.size() > 0) {
            mode = ((FramePart)payloads.get((int)(payloads.size() - 1))).newMode;
        }
        return Spacecraft.getModeString(mode);
    }

    public static String OLDdetermineModeFromHeader(PayloadRtValues realTime, PayloadMaxValues maxPayload, PayloadMinValues minPayload, FramePart radPayload) {
        SortedFramePartArrayList payloads = new SortedFramePartArrayList(4);
        if (realTime != null) {
            payloads.add(realTime);
        }
        if (maxPayload != null) {
            payloads.add(maxPayload);
        }
        if (minPayload != null) {
            payloads.add(minPayload);
        }
        if (radPayload != null) {
            payloads.add(radPayload);
        }
        int mode = 0;
        if (payloads.size() > 0) {
            mode = ((FramePart)payloads.get((int)(payloads.size() - 1))).newMode;
        }
        return Spacecraft.getModeString(mode);
    }

    public static String determineModeString(Spacecraft fox, PayloadRtValues realTime, PayloadMaxValues maxPayload, PayloadMinValues minPayload, FramePart radPayload) {
        int mode = Spacecraft.determine1A1DMode(realTime, maxPayload, minPayload, radPayload);
        return Spacecraft.getModeString(mode);
    }

    public String toString() {
        return this.user_display_name;
    }

    @Override
    public int compareTo(Spacecraft s2) {
        if (this.user_priority == s2.user_priority) {
            return this.user_display_name.compareTo(s2.user_display_name);
        }
        if (this.user_priority < s2.user_priority) {
            return -1;
        }
        if (this.user_priority > s2.user_priority) {
            return 1;
        }
        return -1;
    }

    public class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        public SortedProperties(Properties unsortedProperties) {
            this.putAll((Map<?, ?>)unsortedProperties);
        }

        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<String> keyList = new Vector<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            Set<Map.Entry<Object, Object>> entrySet = super.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                treeMap.put(entry.getKey(), entry.getValue());
            }
            return Collections.synchronizedSet(treeMap.entrySet());
        }
    }
}

