/*
 * Decompiled with CFR 0.152.
 */
import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import telemServer.WebServiceProcess;
import telemetry.PayloadDbStore;

public class FoxService {
    public static int port = 8080;
    int poolSize = 8;
    static String usage = "Usage: FoxService user database port";

    public static void main(String[] args) throws IOException {
        FoxService ws = new FoxService();
        if (args.length < 1) {
            System.out.println(usage);
            System.exit(1);
        }
        if (args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("-version")) {
            System.out.println("AMSAT Fox Web Service. Version " + WebServiceProcess.version);
            System.exit(0);
        }
        if (args.length == 3) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String p = in.readLine();
            if (p == null || p.isEmpty()) {
                System.out.println("Missing password");
                System.exit(2);
            }
            String u = args[0];
            String db = args[1];
            try {
                port = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                System.err.println("FATAL: Invalid Port - " + port);
                Log.println("FATAL: Invalid Port - " + port);
                System.exit(1);
            }
            ws.start(u, p, db);
        } else {
            System.out.println(usage);
            System.exit(1);
        }
    }

    protected void start(String u, String p, String db) {
        Config.logging = true;
        Log.init("FoxWebService");
        Log.alertsAreFatal = false;
        Log.showGuiDialogs = false;
        Log.setStdoutEcho(false);
        Config.currentDir = System.getProperty("user.dir");
        Config.spacecraftDir = String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR;
        Config.serverInit();
        Log.println("Fox Webservice starting up on port " + port + ": " + WebServiceProcess.version);
        Log.println("(press ctrl-c to exit)");
        ServerSocket serverSocket = null;
        boolean listening = true;
        ExecutorService pool = null;
        try {
            serverSocket = new ServerSocket(port);
            pool = Executors.newFixedThreadPool(this.poolSize);
        }
        catch (IOException e) {
            Log.println("Could not listen on port: " + port);
            System.exit(-1);
        }
        while (listening) {
            try {
                Log.println("Waiting for WebService connection ...");
                pool.execute(new WebServiceProcess(FoxService.initPayloadDB(u, p, db), serverSocket.accept(), port));
            }
            catch (SocketTimeoutException s) {
                Log.println("Socket timed out! - trying to continue\t");
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        try {
            serverSocket.close();
            pool.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
    }

    public static PayloadDbStore initPayloadDB(String u, String p, String db) {
        return new PayloadDbStore(u, p, db);
    }
}

