/*
 * Decompiled with CFR 0.152.
 */
package telemetry.mesat;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import telemetry.SatPayloadStore;
import telemetry.mesat.MesatImage;
import telemetry.mesat.SortedMesatImageList;
import telemetry.payloads.CanPacket;

public class MesatImageStore {
    private static final int INIT_SIZE = 100;
    private Spacecraft fox;
    public int foxId;
    public static String INDEX_NAME = "image_index.log";
    private String fileName = INDEX_NAME;
    SortedMesatImageList images;
    boolean updatedImage = false;
    boolean massUpdate = false;

    public MesatImageStore(int id) {
        this.foxId = id;
        this.fox = Config.satManager.getSpacecraft(id);
        this.initPayloadFiles();
    }

    private void initPayloadFiles() {
        File aFile;
        String dir = "images";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator + dir;
        }
        if (!(aFile = new File(dir)).isDirectory()) {
            aFile.mkdir();
            Log.println("Making directory: " + dir);
        }
        if (!aFile.isDirectory()) {
            Log.errorDialog("ERROR", "ERROR can't create the MESAT1 image directory: " + aFile.getAbsolutePath() + "\nAny decoded pictures will not be saved to disk. Downloaded picture packets\n" + "will still be decoded and uploaded to the server.");
        }
        this.images = new SortedMesatImageList(100);
        this.fileName = "images" + File.separator + this.fox.series + this.foxId + INDEX_NAME;
        try {
            this.load(this.fileName);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR Loading Stored MESAT1 Image Index data", 0);
            e.printStackTrace(Log.getWriter());
        }
    }

    public void buildBlockMapsIfNeeded() {
        for (MesatImage img : this.images) {
            if (img.hasBlockMap()) continue;
            this.rebuildFromCanPackets(this.foxId);
        }
    }

    public void setUpdatedAll() {
        this.updatedImage = true;
    }

    public boolean getUpdatedImage() {
        return this.updatedImage;
    }

    public void setUpdatedImage(boolean u) {
        this.updatedImage = u;
    }

    public int getNumberOfImages() {
        return this.images.size();
    }

    public boolean add(int id, int epoch, long uptime, CanPacket p, String captureDate) throws IOException {
        if (p.getLength() != 8) {
            return false;
        }
        int canid = p.getID();
        int block = canid & 0xF;
        int channel = canid >> 4 & 7;
        if (block < 11 && channel < 5) {
            MesatImage img2;
            for (MesatImage img2 : this.images) {
                if (!img2.addPacket(p)) continue;
                this.updatedImage = true;
                if (!this.massUpdate) {
                    img2.saveImage();
                }
                return true;
            }
            img2 = new MesatImage(id, p, epoch, uptime, captureDate);
            if (Config.debugCameraFrames) {
                Log.println("Adding new image: " + epoch + ":" + uptime);
            }
            if (img2.addPacket(p)) {
                this.images.add(img2);
                this.updatedImage = true;
                if (!this.massUpdate) {
                    this.save(img2, this.fileName, true);
                    img2.saveImage();
                }
                return true;
            }
        }
        return false;
    }

    public void rebuildFromCanPackets(int id) {
        this.massUpdate = true;
        ArrayList data = null;
        try {
            data = Config.payloadStore.getFrameParts(id, 0, 0L, 99999999, true, this.fox.getLayoutByType((String)"CAN_PKT").name);
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        if (data != null) {
            for (CanPacket p : data) {
                try {
                    Config.payloadStore.mesatImageStore.add(id, p.resets, p.uptime, p, p.getCaptureDate());
                }
                catch (IOException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
        }
        for (MesatImage img : this.images) {
            try {
                this.save(img, this.fileName, true);
                img.saveImage();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        this.massUpdate = false;
        Config.payloadStore.mesatImageStore.setUpdatedImage(true);
    }

    public SortedMesatImageList getIndex(int id, int period, int fromReset, long fromUptime, int imageNo) {
        int start = 0;
        int end = 0;
        if (fromReset == 0 && fromUptime == 0L) {
            start = this.images.size() - period;
            end = this.images.size();
        } else {
            start = this.images.getNearestFrameIndex(this.fox.foxId, fromUptime, fromReset);
            if (start == -1) {
                return null;
            }
            end = start + period;
        }
        if (end > this.images.size()) {
            end = this.images.size();
        }
        if (end < start) {
            end = start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > this.images.size()) {
            start = this.images.size();
        }
        SortedMesatImageList results = new SortedMesatImageList(end - start);
        int i = end - 1;
        while (i >= start) {
            if (imageNo == 0 || imageNo == ((MesatImage)this.images.get((int)i)).image_index) {
                results.add((MesatImage)this.images.get(i));
            }
            --i;
        }
        return results;
    }

    public void load(String log) throws FileNotFoundException {
        File aFile;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
            Log.println("Loading: " + log);
        }
        if (!(aFile = new File(log)).exists()) {
            try {
                aFile.createNewFile();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR creating jpeg index file " + log, 0);
                e.printStackTrace(Log.getWriter());
            }
        }
        boolean deleted = false;
        BufferedReader dis = new BufferedReader(new FileReader(log));
        try {
            String line;
            while ((line = dis.readLine()) != null) {
                MesatImage img;
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                String captureDate = st.nextToken();
                int id = Integer.valueOf(st.nextToken());
                int resets = Integer.valueOf(st.nextToken());
                long fromUptime = Long.valueOf(st.nextToken());
                int image_index = Integer.valueOf(st.nextToken());
                int image_channel = Integer.valueOf(st.nextToken());
                String name = st.nextToken();
                if (Config.satManager.getSpacecraft(id) == null) {
                    Log.errorDialog("FATAL", "Attempting to Load payloads from the Mesat Camera Image store for satellite with Fox Id: " + id + "\n when no sattellite with that FoxId is configured.  Add this spacecraft to the satellite directory and restart FoxTelem." + "\nProgram will now exit");
                    System.exit(1);
                }
                if ((img = new MesatImage(id, resets, fromUptime, image_index, image_channel, captureDate, name)).fileExists()) {
                    this.images.add(img);
                    continue;
                }
                deleted = true;
            }
            dis.close();
            if (deleted && this.images.size() > 0) {
                this.save((MesatImage)this.images.get(0), log, false);
                int i = 1;
                while (i < this.images.size()) {
                    this.save((MesatImage)this.images.get(i), log, true);
                    ++i;
                }
            }
            this.updatedImage = true;
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        catch (NumberFormatException n) {
            n.printStackTrace(Log.getWriter());
        }
        catch (NoSuchElementException n) {
            Log.println("ERROR loading record from camera picture line store");
            n.printStackTrace(Log.getWriter());
        }
    }

    public void save(MesatImage frame, String log, boolean append) throws IOException {
        File aFile;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
        }
        if (!(aFile = new File(log)).exists()) {
            aFile.createNewFile();
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, append));
        try {
            output.write(String.valueOf(frame.toString()) + "\n");
            ((Writer)output).flush();
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    public void deleteAll() {
        String log = this.fileName;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
        }
        try {
            int i = 0;
            while (i < this.images.size()) {
                String imageFile = ((MesatImage)this.images.get(i)).getFileName();
                if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                    imageFile = String.valueOf(Config.logFileDirectory) + File.separator + imageFile;
                }
                if (((MesatImage)this.images.get(i)).fileExists()) {
                    SatPayloadStore.remove(imageFile);
                    SatPayloadStore.remove(String.valueOf(imageFile) + ".bmp");
                    SatPayloadStore.remove(String.valueOf(imageFile) + ".blk");
                }
                ++i;
            }
            SatPayloadStore.remove(log);
            this.initPayloadFiles();
            this.setUpdatedAll();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting MESAT Image and Index Files for FoxId:" + this.foxId + ", check permissions on file: \n" + log, 0);
        }
    }
}

