/*
 * Decompiled with CFR 0.152.
 */
package telemetry.legacyPayloads;

import common.Log;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PictureScanLine
implements Comparable<PictureScanLine> {
    public int pictureCounter = 0;
    public int scanLineNumber = 0;
    int scanLineLength = 0;
    int[] scanLineData = null;
    String fileName = "";
    public int id;
    public Long uptime;
    public int resets;
    String captureDate;

    public PictureScanLine(String date, int pc, int sln, int sll, int[] sld) {
        this.pictureCounter = pc;
        this.scanLineNumber = sln;
        this.scanLineLength = sll;
        this.scanLineData = sld;
        this.captureDate = date;
    }

    public PictureScanLine(int id, int resets, long uptime, String captureDate, int pc, int sln, int sll, byte[] bytes) {
        this.id = id;
        this.resets = resets;
        this.uptime = uptime;
        this.captureDate = captureDate;
        this.pictureCounter = pc;
        this.scanLineNumber = sln;
        this.scanLineLength = sll;
        this.scanLineData = new int[bytes.length];
        int i = 0;
        while (i < this.scanLineData.length) {
            this.scanLineData[i] = bytes[i];
            ++i;
        }
    }

    public PictureScanLine(int id, int resets, long uptime, String captureDate, int pc, int sln, int sll, StringTokenizer st) {
        this.id = id;
        this.resets = resets;
        this.uptime = uptime;
        this.captureDate = captureDate;
        this.pictureCounter = pc;
        this.scanLineNumber = sln;
        this.scanLineLength = sll;
        this.load(st);
    }

    public void captureHeaderInfo(int id, long uptime, int resets) {
        this.id = id;
        this.uptime = uptime;
        this.resets = resets;
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.scanLineData.length];
        int i = 0;
        while (i < this.scanLineData.length) {
            b[i] = (byte)this.scanLineData[i];
            ++i;
        }
        return b;
    }

    @Override
    public int compareTo(PictureScanLine p) {
        if (this.resets == p.resets && this.uptime == p.uptime && this.pictureCounter == p.pictureCounter && this.scanLineNumber == p.scanLineNumber) {
            return 0;
        }
        if (this.resets > p.resets) {
            return 1;
        }
        if (this.resets < p.resets) {
            return -1;
        }
        if (this.resets == p.resets) {
            if (this.uptime > p.uptime) {
                return 1;
            }
            if (this.uptime < p.uptime) {
                return -1;
            }
            if (this.uptime == p.uptime) {
                if (this.pictureCounter > p.pictureCounter) {
                    return 1;
                }
                if (this.pictureCounter < p.pictureCounter) {
                    return -1;
                }
                if (this.pictureCounter == p.pictureCounter) {
                    if (this.scanLineNumber > p.scanLineNumber) {
                        return 1;
                    }
                    if (this.scanLineNumber < p.scanLineNumber) {
                        return -1;
                    }
                }
            }
        }
        return -1;
    }

    public String toShortString() {
        String s = "";
        s = String.valueOf(s) + this.pictureCounter + "," + this.scanLineNumber + "," + this.scanLineLength + ",";
        return s;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.captureDate + "," + this.id + "," + this.resets + "," + this.uptime + ",";
        s = String.valueOf(s) + this.pictureCounter + "," + this.scanLineNumber + "," + this.scanLineLength + ",";
        if (this.scanLineLength > 0) {
            int i = 0;
            while (i < this.scanLineLength - 1) {
                s = String.valueOf(s) + this.scanLineData[i] + ",";
                ++i;
            }
            s = String.valueOf(s) + this.scanLineData[this.scanLineLength - 1];
        }
        return s;
    }

    public void load(StringTokenizer st) {
        int i = 0;
        String s = null;
        try {
            while ((s = st.nextToken()) != null) {
                this.scanLineData[i++] = Integer.valueOf(s);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.println("ERROR: Too many bytes:  Could not load picture line " + this.id + " " + this.resets + " " + this.uptime + " " + this.pictureCounter + " " + this.scanLineNumber);
        }
        catch (NumberFormatException n) {
            Log.println("ERROR: Invalid number:  Could not load picture line " + this.id + " " + this.resets + " " + this.uptime + " " + this.pictureCounter + " " + this.scanLineNumber);
        }
    }

    public static String getTableCreateStmt() {
        String s = new String();
        s = String.valueOf(s) + "(id int, resets int, uptime bigint, " + "pictureCounter int, " + "scanLineNumber int," + "scanLineLength int," + "imageBytes blob," + "processed tinyint(1) not null default 0," + "date_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,";
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, uptime, pictureCounter, scanLineNumber))";
        return s;
    }

    public String getInsertStmt() {
        String s = new String();
        s = String.valueOf(s) + " (id, resets, uptime,\n";
        s = String.valueOf(s) + "pictureCounter,\n";
        s = String.valueOf(s) + "scanLineNumber,\n";
        s = String.valueOf(s) + "scanLineLength)\n";
        s = String.valueOf(s) + "values (" + this.id + ", " + this.resets + ", " + this.uptime + ",\n";
        s = String.valueOf(s) + this.pictureCounter + ",\n";
        s = String.valueOf(s) + this.scanLineNumber + ",\n";
        s = String.valueOf(s) + this.scanLineLength + ")\n";
        return s;
    }
}

