/*
 * Decompiled with CFR 0.152.
 */
package telemetry.frames;

import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.HighSpeedBitStream;
import fec.RsCodeWord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import measure.PassMeasurement;
import measure.RtMeasurement;
import telemServer.ServerConfig;
import telemServer.StpFileProcessException;
import telemServer.StpFileRsDecodeException;
import telemetry.Format.FormatFrame;
import telemetry.FramePart;
import telemetry.PayloadDbStore;
import telemetry.frames.FrameProcessException;
import telemetry.frames.Header;
import telemetry.frames.HighSpeedFrame;
import telemetry.frames.HighSpeedHeader;
import telemetry.frames.SlowSpeedFrame;
import telemetry.frames.SlowSpeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.PayloadCameraData;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;

public abstract class Frame
implements Comparable<Frame> {
    public static final DateFormat stpDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
    public Header header = null;
    protected Spacecraft fox;
    @Deprecated
    public static final int DUV_FRAME = 0;
    @Deprecated
    public static final int HIGH_SPEED_FRAME = 1;
    @Deprecated
    public static final int PSK_FRAME = 2;
    @Deprecated
    public static final int DUV_FRAME_LEN = 768;
    @Deprecated
    public static final int HIGH_SPEED_FRAME_LEN = 42176;
    @Deprecated
    public static final int PSK_FRAME_LEN = 4576;
    public static final String SEQUENCE_FILE_NAME = "seqno.dat";
    public static final String NONE = "NONE";
    public boolean corrupt = false;
    public int foxId = 0;
    public String receiver = "NONE";
    private String frequency = "NONE";
    protected String source;
    private String length;
    public String rx_location = "NONE";
    public String receiver_rf = "NONE";
    public String demodulator;
    protected Date stpDate;
    public long sequenceNumber = -1L;
    private String measuredTCA = "NONE";
    private String measuredTCAfrequency = "NONE";
    int numberBytesAdded = 0;
    protected byte[] bytes;
    private RtMeasurement rtMeasurement;
    private PassMeasurement passMeasurement;
    public int rsErrors;
    public int rsErasures;
    static char pattern = (char)44;
    static char escapeChar = (char)126;

    public Frame() {
        try {
            this.sequenceNumber = Config.sequence.getNextSequence();
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", e.getMessage());
            e.printStackTrace();
        }
        this.receiver = Config.callsign;
        this.rx_location = String.valueOf(this.formatLatitude(Config.latitude)) + " " + this.formatLongitude(Config.longitude);
        if (this.notNone(Config.altitude)) {
            this.rx_location = String.valueOf(this.rx_location) + " " + Config.altitude;
        }
        this.receiver_rf = Config.stationDetails;
        String os = System.getProperty("os.name").toLowerCase();
        this.demodulator = "FoxTelem " + Config.VERSION + " (" + os + ")";
        this.stpDate = Calendar.getInstance().getTime();
    }

    public Frame(BufferedReader input) throws IOException {
    }

    public abstract Header getHeader();

    private String formatLatitude(String lat) {
        String s = "";
        float f = Float.parseFloat(lat);
        s = f >= 0.0f ? "N " + lat : "S " + Math.abs(f);
        return s;
    }

    public void setStpDate(Date stp) {
        this.stpDate = stp;
    }

    public String getStpDate() {
        if (this.stpDate == null) {
            return null;
        }
        String dt = "";
        try {
            stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dt = stpDateFormat.format(this.stpDate);
        }
        catch (Exception e) {
            Log.println("ERROR: Could not parse date preparing DB insert, ignoring - " + this.stpDate + "\n" + e.getMessage());
        }
        return dt;
    }

    public long getExtimateOfT0() {
        if (this.stpDate == null) {
            return 0L;
        }
        long stp = this.stpDate.getTime() / 1000L;
        long T0 = stp - this.header.uptime;
        return T0 * 1000L;
    }

    private String formatLongitude(String lon) {
        String s = "";
        float f = Float.parseFloat(lon);
        s = f >= 0.0f ? "E " + lon : "W " + Math.abs(f);
        return s;
    }

    public void setMeasurement(RtMeasurement m) {
        this.rtMeasurement = m;
        if (m.getRawValue("CARRIER_FREQ") != 0.0) {
            this.frequency = String.valueOf(Long.toString(Math.round(m.getRawValue("CARRIER_FREQ")))) + " Hz";
        }
    }

    public void setPassMeasurement(PassMeasurement m) {
        this.passMeasurement = m;
        String strDate = null;
        if (m.getStringValue("TCA") != null) {
            strDate = m.getStringValue("TCA");
        }
        if (strDate.equals("-----")) {
            Log.println("TCA Could not be measured");
            this.measuredTCA = NONE;
        } else if (strDate != null) {
            Log.println("Got TCA: " + strDate);
            Date date = null;
            try {
                date = FramePart.fileDateFormat.parse(strDate);
            }
            catch (ParseException e) {
                Log.println("Error parsing TCA date:");
                e.printStackTrace(Log.getWriter());
                date = null;
            }
            if (date != null) {
                stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                try {
                    this.measuredTCA = stpDateFormat.format(date);
                }
                catch (Exception e) {
                    Log.println("ERROR: Could not parse date setting pass measurement, ignoring - " + this.stpDate + "\n" + e.getMessage());
                }
                Log.println("STP TCA set as: " + this.measuredTCA);
            } else {
                this.measuredTCA = NONE;
            }
        }
        if (m.getRawValue("TCA_FREQ") != -99999L) {
            this.measuredTCAfrequency = String.valueOf(m.getRawValue("TCA_FREQ")) + " Hz";
        }
    }

    public abstract void addNext8Bits(byte var1);

    public void addRawFrame(byte[] b) throws FrameProcessException {
        int byteLen = b.length;
        this.bytes = new byte[byteLen];
        int i = 0;
        while (i < byteLen) {
            this.bytes[i] = b[i];
            this.addNext8Bits(b[i]);
            ++i;
        }
        this.foxId = this.header.getFoxId();
        if (this.fox == null) {
            throw new FrameProcessException("Invalid Fox Id: " + this.foxId + ", can not process frame");
        }
        this.length = Integer.toString(byteLen * 8);
        this.source = "";
        try {
            this.source = this instanceof SlowSpeedFrame ? String.valueOf(this.source) + this.fox.sourceName[0] : (this instanceof HighSpeedFrame ? String.valueOf(this.source) + this.fox.sourceName[1] : String.valueOf(this.source) + this.fox.sourceName[0]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FrameProcessException("Source missing in Spacecraft File, frame could not be processed.  ID: " + this.foxId + "\n" + e);
        }
        this.source = this.source.toLowerCase();
    }

    @Override
    public int compareTo(Frame f) {
        if (this.sequenceNumber == f.sequenceNumber && this.foxId == f.foxId) {
            return 0;
        }
        if (this.sequenceNumber < f.sequenceNumber) {
            return -1;
        }
        if (this.sequenceNumber > f.sequenceNumber) {
            return 1;
        }
        if (this.sequenceNumber == f.sequenceNumber && this.foxId < f.foxId) {
            return -1;
        }
        return 1;
    }

    private String getSTPCoreHeader() {
        stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = "";
        try {
            date = stpDateFormat.format(this.stpDate);
        }
        catch (Exception e) {
            Log.println("ERROR: Could not parse date getting STP Core Header, ignoring - " + this.stpDate + "\n" + e.getMessage());
        }
        String header = "Sequence: " + this.sequenceNumber + "\r\n";
        header = String.valueOf(header) + "Source: " + this.source + "\r\n";
        header = String.valueOf(header) + "Length: " + this.length + "\r\n";
        header = String.valueOf(header) + "Date: " + date + " UTC\r\n";
        header = String.valueOf(header) + "Receiver: " + Config.callsign + "\r\n";
        header = String.valueOf(header) + "Rx-Location: " + this.rx_location + "\r\n";
        if (this.notNone(this.frequency)) {
            header = String.valueOf(header) + "Frequency: " + this.frequency + "\r\n";
        }
        if (this.notNone(this.receiver_rf)) {
            header = String.valueOf(header) + "Receiver-RF: " + this.receiver_rf + "\r\n";
        }
        if (this.notNone(this.demodulator)) {
            header = String.valueOf(header) + "Demodulator: " + this.demodulator + "\r\n";
        }
        return header;
    }

    private boolean notNone(String s) {
        if (s.equalsIgnoreCase(NONE)) {
            return false;
        }
        return !s.equalsIgnoreCase("");
    }

    private String getSTPExtendedHeader() {
        String header = "";
        if (this.notNone(this.measuredTCA)) {
            header = "MeasuredTCA: " + this.measuredTCA + " UTC\r\n";
            header = String.valueOf(header) + "MeasuredTCAFrequency: " + this.measuredTCAfrequency + "\r\n";
        }
        return header;
    }

    private String escapeComma(String s) {
        return s.replace(pattern, escapeChar);
    }

    private String insertComma(String s) {
        return s.replace(escapeChar, pattern);
    }

    public void save(BufferedWriter output) throws IOException {
        output.write(String.valueOf(Long.toString(this.sequenceNumber)) + "," + this.foxId + "," + this.escapeComma(this.source) + "," + this.escapeComma(this.receiver) + "," + this.escapeComma(this.frequency) + "," + this.escapeComma(this.rx_location) + "," + this.escapeComma(this.receiver_rf) + "," + this.escapeComma(this.demodulator) + "," + this.stpDate.getTime() + "," + this.length + ",");
        int i = 0;
        while (i < this.bytes.length - 1) {
            output.write(String.valueOf(Integer.toString(this.bytes[i])) + ",");
            ++i;
        }
        output.write(String.valueOf(Integer.toString(this.bytes[this.bytes.length - 1])) + "\n");
    }

    public void saveBytes() throws IOException {
        String rawFile = "raw" + File.separator + this.header.id + "_" + this.header.resets + "_" + this.header.uptime + "_" + this.header.type + "_raw_rame.dat";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            rawFile = String.valueOf(Config.logFileDirectory) + File.separator + rawFile;
        }
        Path path = Paths.get(rawFile, new String[0]);
        Files.write(path, this.bytes, new OpenOption[0]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Frame loadStp(String fileName, boolean rerunRsDecode) throws IOException, StpFileProcessException {
        in = new FileInputStream(fileName);
        lineLen = 0;
        done = false;
        readingKey = true;
        key = "";
        value = "";
        rawFrame = null;
        length = 0;
        receiver = null;
        stpDate = null;
        frequency = "NONE";
        source = null;
        rx_location = "NONE";
        receiver_rf = "NONE";
        demodulator = null;
        sequenceNumber = -1L;
        measuredTCA = "NONE";
        measuredTCAfrequency = "NONE";
        firstColon = true;
        try {
            while (!done && (c = in.read()) != -1) {
                block39: {
                    block41: {
                        block42: {
                            ch = (char)c;
                            if (c == 58 && firstColon) {
                                firstColon = false;
                                c = in.read();
                                c = in.read();
                                ch = (char)c;
                                readingKey = false;
                            }
                            if (c != 13 && c != 10) break block41;
                            c = in.read();
                            if (length == 0 || lineLen != true) break block42;
                            rawFrame = new byte[length / 8];
                            i = 0;
                            if (true) ** GOTO lbl85
                        }
                        readingKey = true;
                        firstColon = true;
                        if (key.startsWith("Length")) {
                            length = Integer.parseInt(value);
                        }
                        if (key.equalsIgnoreCase("Receiver")) {
                            receiver = value;
                        }
                        if (key.equalsIgnoreCase("Source")) {
                            source = value;
                        }
                        if (key.equalsIgnoreCase("Frequency")) {
                            frequency = value;
                        }
                        if (key.equalsIgnoreCase("Rx-location")) {
                            rx_location = value;
                        }
                        if (key.equalsIgnoreCase("Receiver-RF")) {
                            receiver_rf = value;
                        }
                        if (key.equalsIgnoreCase("Demodulator")) {
                            demodulator = value;
                        }
                        if (key.endsWith("Sequence")) {
                            sequenceNumber = Long.parseLong(value);
                        }
                        if (key.equalsIgnoreCase("MeasuredTCA")) {
                            measuredTCA = value;
                        }
                        if (key.equalsIgnoreCase("MeasuredTCAfrequency")) {
                            measuredTCAfrequency = value;
                        }
                        if (key.startsWith("Date")) {
                            dt = value.replace(" UTC", "");
                            Frame.stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            try {
                                stpDate = Frame.stpDateFormat.parse(dt);
                            }
                            catch (NumberFormatException | ParseException e) {
                                Log.println("ERROR - Date was not parsable. Setting to null\n" + e.getClass() + "\n" + e.getMessage());
                                stpDate = null;
                            }
                            catch (Exception e) {
                                Log.println("ERROR - Date was not parsable. Setting to null: " + e.getMessage());
                                stpDate = null;
                                e.printStackTrace(Log.getWriter());
                            }
                        }
                        key = "";
                        value = "";
                        lineLen = 0;
                        break block39;
                    }
                    if (readingKey) {
                        key = String.valueOf(key) + ch;
                        break block39;
                    } else {
                        value = String.valueOf(value) + ch;
                    }
                    break block39;
                    do {
                        rawFrame[i] = (byte)in.read();
                        ++i;
lbl85:
                        // 2 sources

                    } while (i < length / 8);
                    done = true;
                }
                ++lineLen;
            }
        }
        finally {
            in.close();
        }
        in.close();
        if (rawFrame == null) {
            Log.println("Failed to Process STP file. RAW FRAME is null.  No content.  Likely SPAM or broken connection.");
            return null;
        }
        format = null;
        frame = null;
        if (length == 768) {
            frm = new SlowSpeedFrame();
        } else if (length == 42176) {
            frm = new HighSpeedFrame();
        } else {
            if (source == null) {
                throw new StpFileProcessException(fileName, "ERROR: Could not decode the source from STP File Header: " + fileName);
            }
            format = Config.satManager.getFormatBySource(source);
            if (format == null) {
                throw new StpFileProcessException(fileName, "ERROR: Don't understand source: " + source + " STP file not processed: " + fileName);
            }
            frm = new FormatFrame(format);
        }
        if (rerunRsDecode) {
            if (length == 768) {
                if (ServerConfig.slowSpeedRsDecode && !(rs = new RsCodeWord(rawFrame, 159)).validDecode()) {
                    Log.println("RS Decode Failed");
                    throw new StpFileRsDecodeException(fileName, "ERROR: FAILED RS DECODE " + fileName);
                }
            } else if (length == 42176 && ServerConfig.highSpeedRsDecode) {
                if (!Frame.highSpeedRsDecode(4600, 21, HighSpeedBitStream.RS_PADDING, rawFrame, demodulator)) {
                    Log.println("HIGH SPEED RS Decode Failed");
                    throw new StpFileRsDecodeException(fileName, "ERROR: FAILED HIGH SPEED RS DECODE " + fileName);
                }
                rsPadding = format.getPaddingArray();
                if (ServerConfig.highSpeedRsDecode && !Frame.highSpeedRsDecode(format.getInt("data_length"), rsPadding.length, rsPadding, rawFrame, demodulator)) {
                    Log.println("Format Frame RS Decode Failed");
                    throw new StpFileRsDecodeException(fileName, "ERROR: FAILED Format Frame RS DECODE " + fileName);
                }
            }
        }
        frame = rawFrame;
        try {
            frm.addRawFrame(frame);
        }
        catch (FrameProcessException e) {
            Log.println("Failed to Process STP file. FoxId is corrupt.");
            return null;
        }
        frm.receiver = receiver;
        frm.demodulator = demodulator;
        frm.stpDate = stpDate;
        frm.frequency = frequency;
        frm.rx_location = rx_location;
        frm.receiver_rf = receiver_rf;
        frm.demodulator = demodulator;
        frm.sequenceNumber = sequenceNumber;
        frm.measuredTCA = measuredTCA;
        frm.measuredTCAfrequency = measuredTCAfrequency;
        if (frm.getHeader().resets == 44 && frm.getHeader().uptime == 260L || frm.getHeader().resets == 44 && frm.getHeader().uptime == 263L || frm.getHeader().resets == 44 && frm.getHeader().uptime == 390L || frm.getHeader().resets == 44 && frm.getHeader().uptime == 393L) {
            return null;
        }
        return frm;
    }

    private static boolean highSpeedRsDecode(int maxFrameSize, int numOfCodewords, int[] padding, byte[] rawFrame, String demodulator) {
        String[] versionString = demodulator.split(" ");
        int major = Config.parseVersionMajor(versionString[1]);
        int minor = Config.parseVersionMinor(versionString[1]);
        RsCodeWord[] codeWords = new RsCodeWord[numOfCodewords];
        int q = 0;
        while (q < numOfCodewords) {
            codeWords[q] = new RsCodeWord(padding[q]);
            ++q;
        }
        int bytesInFrame = 0;
        int f = 0;
        int rsNum = 0;
        byte[] byArray = rawFrame;
        int n = rawFrame.length;
        int n2 = 0;
        while (n2 < n) {
            byte b8 = byArray[n2];
            if (++bytesInFrame == maxFrameSize + 1) {
                if (major > 1 || major == 1 && minor >= 5) {
                    rsNum = 0;
                    ++f;
                } else {
                    rsNum = 1;
                }
            }
            try {
                codeWords[rsNum++].addByte(b8);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace(Log.getWriter());
            }
            if (rsNum == numOfCodewords) {
                rsNum = 0;
                if (++f > 255) {
                    Log.println("ERROR: Allocated more high speed data that fits in an RSCodeWord");
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < numOfCodewords) {
            codeWords[i].decode();
            if (!codeWords[i].validDecode()) {
                Log.println("FAILED RS DECODE FOR HS WORD " + i);
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Frame importStpFile(String u, String p, String db, File f, boolean delete) throws StpFileProcessException {
        PayloadDbStore payloadStore = null;
        try {
            Frame decodedFrame = Frame.loadStp(f.getPath(), true);
            if (decodedFrame != null && !decodedFrame.corrupt) {
                payloadStore = new PayloadDbStore(u, p, db);
                if (decodedFrame instanceof SlowSpeedFrame) {
                    if (!payloadStore.addStpHeader(decodedFrame)) {
                        throw new StpFileProcessException(f.getName(), "Could not add the STP HEADER to the database ");
                    }
                    SlowSpeedFrame ssf = (SlowSpeedFrame)decodedFrame;
                    FramePart payload = ssf.getPayload();
                    SlowSpeedHeader header = ssf.getHeader();
                    if (!payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), payload)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not add DUV record to database");
                    }
                } else if (decodedFrame instanceof FormatFrame) {
                    FormatFrame hsf = (FormatFrame)decodedFrame;
                    Spacecraft fox = Config.satManager.getSpacecraft(hsf.header.id);
                    int newReset = hsf.header.resets;
                    if (hsf.header.id == 6) {
                        newReset = payloadStore.checkForNewReset(hsf.header.id, hsf.header.uptime, decodedFrame.stpDate, hsf.header.resets, decodedFrame.receiver);
                        if (newReset == -1) {
                            throw new StpFileProcessException(f.getName(), "Failed to process file: Could not get the reset");
                        }
                        hsf.header.copyBitsToFields();
                        hsf.header.resets = newReset;
                        hsf.header.rawBits = null;
                    }
                    if (!payloadStore.addStpHeader(decodedFrame)) {
                        throw new StpFileProcessException(f.getName(), "Could not add the STP HEADER to the database ");
                    }
                    if (!hsf.savePayloads(payloadStore, fox.hasModeInHeader, newReset)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not add PSK record to database");
                    }
                } else {
                    PayloadHERCIhighSpeed[] herciDataSet;
                    PayloadCameraData cameraData;
                    if (!payloadStore.addStpHeader(decodedFrame)) {
                        throw new StpFileProcessException(f.getName(), "Could not add the STP HEADER to the database ");
                    }
                    HighSpeedFrame hsf = (HighSpeedFrame)decodedFrame;
                    HighSpeedHeader header = hsf.getHeader();
                    PayloadRtValues payload = hsf.getRtPayload();
                    if (!payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), payload)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not add HS RT to database");
                    }
                    PayloadMaxValues maxPayload = hsf.getMaxPayload();
                    if (!payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), maxPayload)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not add HS MAX to database");
                    }
                    PayloadMinValues minPayload = hsf.getMinPayload();
                    if (!payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), minPayload)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not HS MIN add to database");
                    }
                    PayloadRadExpData[] radPayloads = hsf.getRadPayloads();
                    if (!payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), radPayloads)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not add HS RAD to database");
                    }
                    if (Config.satManager.hasCamera(header.getFoxId()) && (cameraData = hsf.getCameraPayload()) != null && !payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), cameraData)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not add HS CAMERA data to database");
                    }
                    if (Config.satManager.hasHerci(header.getFoxId()) && (herciDataSet = hsf.getHerciPayloads()) != null && !payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), herciDataSet)) {
                        throw new StpFileProcessException(f.getName(), "Failed to process file: Could not add HERCI HS data to database");
                    }
                }
            }
            if (delete) {
                f.delete();
            }
            Frame frame = decodedFrame;
            return frame;
        }
        catch (IOException e) {
            Log.println(e.getMessage());
            e.printStackTrace(Log.getWriter());
            throw new StpFileProcessException(f.getName(), "IO Exception processing file");
        }
        finally {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                payloadStore.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    public static String getTableCreateStmt() {
        String s = new String();
        s = String.valueOf(s) + "(stpDate varchar(35), id int, resets int, uptime bigint, type int, " + "sequenceNumber bigint, " + "length int, " + "source varchar(35)," + "receiver varchar(35)," + "frequency varchar(35)," + "rx_location varchar(35)," + "receiver_rf varchar(52)," + "demodulator varchar(100)," + "measuredTCA varchar(35)," + "measuredTCAfrequency varchar(35)," + "date_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,";
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, uptime, type, receiver))";
        return s;
    }

    public PreparedStatement getPreparedInsertStmt(Connection con) throws SQLException {
        String dt = "";
        if (this.stpDate != null) {
            try {
                dt = stpDateFormat.format(this.stpDate);
            }
            catch (Exception e) {
                Log.println("ERROR: Could not parse date preparing DB insert, ignoring - " + this.stpDate + "\n" + e.getMessage());
            }
        }
        String s = new String();
        if (this.demodulator.length() > 99) {
            this.demodulator = this.demodulator.substring(0, 99);
        }
        if (this.source.length() > 32) {
            this.source = this.source.substring(0, 32);
        }
        if (this.receiver.length() > 32) {
            this.receiver = this.receiver.substring(0, 32);
        }
        if (this.frequency.length() > 32) {
            this.frequency = this.frequency.substring(0, 32);
        }
        if (this.rx_location.length() > 32) {
            this.rx_location = this.rx_location.substring(0, 32);
        }
        if (this.receiver_rf.length() > 50) {
            this.receiver_rf = this.receiver_rf.substring(0, 50);
        }
        if (this.measuredTCA.length() > 32) {
            this.measuredTCA = this.measuredTCA.substring(0, 32);
        }
        if (this.measuredTCAfrequency.length() > 32) {
            this.measuredTCAfrequency = this.measuredTCAfrequency.substring(0, 32);
        }
        s = String.valueOf(s) + "insert into STP_HEADER (stpDate,  id, resets, uptime, type, \n";
        s = String.valueOf(s) + "sequenceNumber,\n";
        s = String.valueOf(s) + "length,\n";
        s = String.valueOf(s) + "source,\n";
        s = String.valueOf(s) + "receiver,\n";
        s = String.valueOf(s) + "frequency,\n";
        s = String.valueOf(s) + "rx_location,\n";
        s = String.valueOf(s) + "receiver_rf,\n";
        s = String.valueOf(s) + "demodulator,\n";
        s = String.valueOf(s) + "measuredTCA,\n";
        s = String.valueOf(s) + "measuredTCAfrequency)\n";
        s = String.valueOf(s) + "values (?, ?, ?, ?, ?," + "?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = con.prepareStatement(s);
        ps.setString(1, dt);
        ps.setInt(2, this.foxId);
        ps.setInt(3, this.header.resets);
        ps.setLong(4, this.header.uptime);
        ps.setInt(5, this.header.type);
        ps.setLong(6, this.sequenceNumber);
        ps.setString(7, this.length);
        ps.setString(8, this.source);
        ps.setString(9, this.receiver);
        ps.setString(10, this.frequency);
        ps.setString(11, this.rx_location);
        ps.setString(12, this.receiver_rf);
        ps.setString(13, this.demodulator);
        ps.setString(14, this.measuredTCA);
        ps.setString(15, this.measuredTCAfrequency);
        return ps;
    }

    public StringTokenizer loadStpHeader(BufferedReader input) throws IOException {
        String line = input.readLine();
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line, ",");
            this.sequenceNumber = Long.parseLong(st.nextToken());
            this.foxId = Integer.parseInt(st.nextToken());
            this.source = this.insertComma(st.nextToken());
            this.receiver = this.insertComma(st.nextToken());
            this.frequency = this.insertComma(st.nextToken());
            this.rx_location = this.insertComma(st.nextToken());
            this.receiver_rf = this.insertComma(st.nextToken());
            this.demodulator = this.insertComma(st.nextToken());
            this.stpDate = new Date(Long.parseLong(st.nextToken()));
            this.length = st.nextToken();
            return st;
        }
        return null;
    }

    public void loadRestOfFrame(StringTokenizer st) throws IOException {
        while (st.hasMoreTokens()) {
            this.addNext8Bits((byte)Integer.parseInt(st.nextToken()));
        }
    }

    public void load(BufferedReader input) throws IOException {
        String line = input.readLine();
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line, ",");
            this.sequenceNumber = Long.parseLong(st.nextToken());
            this.foxId = Integer.parseInt(st.nextToken());
            this.source = this.insertComma(st.nextToken());
            this.receiver = this.insertComma(st.nextToken());
            this.frequency = this.insertComma(st.nextToken());
            this.rx_location = this.insertComma(st.nextToken());
            this.receiver_rf = this.insertComma(st.nextToken());
            this.demodulator = this.insertComma(st.nextToken());
            this.stpDate = new Date(Long.parseLong(st.nextToken()));
            this.length = st.nextToken();
            while (st.hasMoreTokens()) {
                this.addNext8Bits((byte)Integer.parseInt(st.nextToken()));
            }
        }
    }

    public byte[] getServerBytes() {
        byte b;
        if (this.bytes == null) {
            return null;
        }
        String header = this.getSTPCoreHeader();
        header = String.valueOf(header) + this.getSTPExtendedHeader();
        header = String.valueOf(header) + "\r\n";
        byte[] headerBytes = header.getBytes();
        int j = 0;
        byte[] buffer = new byte[headerBytes.length + this.bytes.length];
        byte[] byArray = headerBytes;
        int n = headerBytes.length;
        int n2 = 0;
        while (n2 < n) {
            b = byArray[n2];
            buffer[j++] = b;
            ++n2;
        }
        byArray = this.bytes;
        n = this.bytes.length;
        n2 = 0;
        while (n2 < n) {
            b = byArray[n2];
            buffer[j++] = b;
            ++n2;
        }
        if (Config.debugFrames) {
            Log.println(header);
        }
        return buffer;
    }

    public byte[][] getLocalServerPayloadBytes() {
        return null;
    }

    public String toWodTimestampString(int reset, long uptime) {
        return null;
    }
}

