/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import telemetry.FramePart;
import telemetry.SortedArrayList;

public class SortedFramePartArrayList
extends SortedArrayList<FramePart> {
    public SortedFramePartArrayList(int i) {
        super(i);
    }

    public boolean hasFrame(int id, long uptime, int resets) {
        return this.getFrameIndex(id, uptime, resets) != -1;
    }

    public boolean hasFrame(int id, long uptime, int resets, int type) {
        return this.getFrameIndex(id, uptime, resets, type) != -1;
    }

    public int getFrameIndex(int id, long uptime, int resets) {
        int i = 0;
        while (i < this.size()) {
            FramePart f = (FramePart)this.get(i);
            if (f.id == id && f.uptime == uptime && f.resets == resets) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getFrameIndex(int id, long uptime, int resets, int type) {
        int i = 0;
        while (i < this.size()) {
            FramePart f = (FramePart)this.get(i);
            if (f.id == id && f.uptime == uptime && f.resets == resets && f.type == type) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public FramePart getFrame(int id, long uptime, int resets) {
        int i = this.getNearestFrameIndex(id, uptime, resets);
        if (i != -1) {
            return (FramePart)this.get(i);
        }
        return null;
    }

    public FramePart getFrame(int id, long uptime, int resets, int type) {
        int i = this.getNearestFrameIndex(id, uptime, resets, type);
        if (i != -1) {
            return (FramePart)this.get(i);
        }
        return null;
    }

    public int getNearestFrameIndex(int id, long uptime, int resets) {
        if (this.size() == 0) {
            return -1;
        }
        return this.getNearestFrameIndex(id, uptime, resets, ((FramePart)this.get((int)0)).type);
    }

    public int getNearestFrameIndex(int id, long uptime, int resets, int type) {
        if (this.size() == 0) {
            return -1;
        }
        if (resets > ((FramePart)this.get((int)(this.size() - 1))).resets) {
            return this.size() - 1;
        }
        if (resets == ((FramePart)this.get((int)(this.size() - 1))).resets && uptime > ((FramePart)this.get((int)(this.size() - 1))).uptime) {
            return this.size() - 1;
        }
        int i = 0;
        while (i < this.size()) {
            FramePart f = (FramePart)this.get(i);
            if (this.compare(f, id, uptime, resets, type) <= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getNearestPrevFrameIndex(int id, long uptime, int resets) {
        return this.getNearestPrevFrameIndex(id, uptime, resets, ((FramePart)this.get((int)0)).type);
    }

    public int getNearestPrevFrameIndex(int id, long uptime, int resets, int type) {
        if (this.size() == 0) {
            return -1;
        }
        if (resets > ((FramePart)this.get((int)(this.size() - 1))).resets) {
            return this.size() - 1;
        }
        if (resets == ((FramePart)this.get((int)(this.size() - 1))).resets && uptime > ((FramePart)this.get((int)(this.size() - 1))).uptime) {
            return this.size() - 1;
        }
        int i = 0;
        while (i < this.size()) {
            FramePart f = (FramePart)this.get(i);
            if (this.compare(f, id, uptime, resets, type) == 0) {
                return i;
            }
            if (this.compare(f, id, uptime, resets, type) < 0) {
                return i - 1;
            }
            ++i;
        }
        return -1;
    }

    private int compare(FramePart p, int id, long uptime, int resets, int type) {
        if (resets == p.resets && uptime == p.uptime && type == p.type) {
            return 0;
        }
        if (resets < p.resets) {
            return -1;
        }
        if (resets > p.resets) {
            return 1;
        }
        if (resets == p.resets && uptime == p.uptime) {
            if (type < p.type) {
                return -1;
            }
            if (type > p.type) {
                return 1;
            }
        } else if (resets == p.resets) {
            if (uptime < p.uptime) {
                return -1;
            }
            if (uptime > p.uptime) {
                return 1;
            }
        }
        return 1;
    }
}

