/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Spacecraft;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import measure.Measurement;
import measure.PassMeasurement;
import measure.RtMeasurement;
import telemServer.StpFileProcessException;
import telemetry.FramePart;
import telemetry.SortedFramePartArrayList;
import telemetry.SortedJpegList;
import telemetry.frames.Frame;
import telemetry.herci.HerciHighspeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.PayloadCameraData;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.legacyPayloads.RadiationTelemetry;
import telemetry.mesat.MesatImageStore;

public abstract class FoxPayloadStore
implements Runnable {
    protected boolean loaded = false;
    public MesatImageStore mesatImageStore;

    public boolean initialized() {
        return this.loaded;
    }

    public abstract boolean hasQueuedFrames();

    public abstract int getQueuedFramesSize();

    public abstract boolean hasQueuedMeasurements();

    public abstract void setUpdatedAll();

    public abstract void setUpdatedAll(int var1);

    public abstract boolean getUpdated(int var1, String var2);

    public abstract void setUpdated(int var1, String var2, boolean var3);

    public abstract boolean getUpdatedCamera(int var1);

    public abstract void setUpdatedCamera(int var1, boolean var2);

    public abstract boolean getUpdatedMeasurement(int var1);

    public abstract void setUpdatedMeasurement(int var1, boolean var2);

    public abstract boolean getUpdatedPassMeasurement(int var1);

    public abstract void setUpdatedPassMeasurement(int var1, boolean var2);

    public abstract int getNumberOfMeasurements(int var1);

    public abstract int getNumberOfPassMeasurements(int var1);

    public abstract int getTotalNumberOfFrames();

    public abstract int getTotalNumberOfFrames(String var1);

    public abstract int getNumberOfFrames(int var1, String var2);

    public abstract int getNumberOfTelemFrames(int var1);

    public abstract int getNumberOfPictureCounters(int var1);

    public abstract SortedJpegList getJpegIndex(int var1, int var2, int var3, long var4);

    public abstract boolean add(int var1, long var2, int var4, FramePart var5);

    public abstract boolean addToFile(int var1, long var2, int var4, FramePart var5);

    @Deprecated
    public abstract boolean add(int var1, long var2, int var4, PayloadRadExpData[] var5);

    public abstract boolean add(int var1, long var2, int var4, PayloadHERCIhighSpeed[] var5);

    @Deprecated
    public abstract boolean addToFile(int var1, long var2, int var4, PayloadRadExpData[] var5) throws IOException;

    @Deprecated
    public abstract boolean addToPictureFile(int var1, long var2, int var4, PayloadCameraData var5);

    public abstract boolean add(int var1, RtMeasurement var2);

    public abstract boolean addToFile(int var1, Measurement var2);

    public abstract RtMeasurement getLatestMeasurement(int var1);

    public abstract boolean add(int var1, PassMeasurement var2);

    public abstract boolean addStpHeader(Frame var1);

    public abstract boolean updateStpHeader(Frame var1) throws StpFileProcessException;

    public abstract boolean processNewImageLines() throws SQLException, IOException;

    public abstract PassMeasurement getLatestPassMeasurement(int var1);

    public abstract SortedFramePartArrayList getFrameParts(int var1, int var2, long var3, int var5, boolean var6, String var7) throws IOException;

    public abstract FramePart getLatest(int var1, String var2);

    public abstract FramePart getLatestRt(int var1);

    public abstract FramePart getLatestMax(int var1);

    public abstract FramePart getLatestMin(int var1);

    public abstract FramePart getFramePart(int var1, int var2, long var3, String var5, boolean var6);

    public abstract FramePart getFramePart(int var1, int var2, long var3, int var5, String var6, boolean var7);

    public abstract FramePart getLatestRad(int var1);

    public abstract RadiationTelemetry getLatestRadTelem(int var1);

    public abstract RadiationTelemetry getRadTelem(int var1, int var2, long var3);

    public abstract PayloadHERCIhighSpeed getLatestHerci(int var1);

    public abstract HerciHighspeedHeader getLatestHerciHeader(int var1);

    public abstract double[][] getGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, String var7, boolean var8, boolean var9);

    public abstract double[][] getRtGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, boolean var7, boolean var8);

    public abstract double[][] getMaxGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, boolean var7, boolean var8);

    public abstract double[][] getMinGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, boolean var7, boolean var8);

    public abstract String[][] getRadData(int var1, int var2, int var3, long var4, boolean var6);

    public abstract String[][] getRadTelemData(int var1, int var2, int var3, long var4, boolean var6);

    public abstract double[][] getRadTelemGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, boolean var7, boolean var8);

    public abstract double[][] getHerciScienceHeaderGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, boolean var7, boolean var8);

    public abstract String[][] getHerciPacketData(int var1, int var2, int var3, long var4, boolean var6, boolean var7);

    public abstract String[][] getHerciHsData(int var1, int var2, int var3, long var4, boolean var6);

    public abstract double[][] getMeasurementGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, boolean var7);

    public abstract double[][] getPassMeasurementGraphData(String var1, int var2, Spacecraft var3, int var4, long var5, boolean var7);

    public abstract String[][] getWodRadTelemData(int var1, int var2, int var3, long var4, boolean var6);

    public abstract String[][] getRtData(int var1, int var2, int var3, long var4, boolean var6);

    public abstract String[][] getWODData(int var1, int var2, int var3, long var4, boolean var6);

    public abstract String[][] getWODRadData(int var1, int var2, int var3, long var4, boolean var6);

    public abstract String getRtUTCFromUptime(int var1, int var2, long var3);

    public abstract int getNumberOfPayloadsBetweenTimestamps(int var1, int var2, long var3, int var5, long var6, String var8);

    public abstract void delete(Spacecraft var1);

    public abstract void deleteAll();

    public abstract void initRad2();

    public abstract void initHerciPackets();

    public abstract String[][] getTableData(int var1, int var2, int var3, long var4, boolean var6, boolean var7, String var8);

    public abstract String[][] getTableData(int var1, int var2, int var3, long var4, boolean var6, String var7);

    public abstract int checkForNewReset(int var1, long var2, Date var4, int var5, String var6);
}

