/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Spacecraft;
import decoder.FoxBitStream;
import telemetry.BitArrayLayout;

public abstract class BitArray {
    public static final double ERROR_VALUE = 9999.0;
    protected static final String PAD = "pad";
    public boolean[] rawBits = null;
    protected int bitPosition = 0;
    public int[] fieldValue = null;
    public BitArrayLayout layout;
    public int numberBytesAdded = 0;

    public void resetBitPosition() {
        this.bitPosition = 0;
    }

    public int[] getFieldValues() {
        return this.fieldValue;
    }

    protected BitArray(BitArrayLayout l) {
        this.layout = l;
        if (this.layout != null) {
            this.rawBits = new boolean[this.layout.getMaxNumberOfBits()];
            this.fieldValue = new int[this.layout.NUMBER_OF_FIELDS];
        }
    }

    public BitArrayLayout getLayout() {
        return this.layout;
    }

    public boolean hasFieldName(String name) {
        return this.layout.hasFieldName(name);
    }

    public int getIntConversionByName(String name) {
        return this.layout.getIntConversionByName(name);
    }

    public String getConversionNameByName(String name) {
        return this.layout.getConversionNameByName(name);
    }

    public String getUnitsByName(String name) {
        return this.layout.getUnitsByName(name);
    }

    public abstract String getStringValue(String var1, Spacecraft var2);

    public void addNext8Bits(byte b) {
        int i = 0;
        while (i < 8) {
            this.rawBits[i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
            ++i;
        }
        ++this.numberBytesAdded;
    }

    public void copyBitsToFields() {
        if (this.rawBits != null) {
            this.resetBitPosition();
            int i = 0;
            while (i < this.layout.fieldName.length) {
                if (this.layout.fieldName[i] == null || this.layout.fieldName[i].startsWith(PAD)) {
                    this.nextbits(this.layout.fieldBitLength[i]);
                    this.fieldValue[i] = 0;
                } else {
                    this.fieldValue[i] = this.nextbits(this.layout.fieldBitLength[i]);
                }
                ++i;
            }
        }
    }

    protected int nextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + n - i - 1];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    public int getRawValue(String name) {
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                return this.fieldValue[i];
            }
            ++i;
        }
        return -1;
    }
}

