/*
 * Decompiled with CFR 0.152.
 */
package telemServer;

import common.Config;
import common.FoxTime;
import common.Log;
import common.Spacecraft;
import java.io.PrintWriter;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import telemServer.WebHealthTab;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.PayloadDbStore;
import telemetry.frames.Frame;
import telemetry.payloads.PayloadWOD;
import uk.me.g4dpz.satellite.SatPos;

public class WebServiceProcess
implements Runnable {
    PayloadDbStore payloadDbStore;
    public static String version = "Version 1.10b - 27 Oct 2022";
    private Socket socket = null;
    int port = 8080;
    public static final String VERSION = "version";
    public static final String TIME = "getSatUtcAtResetUptime";
    public static final String POSITION = "getSatLatLonAtResetUptime";
    public static final String WOD = "getWod";
    public static final int TIMEOUT_CONNECTION = 1000;
    public static final String SAT = "sat";
    public static final String RESET = "reset";
    public static final String UPTIME = "uptime";

    public WebServiceProcess(PayloadDbStore db, Socket socket, int p) {
        this.socket = socket;
        this.port = p;
        this.payloadDbStore = db;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 76[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    HashMap<String, String> consumeArgs(String in) {
        String[] params;
        HashMap<String, String> args = new HashMap<String, String>();
        String[] stringArray = params = in.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            String[] keyVal = p.split("=");
            if (keyVal.length > 1) {
                args.put(keyVal[0], keyVal[1]);
            }
            ++n2;
        }
        return args;
    }

    private void getWod(String args, PrintWriter out) {
        block7: {
            HashMap<String, String> params = this.consumeArgs(args);
            String satId = params.get(SAT);
            String satReset = params.get(RESET);
            String satUptime = params.get(UPTIME);
            if (satId == null) {
                return;
            }
            PayloadWOD wod = null;
            WebHealthTab telemTab = null;
            try {
                Spacecraft fox = Config.satManager.getSpacecraft(Integer.parseInt(satId));
                if (fox != null) {
                    wod = fox.hasFOXDB_V3 ? (PayloadWOD)this.payloadDbStore.getLatest(fox.foxId, fox.getLayoutNameByType("WOD")) : (PayloadWOD)this.payloadDbStore.getLatest(fox.foxId, "wodtelemetry");
                    if (wod != null) {
                        try {
                            telemTab = fox.hasFOXDB_V3 ? new WebHealthTab(this.payloadDbStore, fox, this.port, fox.getLayoutNameByType("WOD")) : new WebHealthTab(this.payloadDbStore, fox, this.port, "wodtelemetry");
                        }
                        catch (LayoutLoadException e1) {
                            e1.printStackTrace(Log.getWriter());
                        }
                        telemTab.setRtPayload(wod);
                        out.println(telemTab.toString());
                    }
                    out.println("WOD record for: " + wod);
                    break block7;
                }
                out.println("Invalid Sat Id");
            }
            catch (Exception e) {
                out.println("AMSAT API Request is invalid id + " + satId + " reset " + satReset + " uptime " + satUptime + "\n" + e + " " + e.getMessage());
            }
        }
    }

    private void getSatLatLonAtResetUptime(String args, PrintWriter out) {
        DecimalFormat d = new DecimalFormat("00.000000");
        HashMap<String, String> params = this.consumeArgs(args);
        String satId = params.get(SAT);
        String satReset = params.get(RESET);
        String satUptime = params.get(UPTIME);
        if (satId == null) {
            return;
        }
        if (satReset == null) {
            return;
        }
        if (satUptime == null) {
            return;
        }
        try {
            Spacecraft fox = Config.satManager.getSpacecraft(Integer.parseInt(satId));
            int reset = Integer.parseInt(satReset);
            long uptime = Long.parseLong(satUptime);
            if (fox != null) {
                SatPos pos = fox.getSatellitePosition(reset, uptime);
                double satLatitude = FramePart.latRadToDeg(pos.getLatitude());
                double satLongitude = FramePart.lonRadToDeg(pos.getLongitude());
                out.println(String.valueOf(d.format(satLatitude)) + "," + d.format(satLongitude));
            } else {
                out.println("0, 0");
            }
        }
        catch (Exception e) {
            out.println("AMSAT API Request is invalid id + " + satId + " reset " + satReset + " uptime " + satUptime + "\n" + e + " " + e.getMessage());
        }
    }

    private void getSatUtcForResetUptime(String args, PrintWriter out) {
        Frame.stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        HashMap<String, String> params = this.consumeArgs(args);
        String satId = params.get(SAT);
        String satReset = params.get(RESET);
        String satUptime = params.get(UPTIME);
        if (satId == null) {
            return;
        }
        if (satReset == null) {
            return;
        }
        if (satUptime == null) {
            return;
        }
        try {
            Spacecraft fox = Config.satManager.getSpacecraft(Integer.parseInt(satId));
            int reset = Integer.parseInt(satReset);
            long uptime = Long.parseLong(satUptime);
            if (fox != null) {
                Date t = fox.getUtcForReset(reset, uptime);
                out.println(Frame.stpDateFormat.format(t));
            } else {
                out.println("0, 0\n");
            }
        }
        catch (Exception e) {
            out.println("AMSAT API Request is invalid id + " + satId + " reset " + satReset + " uptime " + satUptime + "\n" + e.getMessage());
        }
    }

    String calculateSpacecraftTime(Spacecraft fox) {
        Date currentDate = new Date();
        FoxTime foxTime = fox.getUptimeForUtcDate(currentDate);
        return String.valueOf(foxTime.getReset()) + ", " + foxTime.getUptime();
    }

    String calculateT0(PrintWriter out, int sat, int reset, String receiver, int num) {
        Statement stmt = null;
        Frame.stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String update = "  SELECT stpDate, uptime FROM STP_HEADER where id = " + sat + " and resets = " + reset + " and receiver = '" + receiver + "' " + "ORDER BY resets DESC, uptime DESC LIMIT " + num;
        long t0Sum = 0L;
        String s = "";
        s = String.valueOf(s) + "<style> td { border: 5px } th { background-color: lightgray; border: 3px solid lightgray; } td { padding: 5px; vertical-align: top; background-color: darkgray } </style>";
        s = String.valueOf(s) + "<table><tr><th>STP Date</th><th>Uptime</th><th>Estimated T0</th></tr>";
        Connection derby = null;
        ResultSet r = null;
        try {
            derby = this.payloadDbStore.getConnection();
            stmt = derby.createStatement();
            int size = 0;
            int i = 0;
            r = stmt.executeQuery(update);
            if (r != null) {
                while (r.next()) {
                    ++size;
                    long uptime = r.getLong(UPTIME);
                    String stpDate = r.getString("stpDate");
                    try {
                        Date stpDT = Frame.stpDateFormat.parse(stpDate);
                        long stp = stpDT.getTime() / 1000L;
                        long T0 = stp - uptime;
                        t0Sum += T0;
                        Date T0DT = new Date(T0 * 1000L);
                        s = String.valueOf(s) + "<tr><td>" + stpDate + "</td><td>" + uptime + "</td><td>" + T0DT + "</td></tr>";
                        ++i;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (size == 0) {
                String string = "No Frames for sat " + sat + " from reset " + reset + " for receiver " + receiver;
                return string;
            }
            s = String.valueOf(s) + "</table>";
            long avgT0 = t0Sum / (long)i;
            Date T0DT = new Date(avgT0 * 1000L);
            s = String.valueOf(s) + "<br>";
            s = String.valueOf(s) + "T0 Est: " + T0DT + "<br>";
            String string = s = String.valueOf(s) + "T0: " + avgT0 * 1000L + "<br>";
            return string;
        }
        catch (SQLException e) {
            PayloadDbStore.errorPrint("calculateT0", e);
            String string = e.toString();
            return string;
        }
        finally {
            try {
                r.close();
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
    }
}

