/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors.lookupTables;

import common.Spacecraft;
import java.io.IOException;
import java.util.ArrayList;
import spacecraftEditor.SpacecraftEditPanel;
import spacecraftEditor.listEditors.CsvTableModel;
import spacecraftEditor.listEditors.ListTableModel;
import spacecraftEditor.listEditors.TableListEditPanel;
import telemetry.LayoutLoadException;
import telemetry.conversion.ConversionLookUpTable;

public class LookupTableListEditPanel
extends TableListEditPanel {
    private static final long serialVersionUID = 1L;

    public LookupTableListEditPanel(Spacecraft sat, String title, ListTableModel listTableModel, CsvTableModel csvTableModel, SpacecraftEditPanel parent) {
        super(sat, title, listTableModel, csvTableModel, "tab", parent);
    }

    @Override
    protected void loadTable() {
        this.dataLines = new ArrayList();
        int i = 0;
        while (i < this.sat.numberOfLookupTables) {
            String[] dataToAdd = new String[this.listTableModel.getColumnCount()];
            dataToAdd[0] = "" + i;
            dataToAdd[1] = this.sat.lookupTable[i] != null ? this.sat.lookupTable[i].getName() : "NONE";
            dataToAdd[2] = this.sat.lookupTableFilename[i] != null ? this.sat.lookupTableFilename[i] : "NONE";
            this.dataLines.add(dataToAdd);
            ++i;
        }
    }

    @Override
    protected void saveTable() throws IOException, LayoutLoadException {
        this.sat.lookupTable = new ConversionLookUpTable[this.dataLines.size()];
        this.sat.numberOfLookupTables = this.dataLines.size();
        this.sat.lookupTableFilename = new String[this.dataLines.size()];
        int j = 0;
        while (j < this.dataLines.size()) {
            if (((String[])this.dataLines.get(j))[1] == null) {
                this.sat.lookupTable[j] = null;
            } else {
                this.sat.lookupTableFilename[j] = ((String[])this.dataLines.get(j))[2];
                this.sat.lookupTable[j] = new ConversionLookUpTable(((String[])this.dataLines.get(j))[1], this.sat.lookupTableFilename[j], this.sat);
            }
            ++j;
        }
    }
}

