/*
 * Decompiled with CFR 0.152.
 */
package gui.herci;

import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.FoxDecoder;
import gui.MainWindow;
import gui.RadiationPacketTableModel;
import gui.tabs.DisplayModule;
import gui.tabs.ExperimentLayoutTableModel;
import gui.tabs.ExperimentTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.legacyPayloads.RadiationTelemetry;

public class HerciLSTab
extends ExperimentTab
implements ItemListener,
Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String HERCITAB = "HERCITAB";
    private static final String DECODED = "Housekeeping Payloads Decoded: ";
    public final int DEFAULT_DIVIDER_LOCATION = 350;
    JLabel lblName;
    private String NAME;
    JLabel lblFramesDecoded;
    ExperimentLayoutTableModel radTableModel;
    RadiationPacketTableModel radPacketTableModel;
    JPanel healthPanel;
    JPanel topHalfPackets;
    JPanel bottomHalfPackets;
    boolean displayTelem = true;

    public HerciLSTab(Spacecraft sat) {
        this.fox = sat;
        this.foxId = this.fox.foxId;
        this.NAME = String.valueOf(this.fox.toString()) + " IOWA HERCI Housekeeping";
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, HERCITAB, "splitPaneHeight");
        this.lblName = new JLabel(this.NAME);
        this.lblName.setMaximumSize(new Dimension(1600, 20));
        this.lblName.setMinimumSize(new Dimension(1600, 20));
        this.lblName.setFont(new Font("SansSerif", 1, 14));
        this.topPanel.add(this.lblName);
        this.lblFramesDecoded = new JLabel(DECODED);
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, 14));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.topPanel.add(this.lblFramesDecoded);
        this.healthPanel = new JPanel();
        this.healthPanel.setLayout(new BoxLayout(this.healthPanel, 1));
        this.healthPanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.healthPanel.setBackground(Color.DARK_GRAY);
        this.topHalfPackets = new JPanel();
        this.topHalfPackets.setBackground(Color.DARK_GRAY);
        this.bottomHalfPackets = new JPanel();
        this.bottomHalfPackets.setBackground(Color.DARK_GRAY);
        this.healthPanel.add(this.topHalfPackets);
        this.healthPanel.add(this.bottomHalfPackets);
        this.initDisplayHalves(this.healthPanel);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        BitArrayLayout rad = this.fox.getLayoutByName("radtelemetry2");
        BitArrayLayout none = null;
        try {
            this.analyzeModules(rad, none, none, 21);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("FATAL - Load Aborted", e.getMessage());
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
        this.splitPane = new JSplitPane(0, this.healthPanel, this.centerPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(350);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    HerciLSTab.this.splitPaneHeight = HerciLSTab.this.splitPane.getDividerLocation();
                    Log.println("SplitPane: " + HerciLSTab.this.splitPaneHeight);
                    Config.saveGraphIntParam(HerciLSTab.this.fox.getIdString(), 99, 1, HerciLSTab.HERCITAB, "splitPaneHeight", HerciLSTab.this.splitPaneHeight);
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        this.healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.showRawBytes = new JCheckBox("Show Raw Bytes", Config.displayRawRadData);
        this.bottomPanel.add(this.showRawBytes);
        this.showRawBytes.addItemListener(this);
        this.addBottomFilter();
        this.radTableModel = new ExperimentLayoutTableModel(rad);
        this.radPacketTableModel = new RadiationPacketTableModel();
        this.addTables(this.radTableModel, this.radPacketTableModel);
        this.addPacketModules();
        this.topHalfPackets.setVisible(false);
        this.bottomHalfPackets.setVisible(false);
        this.parseExperimentFrames();
    }

    private void displayFramesDecoded(int u) {
        this.lblFramesDecoded.setText(DECODED + u);
    }

    private void addPacketModules() {
    }

    @Override
    protected void addTables(AbstractTableModel radTableModel, AbstractTableModel radPacketTableModel) {
        super.addTables(radTableModel, radPacketTableModel);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        int i = 0;
        while (i < this.table.getColumnCount() - 2) {
            column = this.table.getColumnModel().getColumn(i + 2);
            column.setPreferredWidth(25);
            ++i;
        }
        column = this.table2.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table2.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        column = this.table2.getColumnModel().getColumn(2);
        column.setPreferredWidth(80);
        column = this.table2.getColumnModel().getColumn(3);
        column.setPreferredWidth(70);
        column = this.table2.getColumnModel().getColumn(4);
        column.setPreferredWidth(600);
    }

    @Override
    protected void parseExperimentFrames() {
        if (Config.displayRawRadData) {
            String[][] data = Config.payloadStore.getRadData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.radTableModel);
            }
        } else {
            String[][] data = Config.payloadStore.getRadTelemData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data != null && data.length > 0) {
                this.parseTelemetry(data);
            }
        }
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        MainWindow.frame.repaint();
    }

    private void parseTelemetry(String[][] data) {
        int len = data.length;
        long[][] keyPacketData = new long[len][2];
        String[][] packetData = new String[len][3];
        int i = 0;
        while (i < len) {
            keyPacketData[len - i - 1][0] = Long.parseLong(data[i][0]);
            keyPacketData[len - i - 1][1] = Long.parseLong(data[i][1]);
            packetData[len - i - 1][0] = "TELEMETRY";
            packetData[len - i - 1][1] = data[i][2];
            String telem = "";
            int j = 2;
            while (j < this.fox.getLayoutByName((String)"radtelemetry2").fieldName.length + 2) {
                telem = String.valueOf(telem) + FoxDecoder.plainhex(Integer.parseInt(data[i][j])) + " ";
                ++j;
            }
            packetData[len - i - 1][2] = telem;
            ++i;
        }
        if (packetData.length > 0) {
            this.radPacketTableModel.setData(keyPacketData, packetData);
        }
    }

    public void updateTab(FramePart rad, boolean refreshTable) {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        if (rad != null) {
            DisplayModule mod;
            DisplayModule[] displayModuleArray = this.topModules;
            int n = this.topModules.length;
            int n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateRtValues(rad);
                }
                ++n2;
            }
            if (this.bottomModules != null) {
                displayModuleArray = this.bottomModules;
                n = this.bottomModules.length;
                n2 = 0;
                while (n2 < n) {
                    mod = displayModuleArray[n2];
                    if (mod != null) {
                        mod.updateRtValues(rad);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("HerciLSTab");
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            int frames;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized()) continue;
            if (Config.displayRawRadData != this.showRawBytes.isSelected()) {
                this.showRawBytes.setSelected(Config.displayRawRadData);
                this.parseExperimentFrames();
                this.updateTab(Config.payloadStore.getRadTelem(this.foxId, this.START_RESET, this.START_UPTIME), true);
            }
            if (Config.displayRawValues != this.showRawValues.isSelected()) {
                this.showRawValues.setSelected(Config.displayRawValues);
                this.updateTab(Config.payloadStore.getLatestRadTelem(this.foxId), true);
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized() || (frames = Config.payloadStore.getNumberOfFrames(this.foxId, "radtelemetry")) == currentFrames) continue;
            currentFrames = frames;
            Config.payloadStore.setUpdated(this.foxId, "radtelemetry", false);
            this.parseExperimentFrames();
            this.updateTab(Config.payloadStore.getRadTelem(this.foxId, this.START_RESET, this.START_UPTIME), true);
            this.displayFramesDecoded(frames);
            MainWindow.setTotalDecodes();
            if (!justStarted) continue;
            this.openGraphs();
            justStarted = false;
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            this.updateTab(Config.payloadStore.getLatestRadTelem(this.foxId), true);
        }
    }

    @Override
    public void parseFrames() {
        this.parseExperimentFrames();
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        long reset_l = (Long)table.getValueAt(row, 0);
        long uptime = (Long)table.getValueAt(row, 1);
        int reset = (int)reset_l;
        this.updateTab((RadiationTelemetry)Config.payloadStore.getFramePart(this.foxId, reset, uptime, "radtelemetry2", false), false);
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

