/*
 * Decompiled with CFR 0.152.
 */
package gui.graph;

import common.Config;
import common.Spacecraft;
import gui.graph.GraphCanvas;
import gui.graph.GraphFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import predict.PositionCalcException;
import telemetry.conversion.Conversion;
import telemetry.conversion.ConversionStringLookUpTable;
import uk.me.g4dpz.satellite.SatPos;

public class LinePlotPanel
extends GraphCanvas {
    public static final int NO_TIME_VALUE = -999;
    double[] firstDifference = null;
    double[] dspData = null;
    int[] plottedXreset;
    long[] plottedXuptime;
    int zeroPoint;
    public static final int MAX_VARIABLES = 13;
    Color[] graphColor = new Color[]{Color.BLUE, Config.GRAPH1, Config.GRAPH2, Config.GRAPH3, Config.GRAPH4, Config.GRAPH5, Config.GRAPH6, Config.GRAPH7, Config.GRAPH8, Config.GRAPH9, Config.GRAPH10, Config.GRAPH11, Config.GRAPH12};
    HashMap<Integer, Long> maxPlottedUptimeForReset;
    int sideLabel = 0;
    int bottomLabelOffset = 5;

    LinePlotPanel(String t, GraphFrame gf, Spacecraft fox2) {
        super(t, gf, fox2);
        this.freqOffset = (int)(fox2.user_telemetryDownlinkFreqkHz * 1000.0);
        this.updateGraphData(gf.layout, "GrapPanel.new");
    }

    private void drawLegend(int graphHeight, int graphWidth) {
        int l;
        String w;
        if (this.graphFrame.fieldName.length == 1 && this.graphFrame.fieldName2 == null) {
            return;
        }
        int titleHeight = this.topBorder;
        int verticalOffset = 15;
        if (this.zeroPoint < Config.graphAxisFontSize * 3) {
            titleHeight = graphHeight - 15;
        }
        int lineLength = 15;
        int rows = this.graphFrame.fieldName.length;
        int font = Config.graphAxisFontSize;
        int leftLineOffset = 50;
        int fonth = 12 * font / 9;
        if (this.graphFrame.fieldName2 != null) {
            rows += this.graphFrame.fieldName2.length;
        }
        if (this.graphFrame.plotDerivative) {
            ++rows;
        }
        if (this.graphFrame.dspAvg) {
            ++rows;
        }
        this.g2.setFont(new Font("SansSerif", 0, font));
        int longestWord = 0;
        int i = 0;
        while (i < this.graphFrame.fieldName.length) {
            w = String.valueOf(this.graphFrame.layout.getModuleByName(this.graphFrame.fieldName[i])) + "-" + this.graphFrame.layout.getShortNameByName(this.graphFrame.fieldName[i]) + " (" + this.graphFrame.fieldUnits + ")";
            l = this.g2.getFontMetrics().stringWidth(w);
            if (l > longestWord) {
                longestWord = l;
            }
            ++i;
        }
        if (this.graphFrame.fieldName2 != null) {
            i = 0;
            while (i < this.graphFrame.fieldName2.length) {
                w = String.valueOf(this.graphFrame.layout.getModuleByName(this.graphFrame.fieldName2[i])) + "-" + this.graphFrame.layout.getShortNameByName(this.graphFrame.fieldName2[i]) + " (" + this.graphFrame.fieldUnits2 + ")";
                l = this.g2.getFontMetrics().stringWidth(w);
                if (l > longestWord) {
                    longestWord = l;
                }
                ++i;
            }
        }
        int leftOffset = longestWord + this.sideBorder;
        this.g2.setColor(Color.BLACK);
        this.g2.drawRect(this.sideBorder + graphWidth - leftOffset - 1, titleHeight + 4, leftOffset - 10, 9 + fonth * rows + 1);
        this.g2.setColor(Color.WHITE);
        this.g2.fillRect(this.sideBorder + graphWidth - leftOffset, titleHeight + 5, leftOffset - 11, 9 + fonth * rows);
        int i2 = 0;
        while (i2 < this.graphFrame.fieldName.length) {
            this.g2.setColor(Color.BLACK);
            String name = String.valueOf(this.graphFrame.layout.getModuleByName(this.graphFrame.fieldName[i2])) + "-" + this.graphFrame.layout.getShortNameByName(this.graphFrame.fieldName[i2]);
            this.g2.drawString(String.valueOf(name) + " (" + this.graphFrame.fieldUnits + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5 + i2 * fonth);
            this.g2.setColor(this.graphColor[i2]);
            this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset + i2 * fonth, lineLength + 5, 2);
            ++i2;
        }
        verticalOffset += this.graphFrame.fieldName.length * fonth;
        if (this.graphFrame.fieldName2 != null) {
            i2 = 0;
            while (i2 < this.graphFrame.fieldName2.length) {
                this.g2.setColor(Color.BLACK);
                String name = String.valueOf(this.graphFrame.layout.getModuleByName(this.graphFrame.fieldName2[i2])) + "-" + this.graphFrame.layout.getShortNameByName(this.graphFrame.fieldName2[i2]);
                this.g2.drawString(String.valueOf(name) + " (" + this.graphFrame.fieldUnits2 + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5 + i2 * fonth);
                this.g2.setColor(this.graphColor[this.graphFrame.fieldName.length + i2]);
                this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset + i2 * fonth, lineLength + 5, 2);
                ++i2;
            }
            verticalOffset += this.graphFrame.fieldName2.length * fonth;
        }
        int x = 0;
        if (this.graphFrame.plotDerivative) {
            this.g2.setColor(Color.BLACK);
            this.g2.drawString("Der:" + this.graphFrame.fieldName[0] + " (" + this.graphFrame.fieldUnits + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5);
            this.g2.setColor(Config.AMSAT_RED);
            this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset, lineLength + 5, 2);
            x = 1;
        }
        if (this.graphFrame.dspAvg) {
            this.g2.setColor(Color.BLACK);
            this.g2.drawString("Avg:" + this.graphFrame.fieldName[0] + " (" + this.graphFrame.fieldUnits + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5 + x * fonth);
            this.g2.setColor(Config.AMSAT_GREEN);
            this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset + x * fonth, lineLength + 5, 2);
        }
    }

    @Override
    public void paintComponent(Graphics gr) {
        this.lock.lock();
        try {
            super.paintComponent(gr);
            if (!this.checkDataExists()) {
                return;
            }
            this.maxPlottedUptimeForReset = new HashMap();
            int graphHeight = this.getHeight() - this.topBorder - this.bottomBorder;
            int graphWidth = this.getWidth() - this.sideBorder * 2;
            if (graphWidth < 1) {
                return;
            }
            if (graphHeight < 1) {
                return;
            }
            this.plottedXreset = new int[graphWidth + 1];
            this.plottedXuptime = new long[graphWidth + 1];
            int j = 0;
            while (j < graphWidth + 1) {
                this.plottedXreset[j] = -999;
                this.plottedXuptime[j] = -999L;
                ++j;
            }
            this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
            if (this.graphFrame.plotDerivative) {
                this.firstDifference = new double[this.graphData[0][0].length];
            }
            double[] axisPoints2 = new double[]{0.0, 0.0, 0.0};
            if (this.drawGraph2) {
                axisPoints2 = this.plotVerticalAxis(graphWidth, graphHeight, graphWidth, this.graphData2, false, this.graphFrame.fieldUnits2, this.graphFrame.conversionType2, this.graphFrame.lastConversion2);
            }
            double[] axisPoints = this.plotVerticalAxis(0, graphHeight, graphWidth, this.graphData, this.graphFrame.showHorizontalLines, this.graphFrame.fieldUnits, this.graphFrame.conversionType, this.graphFrame.lastConversion);
            this.zeroPoint = (int)axisPoints[0];
            this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
            ArrayList<Integer> resetPosition = new ArrayList<Integer>();
            resetPosition.add(0);
            double currentReset = this.graphData[0][2][0];
            double lastUptime = this.graphData[0][1][0];
            int i = 1;
            while (i < this.graphData[0][2].length) {
                if (this.graphData[0][2][i] != currentReset) {
                    resetPosition.add(i);
                    currentReset = this.graphData[0][2][i];
                } else if (this.graphFrame.UPTIME_THRESHOLD != -1.0 && this.graphData[0][1][i] - lastUptime > this.graphFrame.UPTIME_THRESHOLD) {
                    resetPosition.add(i);
                    currentReset = this.graphData[0][2][i];
                }
                lastUptime = this.graphData[0][1][i];
                ++i;
            }
            int titleHeight = Config.graphAxisFontSize + 10;
            if (this.zeroPoint < Config.graphAxisFontSize * 3) {
                titleHeight = graphHeight + this.topBorder;
            }
            this.g2.setColor(Color.BLACK);
            this.g.setFont(new Font("SansSerif", 1, Config.graphAxisFontSize + 3));
            this.g2.drawString(this.graphFrame.displayTitle, this.sideBorder / 2 + graphWidth / 2 - this.graphFrame.displayTitle.length() / 2 * Config.graphAxisFontSize / 2, titleHeight);
            this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
            this.g2.setColor(this.graphAxisColor);
            this.g2.drawLine(this.sideLabelOffset, this.zeroPoint, graphWidth + this.sideBorder, this.zeroPoint);
            this.g2.setColor(this.graphTextColor);
            int offset = 0;
            if (!this.graphFrame.hideUptime) {
                this.g2.drawString("Uptime", this.sideLabelOffset, this.zeroPoint + Config.graphAxisFontSize);
                offset = Config.graphAxisFontSize;
            }
            if (!this.graphFrame.showUTCtime) {
                this.g2.drawString("Epoch", this.sideLabelOffset, this.zeroPoint + 1 * Config.graphAxisFontSize + offset);
            } else {
                this.g2.drawString("UTC", this.sideLabelOffset, this.zeroPoint + (int)(1.5 * (double)Config.graphAxisFontSize) + offset);
                this.g.setFont(new Font("SansSerif", 0, (int)((double)Config.graphAxisFontSize * 0.9)));
                this.g2.drawString("(Spacecraft UTC is approximate)", graphWidth - Config.graphAxisFontSize * 10, titleHeight);
                this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
            }
            int maxLabels = graphWidth / (labelWidth * 2);
            int resetLabelFreq = (int)Math.ceil((double)resetPosition.size() / (double)maxLabels);
            int resetLabelCount = 0;
            boolean drawLabels = false;
            int r = 0;
            while (r < resetPosition.size()) {
                int startScreenPos = 0;
                int width = 0;
                int start = (Integer)resetPosition.get(r);
                int end = 0;
                int len = this.graphData[0][0].length;
                startScreenPos = this.sideBorder + graphWidth * start / len;
                end = r == resetPosition.size() - 1 ? len : (Integer)resetPosition.get(r + 1);
                width = graphWidth * (end - start) / len;
                if (width < 1) {
                    width = 1;
                }
                if (this.graphFrame.showContinuous || ++resetLabelCount == resetLabelFreq) {
                    drawLabels = true;
                    resetLabelCount = 0;
                } else {
                    drawLabels = false;
                }
                if (!this.graphFrame.roundLabels) {
                    drawLabels = false;
                }
                this.drawGraphForSingleReset(start, end, width, graphHeight, startScreenPos, this.zeroPoint, axisPoints[1], axisPoints[2], axisPoints2[1], axisPoints2[2], drawLabels);
                ++r;
            }
            if (!this.graphFrame.roundLabels) {
                this.plotAlternateLabels(this.zeroPoint, graphHeight);
            }
            this.drawLegend(graphHeight, graphWidth);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void plotAlternateLabels(int zeroPoint, int graphHeight) {
        int prevReset = -1;
        boolean firstLabel = true;
        DecimalFormat d = new DecimalFormat("0");
        int w = 0;
        int v = 0;
        while (v < this.plottedXuptime.length) {
            int resets = this.plottedXreset[v];
            long uptime = this.plottedXuptime[v];
            if (firstLabel || w++ >= labelWidth && this.plottedXuptime[v] != -999L) {
                Spacecraft fox2;
                firstLabel = false;
                w = 0;
                int timepos = v;
                String s = d.format(uptime);
                int offset = 0;
                if (!this.graphFrame.hideUptime) {
                    offset = Config.graphAxisFontSize;
                }
                if (resets != prevReset) {
                    this.g2.setColor(this.graphTextColor);
                    if (!this.graphFrame.showUTCtime && resets != -999) {
                        this.g2.drawString("" + resets, timepos + this.sideBorder + 2, zeroPoint + 1 * Config.graphAxisFontSize + offset);
                    }
                }
                this.g2.setColor(this.graphTextColor);
                if (!this.graphFrame.hideUptime && uptime != -999L) {
                    this.g2.drawString(s, timepos + this.sideBorder + 2, zeroPoint + Config.graphAxisFontSize);
                }
                if (this.graphFrame.showUTCtime && (fox2 = this.fox).hasTimeZero(resets) && resets != -999) {
                    this.g2.drawString(fox2.getUtcTimeForReset(resets, uptime), timepos + this.sideBorder + 2, zeroPoint + 1 * Config.graphAxisFontSize + offset);
                    this.g2.drawString(fox2.getUtcDateForReset(resets, uptime), timepos + this.sideBorder + 2, zeroPoint + 2 * Config.graphAxisFontSize + offset);
                }
                this.g2.setColor(this.graphAxisColor);
                if (this.graphFrame.showVerticalLines) {
                    this.g2.setColor(Color.GRAY);
                    this.g.drawLine(timepos + this.sideBorder, graphHeight + this.topBorder + 5, timepos + this.sideBorder, this.topBorder);
                } else {
                    this.g.drawLine(timepos + this.sideBorder, zeroPoint - 5, timepos + this.sideBorder, zeroPoint + 5);
                }
                prevReset = resets;
            }
            ++v;
        }
    }

    private void drawGraphForSingleReset(int start, int end, int graphWidth, int graphHeight, int sideBorder, int zeroPoint, double minValue, double maxValue, double minValue2, double maxValue2, boolean drawLabels) {
        if (this.graphFrame.dspAvg) {
            if (this.graphFrame.AVG_PERIOD > this.graphData[0][0].length / 2) {
                this.graphFrame.AVG_PERIOD = this.graphData[0][0].length / 2;
            }
            double sum = 0.0;
            boolean first = true;
            this.dspData = new double[this.graphData[0][0].length];
            int i = this.graphFrame.AVG_PERIOD / 2;
            while (i < this.graphData[0][0].length - this.graphFrame.AVG_PERIOD / 2) {
                sum = 0.0;
                int j = 0;
                while (j < this.graphFrame.AVG_PERIOD) {
                    sum += this.graphData[0][0][i + j - this.graphFrame.AVG_PERIOD / 2];
                    ++j;
                }
                this.dspData[i] = sum /= (double)this.graphFrame.AVG_PERIOD;
                if (first) {
                    j = 0;
                    while (j < this.graphFrame.AVG_PERIOD / 2) {
                        this.dspData[j] = sum;
                        ++j;
                    }
                    first = false;
                }
                ++i;
            }
            int j = this.graphData[0][0].length - this.graphFrame.AVG_PERIOD;
            while (j < this.graphData[0][0].length) {
                this.dspData[j] = sum;
                ++j;
            }
        }
        double maxTimeValue = 0.0;
        double minTimeValue = 9.9999999E7;
        int i = start;
        while (i < end) {
            if (this.graphData[0][1][i] >= maxTimeValue) {
                maxTimeValue = this.graphData[0][1][i];
            }
            if (this.graphData[0][1][i] <= minTimeValue) {
                minTimeValue = this.graphData[0][1][i];
            }
            if (this.graphFrame.plotDerivative && i > 0) {
                double value = this.graphData[0][0][i];
                double value2 = this.graphData[0][0][i - 1];
                if (this.graphFrame.conversionType == 26) {
                    value -= (double)this.freqOffset;
                    value2 -= (double)this.freqOffset;
                }
                this.firstDifference[i] = 5.0 * ((value - value2) / (this.graphData[0][1][i] - this.graphData[0][1][i - 1]));
            }
            ++i;
        }
        int numberOfTimeLabels = graphWidth / labelWidth;
        if (!(!drawLabels || numberOfTimeLabels <= 0 && this.graphFrame.showContinuous || numberOfTimeLabels <= 0 && start >= this.graphData[0][2].length - 1)) {
            double[] timelabels = LinePlotPanel.calcAxisInterval(minTimeValue, maxTimeValue, numberOfTimeLabels, true);
            numberOfTimeLabels = timelabels.length;
            int resets = (int)this.graphData[0][2][start];
            boolean firstLabel = true;
            DecimalFormat d = new DecimalFormat("0");
            int v = 0;
            while (v < numberOfTimeLabels) {
                if (!this.maxPlottedUptimeForReset.containsKey(resets) || !((double)this.maxPlottedUptimeForReset.get(resets).longValue() > timelabels[v])) {
                    this.maxPlottedUptimeForReset.put(resets, (long)timelabels[v]);
                    int timepos = LinePlotPanel.getRatioPosition(minTimeValue, maxTimeValue, timelabels[v], graphWidth) + 2;
                    if (!this.graphFrame.showContinuous && numberOfTimeLabels == 1) {
                        timepos = 1;
                    }
                    if (this.graphFrame.showContinuous && timepos > 0 && graphWidth > timepos && graphWidth - timepos > labelWidth / 2 || !this.graphFrame.showContinuous && timepos > 0 && graphWidth > timepos || !this.graphFrame.showContinuous && numberOfTimeLabels == 1) {
                        String s = d.format(timelabels[v]);
                        int offset = 0;
                        if (!this.graphFrame.hideUptime) {
                            offset = Config.graphAxisFontSize;
                        }
                        if (firstLabel) {
                            this.g2.setColor(this.graphTextColor);
                            if (!this.graphFrame.showUTCtime) {
                                this.g2.drawString("" + resets, timepos + sideBorder + 2, zeroPoint + 1 * Config.graphAxisFontSize + offset);
                            }
                        }
                        this.g2.setColor(this.graphTextColor);
                        if (!this.graphFrame.hideUptime) {
                            this.g2.drawString(s, timepos + sideBorder + 2, zeroPoint + Config.graphAxisFontSize);
                        }
                        if (this.graphFrame.showUTCtime && this.fox.hasTimeZero(resets)) {
                            this.g2.drawString(this.fox.getUtcTimeForReset(resets, (long)timelabels[v]), timepos + sideBorder + 2, zeroPoint + 1 * Config.graphAxisFontSize + offset);
                            this.g2.drawString(this.fox.getUtcDateForReset(resets, (long)timelabels[v]), timepos + sideBorder + 2, zeroPoint + 2 * Config.graphAxisFontSize + offset);
                        }
                        this.g2.setColor(this.graphAxisColor);
                        if (this.graphFrame.showVerticalLines) {
                            this.g2.setColor(Color.GRAY);
                            this.g.drawLine(timepos + sideBorder, graphHeight + this.topBorder + 5, timepos + sideBorder, this.topBorder);
                        } else {
                            this.g.drawLine(timepos + sideBorder, zeroPoint - 5, timepos + sideBorder, zeroPoint + 5);
                        }
                        firstLabel = false;
                    }
                }
                ++v;
            }
        }
        int stepSize = 1;
        if (end - start > graphWidth && graphWidth != 0) {
            stepSize = Math.round((end - start) / graphWidth);
        }
        this.plotSun(this.graphData, graphHeight, graphWidth, start, end, stepSize, sideBorder, minTimeValue, maxTimeValue, minValue, maxValue, 0, this.graphFrame.conversionType, true);
        this.plotGraph(this.graphData, graphHeight, graphWidth, start, end, stepSize, sideBorder, minTimeValue, maxTimeValue, minValue, maxValue, 0, this.graphFrame.conversionType, this.graphFrame.lastConversion, true);
        if (this.drawGraph2) {
            this.plotGraph(this.graphData2, graphHeight, graphWidth, start, end, stepSize, sideBorder, minTimeValue, maxTimeValue, minValue2, maxValue2, this.graphFrame.fieldName.length, this.graphFrame.conversionType2, this.graphFrame.lastConversion2, false);
        }
    }

    private void plotGraph(double[][][] graphData, int graphHeight, int graphWidth, int start, int end, int stepSize, int sideBorder, double minTimeValue, double maxTimeValue, double minValue, double maxValue, int colorIdx, int graphType, Conversion conversion, boolean plotDsp) {
        if (graphData != null) {
            int j = 0;
            while (j < graphData.length) {
                int lastx = sideBorder + 1;
                int nextx = 0;
                int lastx2 = sideBorder + 1;
                int lasty = graphHeight / 2;
                int lasty2 = graphHeight / 2;
                int lasty3 = graphHeight / 2;
                int x = 0;
                int x2 = 0;
                int y = 0;
                int y2 = 0;
                int y3 = 0;
                int i = start;
                while (i < end) {
                    double p = graphData[j][1][i];
                    x = LinePlotPanel.getRatioPosition(minTimeValue, maxTimeValue, p, graphWidth);
                    if (i < end - stepSize) {
                        double q = graphData[j][1][i + stepSize];
                        nextx = LinePlotPanel.getRatioPosition(minTimeValue, maxTimeValue, q, graphWidth);
                        nextx += sideBorder;
                    } else {
                        nextx = 0;
                    }
                    this.plottedXreset[(x += sideBorder) - this.sideBorder] = (int)graphData[j][2][i];
                    this.plottedXuptime[x - this.sideBorder] = (long)graphData[j][1][i];
                    x2 = (x + lastx) / 2;
                    if (!Config.displayRawValues && conversion != null && conversion instanceof ConversionStringLookUpTable) {
                        y = LinePlotPanel.getRatioPosition(minValue, maxValue, graphData[j][0][i] + 1.0, graphHeight);
                    } else if (!(Config.displayRawValues || graphType != 16 && graphType != 44 && graphType != 17 && graphType != 21 && graphType != 27)) {
                        y = LinePlotPanel.getRatioPosition(minValue, maxValue, graphData[j][0][i] + 1.0, graphHeight);
                    } else if (graphType == 26) {
                        y = LinePlotPanel.getRatioPosition(minValue, maxValue, graphData[j][0][i] - (double)this.freqOffset, graphHeight);
                        if (this.graphFrame.plotDerivative && plotDsp && j == 0) {
                            y2 = LinePlotPanel.getRatioPosition(minValue, maxValue, this.firstDifference[i], graphHeight);
                        }
                        if (this.graphFrame.dspAvg && plotDsp && j == 0) {
                            y3 = LinePlotPanel.getRatioPosition(minValue, maxValue, this.dspData[i] - (double)this.freqOffset, graphHeight);
                        }
                    } else {
                        y = LinePlotPanel.getRatioPosition(minValue, maxValue, graphData[j][0][i], graphHeight);
                        if (this.graphFrame.plotDerivative && plotDsp && j == 0) {
                            y2 = LinePlotPanel.getRatioPosition(minValue, maxValue, this.firstDifference[i], graphHeight);
                        }
                        if (this.graphFrame.dspAvg && plotDsp && j == 0) {
                            y3 = LinePlotPanel.getRatioPosition(minValue, maxValue, this.dspData[i], graphHeight);
                        }
                    }
                    y = graphHeight - y + this.topBorder;
                    y2 = graphHeight - y2 + this.topBorder;
                    y3 = graphHeight - y3 + this.topBorder;
                    if (i == start) {
                        lastx = x;
                        lastx2 = x2;
                        lasty = y;
                        lasty2 = y2;
                        lasty3 = y3;
                    }
                    if (!this.graphFrame.hideMain || this.graphFrame.hideMain && plotDsp && j > 0 || this.graphFrame.hideMain && !plotDsp) {
                        this.g2.setColor(this.graphColor[j + colorIdx]);
                        if (!this.graphFrame.hideLines) {
                            this.g2.drawLine(lastx, lasty, x, y);
                        }
                        if (!this.graphFrame.hidePoints) {
                            this.g2.draw(new Ellipse2D.Double(x - 1, y - 1, 2.0, 2.0));
                        }
                    }
                    if (this.graphFrame.plotDerivative && plotDsp && j == 0) {
                        this.g2.setColor(Config.AMSAT_RED);
                        if (!this.graphFrame.hideLines) {
                            this.g2.drawLine(lastx2, lasty2, x2, y2);
                        }
                        if (!this.graphFrame.hidePoints) {
                            this.g2.draw(new Ellipse2D.Double(x2, y2, 2.0, 2.0));
                        }
                    }
                    if (this.graphFrame.dspAvg && plotDsp && j == 0) {
                        this.g2.setColor(Config.AMSAT_GREEN);
                        if (!this.graphFrame.hideLines) {
                            this.g2.drawLine(lastx, lasty3, x, y3);
                        }
                        if (!this.graphFrame.hidePoints) {
                            this.g2.draw(new Ellipse2D.Double(x, y3, 2.0, 2.0));
                        }
                    }
                    lastx = x;
                    lastx2 = x2;
                    lasty = y;
                    lasty2 = y2;
                    lasty3 = y3;
                    i += stepSize;
                }
                ++j;
            }
        }
    }

    private void plotSun(double[][][] graphData, int graphHeight, int graphWidth, int start, int end, int stepSize, int sideBorder, double minTimeValue, double maxTimeValue, double minValue, double maxValue, int colorIdx, int graphType, boolean plotDsp) {
        if (graphData != null) {
            int j = 0;
            while (j < graphData.length) {
                int lastx = sideBorder + 1;
                int nextx = 0;
                int lastMidPoint = 0;
                int x = 0;
                int i = start;
                while (i < end) {
                    double p = graphData[j][1][i];
                    x = LinePlotPanel.getRatioPosition(minTimeValue, maxTimeValue, p, graphWidth);
                    if (i < end - stepSize) {
                        double q = graphData[j][1][i + stepSize];
                        nextx = LinePlotPanel.getRatioPosition(minTimeValue, maxTimeValue, q, graphWidth);
                        nextx += sideBorder;
                    } else {
                        nextx = 0;
                    }
                    x += sideBorder;
                    long up = (long)graphData[j][1][i];
                    int res = (int)graphData[j][2][i];
                    SatPos pos = null;
                    try {
                        pos = this.fox.getSatellitePosition(res, up);
                    }
                    catch (PositionCalcException e) {
                        pos = null;
                    }
                    if (i == start) {
                        lastx = x;
                        lastMidPoint = x;
                    }
                    if (this.graphFrame.showSun) {
                        if (pos != null && pos.isEclipsed()) {
                            this.g2.setColor(new Color(204, 204, 204));
                        } else {
                            this.g2.setColor(new Color(255, 204, 0));
                        }
                        int midPoint = 0;
                        int w = 0;
                        if (nextx == 0) {
                            nextx = x;
                        }
                        midPoint = x + (nextx - x) / 2;
                        w = midPoint - lastMidPoint;
                        if (lastx == x) {
                            this.g2.fillRect(lastx, this.topBorder, w, graphHeight);
                        } else if (w == 0) {
                            midPoint = x;
                            this.g2.drawLine(x, this.topBorder, x, graphHeight + this.topBorder);
                        } else {
                            this.g2.fillRect(lastMidPoint, this.topBorder, w, graphHeight);
                        }
                        lastMidPoint = midPoint;
                    }
                    lastx = x;
                    i += stepSize;
                }
                ++j;
            }
        }
    }
}

