/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.T0SeriesTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;

public class SpacecraftPanel
extends JPanel
implements ActionListener,
ItemListener,
FocusListener {
    JTextField displayName;
    JTextField name;
    JComboBox<String> priority;
    JTextField telemetryDownlinkFreqkHz;
    JTextField minFreqBoundkHz;
    JTextField maxFreqBoundkHz;
    JTextField rssiLookUpTableFileName;
    JTextField ihuTempLookUpTableFileName;
    JTextField ihuVBattLookUpTableFileName;
    JTextField BATTERY_CURRENT_ZERO;
    JTextField mpptResistanceError;
    JTextField mpptSensorOffThreshold;
    JTextField memsRestValueX;
    JTextField memsRestValueY;
    JTextField memsRestValueZ;
    JTextField[] T0;
    JTextField localServer;
    JTextField localServerPort;
    JCheckBox[] sendLayoutToServer;
    JCheckBox useIHUVBatt;
    JCheckBox track;
    JCheckBox user_useGPSTimeForT0;
    JComboBox<String> cbMode;
    JButton btnCancel;
    JButton btnSave;
    JButton btnGetT0;
    JButton btnDeleteT0;
    T0SeriesTableModel t0TableModel;
    Spacecraft sat;
    int headerSize = 12;

    public SpacecraftPanel(Spacecraft sat) {
        this.sat = sat;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 0));
        this.addFields();
    }

    private void addFields() {
        JPanel titlePanel = new JPanel();
        this.add((Component)titlePanel, "North");
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        JPanel titlePanel1 = new JPanel();
        titlePanel.add((Component)titlePanel1, "North");
        titlePanel1.setLayout(new FlowLayout(0));
        JPanel titlePanel2 = new JPanel();
        titlePanel.add((Component)titlePanel2, "North");
        titlePanel2.setLayout(new FlowLayout(0));
        TitledBorder heading0 = this.title("Identification");
        titlePanel.setBorder(heading0);
        this.name = this.addSettingsRow(titlePanel1, 8, "Name (for Keps)", "The name must be the same as the name in your TLE/Keps file if you want to calculate positions or sync with SatPC32", this.sat.user_keps_name);
        titlePanel1.add(this.name);
        this.displayName = this.addSettingsRow(titlePanel2, 15, "Display Name", "This name is use used as a label on Graphs and Tabs", this.sat.user_display_name);
        titlePanel2.add(this.displayName);
        JLabel lId = new JLabel("     ID: " + this.sat.foxId);
        titlePanel1.add(lId);
        JLabel lblPriority = new JLabel("    Priority");
        titlePanel1.add(lblPriority);
        String tip = "The highest priority spacecraft is tracked if more than one is above the horizon";
        lblPriority.setToolTipText(tip);
        String[] nums = new String[20];
        int i = 0;
        while (i < nums.length) {
            nums[i] = "" + i;
            ++i;
        }
        this.priority = new JComboBox<String>(nums);
        this.priority.setSelectedIndex(this.sat.user_priority);
        titlePanel1.add(this.priority);
        JPanel leftPanel = new JPanel();
        this.add((Component)leftPanel, "West");
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel leftFixedPanel = new JPanel();
        JPanel leftFixedPanelf = new JPanel();
        leftFixedPanelf.setLayout(new BorderLayout());
        leftFixedPanel.setLayout(new BoxLayout(leftFixedPanel, 1));
        leftPanel.add(leftFixedPanelf);
        leftFixedPanelf.add((Component)leftFixedPanel, "North");
        TitledBorder heading = this.title("Fixed Paramaters");
        leftFixedPanel.setBorder(heading);
        JLabel lModel = new JLabel("Model: " + Spacecraft.modelNames[this.sat.model]);
        leftFixedPanel.add(lModel);
        JLabel lIhusn = new JLabel("IHU S/N: " + this.sat.IHU_SN);
        leftFixedPanel.add(lIhusn);
        JLabel icr = null;
        if (this.sat.hasImprovedCommandReceiver) {
            icr = new JLabel("Improved Command Receiver");
            leftFixedPanel.add(icr);
        }
        if (this.sat.hasImprovedCommandReceiverII) {
            icr = new JLabel("Improved Command Receiver II");
            leftFixedPanel.add(icr);
        }
        JLabel[] lExp = new JLabel[4];
        int i2 = 0;
        while (i2 < 4) {
            lExp[i2] = new JLabel("Experiment " + (i2 + 1) + ": " + Spacecraft.expNames[this.sat.experiments[i2]]);
            leftFixedPanel.add(lExp[i2]);
            ++i2;
        }
        JPanel t0Panel = new JPanel();
        leftPanel.add(t0Panel);
        TitledBorder headingT0 = this.title("Time Zero");
        t0Panel.setBorder(headingT0);
        t0Panel.setLayout(new BoxLayout(t0Panel, 1));
        this.t0TableModel = new T0SeriesTableModel();
        JTable table = new JTable(this.t0TableModel);
        table.setAutoCreateRowSorter(true);
        JScrollPane scrollPane = new JScrollPane(table, 22, 31);
        scrollPane.setPreferredSize(new Dimension(100, 400));
        table.setFillsViewportHeight(true);
        t0Panel.add(scrollPane);
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(20);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        this.updateTimeSeries();
        JPanel t0buttonsPanel = new JPanel();
        t0Panel.add(t0buttonsPanel);
        this.btnGetT0 = new JButton("Update T0 from Server");
        this.btnGetT0.addActionListener(this);
        t0buttonsPanel.add(this.btnGetT0);
        this.btnDeleteT0 = new JButton("Delete T0 File");
        this.btnDeleteT0.addActionListener(this);
        t0buttonsPanel.add(this.btnDeleteT0);
        JPanel localServerPanel = new JPanel();
        leftPanel.add(localServerPanel);
        if (this.sat.user_localServer != null) {
            TitledBorder localServerPanelHeader = this.title("TCP interface");
            localServerPanel.setBorder(localServerPanelHeader);
            localServerPanel.setLayout(new BoxLayout(localServerPanel, 1));
            this.localServer = this.addSettingsRow(localServerPanel, 15, "Address", "The IP address or domain name of a program where selected telemetry is sent", this.sat.user_localServer);
            this.localServerPort = this.addSettingsRow(localServerPanel, 15, "Port", "The port of the local server or program", "" + this.sat.user_localServerPort);
        }
        leftPanel.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        JPanel rightPanel = new JPanel();
        this.add((Component)rightPanel, "Center");
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        JPanel rightPanel1 = new JPanel();
        rightPanel.add(rightPanel1);
        rightPanel1.setLayout(new BoxLayout(rightPanel1, 1));
        TitledBorder heading2 = this.title("Frequency and Tracking");
        rightPanel1.setBorder(heading2);
        this.cbMode = this.addComboBoxRow(rightPanel1, "Mode", tip, Config.satManager.getFormats());
        this.cbMode.setSelectedItem(this.sat.user_format);
        this.telemetryDownlinkFreqkHz = this.addSettingsRow(rightPanel1, 15, "Downlink Freq (kHz)", "The nominal downlink frequency of the spacecraft", "" + this.sat.user_telemetryDownlinkFreqkHz);
        this.minFreqBoundkHz = this.addSettingsRow(rightPanel1, 15, "Lower Freq Bound (kHz)", "The lower frequency boundry when we are searching for the spacecraft signal", "" + this.sat.user_minFreqBoundkHz);
        this.maxFreqBoundkHz = this.addSettingsRow(rightPanel1, 15, "Upper Freq Bound (kHz)", "The upper frequency boundry when we are searching for the spacecraft signal", "" + this.sat.user_maxFreqBoundkHz);
        this.track = this.addCheckBoxRow("Track this spacecraft", "When Doppler tracking or Find Signal is enabled include this satellite", this.sat.user_track, rightPanel1);
        this.user_useGPSTimeForT0 = this.addCheckBoxRow("Use GPS Time to set T0", "When set the GPS time from the spacecraft will be used to set T0", this.sat.user_useGPSTimeForT0, rightPanel1);
        rightPanel1.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        JPanel rightPanel2 = new JPanel();
        rightPanel.add(rightPanel2);
        rightPanel2.setLayout(new BoxLayout(rightPanel2, 1));
        if (!this.sat.hasFOXDB_V3) {
            TitledBorder heading3 = this.title("Calibration");
            rightPanel2.setBorder(heading3);
            this.BATTERY_CURRENT_ZERO = this.addSettingsRow(rightPanel2, 25, "Battery Current Zero", "The calibration paramater for zero battery current", "" + this.sat.user_BATTERY_CURRENT_ZERO);
            this.rssiLookUpTableFileName = this.addSettingsRow(rightPanel2, 25, "RSSI Lookup Table", "The file containing the lookup table for Received Signal Strength", this.sat.getLookupTableFileNameByName("RSSI"));
            this.ihuTempLookUpTableFileName = this.addSettingsRow(rightPanel2, 25, "IHU Temp Lookup Table", "The file containing the lookup table for the IHU Temperature", this.sat.getLookupTableFileNameByName("IHU_TEMP"));
            this.ihuVBattLookUpTableFileName = this.addSettingsRow(rightPanel2, 25, "VBatt Lookup Table", "The file containing the lookup table for the Battery Voltage", this.sat.getLookupTableFileNameByName("IHU_VBATT"));
            this.rssiLookUpTableFileName.setEnabled(false);
            this.ihuTempLookUpTableFileName.setEnabled(false);
            this.ihuVBattLookUpTableFileName.setEnabled(false);
            this.useIHUVBatt = this.addCheckBoxRow("Use Bus Voltage as VBatt", "Read the Bus Voltage from the IHU rather than the Battery Voltage from the battery card using I2C", this.sat.useIHUVBatt, rightPanel2);
            if (this.sat.hasMpptSettings) {
                this.mpptResistanceError = this.addSettingsRow(rightPanel2, 25, "MPPT Resistance Error", "The extra resistance in the RTD temperature measurement circuit", "" + this.sat.user_mpptResistanceError);
                this.mpptSensorOffThreshold = this.addSettingsRow(rightPanel2, 25, "MPPT Sensor Off Threshold", "The ADC value when the temperature sensor is considered off", "" + this.sat.user_mpptSensorOffThreshold);
            }
            if (this.sat.hasMemsRestValues) {
                this.memsRestValueX = this.addSettingsRow(rightPanel2, 25, "MEMS Rest Value X", "The rest value for the MEMS X rotation sensor", "" + this.sat.user_memsRestValueX);
                this.memsRestValueY = this.addSettingsRow(rightPanel2, 25, "MEMS Rest Value Y", "The rest value for the MEMS Y rotation sensor", "" + this.sat.user_memsRestValueY);
                this.memsRestValueZ = this.addSettingsRow(rightPanel2, 25, "MEMS Rest Value Z", "The rest value for the MEMS Z rotation sensor", "" + this.sat.user_memsRestValueZ);
            }
        }
        rightPanel2.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        JPanel footerPanel = new JPanel();
        TitledBorder heading9 = this.title("Description");
        footerPanel.setBorder(heading9);
        JTextArea taDesc = new JTextArea(2, 45);
        taDesc.setText(this.sat.description);
        taDesc.setLineWrap(true);
        taDesc.setWrapStyleWord(true);
        taDesc.setEditable(false);
        taDesc.setFont(new Font("SansSerif", 0, 12));
        footerPanel.add(taDesc);
        this.add((Component)footerPanel, "South");
    }

    private void setSelection(JComboBox<String> comboBox, String[] values, String value) {
        int i = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String rate = stringArray[n2];
            if (rate.equalsIgnoreCase(value)) break;
            ++i;
            ++n2;
        }
        if (i >= values.length) {
            i = 0;
        }
        comboBox.setSelectedIndex(i);
    }

    private JComboBox<String> addComboBoxRow(JPanel parent, String name, String tip, String[] values) {
        JPanel row = new JPanel();
        row.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lbl = new JLabel(name);
        JComboBox<String> checkBox = new JComboBox<String>(values);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        lbl.setToolTipText(tip);
        row.add(lbl);
        row.add(checkBox);
        parent.add(row);
        parent.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return checkBox;
    }

    private void updateTimeSeries() {
        String[][] data = null;
        if (this.sat.hasTimeZero()) {
            data = this.sat.getT0TableData();
        }
        if (data == null) {
            data = new String[1][2];
            data[0][0] = "0";
            data[0][1] = "Time origin missing";
        }
        this.t0TableModel.setData(data);
    }

    private TitledBorder title(String s) {
        TitledBorder title = new TitledBorder(null, s, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        return title;
    }

    private JCheckBox addCheckBoxRow(String name, String tip, boolean value, JPanel parent) {
        JPanel box = new JPanel();
        box.setLayout(new FlowLayout(0));
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        box.add(checkBox);
        parent.add(box);
        if (value) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        return checkBox;
    }

    private JTextField addSettingsRow(JPanel column, int length, String name, String tip, String value) {
        JPanel panel = new JPanel();
        column.add(panel);
        panel.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lblDisplayModuleFont = new JLabel(name);
        lblDisplayModuleFont.setToolTipText(tip);
        panel.add(lblDisplayModuleFont);
        JTextField textField = new JTextField(value);
        textField.setToolTipText(tip);
        panel.add(textField);
        textField.setColumns(length);
        textField.addActionListener(this);
        textField.addFocusListener(this);
        column.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return textField;
    }

    public boolean save() {
        boolean dispose = true;
        double downlinkFreq = 0.0;
        double minFreq = 0.0;
        double maxFreq = 0.0;
        try {
            String m;
            try {
                downlinkFreq = (double)Math.round(Double.parseDouble(this.telemetryDownlinkFreqkHz.getText()) * 1000.0) / 1000.0;
                minFreq = (double)Math.round(Double.parseDouble(this.minFreqBoundkHz.getText()) * 1000.0) / 1000.0;
                maxFreq = (double)Math.round(Double.parseDouble(this.maxFreqBoundkHz.getText()) * 1000.0) / 1000.0;
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException("The Frequency fields must contain a valid frequency in kHz");
            }
            if (minFreq < maxFreq) {
                this.sat.user_telemetryDownlinkFreqkHz = downlinkFreq;
                this.sat.user_minFreqBoundkHz = minFreq;
                this.sat.user_maxFreqBoundkHz = maxFreq;
            } else {
                Log.errorDialog("ERROR", "Lower Frequency Bound must be less than Upper Frequency Bound");
                dispose = false;
            }
            this.sat.user_format = m = (String)this.cbMode.getSelectedItem();
            if (!this.sat.hasFOXDB_V3) {
                if (this.sat.user_BATTERY_CURRENT_ZERO != Double.parseDouble(this.BATTERY_CURRENT_ZERO.getText())) {
                    this.sat.user_BATTERY_CURRENT_ZERO = Double.parseDouble(this.BATTERY_CURRENT_ZERO.getText());
                }
                if (this.sat.hasMpptSettings) {
                    if (this.sat.user_mpptResistanceError != Double.parseDouble(this.mpptResistanceError.getText())) {
                        this.sat.user_mpptResistanceError = Double.parseDouble(this.mpptResistanceError.getText());
                    }
                    if (this.sat.user_mpptSensorOffThreshold != Integer.parseInt(this.mpptSensorOffThreshold.getText())) {
                        this.sat.user_mpptSensorOffThreshold = Integer.parseInt(this.mpptSensorOffThreshold.getText());
                    }
                }
                if (this.sat.hasMemsRestValues) {
                    if (this.sat.user_memsRestValueX != Integer.parseInt(this.memsRestValueX.getText())) {
                        this.sat.user_memsRestValueX = Integer.parseInt(this.memsRestValueX.getText());
                    }
                    if (this.sat.user_memsRestValueY != Integer.parseInt(this.memsRestValueY.getText())) {
                        this.sat.user_memsRestValueY = Integer.parseInt(this.memsRestValueY.getText());
                    }
                    if (this.sat.user_memsRestValueZ != Integer.parseInt(this.memsRestValueZ.getText())) {
                        this.sat.user_memsRestValueZ = Integer.parseInt(this.memsRestValueZ.getText());
                    }
                }
                if (this.sat.useIHUVBatt != this.useIHUVBatt.isSelected()) {
                    this.sat.useIHUVBatt = this.useIHUVBatt.isSelected();
                }
            }
            if (!this.sat.user_keps_name.equalsIgnoreCase(this.name.getText())) {
                this.sat.user_keps_name = this.name.getText();
            }
            if (!this.sat.user_display_name.equalsIgnoreCase(this.displayName.getText())) {
                this.sat.user_display_name = this.displayName.getText();
            }
            int pri = 99;
            try {
                pri = this.priority.getSelectedIndex();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.sat.user_priority != pri) {
                this.sat.user_priority = pri;
            }
            if (this.localServer != null) {
                this.sat.user_localServer = this.localServer.getText();
                this.sat.user_localServerPort = this.localServerPort.getText().equalsIgnoreCase("") ? 0 : Integer.parseInt(this.localServerPort.getText());
            }
            this.sat.user_track = this.track.isSelected();
            this.sat.user_useGPSTimeForT0 = this.user_useGPSTimeForT0.isSelected();
        }
        catch (NumberFormatException Ex) {
            Log.errorDialog("Invalid Paramaters", Ex.getMessage());
        }
        return dispose;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnGetT0) {
            MainWindow.updateManager.updateT0(this.sat);
            this.updateTimeSeries();
            if (this.sat.hasTimeZero()) {
                Log.infoDialog("Time Zero Downloaded", "Time Zero (T0) was downloaded from the server for each reset.  This will not automatically\nupdate any open graphs.  You can toggle UTC on/off to refresh the time base on a graph.");
            } else {
                Log.infoDialog("Time Zero Downloaded Failed", "Time Zero (T0) could not be downloaded from the server.");
            }
        }
        if (e.getSource() == this.btnDeleteT0) {
            String message = "Do you want to delete the T0 file?\nTHIS WILL REMOVE THE T0 FILE. This is only useful when testing in the lab\nAfter launch the T0 file will be downloaded again from the server by FoxTelem when it starts and periodically while running.";
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(MainWindow.frame, message, "Do you want to continue?", 0, 0, null, options, options[1]);
            if (n == 1) {
                return;
            }
            MainWindow.updateManager.deleteT0(this.sat);
            this.updateTimeSeries();
        }
        e.getSource();
    }

    public void saveProperties() {
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowHeight", this.getHeight());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowWidth", this.getWidth());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowX", this.getX());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftWindow", "windowY", this.getY());
    }

    public void loadProperties() {
        int windowX = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowX");
        int windowY = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowY");
        int windowWidth = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowWidth");
        int windowHeight = Config.loadGraphIntValue("Global", 0, 0, "spacecraftWindow", "windowHeight");
        if (windowX == 0 || windowY == 0 || windowWidth == 0 || windowHeight == 0) {
            this.setBounds(100, 100, 600, 700);
        } else {
            this.setBounds(windowX, windowY, windowWidth, windowHeight);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }
}

