/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Location;
import common.Log;
import gui.MainWindow;
import gui.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SettingsFrame
extends JDialog
implements ActionListener,
ItemListener,
FocusListener,
WindowListener {
    public static final int MAX_CALLSIGN_LEN = 32;
    public static final int MAX_STATION_LEN = 50;
    private JPanel contentPane;
    private JTextField txtDisplayModuleFontSize;
    private JTextField txtGraphAxisFontSize;
    private JTextField txtLogFileDirectory;
    private JTextField txtServerUrl;
    private JTextField txtCallsign;
    private JTextField txtLatitude;
    private JTextField txtLongitude;
    private JTextField txtMaidenhead;
    private JTextField txtStation;
    private JTextField txtAltitude;
    private JTextField txtPrimaryServer;
    private JTextField txtSecondaryServer;
    private JCheckBox cbUploadToServer;
    private JCheckBox rdbtnTrackSignal;
    private JCheckBox saveFcdParams;
    private JCheckBox useLeftStereoChannel;
    private JCheckBox swapIQ;
    private JCheckBox cbUseDDEAzEl;
    private JCheckBox cbUseDDEFreq;
    private JCheckBox cbFoxTelemCalcsPosition;
    private JCheckBox cbFoxTelemCalcsDoppler;
    private JCheckBox cbWhenAboveHorizon;
    private JCheckBox useCostas;
    private JCheckBox use12kHzIf;
    boolean useUDP;
    private JPanel serverPanel;
    OptionsPanel optionsPanel;
    JButton btnSave;
    JButton btnCancel;
    JButton btnBrowse;

    public SettingsFrame(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setTitle("Settings");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel southpanel = new JPanel();
        this.contentPane.add((Component)southpanel, "South");
        southpanel.setLayout(new FlowLayout(1, 5, 5));
        this.btnSave = new JButton("Save");
        this.btnSave.addActionListener(this);
        southpanel.add(this.btnSave);
        this.getRootPane().setDefaultButton(this.btnSave);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        southpanel.add(this.btnCancel);
        JPanel northpanel = new JPanel();
        this.contentPane.add((Component)northpanel, "North");
        northpanel.setLayout(new BorderLayout());
        JPanel northpanel1 = new JPanel();
        JPanel northpanel2 = new JPanel();
        JPanel northpanelA = new JPanel();
        JPanel northpanelB = new JPanel();
        northpanel.add((Component)northpanel1, "North");
        northpanel1.setLayout(new BorderLayout());
        northpanel1.add((Component)northpanelA, "North");
        northpanel1.add((Component)northpanelB, "South");
        northpanel.add((Component)northpanel2, "South");
        northpanel2.setLayout(new BorderLayout());
        northpanelA.setLayout(new BorderLayout());
        northpanelB.setLayout(new BorderLayout());
        JLabel lblHomeDir = new JLabel("Home directory     ");
        lblHomeDir.setToolTipText("This is the directory that contains the settings file");
        lblHomeDir.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanelA.add((Component)lblHomeDir, "West");
        JLabel lblHomeDir2 = new JLabel(Config.homeDirectory);
        northpanelA.add((Component)lblHomeDir2, "Center");
        JLabel lblServerUrl = new JLabel("Server Data URL  ");
        lblServerUrl.setToolTipText("This sets the URL we use to fetch and download server data");
        lblServerUrl.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanelB.add((Component)lblServerUrl, "West");
        this.txtServerUrl = new JTextField(Config.webSiteUrl);
        northpanelB.add((Component)this.txtServerUrl, "Center");
        this.txtServerUrl.setColumns(30);
        this.txtServerUrl.addActionListener(this);
        JLabel lblLogFilesDir = new JLabel("Log files directory");
        lblLogFilesDir.setToolTipText("This sets the directory that the downloaded telemetry data is stored in");
        lblLogFilesDir.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanel2.add((Component)lblLogFilesDir, "West");
        this.txtLogFileDirectory = new JTextField(Config.logFileDirectory);
        northpanel2.add((Component)this.txtLogFileDirectory, "Center");
        this.txtLogFileDirectory.setColumns(30);
        this.txtLogFileDirectory.addActionListener(this);
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(this);
        northpanel2.add((Component)this.btnBrowse, "East");
        if (Config.logDirFromPassedParam) {
            this.txtLogFileDirectory.setEnabled(false);
            this.btnBrowse.setVisible(false);
            JLabel lblPassedParam = new JLabel("  (Fixed at Startup)");
            northpanel2.add((Component)lblPassedParam, "East");
        }
        TitledBorder eastTitle1 = this.title("Files and Directories");
        northpanel.setBorder(eastTitle1);
        JPanel centerpanel = new JPanel();
        this.contentPane.add((Component)centerpanel, "Center");
        centerpanel.setLayout(new BoxLayout(centerpanel, 0));
        JPanel leftcolumnpanel = new JPanel();
        JScrollPane leftscrollPane = new JScrollPane(leftcolumnpanel, 20, 30);
        leftscrollPane.setBorder(new EmptyBorder(5, 2, 5, 5));
        centerpanel.add(leftscrollPane);
        leftcolumnpanel.setLayout(new BoxLayout(leftcolumnpanel, 3));
        this.serverPanel = this.addColumn(leftcolumnpanel, 6);
        TitledBorder eastTitle2 = this.title("Ground Station Params");
        this.serverPanel.setBorder(eastTitle2);
        this.txtCallsign = this.addSettingsRow(this.serverPanel, 5, "Groundstation Name", "Ground station name is the unique identifier that you will use to store data on the AMSAT telemetry server", Config.callsign);
        this.txtPrimaryServer = this.addSettingsRow(this.serverPanel, 5, "Primary Server", "The address of the Amsat Telemetry server. Should not need to be changed", Config.primaryServer);
        this.txtSecondaryServer = this.addSettingsRow(this.serverPanel, 5, "Secondary Server", "The backup address of the Amsat Telemetry server. Should not need to be changed", Config.secondaryServer);
        JPanel locatorPanel = new JPanel();
        JLabel lblLoc = new JLabel("Locator from Lat Long: ");
        this.txtMaidenhead = new JTextField(Config.maidenhead);
        this.txtMaidenhead.addActionListener(this);
        this.txtMaidenhead.addFocusListener(this);
        this.txtMaidenhead.setColumns(7);
        String tip = "Only enter the grid square if you do not have the exact latitude and longitude";
        this.txtMaidenhead.setToolTipText(tip);
        lblLoc.setToolTipText(tip);
        this.serverPanel.add(locatorPanel);
        locatorPanel.add(lblLoc);
        locatorPanel.add(this.txtMaidenhead);
        this.txtLatitude = this.addSettingsRow(this.serverPanel, 4, "Lat (S is -ve)", "Latitude / Longitude or Locator need to be specified if you supply decoded data to AMSAT", Config.latitude);
        this.txtLongitude = this.addSettingsRow(this.serverPanel, 4, "Long (W is -ve)", "Latitude / Longitude or Locator need to be specified if you supply decoded data to AMSAT", Config.longitude);
        if (this.txtMaidenhead.getText().equalsIgnoreCase("XX00xx") || this.txtMaidenhead.getText().equals("")) {
            this.updateLocator();
        } else if (!SettingsFrame.validLatLong(this, this.txtLatitude.getText(), this.txtLongitude.getText())) {
            this.updateLatLong();
        }
        this.txtAltitude = this.addSettingsRow(this.serverPanel, 5, "Altitude (m)", "Altitude will be supplied to AMSAT along with your data if you specify it", Config.altitude);
        this.txtStation = this.addSettingsRow(this.serverPanel, 5, "RF-Receiver Description", "RF-Receiver can be specified to give us an idea of the types of stations that are in operation", Config.stationDetails);
        this.serverPanel.add(new Box.Filler(new Dimension(100, 0), new Dimension(100, 0), new Dimension(100, 0)));
        JPanel leftcolumnpanel2 = this.addColumn(leftcolumnpanel, 6);
        TitledBorder eastTitle3 = this.title("Formatting");
        leftcolumnpanel2.setBorder(eastTitle3);
        this.txtDisplayModuleFontSize = this.addSettingsRow(leftcolumnpanel2, 3, "Health Module Font Size", "Change the size of the font on the Satellite tabs so that it is more readable or so that it fits in the space available", Integer.toString(Config.displayModuleFontSize));
        this.txtGraphAxisFontSize = this.addSettingsRow(leftcolumnpanel2, 3, "Graph Font Size", "Change the size of the font on the graph axis", Integer.toString(Config.graphAxisFontSize));
        leftcolumnpanel2.add(new Box.Filler(new Dimension(250, 0), new Dimension(250, 0), new Dimension(1000, 0)));
        JPanel leftcolumnpanel3 = this.addColumn(leftcolumnpanel, 6);
        TitledBorder measureTitle = this.title("Measurements");
        leftcolumnpanel3.setBorder(measureTitle);
        if (Config.useDDEforAzEl) {
            Config.foxTelemCalcsPosition = false;
        }
        this.cbUseDDEFreq = this.addCheckBoxRow("Log Freq from SatPC32 in AF mode", "In AF mode FoxTelem can read the CAT frequency from SatPC32.  It is stored alongside other measurements", Config.useDDEforFreq, leftcolumnpanel3);
        this.cbUseDDEAzEl = this.addCheckBoxRow("Read position from SatPC32", "FoxTelem can read the position of the satellite from SatPC32.  It is stored alongside other measurements", Config.useDDEforAzEl, leftcolumnpanel3);
        if (Config.isWindowsOs()) {
            this.cbUseDDEFreq.setVisible(true);
            this.cbUseDDEAzEl.setVisible(true);
        } else {
            this.cbUseDDEFreq.setVisible(false);
            this.cbUseDDEAzEl.setVisible(false);
        }
        this.cbFoxTelemCalcsPosition = this.addCheckBoxRow("FoxTelem Calculates Position", "FoxTelem can calculate the position of the spacecraft and store it for analysis", Config.foxTelemCalcsPosition, leftcolumnpanel3);
        this.cbFoxTelemCalcsDoppler = this.addCheckBoxRow("FoxTelem Calculates Doppler", "FoxTelem can calculate the doppler shift of the downlink and tune the decoder", Config.foxTelemCalcsDoppler, leftcolumnpanel3);
        this.cbWhenAboveHorizon = this.addCheckBoxRow("Auto Start Decoder when above horizon", "FoxTelem can start/stop the decoder when the spacecraft is above/below the horizon", Config.whenAboveHorizon, leftcolumnpanel3);
        if (!Config.foxTelemCalcsPosition) {
            this.cbFoxTelemCalcsDoppler.setEnabled(false);
        }
        leftcolumnpanel3.add(new Box.Filler(new Dimension(250, 0), new Dimension(250, 0), new Dimension(1000, 0)));
        leftcolumnpanel.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 1000)));
        JPanel rightcolumnpanel = new JPanel();
        JScrollPane rightscrollPane = new JScrollPane(rightcolumnpanel, 20, 30);
        rightscrollPane.setBorder(new EmptyBorder(5, 2, 5, 5));
        centerpanel.add(rightscrollPane);
        rightcolumnpanel.setLayout(new BoxLayout(rightcolumnpanel, 1));
        JPanel rightcolumnpanel0 = this.addColumn(rightcolumnpanel, 3);
        rightcolumnpanel0.setLayout(new BoxLayout(rightcolumnpanel0, 1));
        TitledBorder eastTitle4 = this.title("Decoder Options");
        rightcolumnpanel0.setBorder(eastTitle4);
        this.cbUploadToServer = this.addCheckBoxRow("Upload to Server", "Select this if you want to send your collected data to the AMSAT telemetry server", Config.uploadToServer, rightcolumnpanel0);
        this.rdbtnTrackSignal = this.addCheckBoxRow("Find Signal", "Find and follow the signal. Record the frequency of the downlink.  Useful if you are trying to measure the actual spacecraft downlink frequency.", Config.findSignal, rightcolumnpanel0);
        this.useUDP = true;
        if (Config.serverProtocol == 0) {
            this.useUDP = false;
        }
        this.saveFcdParams = this.addCheckBoxRow("Store FCD Params", "Save the FCD settings to disk and restore at start up.  May conflict with other programs or other copies of FoxTelem.", Config.saveFcdParams, rightcolumnpanel0);
        this.useLeftStereoChannel = this.addCheckBoxRow("Use Left Stereo Channel", "The default is for FoxTelem to read audio from the left stereo channel of your soundcard.  If you uncheck this it will read from the right", Config.useLeftStereoChannel, rightcolumnpanel0);
        this.swapIQ = this.addCheckBoxRow("Swap IQ", "Swap the I and Q channels in IQ deocder mode", Config.swapIQ, rightcolumnpanel0);
        this.useCostas = this.addCheckBoxRow("PSK: Use Costas", "Use a coherent Costas Loop Decoder for PSK (better decoder but worse with fading)", Config.useCostas, rightcolumnpanel0);
        this.use12kHzIf = this.addCheckBoxRow("PSK: Use 12 kHz IF", "Use a 12 kHz IF for BPSK decoding (AF only, don't use in IQ mode)", Config.use12kHzIfForBPSK, rightcolumnpanel0);
        rightcolumnpanel0.add(new Box.Filler(new Dimension(0, 0), new Dimension(100, 0), new Dimension(1000, 0)));
        this.optionsPanel = new OptionsPanel();
        rightcolumnpanel.add(this.optionsPanel);
        rightcolumnpanel.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 1000)));
        this.setServerPanelEnabled(Config.uploadToServer);
        this.txtPrimaryServer.setEnabled(false);
        this.txtSecondaryServer.setEnabled(false);
        this.enableDependentParams();
    }

    public void saveProperties() {
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowHeight", this.getHeight());
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowWidth", this.getWidth());
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowX", this.getX());
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowY", this.getY());
    }

    public void loadProperties() {
        int windowX = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowX");
        int windowY = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowY");
        int windowWidth = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowWidth");
        int windowHeight = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowHeight");
        if (windowX == 0 || windowY == 0 || windowWidth == 0 || windowHeight == 0) {
            this.setBounds(100, 100, 725, 700);
        } else {
            this.setBounds(windowX, windowY, windowWidth, windowHeight);
        }
    }

    private TitledBorder title(String s) {
        TitledBorder title = new TitledBorder(null, s, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        return title;
    }

    private void setServerPanelEnabled(boolean en) {
    }

    public static boolean validLatLong(Component component, String txtLatitude, String txtLongitude) {
        float lon;
        float lat;
        block7: {
            block6: {
                lat = 0.0f;
                lon = 0.0f;
                try {
                    lat = Float.parseFloat(txtLatitude);
                    lon = Float.parseFloat(txtLongitude);
                    if (lat != Float.parseFloat("0.0") || lon != Float.parseFloat("0.0")) break block6;
                    return false;
                }
                catch (NumberFormatException n) {
                    JOptionPane.showMessageDialog(component, "Only numerical values are valid for the latitude and longitude. Can't use Lat: " + txtLatitude + " Long: " + txtLongitude, "Format Error\n", 0);
                    return false;
                }
            }
            if (!txtLatitude.equals("")) break block7;
            return false;
        }
        if (txtLongitude.equals("")) {
            return false;
        }
        if (Float.isNaN(lon) || Math.abs(lon) > 180.0f || Float.isNaN(lat) || (double)Math.abs(lat) == 90.0 || Math.abs(lat) > 90.0f) {
            JOptionPane.showMessageDialog(component, "Invalid latitude or longitude. Can't use Lat: " + txtLatitude + " Long: \n" + txtLongitude, "Error\n", 0);
            return false;
        }
        return true;
    }

    private boolean validLocator() {
        if (this.txtMaidenhead.getText().equalsIgnoreCase("XX00xx") || this.txtMaidenhead.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Enter a latitude/longitude or set the locator to a valid value", "Format Error\n", 0);
            return false;
        }
        return true;
    }

    private boolean validCallsign() {
        return !this.txtCallsign.getText().equalsIgnoreCase("NONE") && !this.txtCallsign.getText().equals("");
    }

    private boolean validServerParams() {
        if (!this.validCallsign()) {
            return false;
        }
        if (!this.validLocator()) {
            return false;
        }
        if (!SettingsFrame.validLatLong(this, this.txtLatitude.getText(), this.txtLongitude.getText())) {
            return false;
        }
        return this.validAltitude();
    }

    private JPanel addColumn(JPanel parent, int rows) {
        JPanel columnpanel = new JPanel();
        parent.add(columnpanel);
        columnpanel.setLayout(new BoxLayout(columnpanel, 1));
        return columnpanel;
    }

    private JCheckBox addCheckBoxRow(String name, String tip, boolean value, JPanel parent) {
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        parent.add(checkBox);
        if (value) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        return checkBox;
    }

    private JTextField addSettingsRow(JPanel column, int length, String name, String tip, String value) {
        JPanel panel = new JPanel();
        column.add(panel);
        panel.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lblDisplayModuleFont = new JLabel(name);
        lblDisplayModuleFont.setToolTipText(tip);
        panel.add(lblDisplayModuleFont);
        JTextField textField = new JTextField(value);
        panel.add(textField);
        textField.setColumns(length);
        textField.addActionListener(this);
        textField.addFocusListener(this);
        return textField;
    }

    private boolean validAltitude() {
        int alt = 0;
        try {
            alt = Integer.parseInt(this.txtAltitude.getText());
        }
        catch (NumberFormatException n) {
            JOptionPane.showMessageDialog(this, "Only integer values are valid for the altitude. Specify it to the nearest meter, but with no units.", "Format Error\n", 0);
            return false;
        }
        if (alt < 0 || alt > 8484) {
            JOptionPane.showMessageDialog(this, "Invalid altitude.  Must be between 0 and 8484m.", "Format Error\n", 0);
            return false;
        }
        return true;
    }

    private void updateLocator() {
        if (SettingsFrame.validLatLong(this, this.txtLatitude.getText(), this.txtLongitude.getText())) {
            Location l = new Location(this.txtLatitude.getText(), this.txtLongitude.getText());
            this.txtMaidenhead.setText(l.maidenhead);
        }
    }

    private void updateLatLong() {
        if (this.validLocator()) {
            Location l = new Location(this.txtMaidenhead.getText());
            this.txtLatitude.setText(Float.toString(l.latitude));
            this.txtLongitude.setText(Float.toString(l.longitude));
        }
    }

    private void enableDependentParams() {
        if (SettingsFrame.validLatLong(this, this.txtLatitude.getText(), this.txtLongitude.getText()) && this.validAltitude()) {
            if (this.validCallsign()) {
                this.cbUploadToServer.setEnabled(true);
            } else {
                this.cbUploadToServer.setEnabled(false);
            }
            this.cbFoxTelemCalcsPosition.setEnabled(true);
            if (this.cbFoxTelemCalcsPosition.isSelected()) {
                this.cbFoxTelemCalcsDoppler.setEnabled(true);
            } else {
                this.cbFoxTelemCalcsDoppler.setEnabled(false);
            }
            this.cbWhenAboveHorizon.setEnabled(true);
        } else {
            this.cbUploadToServer.setEnabled(false);
            this.cbFoxTelemCalcsPosition.setEnabled(false);
            this.cbFoxTelemCalcsDoppler.setEnabled(false);
            this.cbWhenAboveHorizon.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
        if (e.getSource() == this.txtLatitude || e.getSource() == this.txtLongitude) {
            this.updateLocator();
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtMaidenhead) {
            this.updateLatLong();
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtAltitude) {
            this.validAltitude();
            this.enableDependentParams();
        }
        if (e.getSource() == this.btnSave) {
            boolean dispose = true;
            boolean refreshTabs = false;
            boolean refreshGraphs = false;
            Config.uploadToServer = this.cbUploadToServer.isSelected();
            if (Config.uploadToServer && !this.validServerParams()) {
                JOptionPane.showMessageDialog(this, "You need to specify a Groundstation name to upload to the server.\nUse an amateur radio callsign or something like 'Sunnytown Primary School'.\nYou also need to specify a valid latitude and longitude or a Maidenhead locator.\nIf you specify an altitude, then it needs to be a valid value.", "Missing Server Upload Settings", 0);
                this.cbUploadToServer.setSelected(false);
                Config.uploadToServer = this.cbUploadToServer.isSelected();
            } else {
                Object[] options;
                int n;
                Config.callsign = this.txtCallsign.getText();
                Log.println("Setting callsign: " + Config.callsign);
                if (SettingsFrame.validLatLong(this, this.txtLatitude.getText(), this.txtLongitude.getText())) {
                    Config.latitude = this.txtLatitude.getText();
                    Config.longitude = this.txtLongitude.getText();
                } else {
                    dispose = this.txtLatitude.getText().equalsIgnoreCase("0.0") && this.txtLongitude.getText().equalsIgnoreCase("0.0");
                }
                if (this.validLocator()) {
                    Config.maidenhead = this.txtMaidenhead.getText();
                } else {
                    dispose = false;
                }
                if (this.validAltitude()) {
                    Config.altitude = this.txtAltitude.getText();
                } else {
                    dispose = false;
                }
                Config.stationDetails = this.txtStation.getText();
                if (Config.stationDetails.equalsIgnoreCase("")) {
                    Config.stationDetails = "NONE";
                }
                Config.primaryServer = this.txtPrimaryServer.getText();
                Config.secondaryServer = this.txtSecondaryServer.getText();
                Config.webSiteUrl = this.txtServerUrl.getText();
                Config.saveFcdParams = this.saveFcdParams.isSelected();
                Config.useLeftStereoChannel = this.useLeftStereoChannel.isSelected();
                Config.swapIQ = this.swapIQ.isSelected();
                if (Config.useCostas != this.useCostas.isSelected() || Config.use12kHzIfForBPSK != this.use12kHzIf.isSelected()) {
                    Log.errorDialog("CHANGED Decoder", "The decoder needs to be stopped and restarted.\nYou do not need to exit FoxTelem.");
                }
                Config.useCostas = this.useCostas.isSelected();
                Config.use12kHzIfForBPSK = this.use12kHzIf.isSelected();
                if (Config.isWindowsOs()) {
                    Config.useDDEforFreq = this.cbUseDDEFreq.isSelected();
                    Config.useDDEforAzEl = this.cbUseDDEAzEl.isSelected();
                }
                if (this.cbFoxTelemCalcsPosition.isSelected() && !Config.foxTelemCalcsPosition) {
                    Config.satManager.fetchTLEFile();
                }
                Config.foxTelemCalcsPosition = this.cbFoxTelemCalcsPosition.isSelected();
                Config.foxTelemCalcsDoppler = this.cbFoxTelemCalcsDoppler.isSelected();
                Config.whenAboveHorizon = this.cbWhenAboveHorizon.isSelected();
                Config.findSignal = this.rdbtnTrackSignal.isSelected();
                if (Config.displayModuleFontSize != this.parseIntTextField(this.txtDisplayModuleFontSize)) {
                    Config.displayModuleFontSize = this.parseIntTextField(this.txtDisplayModuleFontSize);
                    Log.println("Setting Health Tab font to: " + Config.displayModuleFontSize);
                    refreshTabs = true;
                }
                if (Config.graphAxisFontSize != this.parseIntTextField(this.txtGraphAxisFontSize) && (n = JOptionPane.showOptionDialog(MainWindow.frame, "Are you sure you want to change the font size? It will close any open graphs.", "Do you want to continue?", 0, 3, null, options = new Object[]{"Yes", "No"}, options[1])) == 0) {
                    Config.graphAxisFontSize = this.parseIntTextField(this.txtGraphAxisFontSize);
                    Log.println("Setting Graph font to: " + Config.displayModuleFontSize);
                    refreshTabs = true;
                    refreshGraphs = true;
                }
                if (!Config.logFileDirectory.equalsIgnoreCase(this.txtLogFileDirectory.getText())) {
                    boolean currentDir = false;
                    if (this.txtLogFileDirectory.getText().equalsIgnoreCase("")) {
                        currentDir = true;
                    }
                    File file = new File(this.txtLogFileDirectory.getText());
                    if (!(currentDir || file.isDirectory() && file != null && file.exists())) {
                        Log.errorDialog("Invalid directory", "Can not find the specified directory: " + this.txtLogFileDirectory.getText());
                        dispose = false;
                        refreshGraphs = false;
                    } else {
                        Object[] options2 = new Object[]{"Yes", "No"};
                        int n2 = JOptionPane.showOptionDialog(MainWindow.frame, "Do you want to switch log file directories? It will close any open graphs.", "Do you want to continue?", 0, 3, null, options2, options2[1]);
                        if (n2 == 0) {
                            Config.logFileDirectory = this.txtLogFileDirectory.getText();
                            Log.println("Setting log file directory to: " + Config.logFileDirectory);
                            Config.totalFrames = 0;
                            Config.initSatelliteManager();
                            Config.initPayloadStore();
                            Config.initPassManager();
                            Config.initSequence();
                            Config.initServerQueue();
                            Config.mainWindow.initSatMenu();
                            refreshTabs = true;
                            refreshGraphs = true;
                        }
                    }
                }
            }
            if (dispose) {
                Config.save();
                Config.storeGroundStation();
                this.dispose();
            }
            if (refreshTabs) {
                MainWindow.refreshTabs(refreshGraphs);
            }
            Config.fileProgress.updateProgress(100);
        }
        if (e.getSource() == this.btnBrowse) {
            File dir = null;
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                dir = new File(Config.logFileDirectory);
            }
            if (Config.isMacOs()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog fd = new FileDialog((Dialog)this, "Choose Directory for Log Files", 0);
                if (dir != null) {
                    fd.setDirectory(dir.getAbsolutePath());
                }
                fd.setVisible(true);
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
                String filename = fd.getFile();
                String dirname = fd.getDirectory();
                if (filename == null) {
                    Log.println("You cancelled the choice");
                } else {
                    Log.println("File: " + filename);
                    Log.println("DIR: " + dirname);
                    File selectedFile = new File(String.valueOf(dirname) + filename);
                    this.txtLogFileDirectory.setText(selectedFile.getAbsolutePath());
                }
            } else {
                JFileChooser fc = new JFileChooser();
                fc.setApproveButtonText("Choose");
                if (dir != null) {
                    fc.setCurrentDirectory(dir);
                }
                fc.setDialogTitle("Choose Directory for Log Files");
                fc.setFileSelectionMode(1);
                fc.setPreferredSize(new Dimension(Config.windowFcWidth, Config.windowFcHeight));
                int returnVal = fc.showOpenDialog(this);
                Config.windowFcHeight = fc.getHeight();
                Config.windowFcWidth = fc.getWidth();
                if (returnVal == 0) {
                    this.txtLogFileDirectory.setText(fc.getSelectedFile().getAbsolutePath());
                } else {
                    System.out.println("No Selection ");
                }
            }
        }
    }

    private int parseIntTextField(JTextField text) {
        int value = 0;
        try {
            value = Integer.parseInt(text.getText());
            if (value > 30) {
                value = 30;
                text.setText(Integer.toString(30));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbUploadToServer) {
            if (e.getStateChange() == 2) {
                this.setServerPanelEnabled(false);
            } else {
                this.setServerPanelEnabled(true);
            }
        }
        if (source == this.cbUseDDEAzEl && e.getStateChange() == 1) {
            this.cbFoxTelemCalcsPosition.setSelected(false);
            this.cbFoxTelemCalcsDoppler.setSelected(false);
        }
        if (source == this.cbFoxTelemCalcsPosition) {
            if (e.getStateChange() == 1) {
                this.cbUseDDEAzEl.setSelected(false);
                this.cbFoxTelemCalcsDoppler.setEnabled(true);
            } else {
                if (this.cbWhenAboveHorizon.isSelected()) {
                    this.cbWhenAboveHorizon.setSelected(false);
                }
                if (this.cbFoxTelemCalcsDoppler.isSelected()) {
                    this.cbFoxTelemCalcsDoppler.setSelected(false);
                }
                this.cbFoxTelemCalcsDoppler.setEnabled(false);
            }
        }
        if (source == this.cbFoxTelemCalcsDoppler && e.getStateChange() == 1) {
            this.rdbtnTrackSignal.setSelected(false);
        }
        if (source == this.cbWhenAboveHorizon && e.getStateChange() == 1) {
            if (!this.cbFoxTelemCalcsPosition.isSelected() && !this.cbUseDDEAzEl.isSelected()) {
                this.cbFoxTelemCalcsPosition.setSelected(true);
            }
            MainWindow.inputTab.rdbtnFindSignal.setSelected(true);
        }
        if (e.getSource() == this.rdbtnTrackSignal) {
            if (e.getStateChange() == 2) {
                Config.findSignal = false;
            } else {
                Config.findSignal = true;
                this.cbFoxTelemCalcsDoppler.setSelected(false);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.txtCallsign) {
            if (this.txtCallsign.getText().length() > 32) {
                this.txtCallsign.setText(this.txtCallsign.getText().substring(0, 32));
            }
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtStation && this.txtStation.getText().length() > 50) {
            this.txtStation.setText(this.txtStation.getText().substring(0, 50));
        }
        if (e.getSource() == this.txtLatitude || e.getSource() == this.txtLongitude) {
            this.updateLocator();
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtMaidenhead) {
            this.updateLatLong();
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtAltitude) {
            this.validAltitude();
            this.enableDependentParams();
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

