/*
 * Decompiled with CFR 0.152.
 */
package filter;

public class IirFilter {
    private int n1;
    private int n2;
    private double[] a;
    private double[] b;
    private double[] buf1;
    private double[] buf2;
    private int pos1;
    private int pos2;

    public IirFilter(double[] a, double[] b) {
        this.a = a;
        this.b = b;
        if (a.length < 1 || b.length < 1 || b[0] != 1.0) {
            throw new IllegalArgumentException("Invalid coefficients.");
        }
        this.n1 = a.length - 1;
        this.n2 = b.length - 1;
        this.buf1 = new double[this.n1];
        this.buf2 = new double[this.n2];
    }

    public double filterDouble(double in) {
        int p;
        double out = this.a[0] * in;
        int j = 1;
        while (j <= this.n1) {
            p = (this.pos1 + this.n1 - j) % this.n1;
            out += this.a[j] * this.buf1[p];
            ++j;
        }
        j = 1;
        while (j <= this.n2) {
            p = (this.pos2 + this.n2 - j) % this.n2;
            out += this.b[j] * this.buf2[p];
            ++j;
        }
        if (this.n1 > 0) {
            this.buf1[this.pos1] = in;
            this.pos1 = (this.pos1 + 1) % this.n1;
        }
        if (this.n2 > 0) {
            this.buf2[this.pos2] = out;
            this.pos2 = (this.pos2 + 1) % this.n2;
        }
        return out;
    }
}

