/*
 * Decompiled with CFR 0.152.
 */
package filter;

public class HilbertTransform {
    double[] coeffs;
    double[] xv;
    double gain = 1.0;
    int M;

    public HilbertTransform(double sampleRate, int len) {
        this.init(sampleRate, len);
        this.M = len - 1;
        this.xv = new double[len];
    }

    private void init(double sampleRate, int len) {
        double[] tempCoeffs = new double[len];
        double sumofsquares = 0.0;
        int n = 0;
        while (n < len) {
            tempCoeffs[n] = n == len / 2 ? 0.0 : sampleRate / (Math.PI * (double)(n - len / 2)) * (1.0 - Math.cos(Math.PI * (double)(n - len / 2)));
            sumofsquares += tempCoeffs[n] * tempCoeffs[n];
            ++n;
        }
        this.gain = Math.sqrt(sumofsquares);
        System.out.println("Hilbert Transform GAIN: " + this.gain);
        this.coeffs = new double[len];
        int i = 0;
        while (i < tempCoeffs.length) {
            this.coeffs[i] = tempCoeffs[tempCoeffs.length - i - 1] / this.gain;
            ++i;
        }
    }

    public double filter(double in) {
        int i = 0;
        while (i < this.M) {
            this.xv[i] = this.xv[i + 1];
            ++i;
        }
        this.xv[this.M] = in;
        double sum = 0.0;
        i = 0;
        while (i <= this.M) {
            sum += this.coeffs[i] * this.xv[i];
            ++i;
        }
        return sum;
    }
}

