/*
 * Decompiled with CFR 0.152.
 */
package device.rtl;

import common.Log;
import device.DeviceException;
import device.DevicePanel;
import device.TunerController;
import device.rtl.R820TTunerController;
import device.rtl.RTL2832TunerController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.usb.UsbException;

public class RTLPanel
extends DevicePanel
implements ItemListener,
ActionListener,
ChangeListener {
    private static final R820TTunerController.R820TGain DEFAULT_GAIN = R820TTunerController.R820TGain.GAIN_279;
    int NUM_OF_PARAMS = 15;
    private JSpinner mFrequencyCorrection;
    private JComboBox<R820TTunerController.R820TGain> mComboMasterGain;
    private JComboBox<R820TTunerController.R820TMixerGain> mComboMixerGain;
    private JComboBox<R820TTunerController.R820TLNAGain> mComboLNAGain;
    private JComboBox<R820TTunerController.R820TVGAGain> mComboVGAGain;
    private JCheckBox cbBiasTee;
    boolean loading = true;
    private JLabel lblSampleRate;
    public static final String SAMPLE_RATE = "Sample Rate: ";

    public RTLPanel() throws IOException, DeviceException {
        TitledBorder title = new TitledBorder(null, "R820T USB SDR", 4, 2, null, null);
        this.setBorder(title);
        this.initializeGui();
    }

    @Override
    public void setEnabled(boolean b) {
    }

    public void initializeGui() throws IOException, DeviceException {
        this.loading = true;
        this.setLayout(new BorderLayout(3, 3));
        JPanel center = new JPanel();
        JPanel top = new JPanel();
        JPanel bottom = new JPanel();
        this.add((Component)top, "North");
        top.setLayout(new FlowLayout());
        bottom.setLayout(new FlowLayout());
        this.add((Component)center, "Center");
        this.add((Component)bottom, "South");
        this.lblSampleRate = new JLabel(SAMPLE_RATE);
        top.add(this.lblSampleRate);
        SpinnerNumberModel model = new SpinnerNumberModel(0, -1000, 1000, 1);
        this.mFrequencyCorrection = new JSpinner(model);
        this.mFrequencyCorrection.setEnabled(true);
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.mFrequencyCorrection.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setMinimumFractionDigits(0);
        editor.getTextField().setHorizontalAlignment(0);
        this.mFrequencyCorrection.addChangeListener(this);
        top.add(new JLabel(" |  Freq Correction (ppm):"));
        top.add(this.mFrequencyCorrection);
        top.add(new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)));
        this.cbBiasTee = new JCheckBox("Bias T");
        top.add(this.cbBiasTee);
        this.cbBiasTee.addItemListener(this);
        this.cbBiasTee.setToolTipText("Toggle the rtl-sdr.com V3 Bias Tee.  Don't toggle to a short circuit antenna without a preamp!");
        center.add(new JLabel("Gain"));
        this.mComboMasterGain = new JComboBox<R820TTunerController.R820TGain>(R820TTunerController.R820TGain.values());
        this.mComboMasterGain.addActionListener(this);
        this.mComboMasterGain.setToolTipText("<html>Select <b>AUTOMATIC</b> for auto gain, <b>MANUAL</b> to enable<br> independent control of <i>Mixer</i>, <i>LNA</i> and <i>Enhance</i> gain<br>settings, or one of the individual gain settings for<br>semi-manual gain control</html>");
        center.add(new JLabel("Master:"));
        center.add(this.mComboMasterGain);
        R820TTunerController.R820TGain gain = (R820TTunerController.R820TGain)((Object)this.mComboMasterGain.getSelectedItem());
        this.mComboMixerGain = new JComboBox<R820TTunerController.R820TMixerGain>(R820TTunerController.R820TMixerGain.values());
        if (gain != R820TTunerController.R820TGain.MANUAL) {
            this.mComboMixerGain.setEnabled(false);
        }
        this.mComboMixerGain.addActionListener(this);
        this.mComboMixerGain.setToolTipText("<html>Mixer Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
        center.add(new JLabel("Mixer:"));
        center.add(this.mComboMixerGain);
        this.mComboLNAGain = new JComboBox<R820TTunerController.R820TLNAGain>(R820TTunerController.R820TLNAGain.values());
        if (gain != R820TTunerController.R820TGain.MANUAL) {
            this.mComboLNAGain.setEnabled(false);
        }
        this.mComboLNAGain.addActionListener(this);
        this.mComboLNAGain.setToolTipText("<html>LNA Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
        center.add(new JLabel("LNA:"));
        center.add(this.mComboLNAGain);
        this.mComboVGAGain = new JComboBox<R820TTunerController.R820TVGAGain>(R820TTunerController.R820TVGAGain.values());
        if (gain != R820TTunerController.R820TGain.MANUAL) {
            this.mComboVGAGain.setEnabled(false);
        }
        this.mComboVGAGain.addActionListener(this);
        this.mComboVGAGain.setToolTipText("<html>VGA Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
        center.add(new JLabel("VGA:"));
        center.add(this.mComboVGAGain);
        this.loading = false;
    }

    @Override
    public void setDevice(TunerController d) throws IOException, DeviceException, UsbException {
        this.device = (RTL2832TunerController)d;
        this.loading = true;
        this.getSettings();
        this.loading = false;
    }

    public void getSettings() throws IOException, DeviceException, UsbException {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.loadParam(this.mComboMasterGain, "mComboMasterGain");
        this.loadParam(this.mComboMixerGain, "mComboMixerGain");
        this.loadParam(this.mComboLNAGain, "mComboLNAGain");
        this.loadParam(this.mComboVGAGain, "mComboVGAGain");
        this.loadParam(this.mFrequencyCorrection, "mFrequencyCorrection");
        this.loadParam(this.cbBiasTee, "cbBiasTee");
        this.setGain();
        this.setMixerGain();
        this.setLnaGain();
        this.setVgaGain();
        this.setFrequencyCorrection();
        this.setBiasTee(this.cbBiasTee.isSelected());
        int sampleRate = this.device.getCurrentSampleRate();
        RTL2832TunerController.SampleRate s = RTL2832TunerController.SampleRate.getClosest(sampleRate);
        this.lblSampleRate.setText(SAMPLE_RATE + (Object)((Object)s));
    }

    private void save() {
        if (!this.loading) {
            this.saveParam(this.mComboMasterGain, "mComboMasterGain");
            this.saveParam(this.mComboMixerGain, "mComboMixerGain");
            this.saveParam(this.mComboLNAGain, "mComboLNAGain");
            this.saveParam(this.mComboVGAGain, "mComboVGAGain");
            this.saveParam(this.mFrequencyCorrection, "mFrequencyCorrection");
            this.saveParam(this.cbBiasTee.isSelected(), "cbBiasTee");
        }
    }

    @Override
    public void updateFilter() throws IOException, DeviceException {
    }

    @Override
    public void run() {
        this.done = false;
        this.running = true;
        Thread.currentThread().setName("RTLPanel");
    }

    private void setGain() {
        try {
            R820TTunerController.R820TGain gain = (R820TTunerController.R820TGain)((Object)this.mComboMasterGain.getSelectedItem());
            ((R820TTunerController)this.device).setGain((R820TTunerController.R820TGain)((Object)this.mComboMasterGain.getSelectedItem()), true);
            if (gain == R820TTunerController.R820TGain.MANUAL) {
                this.mComboMixerGain.setSelectedItem((Object)gain.getMixerGain());
                this.mComboMixerGain.setEnabled(true);
                this.mComboLNAGain.setSelectedItem((Object)gain.getLNAGain());
                this.mComboLNAGain.setEnabled(true);
                this.mComboVGAGain.setSelectedItem((Object)gain.getVGAGain());
                this.mComboVGAGain.setEnabled(true);
            } else {
                this.mComboMixerGain.setEnabled(false);
                this.mComboMixerGain.setSelectedItem((Object)gain.getMixerGain());
                this.mComboLNAGain.setEnabled(false);
                this.mComboLNAGain.setSelectedItem((Object)gain.getLNAGain());
                this.mComboVGAGain.setEnabled(false);
                this.mComboVGAGain.setSelectedItem((Object)gain.getVGAGain());
            }
            this.save();
        }
        catch (UsbException e) {
            Log.errorDialog("R820T Tuner Controller - couldn't apply the gain ", "setting - " + e.getLocalizedMessage());
            Log.println("R820T Tuner Controller - couldn't apply gain setting - " + e);
        }
    }

    private void setMixerGain() {
        try {
            R820TTunerController.R820TMixerGain mixerGain = (R820TTunerController.R820TMixerGain)((Object)this.mComboMixerGain.getSelectedItem());
            if (mixerGain == null) {
                mixerGain = DEFAULT_GAIN.getMixerGain();
            }
            if (this.mComboMixerGain.isEnabled()) {
                ((R820TTunerController)this.device).setMixerGain(mixerGain, true);
            }
            this.save();
        }
        catch (UsbException e) {
            Log.errorDialog("R820T Tuner Controller - couldn't apply the mixer ", "gain setting - " + e.getLocalizedMessage());
            Log.println("R820T Tuner Controller - couldn't apply mixer gain setting - " + e);
        }
    }

    private void setLnaGain() {
        try {
            R820TTunerController.R820TLNAGain lnaGain = (R820TTunerController.R820TLNAGain)((Object)this.mComboLNAGain.getSelectedItem());
            if (lnaGain == null) {
                lnaGain = DEFAULT_GAIN.getLNAGain();
            }
            if (this.mComboLNAGain.isEnabled()) {
                ((R820TTunerController)this.device).setLNAGain(lnaGain, true);
            }
            this.save();
        }
        catch (UsbException e) {
            Log.errorDialog("R820T Tuner Controller - couldn't apply the LNA ", "gain setting - " + e.getLocalizedMessage());
            Log.println("R820T Tuner Controller - couldn't apply LNA gain setting - " + e);
        }
    }

    private void setVgaGain() {
        try {
            R820TTunerController.R820TVGAGain vgaGain = (R820TTunerController.R820TVGAGain)((Object)this.mComboVGAGain.getSelectedItem());
            if (vgaGain == null) {
                vgaGain = DEFAULT_GAIN.getVGAGain();
            }
            if (this.mComboVGAGain.isEnabled()) {
                ((R820TTunerController)this.device).setVGAGain(vgaGain, true);
            }
            this.save();
        }
        catch (UsbException e) {
            Log.errorDialog("R820T Tuner Controller - couldn't apply the VGA ", "gain setting - " + e.getLocalizedMessage());
            Log.println("R820T Tuner Controller - couldn't apply VGA gain setting" + e);
        }
    }

    private void setBiasTee(boolean b) {
        Log.println("RTL Bias Tee: " + b);
        if (!b) {
            ((R820TTunerController)this.device).setBiasTee(false);
        } else {
            ((R820TTunerController)this.device).setBiasTee(true);
        }
        this.save();
    }

    private void setSampleRate() {
    }

    private void setFrequencyCorrection() throws UsbException {
        try {
            int rate = (Integer)this.mFrequencyCorrection.getValue();
            ((RTL2832TunerController)this.device).setSampleRateFrequencyCorrection(rate);
            this.save();
        }
        catch (DeviceException eSampleRate) {
            Log.errorDialog("R820T Tuner Controller - couldn't set the frequency correction ", "rate [" + this.mFrequencyCorrection.getValue() + "] " + eSampleRate.getLocalizedMessage());
            Log.println("R820T Tuner Controller - couldn't set the frequency correction rate setting [" + this.mFrequencyCorrection.getValue() + "] " + eSampleRate);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mComboMasterGain) {
            this.setGain();
        }
        if (e.getSource() == this.mComboMixerGain) {
            this.setMixerGain();
        }
        if (e.getSource() == this.mComboLNAGain) {
            this.setLnaGain();
        }
        if (e.getSource() == this.mComboVGAGain) {
            this.setVgaGain();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbBiasTee) {
            if (e.getStateChange() == 2) {
                this.setBiasTee(false);
            } else {
                this.setBiasTee(true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.mFrequencyCorrection) {
            Log.println("Set PPM to:" + (Integer)this.mFrequencyCorrection.getValue());
            try {
                this.setFrequencyCorrection();
            }
            catch (UsbException e1) {
                e1.printStackTrace(Log.getWriter());
            }
        }
    }

    @Override
    public int getSampleRate() {
        try {
            return this.device.getCurrentSampleRate();
        }
        catch (DeviceException e) {
            e.printStackTrace(Log.getWriter());
            return 192000;
        }
    }

    @Override
    public int getDecimationRate() {
        return 1;
    }
}

