/*
 * Decompiled with CFR 0.152.
 */
package device.airspy;

import common.Log;
import device.DeviceException;
import device.DevicePanel;
import device.TunerController;
import device.airspy.AirspyDevice;
import device.airspy.AirspySampleRate;
import device.airspy.AirspyTunerConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.usb.UsbException;
import org.usb4java.LibUsbException;

public class AirspyPanel
extends DevicePanel
implements ItemListener,
ActionListener,
Runnable,
ChangeListener {
    int NUM_OF_PARAMS = 15;
    boolean running = true;
    boolean done = false;
    AirspyDevice device;
    JCheckBox cbMixerGain;
    JCheckBox cbLnaGain;
    JTextField rfFilterValue;
    JTextField ifFilterValue;
    JSpinner ifSpinner;
    private JComboBox<AirspySampleRate> mSampleRateCombo;
    private JComboBox<Integer> cbDecimation;
    AirspyTunerConfiguration config = new AirspyTunerConfiguration();
    private JComboBox<AirspyDevice.GainMode> mGainModeCombo;
    private JSlider mMasterGain;
    private JLabel mMasterGainValueLabel;
    private JSlider mIFGain;
    private JLabel mIFGainValueLabel;
    private JSlider mLNAGain;
    private JLabel mLNAGainValueLabel;
    private JSlider mMixerGain;
    private JLabel mMixerGainValueLabel;
    private JCheckBox mLNAAGC;
    private JCheckBox mMixerAGC;

    public AirspyPanel() throws IOException, DeviceException {
        TitledBorder title = new TitledBorder(null, "Airspy", 4, 2, null, null);
        this.setBorder(title);
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.mSampleRateCombo != null) {
            this.mSampleRateCombo.setEnabled(false);
        }
        if (this.cbDecimation != null) {
            this.cbDecimation.setEnabled(b);
        }
    }

    public void initializeGui() throws IOException, DeviceException {
        this.setLayout(new BorderLayout(3, 3));
        JPanel center = new JPanel();
        JPanel top = new JPanel();
        this.add((Component)top, "North");
        top.setLayout(new BoxLayout(top, 0));
        top.add(new JLabel("Sample Rate:  "));
        List<AirspySampleRate> rates = this.device.getSampleRates();
        this.mSampleRateCombo = new JComboBox<AirspySampleRate>(new DefaultComboBoxModel<AirspySampleRate>(rates.toArray(new AirspySampleRate[rates.size()])));
        this.mSampleRateCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirspySampleRate rate = (AirspySampleRate)AirspyPanel.this.mSampleRateCombo.getSelectedItem();
                try {
                    AirspyPanel.this.device.setSampleRate(rate);
                }
                catch (DeviceException | UsbException | LibUsbException e1) {
                    Log.errorDialog("Error setting airspy sample rate", e1.getMessage());
                }
            }
        });
        top.add(this.mSampleRateCombo);
        this.mSampleRateCombo.setEnabled(false);
        top.add(new JLabel("  Decimation:  "));
        Integer[] decRates = new Integer[]{1, 2, 4, 8, 16, 32};
        this.cbDecimation = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(decRates));
        this.cbDecimation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        top.add(this.cbDecimation);
        this.cbDecimation.setEnabled(false);
        top.add(new JLabel("  Gain Mode:  "));
        this.mGainModeCombo = new JComboBox<AirspyDevice.GainMode>(AirspyDevice.GainMode.values());
        this.mGainModeCombo.setEnabled(true);
        this.mGainModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirspyDevice.GainMode mode = (AirspyDevice.GainMode)((Object)AirspyPanel.this.mGainModeCombo.getSelectedItem());
                AirspyPanel.this.updateGainComponents(mode);
            }
        });
        top.add(this.mGainModeCombo);
        JPanel centerLeft = new JPanel();
        JPanel centerRight = new JPanel();
        this.add((Component)center, "Center");
        center.setLayout(new BoxLayout(center, 0));
        center.add(centerLeft);
        centerLeft.setLayout(new BoxLayout(centerLeft, 1));
        center.add(centerRight);
        centerRight.setLayout(new BoxLayout(centerRight, 1));
        JPanel line1 = new JPanel();
        centerLeft.add(line1);
        line1.add(new JLabel("Master:"));
        this.mMasterGain = new JSlider(0, 1, 22, 1);
        this.mMasterGain.setMajorTickSpacing(1);
        this.mMasterGain.setPaintTicks(true);
        this.mMasterGain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                AirspyDevice.GainMode mode = (AirspyDevice.GainMode)((Object)AirspyPanel.this.mGainModeCombo.getSelectedItem());
                int value = AirspyPanel.this.mMasterGain.getValue();
                AirspyDevice.Gain gain = AirspyDevice.Gain.getGain(mode, value);
                try {
                    AirspyPanel.this.device.setGain(gain);
                    AirspyPanel.this.mMasterGainValueLabel.setText(String.valueOf(gain.getValue()));
                }
                catch (Exception e) {
                    Log.errorDialog("Couldn't set airspy gain to:" + gain.name(), e.getMessage());
                    JOptionPane.showMessageDialog(AirspyPanel.this.mMasterGain, "Couldn't set gain value to " + gain.getValue());
                }
                AirspyPanel.this.updateGainComponents(mode);
            }
        });
        line1.add(this.mMasterGain);
        this.mMasterGainValueLabel = new JLabel("0");
        line1.add(this.mMasterGainValueLabel);
        JPanel line2 = new JPanel();
        centerLeft.add(line2);
        line2.add(new JLabel("IF:"));
        this.mIFGain = new JSlider(0, 0, 15, 0);
        this.mIFGain.setMajorTickSpacing(1);
        this.mIFGain.setPaintTicks(true);
        this.mIFGain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int gain = AirspyPanel.this.mIFGain.getValue();
                try {
                    AirspyPanel.this.device.setIFGain(gain);
                    AirspyPanel.this.mIFGainValueLabel.setText(String.valueOf(gain));
                }
                catch (Exception e) {
                    Log.errorDialog("Couldn't set airspy IF gain to:" + gain, e.getMessage());
                    JOptionPane.showMessageDialog(AirspyPanel.this.mIFGain, "Couldn't set IF gain value to " + gain);
                }
            }
        });
        line2.add(this.mIFGain);
        this.mIFGainValueLabel = new JLabel("0");
        line2.add(this.mIFGainValueLabel);
        JPanel line3 = new JPanel();
        centerLeft.add(line3);
        line3.add(new JLabel("Mixer:"));
        this.mMixerGain = new JSlider(0, 0, 15, 0);
        this.mMixerGain.setMajorTickSpacing(1);
        this.mMixerGain.setPaintTicks(true);
        this.mMixerGain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int gain = AirspyPanel.this.mMixerGain.getValue();
                try {
                    AirspyPanel.this.device.setMixerGain(gain);
                    AirspyPanel.this.mMixerGainValueLabel.setText(String.valueOf(gain));
                }
                catch (Exception e) {
                    Log.errorDialog("Couldn't set airspy Mixer gain to:" + gain, e.getMessage());
                    JOptionPane.showMessageDialog(AirspyPanel.this.mIFGain, "Couldn't set Mixer gain value to " + gain);
                }
            }
        });
        line3.add(this.mMixerGain);
        this.mMixerGainValueLabel = new JLabel("0");
        line3.add(this.mMixerGainValueLabel);
        JPanel line4 = new JPanel();
        centerLeft.add(line4);
        line4.add(new JLabel("LNA:"));
        this.mLNAGain = new JSlider(0, 0, 14, 0);
        this.mLNAGain.setMajorTickSpacing(1);
        this.mLNAGain.setPaintTicks(true);
        this.mLNAGain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int gain = AirspyPanel.this.mLNAGain.getValue();
                try {
                    AirspyPanel.this.device.setLNAGain(gain);
                    AirspyPanel.this.mLNAGainValueLabel.setText(String.valueOf(gain));
                }
                catch (Exception e) {
                    Log.errorDialog("Couldn't set airspy LNA gain to:" + gain, e.getMessage());
                    JOptionPane.showMessageDialog(AirspyPanel.this.mIFGain, "Couldn't set LNA gain value to " + gain);
                }
            }
        });
        line4.add(this.mLNAGain);
        this.mLNAGainValueLabel = new JLabel("0");
        line4.add(this.mLNAGainValueLabel);
        this.mMixerAGC = new JCheckBox("Mixer AGC");
        this.mMixerAGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AirspyPanel.this.device.setMixerAGC(AirspyPanel.this.mMixerAGC.isSelected());
                    AirspyPanel.this.mMixerGain.setEnabled(!AirspyPanel.this.mMixerAGC.isSelected());
                }
                catch (Exception e1) {
                    Log.errorDialog("ERROR", "Error setting Mixer AGC Enabled");
                }
            }
        });
        centerRight.add(this.mMixerAGC);
        this.mLNAAGC = new JCheckBox("LNA AGC");
        this.mLNAAGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AirspyPanel.this.device.setLNAAGC(AirspyPanel.this.mLNAAGC.isSelected());
                    AirspyPanel.this.mLNAGain.setEnabled(!AirspyPanel.this.mLNAAGC.isSelected());
                }
                catch (Exception e1) {
                    Log.errorDialog("ERROR", "Error setting LNA AGC Enabled");
                }
            }
        });
        centerRight.add(this.mLNAAGC);
    }

    @Override
    public void setDevice(TunerController fcd) throws IOException, DeviceException {
        this.setAirpy((AirspyDevice)fcd);
        this.initializeGui();
        AirspyDevice.GainMode mode = (AirspyDevice.GainMode)((Object)this.mGainModeCombo.getSelectedItem());
        this.updateGainComponents(mode);
    }

    private void setAirpy(AirspyDevice f) throws IOException, DeviceException {
        this.device = f;
        this.getSettings();
    }

    @Override
    public void updateFilter() throws IOException, DeviceException {
    }

    public void getSettings() throws IOException, DeviceException {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.done = false;
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: FCD thread interrupted");
            }
            if (this.device == null) continue;
            try {
                this.getSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbLnaGain) {
            this.loadConfig();
        }
        if (e.getSource() != this.cbMixerGain || e.getStateChange() == 2) {
            // empty if block
        }
    }

    private void updateGainComponents(AirspyDevice.GainMode mode) {
        switch (mode) {
            case LINEARITY: {
                this.mMasterGain.setEnabled(true);
                this.mMasterGainValueLabel.setEnabled(true);
                this.mIFGain.setEnabled(false);
                this.mIFGainValueLabel.setEnabled(false);
                this.mLNAAGC.setEnabled(false);
                this.mLNAGainValueLabel.setEnabled(false);
                this.mLNAGain.setEnabled(false);
                this.mMixerGainValueLabel.setEnabled(false);
                this.mMixerAGC.setEnabled(false);
                this.mMixerGain.setEnabled(false);
                break;
            }
            case SENSITIVITY: {
                this.mMasterGain.setEnabled(true);
                this.mMasterGainValueLabel.setEnabled(true);
                this.mIFGain.setEnabled(false);
                this.mIFGainValueLabel.setEnabled(false);
                this.mLNAAGC.setEnabled(false);
                this.mLNAGainValueLabel.setEnabled(false);
                this.mLNAGain.setEnabled(false);
                this.mMixerGainValueLabel.setEnabled(false);
                this.mMixerAGC.setEnabled(false);
                this.mMixerGain.setEnabled(false);
                break;
            }
            case CUSTOM: {
                this.mMasterGain.setEnabled(false);
                this.mMasterGainValueLabel.setEnabled(false);
                this.mIFGain.setEnabled(true);
                this.mIFGainValueLabel.setEnabled(true);
                this.mLNAAGC.setEnabled(true);
                this.mLNAGainValueLabel.setEnabled(true);
                this.mLNAGain.setEnabled(true);
                this.mMixerGainValueLabel.setEnabled(true);
                this.mMixerAGC.setEnabled(true);
                this.mMixerGain.setEnabled(true);
            }
        }
        AirspyTunerConfiguration airspy = this.config;
        int value = this.mMasterGain.getValue();
        AirspyDevice.Gain gain = AirspyDevice.Gain.getGain(mode, value);
        if (mode == AirspyDevice.GainMode.CUSTOM) {
            this.mIFGain.setValue(airspy.getIFGain());
            this.mMixerGain.setValue(airspy.getMixerGain());
            this.mMixerAGC.setSelected(airspy.isMixerAGC());
            this.mLNAGain.setValue(airspy.getLNAGain());
            this.mLNAAGC.setSelected(airspy.isLNAAGC());
        } else {
            this.mMixerAGC.setSelected(false);
            this.mLNAAGC.setSelected(false);
            this.mMasterGain.setValue(gain.getValue());
            this.mIFGain.setValue(gain.getIF());
            this.mMixerGain.setValue(gain.getMixer());
            this.mLNAGain.setValue(gain.getLNA());
        }
    }

    private void loadConfig() {
        try {
            Log.println("Loading config");
            this.device.apply(this.config);
        }
        catch (LibUsbException e1) {
            e1.printStackTrace();
        }
        catch (DeviceException e1) {
            e1.printStackTrace();
        }
        catch (UsbException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.ifSpinner) {
            int u = Integer.parseInt((String)this.ifSpinner.getValue());
            try {
                Log.println("Setting IF Gain to: " + u);
                this.device.setIFGain(u);
            }
            catch (DeviceException e1) {
                Log.println("Error setting IF Gain on FCD");
                e1.printStackTrace(Log.getWriter());
            }
        }
    }

    @Override
    public int getSampleRate() {
        return this.device.getAirspySampleRate().getRate();
    }

    @Override
    public int getDecimationRate() {
        return (Integer)this.cbDecimation.getSelectedItem();
    }
}

