/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import common.Performance;
import common.Spacecraft;
import decoder.Code8b10b;
import decoder.Decoder;
import decoder.Fox9600bpsDecoder;
import decoder.FoxBitStream;
import decoder.LookupException;
import decoder.SourceAudio;
import filter.Filter;
import filter.RaisedCosineFilter;
import gui.MainWindow;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import telemetry.Format.FormatFrame;
import telemetry.Format.FormatHeader;
import telemetry.Format.TelemFormat;
import telemetry.FramePart;
import telemetry.frames.Frame;
import telemetry.frames.Header;
import telemetry.frames.HighSpeedFrame;
import telemetry.frames.HighSpeedHeader;
import telemetry.frames.SlowSpeedFrame;
import telemetry.frames.SlowSpeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.PayloadCameraData;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;

public abstract class FoxDecoder
extends Decoder {
    public static final int BIT_DISTANCE_THRESHOLD_PERCENT = 15;
    protected int currentFilterLength = 0;
    protected double currentFilterFreq = 0.0;
    private int lastBitValue = 0;
    private boolean lastBit = false;
    public Filter monitorFilter = null;
    int rd = 0;
    int nextRd = 0;

    public FoxDecoder(String n, SourceAudio as, int chan, TelemFormat telemFormat) {
        super(n, as, chan, telemFormat);
    }

    @Override
    public void init() {
        Performance.setEnabled(Config.debugPerformance);
        this.BUFFER_SIZE = this.SAMPLE_WINDOW_LENGTH * this.bucketSize;
        this.initWindowData();
        this.monitorFilter = new RaisedCosineFilter(this.audioSource.audioFormat, this.BUFFER_SIZE);
        this.monitorFilter.init(this.currentSampleRate, 3000.0, 256);
    }

    protected void processPossibleFrame(ArrayList<Frame> frames) {
        for (Frame decodedFrame : frames) {
            if (decodedFrame != null && !decodedFrame.corrupt) {
                Performance.startTimer("Store");
                this.eyeData.lastErasureCount = decodedFrame.rsErasures;
                this.eyeData.lastErrorsCount = decodedFrame.rsErrors;
                if (Config.storePayloads) {
                    Header header;
                    if (decodedFrame instanceof SlowSpeedFrame) {
                        SlowSpeedFrame ssf = (SlowSpeedFrame)decodedFrame;
                        FramePart payload = ssf.getPayload();
                        header = ssf.getHeader();
                        if (Config.storePayloads) {
                            Config.payloadStore.add(header.getFoxId(), header.getUptime(), header.getResets(), payload);
                        }
                        this.addMeasurements(((SlowSpeedHeader)header).id, ((SlowSpeedHeader)header).resets, ((SlowSpeedHeader)header).uptime, decodedFrame, decodedFrame.rsErrors, decodedFrame.rsErasures);
                    } else if (decodedFrame instanceof FormatFrame) {
                        Spacecraft sat = null;
                        FormatFrame hsf = (FormatFrame)decodedFrame;
                        header = hsf.getHeader();
                        sat = Config.satManager.getSpacecraft(((FormatHeader)header).id);
                        int newReset = sat.getCurrentReset(((FormatHeader)header).resets, ((FormatHeader)header).uptime);
                        hsf.savePayloads(Config.payloadStore, sat.hasModeInHeader, newReset);
                        this.addMeasurements(((FormatHeader)header).id, newReset, ((FormatHeader)header).uptime, decodedFrame, decodedFrame.rsErrors, decodedFrame.rsErasures);
                    } else {
                        PayloadHERCIhighSpeed[] herciDataSet;
                        PayloadCameraData cameraData;
                        HighSpeedFrame hsf = (HighSpeedFrame)decodedFrame;
                        HighSpeedHeader header2 = hsf.getHeader();
                        PayloadRtValues payload = hsf.getRtPayload();
                        Config.payloadStore.add(header2.getFoxId(), header2.getUptime(), header2.getResets(), payload);
                        PayloadMaxValues maxPayload = hsf.getMaxPayload();
                        Config.payloadStore.add(header2.getFoxId(), header2.getUptime(), header2.getResets(), maxPayload);
                        PayloadMinValues minPayload = hsf.getMinPayload();
                        Config.payloadStore.add(header2.getFoxId(), header2.getUptime(), header2.getResets(), minPayload);
                        PayloadRadExpData[] radPayloads = hsf.getRadPayloads();
                        Config.payloadStore.add(header2.getFoxId(), header2.getUptime(), header2.getResets(), radPayloads);
                        if (Config.satManager.hasCamera(header2.getFoxId()) && (cameraData = hsf.getCameraPayload()) != null) {
                            Config.payloadStore.add(header2.getFoxId(), header2.getUptime(), header2.getResets(), cameraData);
                        }
                        if (Config.satManager.hasHerci(header2.getFoxId()) && (herciDataSet = hsf.getHerciPayloads()) != null) {
                            Config.payloadStore.add(header2.getFoxId(), header2.getUptime(), header2.getResets(), herciDataSet);
                        }
                        this.addMeasurements(header2.id, header2.resets, header2.uptime, decodedFrame, decodedFrame.rsErrors, decodedFrame.rsErasures);
                    }
                }
                ++Config.totalFrames;
                if (Config.storeRawByteFrames) {
                    try {
                        decodedFrame.saveBytes();
                    }
                    catch (IOException e) {
                        e.printStackTrace(Log.getWriter());
                    }
                }
                if (Config.uploadToServer) {
                    try {
                        Config.rawFrameQueue.add(decodedFrame);
                    }
                    catch (IOException e) {
                        e.printStackTrace(Log.getWriter());
                    }
                }
                ++this.framesDecoded;
                if (MainWindow.frame != null) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                MainWindow.setTotalDecodes();
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                Performance.endTimer("Store");
                continue;
            }
            if (!Config.debugBits) continue;
            Log.println("SYNC marker found but frame not decoded\n");
        }
    }

    @Override
    protected void sampleBuckets() {
        if (this instanceof Fox9600bpsDecoder) {
            this.sampleBucketsAgainstZeroCrossover();
        } else {
            this.sampleBucketsVsDistanceToLastBit();
        }
    }

    protected void sampleBucketsVsDistanceToLastBit() {
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            ++this.sampleNumber;
            int sampleSum = 0;
            int samples = 0;
            int s = this.bucketSize / 2 - this.SAMPLE_WIDTH;
            while (s <= this.bucketSize / 2 + this.SAMPLE_WIDTH) {
                sampleSum += this.dataValues[i][s];
                ++samples;
                ++s;
            }
            int bitDistance = Math.abs(this.lastBitValue - (sampleSum /= samples));
            int bitHeight = this.averageMax - this.averageMin;
            if (bitHeight == 0) {
                bitHeight = 1;
            }
            int movePercent = bitDistance * 100 / bitHeight;
            if (sampleSum >= this.zeroValue) {
                if (!this.lastBit) {
                    if (movePercent < 15) {
                        this.middleSample[i] = false;
                        this.eyeData.setLow(sampleSum);
                    } else {
                        this.middleSample[i] = true;
                        this.eyeData.setHigh(sampleSum);
                    }
                } else {
                    this.middleSample[i] = true;
                    this.eyeData.setHigh(sampleSum);
                }
            } else if (this.lastBit) {
                if (movePercent < 15) {
                    this.middleSample[i] = true;
                    this.eyeData.setHigh(sampleSum);
                } else {
                    this.middleSample[i] = false;
                    this.eyeData.setLow(sampleSum);
                }
            } else {
                this.middleSample[i] = false;
                this.eyeData.setLow(sampleSum);
            }
            this.lastBitValue = sampleSum;
            this.lastBit = this.middleSample[i];
            ++i;
        }
    }

    protected void sampleBucketsAgainstZeroCrossover() {
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            ++this.sampleNumber;
            int sampleSum = 0;
            int samples = 0;
            int s = this.bucketSize / 2 - this.SAMPLE_WIDTH;
            while (s <= this.bucketSize / 2 + this.SAMPLE_WIDTH) {
                sampleSum += this.dataValues[i][s];
                ++samples;
                ++s;
            }
            if ((sampleSum /= samples) >= this.zeroValue) {
                this.middleSample[i] = true;
                this.eyeData.setHigh(sampleSum);
            } else {
                this.middleSample[i] = false;
                this.eyeData.setLow(sampleSum);
            }
            ++i;
        }
    }

    @Override
    protected void processBitsWindow() {
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            this.bitStream.addBit(this.middleSample[i]);
            ++i;
        }
        ArrayList<Frame> frames = this.bitStream.findFrames(this.SAMPLE_WINDOW_LENGTH);
        if (frames != null) {
            this.processPossibleFrame(frames);
        }
    }

    protected void debugBitsWindow() {
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            boolean[] b = new boolean[10];
            boolean[] b8 = new boolean[8];
            int k = 0;
            while (k < 10) {
                b[k] = this.middleSample[i + k];
                ++k;
            }
            int word = FoxBitStream.binToInt(b);
            this.rd = Code8b10b.getRdSense10b(word, Config.flipReceivedBits);
            FoxBitStream.printBitArray(b);
            System.out.println("Expected: " + this.nextRd + " rd: " + this.rd);
            this.nextRd = Code8b10b.getNextRd(word, Config.flipReceivedBits);
            try {
                byte word8b = Code8b10b.decode(word, Config.flipReceivedBits);
                Log.print(String.valueOf(i) + ": 10b:" + FoxDecoder.hex(word));
                Log.print(" 8b:" + FoxDecoder.hex(word8b));
                Log.println("");
                b8 = FoxBitStream.intToBin8(word8b);
                FoxBitStream.printBitArray(b8);
            }
            catch (LookupException e) {
                Log.print(String.valueOf(i) + ": 10b:" + FoxDecoder.hex(word));
                Log.print(" 8b: -1");
                Log.println("");
            }
            i += 10;
        }
    }

    @Override
    public int recoverClockOffset() {
        int[] transitionPoint = new int[this.SAMPLE_WINDOW_LENGTH];
        int averageTransition = 0;
        int numberOfTransitions = 0;
        boolean foundTransition = false;
        int threshold = (this.averageMax - this.averageMin) / this.CLOCK_REOVERY_ZERO_THRESHOLD;
        boolean initialValue = false;
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            if (i > 0) {
                initialValue = this.dataValues[i - 1][this.bucketSize - 1] >= this.zeroValue + threshold;
            }
            foundTransition = false;
            int j = 0;
            while (j < this.bucketSize) {
                if (this.dataValues[i][j] > this.zeroValue + threshold && !initialValue && !foundTransition) {
                    transitionPoint[i] = j;
                    initialValue = true;
                    foundTransition = true;
                    ++numberOfTransitions;
                }
                if (this.dataValues[i][j] < this.zeroValue - threshold && initialValue && !foundTransition) {
                    transitionPoint[i] = j;
                    initialValue = false;
                    foundTransition = true;
                    ++numberOfTransitions;
                }
                ++j;
            }
            averageTransition += transitionPoint[i];
            ++i;
        }
        if (numberOfTransitions > 0) {
            averageTransition /= numberOfTransitions;
        }
        if (Config.debugClock) {
            Log.println("CLOCK: Average First Transition at: " + averageTransition);
        }
        return averageTransition;
    }
}

