/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import decoder.BitStream;
import decoder.Code8b10b;
import decoder.CodePRN;
import decoder.Decoder;
import decoder.FoxDecoder;
import decoder.LookupException;
import gui.MainWindow;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import telemetry.FramePart;
import telemetry.frames.Frame;
import telemetry.frames.SlowSpeedHeader;

public abstract class FoxBitStream
extends BitStream {
    protected int SYNC_WORD_LENGTH = 10;
    protected int DATA_WORD_LENGTH = 10;
    protected static final int MAX_ERASURES = 15;
    protected static final int FRAME_PROCESSED = -999;
    protected static int SYNC_WORD_BIT_TOLERANCE = 0;
    protected int syncWordbitPosition = 0;
    protected boolean[] syncWord = new boolean[this.SYNC_WORD_LENGTH];
    protected boolean alreadyTriedToFlipBits = false;
    private long millisecondsBetweenSyncWords;
    private double millisecondsPerBit;
    protected boolean findFramesWithPRN = false;

    public FoxBitStream(int size, Decoder dec, int syncWordDistance, int wordLength, int syncWordLength, double millisecondsPerBit) {
        super(size, dec, syncWordDistance);
        this.SYNC_WORD_LENGTH = syncWordLength;
        this.DATA_WORD_LENGTH = wordLength;
        this.syncWord = new boolean[syncWordLength];
        this.millisecondsPerBit = millisecondsPerBit;
        this.millisecondsBetweenSyncWords = (long)(millisecondsPerBit * (double)this.SYNC_WORD_DISTANCE);
    }

    public ArrayList<Frame> findFrames(int windowLength) {
        if (this.size() < this.SYNC_WORD_LENGTH) {
            return null;
        }
        ArrayList<Frame> frames = null;
        this.syncWordbitPosition = 0;
        this.syncWord = new boolean[this.SYNC_WORD_LENGTH];
        int i = this.size() - windowLength - this.SYNC_WORD_LENGTH;
        while (i < this.size()) {
            if (i < 0) {
                return null;
            }
            this.syncWord[this.syncWordbitPosition++] = this.get(i);
            if (this.syncWordbitPosition > this.SYNC_WORD_LENGTH - 1) {
                this.syncWordbitPosition = this.SYNC_WORD_LENGTH - 1;
                int word = FoxBitStream.binToInt(this.syncWord);
                if (this.findFramesWithPRN && CodePRN.probabllyFrameMarker(this.syncWord) || !this.findFramesWithPRN && (word == 773 || word == 250)) {
                    Date timeOfSync = Calendar.getInstance().getTime();
                    if (Config.debugFrames) {
                        Log.println("SYNC WORD " + this.syncWords.size() + " FROM " + (i - this.SYNC_WORD_LENGTH) + " total:" + (this.totalBits + (long)i - (long)this.SYNC_WORD_LENGTH) + " DATA STARTS: " + i + " total:" + (this.totalBits + (long)i) + " at: " + timeOfSync);
                        int last = 0;
                        Iterator iterator = this.syncWords.iterator();
                        while (iterator.hasNext()) {
                            int s = (Integer)iterator.next();
                            Log.print(String.valueOf(s) + "-" + (s - last) + ", ");
                            last = s;
                        }
                        Log.println("");
                        FoxBitStream.printBitArray(this.syncWord);
                    }
                    this.alreadyTriedToFlipBits = false;
                    frames = this.tryToProcessFrames(timeOfSync, i + 1);
                    if (!(MainWindow.inputTab.getSelectedFormat().isBPSK() || frames != null && !frames.isEmpty() || this.alreadyTriedToFlipBits)) {
                        this.alreadyTriedToFlipBits = true;
                        this.decoder.flipReceivedBits = !this.decoder.flipReceivedBits;
                        frames = this.tryToProcessFrames(timeOfSync, i + 1);
                        if (frames != null && !frames.isEmpty()) {
                            Log.println("DECODER: Flipped bits");
                            this.flipBitStream();
                        } else {
                            this.decoder.flipReceivedBits = !this.decoder.flipReceivedBits;
                        }
                    }
                }
                int k = 1;
                while (k < this.SYNC_WORD_LENGTH) {
                    this.syncWord[k - 1] = this.syncWord[k];
                    ++k;
                }
            }
            ++i;
        }
        return frames;
    }

    private ArrayList<Frame> tryToProcessFrames(Date timeOfFinalSync, int end) {
        Date timeOfStartSync = new Date(timeOfFinalSync.getTime() - this.millisecondsBetweenSyncWords - (long)((double)this.SYNC_WORD_LENGTH * this.millisecondsPerBit));
        int END = end;
        ArrayList<Frame> frames = new ArrayList<Frame>();
        int start = end - this.SYNC_WORD_DISTANCE;
        int missedBits = 0;
        int repairPosition = 0;
        while (start > 0) {
            Frame frame = this.decodeFrame(start, end, missedBits, repairPosition, timeOfFinalSync);
            if (frame != null) {
                frames.add(frame);
                end -= this.SYNC_WORD_DISTANCE;
                start -= this.SYNC_WORD_DISTANCE;
                timeOfStartSync = new Date(timeOfStartSync.getTime() - this.millisecondsBetweenSyncWords);
                continue;
            }
            start = -1;
        }
        if (frames.isEmpty()) {
            return null;
        }
        this.removeBits(0, END - this.SYNC_WORD_LENGTH);
        return frames;
    }

    public abstract Frame decodeFrame(int var1, int var2, int var3, int var4, Date var5);

    protected int checkShortFrame(int start, int end) {
        int SYNC_WORD_BIT_TOLERANCE = 6;
        int firstMinErasures = 0;
        int shortBits = 0;
        shortBits = this.SYNC_WORD_DISTANCE - (end - start);
        int minErasures = 999;
        if (Config.debugFrames) {
            Log.println("**** SHORT FRAME from bits " + start + " to " + end + " length " + (end - start) + " bits, " + shortBits + " short");
        }
        int totalBytes = this.SYNC_WORD_DISTANCE / 10;
        int[] erasureCount = new int[totalBytes];
        int a = 0;
        while (a < totalBytes) {
            int currentErasureCount = 0;
            int currentWord = 0;
            int j = start;
            while (j < end - this.SYNC_WORD_LENGTH) {
                if (a == currentWord++) {
                    j -= shortBits;
                }
                int b8 = -1;
                try {
                    b8 = this.processWord(j);
                }
                catch (LookupException er) {
                    ++currentErasureCount;
                }
                j += 10;
            }
            erasureCount[a] = currentErasureCount;
            if (currentErasureCount < minErasures) {
                minErasures = currentErasureCount;
                firstMinErasures = a;
            }
            ++a;
        }
        if (shortBits > 0) {
            int position = start + firstMinErasures * 10;
            return position;
        }
        return 0;
    }

    @Deprecated
    protected void checkMissingStartSYNC(int n, FramePart header) {
        int start = (Integer)this.syncWords.get(n);
        if (start > this.SYNC_WORD_DISTANCE) {
            int loopUpError = 0;
            int j = start - this.SYNC_WORD_DISTANCE;
            while (j < start - this.SYNC_WORD_DISTANCE + header.getMaxBytes() * 10) {
                byte b8;
                try {
                    b8 = this.processWord(j);
                }
                catch (LookupException e) {
                    b8 = -1;
                    ++loopUpError;
                }
                header.addNext8Bits(b8);
                j += 10;
            }
            if (loopUpError < header.getMaxBytes()) {
                this.syncWords.add(n, start - this.SYNC_WORD_DISTANCE);
                if (Config.debugFrames) {
                    Log.println("SYNC WORD MISSING, but found Header");
                }
            } else if (Config.debugFrames) {
                Log.println("Looked for Missing START sync but did not find it");
            }
        }
    }

    @Deprecated
    private void checkLongFramesForMissingStartSYNC() {
        int start = 0;
        int end = 0;
        int syncs = this.syncWords.size();
        int i = 0;
        while (i < syncs - 1) {
            start = (Integer)this.syncWords.get(i);
            int e = i + 1;
            while (e < syncs) {
                end = (Integer)this.syncWords.get(e);
                if (start != -999 && end - start > this.SYNC_WORD_DISTANCE) {
                    if (Config.debugFrames) {
                        Log.println("CHECKING LONG FRAME from bits " + start + " to " + end);
                    }
                    this.checkMissingStartSYNC(e, new SlowSpeedHeader());
                }
                ++e;
            }
            ++i;
        }
    }

    @Deprecated
    protected void checkMissingMiddleSYNC() {
        int start = 0;
        int end = 0;
        int syncs = this.syncWords.size();
        int i = 0;
        while (i < syncs - 1) {
            start = (Integer)this.syncWords.get(i);
            int e = i + 1;
            while (e < syncs) {
                end = (Integer)this.syncWords.get(e);
                if (start != -999 && end - start == this.SYNC_WORD_DISTANCE * 2 && !this.haveSyncWordAtBit(end - this.SYNC_WORD_DISTANCE)) {
                    if (Config.debugFrames) {
                        Log.println("DOUBLE LENGTH FRAME from bits " + start + " to " + end);
                    }
                    this.syncWords.add(e, end - this.SYNC_WORD_DISTANCE);
                }
                ++e;
            }
            ++i;
        }
    }

    protected byte processWord(int j) throws LookupException {
        if (Config.debugBits) {
            FoxBitStream.printBitArray(this.get10Bits(j));
        }
        int word = FoxBitStream.binToInt(this.get10Bits(j));
        try {
            byte word8b = Code8b10b.decode(word, this.decoder.flipReceivedBits);
            if (Config.debugBits) {
                Log.print(String.valueOf(this.totalBits + (long)j - 1L) + ": " + j + ": 10b:" + FoxDecoder.hex(word));
            }
            if (Config.debugBits) {
                Log.print(" 8b:" + FoxDecoder.hex(word8b) + "\n");
            }
            if (Config.debugBits) {
                FoxBitStream.printBitArray(FoxBitStream.intToBin8(word8b));
            }
            return word8b;
        }
        catch (LookupException e) {
            if (Config.debugBits) {
                Log.print(String.valueOf(this.totalBits + (long)j - 1L) + ": " + j + ": 10b:" + FoxDecoder.hex(word));
            }
            if (Config.debugBits) {
                Log.print(" 8b: -1\n\n");
            }
            throw e;
        }
    }

    public boolean haveSyncWordAtBit(int b) {
        int i = 0;
        while (i < this.syncWords.size()) {
            if ((Integer)this.syncWords.get(i) == b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean has10() {
        return this.size() > 9;
    }

    public boolean[] get10Bits(int n) {
        if (this.size() > n + 9) {
            boolean[] b = new boolean[10];
            int j = 0;
            while (j < 10) {
                b[j] = this.get(n + j);
                ++j;
            }
            return b;
        }
        return null;
    }

    public boolean[] last10() {
        if (!this.has10()) {
            return null;
        }
        boolean[] b = new boolean[10];
        int j = 0;
        while (j < 10) {
            b[j] = this.get(this.size() - 10 + j);
            ++j;
        }
        return b;
    }

    public static int binToInt(boolean[] word10) {
        int d = 0;
        int i = 0;
        while (i < word10.length) {
            int value = 0;
            if (word10[word10.length - 1 - i]) {
                value = 1;
            }
            d += value << i;
            ++i;
        }
        return d;
    }

    public static boolean[] intToBin8(int word) {
        boolean[] b = new boolean[8];
        int i = 0;
        while (i < 8) {
            b[7 - i] = (word >> i & 1) == 1;
            ++i;
        }
        return b;
    }

    public static boolean[] intToBin9(int word) {
        boolean[] b = new boolean[9];
        int i = 0;
        while (i < 9) {
            b[8 - i] = (word >> i & 1) == 1;
            ++i;
        }
        return b;
    }

    public static boolean[] intToBin10(int word) {
        boolean[] b = new boolean[10];
        int i = 0;
        while (i < 10) {
            b[9 - i] = (word >> i & 1) == 1;
            ++i;
        }
        return b;
    }

    public void printSyncWordPositions() {
        int i = 0;
        while (i < this.syncWords.size()) {
            Log.println("SYNC WORD AT: " + this.syncWords.get(i));
            ++i;
        }
    }

    public static void printBitArray(boolean[] bs) {
        int j = 0;
        while (j < bs.length) {
            if (bs[j]) {
                Log.print("1 ");
            } else {
                Log.print("0 ");
            }
            ++j;
        }
        Log.print("\n");
    }

    public static String stringBitArray(boolean[] bs) {
        String s = new String();
        int j = 0;
        while (j < bs.length) {
            s = bs[j] ? String.valueOf(s) + "1" : String.valueOf(s) + "0";
            ++j;
        }
        return s;
    }

    @Override
    public String toString() {
        if (!this.has10()) {
            return "";
        }
        String s = new String();
        int i = this.size() - 10;
        while (i < this.size()) {
            s = String.valueOf(s) + this.get(i) + " ";
            ++i;
        }
        return s;
    }

    protected void flipBitStream() {
        int c = 0;
        while (c < this.size()) {
            this.set(c, this.get(c) == false);
            ++c;
        }
    }
}

