/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Log;

public class CircularDoubleBuffer {
    double[] doubles;
    int bufferSize = 0;
    int startPointer = 0;
    int endPointer = 0;
    public static final int DEFAULT_SIZE = 96000;
    int statusCount = 0;

    public CircularDoubleBuffer(int size) {
        this.doubles = new double[size];
        this.bufferSize = size;
        Log.println("Created circular Double buffer with " + this.bufferSize + " bytes");
    }

    public int getStartPointer() {
        return this.startPointer;
    }

    public int getEndPointer() {
        return this.endPointer;
    }

    public int getCapacity() {
        if (this.startPointer == 0 && this.endPointer == 0) {
            return this.bufferSize;
        }
        int size = 0;
        size = this.endPointer > this.startPointer ? this.bufferSize - this.endPointer + this.startPointer : this.startPointer - this.endPointer;
        return size;
    }

    public boolean add(double one, double two) {
        if (this.endPointer + 1 == this.startPointer) {
            throw new IndexOutOfBoundsException("End pointer has reached start pointer");
        }
        if (this.endPointer + 2 == this.startPointer) {
            throw new IndexOutOfBoundsException("End pointer one byte from start pointer");
        }
        this.add(one);
        this.add(two);
        return true;
    }

    public boolean add(double o) {
        this.doubles[this.endPointer] = o;
        ++this.endPointer;
        ++this.statusCount;
        if (this.endPointer == this.bufferSize) {
            this.endPointer = 0;
        }
        if (this.endPointer == this.startPointer) {
            --this.endPointer;
            if (this.endPointer == -1) {
                this.endPointer = this.bufferSize - 1;
            }
            throw new IndexOutOfBoundsException("End pointer has reached start pointer");
        }
        return true;
    }

    private int incPointer(int pointer, int amount) {
        int p = pointer + amount;
        if (p >= this.bufferSize) {
            p %= this.bufferSize;
        }
        return p;
    }

    private int decPointer(int pointer, int amount) {
        int p = pointer - amount;
        if (p < 0) {
            p += this.bufferSize;
        }
        return p;
    }

    public double get(int i) {
        if (i > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to read past end pointer");
        }
        int p = this.incPointer(this.startPointer, i);
        return this.doubles[p];
    }

    public void incStartPointer(int amount) {
        int testPointer;
        int e = this.endPointer;
        if (e > this.startPointer) {
            if (this.startPointer + amount >= e) {
                throw new IndexOutOfBoundsException("Attempt to move start pointer " + this.startPointer + " past end pointer " + e);
            }
        } else if (this.startPointer + amount >= this.bufferSize && (testPointer = this.incPointer(this.startPointer, amount)) >= this.endPointer) {
            throw new IndexOutOfBoundsException("Attempt to wrap start pointer " + this.startPointer + " past end pointer " + e);
        }
        this.startPointer = this.incPointer(this.startPointer, amount);
    }

    public void decStartPointer(int amount) {
        int testPointer;
        int e = this.endPointer;
        if (e < this.startPointer) {
            if (this.startPointer - amount <= e) {
                throw new IndexOutOfBoundsException("Attempt to decrement start pointer " + this.startPointer + " by " + amount + " past end pointer " + e);
            }
        } else if (this.startPointer - amount < 0 && (testPointer = this.decPointer(this.startPointer, amount)) <= this.endPointer) {
            throw new IndexOutOfBoundsException("Attempt to decrement start pointer past end pointer (wraps)" + this.startPointer + " past end pointer " + e);
        }
        this.startPointer = this.decPointer(this.startPointer, amount);
    }

    public int size() {
        int size = 0;
        int e = this.endPointer;
        if (e >= this.startPointer) {
            size = e - this.startPointer;
        } else {
            size = this.bufferSize - this.startPointer;
            size += e;
        }
        return size;
    }
}

