/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;

public class TlmServer {
    public static final int TCP = 0;
    public static final int UDP = 1;
    public static final int FTP_PORT = 22;
    public static final boolean KEEP_OPEN = false;
    public static final boolean AUTO_CLOSE = true;
    public static final boolean WAIT_FOR_ACK = true;
    public static final boolean NO_ACK = false;
    public static final int TIMEOUT_CONNECT = 5000;
    public static final int TIMEOUT_CONNECTION = 2000;
    String hostName;
    int portNumber;
    boolean autoClose = true;
    boolean waitForAck = true;
    Socket socket = null;
    OutputStream out = null;
    InputStream in = null;
    public static final int[] OK = new int[]{79, 77, 13, 10};
    public static final int[] FAIL = new int[]{70, 65, 13, 10};

    public TlmServer(String hostName, int portNumber, boolean autoClose, boolean waitForAck) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.autoClose = autoClose;
        this.waitForAck = waitForAck;
    }

    public void setHostName(String hostName) {
        if (this.hostName != hostName) {
            this.close();
        }
        this.hostName = hostName;
    }

    public void setPort(int port) {
        if (this.portNumber != port) {
            this.close();
        }
        this.portNumber = port;
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.out = null;
        this.in = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    public boolean sendToServer(byte[] buffer, int protocol) throws UnknownHostException, IOException {
        boolean success = false;
        if (protocol == 0) {
            if (this.autoClose || this.socket == null) {
                this.socket = new Socket();
                this.socket.connect(new InetSocketAddress(this.hostName, this.portNumber), 5000);
                if (this.waitForAck) {
                    this.socket.setSoTimeout(2000);
                }
                this.out = this.socket.getOutputStream();
                this.in = this.socket.getInputStream();
            }
            this.out.write(buffer);
            success = this.waitForAck ? this.waitForAck() : true;
            if (this.autoClose) {
                this.close();
            }
            return success;
        }
        DatagramSocket socket = new DatagramSocket();
        InetAddress address = InetAddress.getByName(this.hostName);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, this.portNumber);
        socket.send(packet);
        socket.close();
        return success;
    }

    private boolean waitForAck() throws IOException {
        int c;
        boolean success = false;
        int i = 0;
        int LEN = 4;
        int[] buffer = new int[4];
        boolean done = false;
        while (!done && (c = this.in.read()) != -1) {
            buffer[i++] = c;
            if (i == 4) {
                done = true;
            }
            if (c != 13 && c != 10) continue;
            c = this.in.read();
            buffer[i++] = c;
            if (Arrays.equals(OK, buffer)) {
                Log.println("SERVER ACK: OK");
                return true;
            }
            Log.println("SERVER ACK: FAIL");
            return false;
        }
        return success;
    }
}

