/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Config;
import common.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class Sequence {
    public static final long ERROR_NUMBER = -1L;
    private static long number = -1L;
    private static final String SEQ_FILE_NAME = "seq.dat";

    public Sequence() throws IOException {
        this.load();
    }

    private void load() throws IOException {
        File aFile;
        String log = SEQ_FILE_NAME;
        if (!Config.homeDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.homeDirectory) + File.separator + log;
            Log.println("Loading Sequence from: " + log);
        }
        if (!(aFile = new File(log)).exists()) {
            aFile.createNewFile();
            number = 0L;
            this.save();
        } else {
            FileInputStream dis = new FileInputStream(log);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(dis));){
                String line = reader.readLine();
                try {
                    number = Long.parseLong(line);
                }
                catch (NumberFormatException e) {
                    number = 0L;
                    this.save();
                }
            }
        }
    }

    public long getNextSequence() throws IOException {
        if (number == -1L) {
            this.load();
        }
        this.save();
        return ++number;
    }

    private void save() throws IOException {
        String log = SEQ_FILE_NAME;
        if (!Config.homeDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.homeDirectory) + File.separator + log;
        }
        FileOutputStream dis = new FileOutputStream(log);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dis));
        try {
            writer.write(Long.toString(number));
        }
        finally {
            writer.flush();
            writer.close();
        }
    }
}

