/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Log;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;

public class DesktopApi {
    public static boolean browse(URI uri) {
        if (DesktopApi.browseDESKTOP(uri)) {
            return true;
        }
        return DesktopApi.openSystemSpecific(uri.toString());
    }

    public static boolean open(File file) {
        if (DesktopApi.openSystemSpecific(file.getPath())) {
            return true;
        }
        return DesktopApi.openDESKTOP(file);
    }

    public static boolean edit(File file) {
        if (DesktopApi.openSystemSpecific(file.getPath())) {
            return true;
        }
        return DesktopApi.editDESKTOP(file);
    }

    private static boolean openSystemSpecific(String what) {
        EnumOS os = DesktopApi.getOs();
        if (os.isLinux()) {
            if (DesktopApi.runCommand("kde-open", "%s", what)) {
                return true;
            }
            if (DesktopApi.runCommand("gnome-open", "%s", what)) {
                return true;
            }
            if (DesktopApi.runCommand("xdg-open", "%s", what)) {
                return true;
            }
        }
        if (os.isMac() && DesktopApi.runCommand("open", "%s", what)) {
            return true;
        }
        return os.isWindows() && DesktopApi.runCommand("explorer", "%s", what);
    }

    private static boolean browseDESKTOP(URI uri) {
        block6: {
            block5: {
                DesktopApi.logOut("Trying to use Desktop.getDesktop().browse() with " + uri.toString());
                if (Desktop.isDesktopSupported()) break block5;
                DesktopApi.logErr("Platform is not supported.");
                return false;
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) break block6;
            DesktopApi.logErr("BROWSE is not supported.");
            return false;
        }
        try {
            Desktop.getDesktop().browse(uri);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (Throwable t) {
            Log.errorDialog("Error using desktop browse.", String.valueOf(t.getMessage()) + "\nTrying: " + uri.toString());
            return false;
        }
    }

    private static boolean openDESKTOP(File file) {
        block5: {
            block4: {
                DesktopApi.logOut("Trying to use Desktop.getDesktop().open() with " + file.toString());
                try {
                    if (Desktop.isDesktopSupported()) break block4;
                    DesktopApi.logErr("Platform is not supported.");
                    return false;
                }
                catch (Throwable t) {
                    DesktopApi.logErr("Error using desktop open.", t);
                    return false;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) break block5;
            DesktopApi.logErr("OPEN is not supported.");
            return false;
        }
        Desktop.getDesktop().open(file);
        return true;
    }

    private static boolean editDESKTOP(File file) {
        block5: {
            block4: {
                DesktopApi.logOut("Trying to use Desktop.getDesktop().edit() with " + file);
                try {
                    if (Desktop.isDesktopSupported()) break block4;
                    DesktopApi.logErr("Platform is not supported.");
                    return false;
                }
                catch (Throwable t) {
                    DesktopApi.logErr("Error using desktop edit.", t);
                    return false;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) break block5;
            DesktopApi.logErr("EDIT is not supported.");
            return false;
        }
        Desktop.getDesktop().edit(file);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean runCommand(String command, String args, String file) {
        DesktopApi.logOut("Trying to exec:\n   cmd = " + command + "\n   args = " + args + "\n   %s = " + file);
        String[] parts = DesktopApi.prepareCommand(command, args, file);
        try {
            Process p = Runtime.getRuntime().exec(parts);
            if (p == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    DesktopApi.logErr("Process ended immediately.");
                    return false;
                }
                DesktopApi.logErr("Process crashed.");
                return false;
            }
            catch (IllegalThreadStateException itse) {
                Log.println("Process is running.");
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args != null) {
            String[] stringArray = args.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                s = String.format(s, file);
                parts.add(s.trim());
                ++n2;
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static void logErr(String msg, Throwable t) {
        System.err.println(msg);
        t.printStackTrace();
    }

    private static void logErr(String msg) {
        Log.errorDialog("ERROR", msg);
    }

    private static void logOut(String msg) {
        Log.println(msg);
    }

    public static EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS.linux;
        }
        if (s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public static enum EnumOS {
        linux,
        macos,
        solaris,
        unknown,
        windows;


        public boolean isLinux() {
            return this == linux || this == solaris;
        }

        public boolean isMac() {
            return this == macos;
        }

        public boolean isWindows() {
            return this == windows;
        }
    }
}

