/*
 * Decompiled with CFR 0.152.
 */
package FuncubeDecoder;

import FuncubeDecoder.FUNcubeHeader;
import FuncubeDecoder.FUNcubeSpacecraft;
import FuncubeDecoder.PayloadRealTime;
import common.Config;
import common.Log;
import telemetry.FramePart;

public class FUNcubeFrame {
    public static final int MAX_HEADER_SIZE = 1;
    public static final int MAX_FRAME_SIZE = 256;
    public static final int MAX_RT_TELEMETRY_SIZE = 55;
    public static final int MAX_WHOLE_ORBIT_DATA_SIZE = 23;
    public static final int MAX_HIGH_RES_TELEMETRY_SIZE = 10;
    public static final int MAX_FITTER_MESSAGE_SIZE = 200;
    FUNcubeHeader header = new FUNcubeHeader();
    PayloadRealTime rtPayload = null;
    FramePart payload = null;
    FUNcubeSpacecraft funCube;
    byte[] bytes = new byte[256];
    int numberBytesAdded = 0;
    boolean corrupt;

    public void addRawFrame(byte[] b) {
        int byteLen = b.length;
        int i = 0;
        while (i < byteLen) {
            this.addNext8Bits(b[i]);
            ++i;
        }
    }

    public void addNext8Bits(byte b) {
        if (this.corrupt) {
            return;
        }
        if (this.numberBytesAdded < 1) {
            this.header.addNext8Bits(b);
        } else if (this.numberBytesAdded < 56) {
            this.rtPayload.addNext8Bits(b);
        } else if (this.numberBytesAdded >= 256) {
            Log.println("ERROR: attempt to add byte past end of frame");
        }
        this.bytes[this.numberBytesAdded] = b;
        ++this.numberBytesAdded;
        if (this.numberBytesAdded == 1) {
            this.header.copyBitsToFields();
            if (Config.debugFrames) {
                Log.println("DECODING FUNCUBE PAYLOAD TYPE: " + this.header.type);
            }
            int type = this.header.type;
            this.header.id = 100;
            this.funCube = (FUNcubeSpacecraft)Config.satManager.getSpacecraft(100);
            if (this.funCube != null) {
                this.rtPayload = new PayloadRealTime(this.funCube.getLayoutByName("rttelemetry"));
                this.payload = this.funCube.getPayloadByType(type);
                if (this.payload == null) {
                    Log.println("FOX ID: " + this.header.id + " is not configured in the spacecraft directory.  Decode not possible.");
                    this.corrupt = true;
                }
            }
        }
        if (this.numberBytesAdded == 256) {
            this.rtPayload.copyBitsToFields();
        }
    }

    public static int getMaxBytes() {
        return 256;
    }

    public String toString() {
        return "\n" + this.header.toString() + "\n\n" + this.payload.toString() + "\n";
    }
}

