/*
 * Decompiled with CFR 0.152.
 */
package telemetry.legacyPayloads;

import common.Config;
import common.Log;
import decoder.FoxBitStream;
import decoder.FoxDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.legacyPayloads.PictureScanLine;

@Deprecated
public class PayloadCameraData
extends FramePart {
    public static final byte END_OF_JPEG_DATA = -86;
    public static final int LINE_HEADER_BYTES = 9;
    private int headerByte = 0;
    private int lineByte = 0;
    boolean firstByte = false;
    PictureScanLine currentScanLine;
    private int currentScanLineCount = 0;
    int[] cameraData = new int[this.MAX_BYTES];
    int scanLineCount = 0;
    public ArrayList<PictureScanLine> pictureLines;
    int linesAdded = 0;
    private boolean foundEndOfJpegData = false;

    public PayloadCameraData(int slc) {
        super(5, new BitArrayLayout());
        this.MAX_BYTES = 4300;
        this.rawBits = new boolean[this.MAX_BYTES * 8];
        this.setupScanLines(slc);
    }

    public PayloadCameraData(int id, int resets, long uptime, String date, StringTokenizer st) {
        super(id, resets, uptime, 5, date, st, new BitArrayLayout());
        this.MAX_BYTES = 4300;
    }

    @Override
    protected void init() {
    }

    public boolean foundEndOfJpegData() {
        return this.foundEndOfJpegData;
    }

    private void setupScanLines(int slc) {
        this.firstByte = false;
        this.scanLineCount = slc;
        this.resetBitPosition();
        this.pictureLines = new ArrayList();
        if (this.scanLineCount == 0) {
            this.foundEndOfJpegData = true;
        }
        this.headerByte = 0;
        this.currentScanLineCount = 0;
        if (Config.debugCameraFrames) {
            Log.print("SLC: " + this.scanLineCount + " ");
        }
    }

    @Override
    public void addNext8Bits(byte b) {
        super.addNext8Bits(b);
        if (this.firstByte) {
            this.firstByte = false;
            this.resetBitPosition();
            this.pictureLines = new ArrayList();
            this.scanLineCount = this.nextbits(8);
            if (this.scanLineCount == 0) {
                this.foundEndOfJpegData = true;
            }
            this.headerByte = 0;
            this.currentScanLineCount = 0;
            if (Config.debugCameraFrames) {
                Log.print("SLC: " + this.scanLineCount + " ");
            }
        } else {
            ++this.headerByte;
            if (this.headerByte == 9) {
                int preamble = 0;
                int p = 0;
                while (p < 6) {
                    preamble = this.nextbits(8);
                    ++p;
                }
                int pictureCounter = this.nextbits(8);
                int descriptor = this.nextbits(8);
                int descriptor2 = this.nextbits(8);
                int scanLineLength = ((descriptor & 3) << 8) + descriptor2;
                int scanLineNumber = descriptor >> 2;
                int[] scanLineData = new int[scanLineLength];
                this.currentScanLine = new PictureScanLine(FramePart.fileDateStamp(), pictureCounter, scanLineNumber, scanLineLength, scanLineData);
                this.pictureLines.add(this.currentScanLine);
                this.lineByte = 0;
            } else if (this.headerByte > 9 && this.lineByte < this.currentScanLine.scanLineLength - 1) {
                if (Config.debugCameraFrames) {
                    Log.print("PC:" + this.currentScanLine.pictureCounter + " SL:" + this.currentScanLine.scanLineNumber + " SLL:" + this.currentScanLine.scanLineLength + " Byte Num:" + this.lineByte + " ");
                }
                this.currentScanLine.scanLineData[this.lineByte++] = this.nextbits(8);
            } else if (this.headerByte > 9 && this.lineByte == this.currentScanLine.scanLineLength - 1) {
                if (Config.debugCameraFrames) {
                    Log.print("PC:" + this.currentScanLine.pictureCounter + " SL:" + this.currentScanLine.scanLineNumber + " SLL:" + this.currentScanLine.scanLineLength + " Byte Num:" + this.lineByte + " ");
                }
                this.currentScanLine.scanLineData[this.lineByte] = this.nextbits(8);
                ++this.currentScanLineCount;
                this.headerByte = 0;
                this.lineByte = 0;
                if (this.currentScanLineCount == this.scanLineCount) {
                    this.foundEndOfJpegData = true;
                }
            }
        }
        if (Config.debugCameraFrames) {
            Log.print(String.valueOf(FoxDecoder.hex(b)) + ": ");
            FoxBitStream.printBitArray(FoxBitStream.intToBin8(b));
        }
        if (this.numberBytesAdded == 4300) {
            this.foundEndOfJpegData = true;
        }
    }

    @Override
    public void copyBitsToFields() {
    }

    public ArrayList<PictureScanLine> getPictureLines() {
        return this.pictureLines;
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = "JPEG CAMERA IMGAGE - " + this.pictureLines.size() + " picture lines\n";
        for (PictureScanLine line : this.pictureLines) {
            s = String.valueOf(s) + line.toShortString() + "\n";
        }
        return s;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public String toFile() {
        this.copyBitsToFields();
        String s = new String();
        for (PictureScanLine line : this.pictureLines) {
            s = String.valueOf(s) + this.reportDate + "," + this.id + "," + this.resets + "," + this.uptime + "," + this.type + ",";
            s = String.valueOf(s) + line.toString() + "\n";
        }
        return s;
    }
}

