/*
 * Decompiled with CFR 0.152.
 */
package telemetry.legacyPayloads;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import telemetry.SatPayloadStore;
import telemetry.SortedArrayList;
import telemetry.legacyPayloads.PictureScanLine;

public class CameraJpeg
implements Comparable<CameraJpeg> {
    public static final String IMAGES_DIR = "images";
    public static final String JPG_HEADER = "spacecraft" + File.separator + "jpeg_header.jpg";
    public static final String JPG_HEADER_LOW_RES = "spacecraft" + File.separator + "jpeg_header_low_res.jpg";
    public static final int UPTIME_THRESHOLD = 500;
    public static final boolean INSERT_MARKERS = true;
    public static final int LAST_LINE = 59;
    public int id;
    public int resets;
    public long fromUptime;
    public long toUptime;
    public int pictureCounter;
    private String fileName;
    public String captureDate;
    private boolean thumbStale = false;
    BufferedImage thumbNail;
    SortedArrayList<PictureScanLine> pictureLines;

    public CameraJpeg(int id, int resets, long from, long to, int pc, String date, String name) {
        this.id = id;
        this.resets = resets;
        this.fromUptime = from;
        this.toUptime = to;
        this.pictureCounter = pc;
        this.captureDate = date;
        this.fileName = name;
    }

    CameraJpeg(int id, int resets, long from, long to, int pc) {
        this.id = id;
        this.resets = resets;
        this.fromUptime = from;
        this.toUptime = to;
        this.pictureCounter = pc;
        this.pictureLines = new SortedArrayList(60);
    }

    public CameraJpeg(int id, int resets, long from, long to, int pc, SortedArrayList<PictureScanLine> psl) throws SQLException {
        this(id, resets, from, to, pc);
        this.pictureLines = psl;
        this.fileName = this.makeFileName();
    }

    public CameraJpeg(int id, int resets, long from, long to, int pc, PictureScanLine line) throws IOException {
        this.id = id;
        this.resets = resets;
        this.fromUptime = from;
        this.toUptime = to;
        this.pictureCounter = pc;
        this.captureDate = line.captureDate;
        this.fileName = this.createJpegFile(id, resets, from, pc, false);
        this.addLine(line);
    }

    public String getFileName() {
        String toFileName = this.fileName;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toFileName = String.valueOf(Config.logFileDirectory) + File.separator + this.fileName;
        }
        return toFileName;
    }

    public void addLine(PictureScanLine line) throws IOException {
        if (this.toUptime < line.uptime) {
            this.toUptime = line.uptime;
        }
        String toFileName = this.getFileName();
        try (FileOutputStream out = new FileOutputStream(toFileName, true);){
            this.writeLine(line, out);
        }
    }

    private void writeLine(PictureScanLine line, OutputStream out) throws IOException {
        int[] nArray = line.scanLineData;
        int n = line.scanLineData.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            out.write((byte)a);
            ++n2;
        }
        out.write(-1);
        int num = line.scanLineNumber % 8;
        int rsi = num & 7 | 0xD0;
        out.write((byte)rsi);
        if (line.scanLineNumber == 59) {
            Log.println("LAST LINE - JPEG FOOTER ADDED");
            out.write(-1);
            out.write(-39);
        }
        this.thumbStale = true;
    }

    public void writeAllLines() throws IOException {
        this.fileName = this.createJpegFile(this.id, this.resets, this.fromUptime, this.pictureCounter, true);
        String toFileName = this.getFileName();
        try (FileOutputStream out = new FileOutputStream(toFileName, true);){
            int i = 0;
            while (i < this.pictureLines.size()) {
                this.writeLine((PictureScanLine)this.pictureLines.get(i), out);
                ++i;
            }
        }
    }

    public boolean isSameFile(int id, int resets, long uptime, int pc) {
        return this.id == id && this.resets == resets && this.pictureCounter == pc && (Math.abs(this.fromUptime - uptime) < 500L || Math.abs(this.toUptime - uptime) < 500L);
    }

    @Override
    public int compareTo(CameraJpeg p) {
        if (this.resets == p.resets && this.fromUptime == p.fromUptime) {
            return 0;
        }
        if (this.resets < p.resets) {
            return -1;
        }
        if (this.resets > p.resets) {
            return 1;
        }
        if (this.resets == p.resets && this.fromUptime < p.fromUptime) {
            return -1;
        }
        return 1;
    }

    public boolean fileExists() {
        String toFileName = this.getFileName();
        File toFile = new File(toFileName);
        return toFile.exists();
    }

    public String createJpegFile(int id, int reset, long uptime, int pc, boolean overWrite) throws IOException {
        String name;
        String header = JPG_HEADER;
        Spacecraft sat = Config.satManager.getSpacecraft(id);
        if (sat.hasLowResCamera()) {
            header = JPG_HEADER_LOW_RES;
        }
        String toFileName = name = this.makeFileName();
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toFileName = String.valueOf(Config.logFileDirectory) + File.separator + name;
        }
        File toFile = new File(toFileName);
        if (overWrite || !toFile.exists()) {
            File headerFile = new File(header);
            SatPayloadStore.copyFile(headerFile, toFile);
            return name;
        }
        return name;
    }

    public String makeFileName() {
        String name = IMAGES_DIR + File.separator + this.id + "_" + this.resets + "_" + this.fromUptime + "_" + this.pictureCounter + ".jpg";
        return name;
    }

    public void makeServerThumbnail(int sizeX) {
        BufferedImage img = null;
        String imageFile = this.getFileName();
        File source = new File(imageFile);
        imageFile = imageFile.replace(".jpg", "_tn.jpg");
        File f = new File(imageFile);
        try {
            img = ImageIO.read(source);
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
            img = new BufferedImage(sizeX, 75, 2);
            try {
                ImageIO.write((RenderedImage)img, "JPEG", f);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (img != null) {
            double w = img.getWidth();
            double scale = (double)sizeX / w;
            this.thumbNail = CameraJpeg.scale(img, scale);
            try {
                ImageIO.write((RenderedImage)this.thumbNail, "JPEG", f);
            }
            catch (IOException e) {
                e.printStackTrace();
                img = new BufferedImage(sizeX, 75, 2);
                try {
                    ImageIO.write((RenderedImage)img, "JPEG", f);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.thumbStale = false;
    }

    public BufferedImage getThumbnail(int sizeX) throws IOException, IIOException {
        if (!this.thumbStale && this.thumbNail != null) {
            return this.thumbNail;
        }
        BufferedImage img = null;
        String imageFile = this.getFileName();
        File source = new File(imageFile);
        imageFile = imageFile.replace(".jpg", "_tn.jpg");
        File thumbFile = new File(imageFile);
        if (!this.thumbStale && thumbFile.exists()) {
            this.thumbNail = img = ImageIO.read(thumbFile);
            return img;
        }
        File f = new File(imageFile);
        try {
            img = ImageIO.read(source);
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
            try {
                img = new BufferedImage(sizeX, 75, 2);
                ImageIO.write((RenderedImage)img, "JPEG", f);
            }
            catch (Exception e2) {
                Log.errorDialog("ERROR Writing the Jpeg Header to File", "Can't read the file: " + source.getName() + "\n" + "Can't write the file: " + f.getName());
            }
        }
        if (img != null) {
            double w = img.getWidth();
            double scale = (double)sizeX / w;
            this.thumbNail = CameraJpeg.scale(img, scale);
            ImageIO.write((RenderedImage)this.thumbNail, "JPEG", f);
        }
        this.thumbStale = false;
        return this.thumbNail;
    }

    public static BufferedImage scale(BufferedImage source, double ratio) {
        int w = (int)((double)source.getWidth() * ratio);
        int h = (int)((double)source.getHeight() * ratio);
        if (w == 0 || h == 0) {
            return source;
        }
        BufferedImage bi = CameraJpeg.getCompatibleImage(w, h);
        Graphics2D g2d = bi.createGraphics();
        double xScale = (double)w / (double)source.getWidth();
        double yScale = (double)h / (double)source.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        g2d.drawRenderedImage(source, at);
        g2d.dispose();
        return bi;
    }

    private static BufferedImage getCompatibleImage(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        return image;
    }

    public String toString() {
        String s = String.valueOf(this.captureDate) + "," + this.id + "," + this.resets + "," + this.fromUptime + "," + this.toUptime + "," + this.pictureCounter + "," + this.fileName;
        return s;
    }

    public static String getTableCreateStmt() {
        String s = new String();
        s = String.valueOf(s) + "(id int, resets int, fromUptime bigint, toUptime bigint, " + "pictureCounter int, " + "fileName varchar(255)," + "date_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,";
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, fromUptime, pictureCounter))";
        return s;
    }

    public String getInsertStmt() {
        String s = new String();
        s = String.valueOf(s) + " (id, resets, fromUptime, toUptime, \n";
        s = String.valueOf(s) + "pictureCounter,\n";
        s = String.valueOf(s) + "fileName)\n";
        s = String.valueOf(s) + "values (" + this.id + ", " + this.resets + ", " + this.fromUptime + ", " + this.toUptime + ",\n";
        s = String.valueOf(s) + this.pictureCounter + ",\n";
        s = String.valueOf(s) + "'" + this.fileName + "')\n";
        return s;
    }
}

