/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Config;
import common.Spacecraft;
import java.util.Date;
import java.util.TimeZone;
import telemetry.FramePart;
import telemetry.conversion.Conversion;

public class ConversionTimestamp
extends Conversion {
    String resetFieldName;
    String uptimeFieldName;

    public ConversionTimestamp(String name, Spacecraft fox) {
        super(name, fox);
        String stem9 = "";
        if (name.length() >= 9 && (stem9 = name.substring(0, 9)).equalsIgnoreCase("TIMESTAMP")) {
            String index1 = name.substring(9);
            String[] values = index1.split("\\s+");
            if (values.length < 3 || values[1] == null || values[2] == null) {
                this.resetFieldName = null;
                this.uptimeFieldName = null;
            } else if (values.length == 3) {
                this.resetFieldName = values[1];
                this.uptimeFieldName = values[2];
            }
        }
    }

    @Override
    public double calculate(double x) {
        return x;
    }

    @Override
    public String calculateString(double x) {
        throw new RuntimeException("Call conversion " + this.name + " with calculateTimeString method only!");
    }

    public String calculateTimeString(double x, FramePart framePart) {
        Integer reset = null;
        Long uptime = null;
        String s = "";
        if (!framePart.hasFieldName(this.resetFieldName)) {
            s = "!Invalid Reset Field";
            return s;
        }
        reset = (int)framePart.getDoubleValue(this.resetFieldName, this.fox);
        if (!framePart.hasFieldName(this.uptimeFieldName)) {
            s = "!Invalid Uptime Field";
            return s;
        }
        uptime = (long)framePart.getDoubleValue(this.uptimeFieldName, this.fox);
        if (reset != null && uptime != null) {
            if (Config.displayUTCtime) {
                Date date = this.fox.getUtcForReset(reset, uptime);
                if (date == null) {
                    s = "T0 not set";
                } else {
                    FramePart.reportDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    s = FramePart.reportDateFormat.format(date);
                }
            } else {
                s = reset + " / " + uptime;
            }
            return s;
        }
        return null;
    }
}

