/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import telemetry.LayoutLoadException;
import telemetry.conversion.Conversion;

public class ConversionLookUpTable
extends Conversion {
    protected Map<Integer, Double> table = new LinkedHashMap<Integer, Double>();

    public ConversionLookUpTable(String name, Spacecraft fox) {
        super(name, fox);
    }

    public ConversionLookUpTable(String name, String fileName, Spacecraft fox) throws FileNotFoundException, LayoutLoadException {
        super(name, fox);
        this.load(fileName);
    }

    private double linearInterpolation(double x, double x0, double x1, double y0, double y1) {
        double y = y0 + (y1 - y0) * ((x - x0) / (x1 - x0));
        return y;
    }

    @Override
    public double calculate(double x) {
        int lookUpKey = (int)x;
        Iterator<Map.Entry<Integer, Double>> it = this.table.entrySet().iterator();
        double lastValue = 0.0;
        int lastKey = 0;
        double prevValue = 0.0;
        int prevKey = 0;
        Map.Entry<Integer, Double> pairs = null;
        boolean firstKey = true;
        double value = 9999.0;
        while (it.hasNext()) {
            pairs = it.next();
            int key = pairs.getKey();
            value = pairs.getValue();
            if (firstKey) {
                firstKey = false;
                if (lookUpKey < key) {
                    lastKey = key;
                    lastValue = value;
                    pairs = it.next();
                    key = pairs.getKey();
                    value = pairs.getValue();
                    value = this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                    return value;
                }
            }
            if (lookUpKey == key) {
                return value;
            }
            if (lookUpKey < key) {
                value = this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                return value;
            }
            prevKey = lastKey;
            prevValue = lastValue;
            lastKey = key;
            lastValue = value;
        }
        if (pairs != null) {
            value = this.linearInterpolation(lookUpKey, prevKey, lastKey, prevValue, lastValue);
        }
        return value;
    }

    public int reverseLookup(double lookUpKey) {
        Iterator<Map.Entry<Integer, Double>> it = this.table.entrySet().iterator();
        int lastValue = 0;
        double lastKey = 0.0;
        int prevValue = 0;
        double prevKey = 0.0;
        Map.Entry<Integer, Double> pairs = null;
        boolean firstKey = true;
        int value = 9999;
        while (it.hasNext()) {
            pairs = it.next();
            value = pairs.getKey();
            double key = pairs.getValue();
            if (firstKey) {
                firstKey = false;
                if (lookUpKey < key) {
                    lastKey = key;
                    lastValue = value;
                    pairs = it.next();
                    value = pairs.getKey();
                    key = pairs.getValue();
                    value = (int)this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                    return value;
                }
            }
            if (lookUpKey == key) {
                return value;
            }
            if (lookUpKey < key) {
                value = (int)this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                return value;
            }
            prevKey = lastKey;
            prevValue = lastValue;
            lastKey = key;
            lastValue = value;
        }
        if (pairs != null) {
            value = (int)this.linearInterpolation(lookUpKey, prevKey, lastKey, prevValue, lastValue);
        }
        return value;
    }

    @Override
    public String calculateString(double x) {
        String s = String.format("%2.1f", x);
        return s;
    }

    protected void load(String fileName) throws FileNotFoundException, LayoutLoadException {
        fileName = String.valueOf(Config.spacecraftDir) + File.separator + fileName;
        Log.println("Loading lookup table: " + fileName);
        BufferedReader dis = new BufferedReader(new FileReader(fileName));
        try {
            String line;
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                int key = Integer.valueOf(st.nextToken());
                double value = Double.valueOf(st.nextToken());
                this.table.put(key, value);
            }
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        catch (NumberFormatException n) {
            Log.errorDialog("NUMBER FORMAT EXCEPTION", "Loading Lookup table " + fileName + " " + n.getMessage());
            n.printStackTrace(Log.getWriter());
        }
        catch (NoSuchElementException n) {
            Log.errorDialog("Missing Field in Lookup table File", "Halted loading " + fileName);
            n.printStackTrace(Log.getWriter());
        }
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "Lookup Table: " + this.name;
        return s;
    }
}

