/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Spacecraft;
import decoder.FoxBitStream;
import gui.graph.LinePlotPanel;
import telemetry.FramePart;
import telemetry.conversion.Conversion;
import telemetry.conversion.LookUpTableBatteryTemp;
import telemetry.conversion.LookUpTableSolarPanelTemp;
import telemetry.conversion.LookUpTableTemperature;

@Deprecated
public class ConversionLegacy
extends Conversion {
    public static final int SPININFO_1 = 0;
    public static final int SPININFO_2 = 1;
    public static final int SPININFO_3 = 2;
    public static final int SPININFO_4 = 3;
    public static final int LAST3_DL_STATES = 4;
    public static final int COMMAND_RING = 5;
    public static final int COMMAND_COUNT = 6;
    public static final int I2C1_ERRORS = 7;
    public static final int I2C2_ERRORS = 8;
    public static final int GYRO1Z = 11;
    public static final int GYRO1V = 12;
    public static final int GYRO2V = 13;
    public static final int UNKNOWN = 15;
    public static final int IHU_SW_VERSION = 14;
    public static final int ISISStatus = 16;
    public static final int IHU_TEMP_CALIBRATION_VOLTAGE = 17;
    public static final int AUTO_SAFE_VOLTAGES = 18;
    public static final String[] ihuErrorType = new String[]{"Unknown", "PowerCycle", "StackOverflow", "NMIExc", "HardFault", "MemManage", "BusFault", "UseFault", "USBHighPrio", "SPIInUse", "SPIOperationTimeout", "SPIMramTimeout", "UnexpectedBehavior", "SemaphoreFail", "USARTError", "DMAInUseTimeout", "IllegalGPIOOutput", "IllegalGPIOInput", "IllegalGPIOWait", "MRAMcrc ", "MRAMread", "MRAMwrite", "RTOSfailure", "ADCTimeout", "ADCDACSync", "I2C1failure", "I2C2failure", "ControlQueueOverflow", "ControlTimerNotStarted", "FlashCRCfaulty", "ExperimentFailure"};
    public static final String[] ihuTask = new String[]{"Unknown", "Audio", "Telemetry", "Control", "Command", "Idle", "Experiment"};
    public static final String[] ihuDownlinkStateMachineTask = new String[]{"NoChange", "Relay", "TlmFnsh", "Idle", "IdleBcon", "IdleMsg", "IdleWaitTlm", "IdleWaitID", "IdleCar2", "Safe", "SafeBcon", "SafeMsg", "SafeWaitTlm", "SafeWaitID", "SafeCar2", "DataMode", "Unexpctd"};
    private static final double BATTERY_CURRENT_MIN = 0.05;
    private static final double VOLTAGE_STEP_FOR_2V5_SENSORS = 6.103515625E-4;
    private static final double VOLTAGE_STEP_FOR_3V_SENSORS = 7.32421875E-4;
    private static final double BATTERY_B_SCALING_FACTOR = 0.76;
    private static final double BATTERY_C_SCALING_FACTOR = 0.5;
    private static final double SOLAR_PANEL_SCALING_FACTOR = 0.428;
    private static final double MPPT_SOLAR_PANEL_SCALING_FACTOR = 2.7024793388429753;
    private static final double PSU_CURRENT_SCALING_FACTOR = 0.003;
    private static final double MPPT_CURRENT_SCALING_FACTOR = 2.5;
    private static final double MPPT_RTD_CONSTANT_CURERNT = 0.001;
    private static final double MPPT_RTD_AMP_GAIN = -8.14228;
    private static final double MPPT_RTD_AMP_FACTOR = 2.0523;
    public static final int MPPT_DEFAULT_TEMP = 0;
    private static final double PA_CURRENT_INA194_FACTOR = 50.0;
    private static final double PA_CURRENT_SHUNT_RESISTOR_FACTOR = 0.2;
    private static final double MEMS_ZERO_VALUE_VOLTS = 1.51;
    private static final double MEMS_VOLT_PER_DPS = 0.0333;
    public static LookUpTableTemperature temperatureTable = new LookUpTableTemperature();
    public static LookUpTableBatteryTemp batteryTempTable = new LookUpTableBatteryTemp();
    public static LookUpTableSolarPanelTemp solarPanelTempTable = new LookUpTableSolarPanelTemp();
    int convInt = 0;
    public static final int wdReportAudioTask = 1;
    public static final int wdReportTelemetryCollectionTask = 2;
    public static final int wdReportDownlinkControlTask = 4;
    public static final int wdReportUplinkCommandRxTask = 8;
    public static final int wdReportIdleTask = 16;
    public static final int wdReportExpTask = 32;

    public ConversionLegacy(String name, Spacecraft fox) {
        super(name, fox);
        try {
            this.convInt = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            this.convInt = 0;
        }
    }

    @Override
    public double calculate(double x) {
        throw new RuntimeException("Call legacy conversion " + this.name + " with calculateLegacy method only!");
    }

    public double calculateLegacy(double x, FramePart framePart, String fieldName) {
        double result = this.convertRawValue(framePart, fieldName, x, this.convInt, this.fox);
        return result;
    }

    @Override
    public String calculateString(double x) {
        String s = this.legacyStringConversion(this.convInt, x, this.fox);
        return s;
    }

    @Deprecated
    private String legacyStringConversion(int conv, double value, Spacecraft fox) {
        String s = "-----";
        if (value == 9999.0) {
            s = "-----";
        } else if (conv == 16) {
            s = value == 0.0 ? "Stowed" : "Deployed";
        } else if (conv == 51) {
            s = ConversionLegacy.isisAntennaStatus((int)value, true);
        } else if (conv == 17) {
            s = value == 0.0 ? "OK" : "FAIL";
        } else if (conv == 44) {
            s = value == 1.0 ? "Enabled" : "Disabled";
        } else if (conv == 21) {
            s = value == 1.0 ? "TRUE" : "FALSE";
        } else if (conv == 1 || conv == 36) {
            s = Long.toString((long)value);
        } else if (conv == 18) {
            s = ConversionLegacy.ihuDiagnosticString((int)value, true, fox);
        } else if (conv == 19) {
            s = ConversionLegacy.hardErrorString((int)value, true);
        } else if (conv == 20) {
            s = ConversionLegacy.softErrorStringFox1A((int)value, true);
        } else if (conv == 39) {
            s = ConversionLegacy.softErrorString84488((int)value, true);
        } else if (conv == 34) {
            s = ConversionLegacy.icrSwCommandCount((int)value, true);
        } else if (conv == 35) {
            s = ConversionLegacy.icrDiagnosticString((int)value, true);
        } else {
            if (conv == 55) {
                if (value >= 1500.0) {
                    return "OK";
                }
                return "FAIL";
            }
            s = conv == 4 || conv == 43 || conv == 23 || conv == 45 || conv == 61 || conv == 62 || conv == 63 || conv == 60 || conv == 42 ? String.format("%1.2f", value) : String.format("%2.1f", value);
        }
        return s;
    }

    @Deprecated
    protected double convertRawValue(FramePart framePart, String name, double rawValue, int conversion, Spacecraft fox) {
        switch (conversion) {
            case 16: {
                return rawValue;
            }
            case 21: {
                return rawValue;
            }
            case 0: {
                return rawValue;
            }
            case 1: {
                return rawValue;
            }
            case 2: {
                return rawValue * 6.103515625E-4;
            }
            case 3: {
                return rawValue * 7.32421875E-4;
            }
            case 4: {
                if (name.equalsIgnoreCase("BATT_A_V")) {
                    return rawValue * 6.103515625E-4;
                }
                if (name.equalsIgnoreCase("BATT_B_V")) {
                    return rawValue * 6.103515625E-4 / 0.76;
                }
                if (name.equalsIgnoreCase("BATT_C_V")) {
                    if (fox.useIHUVBatt) {
                        return fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                    }
                    return rawValue * 6.103515625E-4 / 0.5;
                }
                return 9999.0;
            }
            case 8: {
                return batteryTempTable.calculate(rawValue);
            }
            case 9: {
                double d = rawValue;
                d = ((d * 6.103515625E-4 - 0.05) * fox.user_BATTERY_CURRENT_ZERO + 2.0) * 1000.0;
                return d;
            }
            case 5: {
                return rawValue * 7.32421875E-4 / 0.428;
            }
            case 23: {
                return rawValue * 6.103515625E-4 * 2.7024793388429753;
            }
            case 6: {
                return solarPanelTempTable.calculate(rawValue);
            }
            case 24: {
                if (rawValue < (double)fox.user_mpptSensorOffThreshold) {
                    return 9999.0;
                }
                double raw = rawValue;
                double vadc = raw * 6.103515625E-4;
                double v = (vadc - 2.0523) / -8.14228;
                double r = v / 0.001 - fox.user_mpptResistanceError;
                double t = -247.29 + 2.3992 * r + 6.3962E-4 * Math.pow(r, 2.0) + 1.0241E-6 * Math.pow(r, 3.0);
                return t;
            }
            case 7: {
                return temperatureTable.calculate(rawValue);
            }
            case 10: {
                double paVolts = rawValue * 7.32421875E-4;
                double paCurrent = paVolts / 50.0 / 0.2;
                return paCurrent * 1000.0;
            }
            case 11: {
                return rawValue * 7.32421875E-4 / 0.003;
            }
            case 22: {
                return rawValue * 6.103515625E-4 / 2.5 * 1000.0;
            }
            case 12: {
                double value = rawValue;
                if (value > 2047.0) {
                    value += -4096.0;
                }
                return value /= 256.0;
            }
            case 13: {
                return ConversionLegacy.calcMemsValue((int)rawValue, name, fox);
            }
            case 60: {
                double xdps = framePart.getDoubleValue("SatelliteXAxisAngularVelocity", fox);
                double ydps = framePart.getDoubleValue("SatelliteYAxisAngularVelocity", fox);
                double zdps = framePart.getDoubleValue("SatelliteZAxisAngularVelocity", fox);
                double scalar = Math.sqrt(xdps * xdps + ydps * ydps + zdps * zdps);
                return scalar;
            }
            case 61: {
                double xdps = framePart.getDoubleValue("SatelliteXAxisAngularVelocity", fox);
                double scalar = framePart.getDoubleValue("MemsScalarRotation", fox);
                double xcosine = xdps / scalar;
                double xangle = Math.acos(Math.abs(xcosine));
                return 360.0 * xangle / (Math.PI * 2);
            }
            case 62: {
                double yvel = framePart.getDoubleValue("SatelliteYAxisAngularVelocity", fox);
                double scalar = framePart.getDoubleValue("MemsScalarRotation", fox);
                double ycosine = yvel / scalar;
                double yangle = Math.acos(Math.abs(ycosine));
                return 360.0 * yangle / (Math.PI * 2);
            }
            case 63: {
                double zvel = framePart.getDoubleValue("SatelliteZAxisAngularVelocity", fox);
                double scalar = framePart.getDoubleValue("MemsScalarRotation", fox);
                double zcosine = zvel / scalar;
                double zangle = Math.acos(Math.abs(zcosine));
                return 360.0 * zangle / (Math.PI * 2);
            }
            case 14: {
                return fox.getLookupTableByName("RSSI").calculate(rawValue);
            }
            case 15: {
                return fox.getLookupTableByName("IHU_TEMP").calculate(rawValue);
            }
            case 17: {
                return rawValue;
            }
            case 18: {
                return rawValue;
            }
            case 19: {
                return rawValue;
            }
            case 20: {
                return rawValue;
            }
            case 39: {
                return rawValue;
            }
            case 34: {
                return rawValue;
            }
            case 35: {
                return rawValue;
            }
            case 36: {
                return rawValue * 4.0;
            }
            case 37: {
                double volts = fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                return 100.0 * (volts /= 2.0) - 50.0;
            }
            case 38: {
                double voltspa = fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                double pacurrent = (voltspa /= 2.0) / 50.0 / 0.1;
                return 1000.0 * pacurrent;
            }
            case 40: {
                double x = fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                double y = 1.6707 * Math.pow(x /= 2.0, 3.0) - 12.954 * Math.pow(x, 2.0) + 37.706 * x - 14.388;
                return Math.pow(10.0, y / 10.0);
            }
            case 41: {
                double x = rawValue * 6.103515625E-4 / 0.758;
                double y = 0.1921 * Math.pow(x, 3.0) + 14.663 * Math.pow(x, 2.0) + 11.56 * x - 1.8544;
                if (y < 0.0) {
                    y = 0.0;
                }
                return y;
            }
            case 42: {
                double volts = fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                return volts /= 2.0;
            }
            case 43: {
                double volts = rawValue * 6.103515625E-4;
                volts = volts * 99.0 / 75.0;
                return volts;
            }
            case 47: {
                double spin = rawValue - 32768.0;
                return spin /= 131.0;
            }
            case 45: {
                double acc = rawValue - 32768.0;
                return acc /= 16384.0;
            }
            case 46: {
                double mag = rawValue - 32768.0;
                return mag *= 0.6;
            }
            case 48: {
                double temp = rawValue * 0.1 - 40.0;
                return temp;
            }
            case 49: {
                double V = 3.225806451612903 * rawValue;
                double antTemp = fox.getLookupTableByName("HUSKY_ISIS_ANT_TEMP").calculate((int)V);
                return antTemp;
            }
            case 50: {
                double time = rawValue / 20.0;
                return time;
            }
            case 51: {
                return rawValue;
            }
            case 59: {
                return Math.pow(10.0, rawValue / 10.0);
            }
            case 53: {
                double x = fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                double y = 1.7685 * Math.pow(x /= 2.0, 3.0) - 13.107 * Math.pow(x, 2.0) + 36.436 * x - 13.019;
                double z = Math.pow(10.0, y / 10.0);
                return z;
            }
            case 54: {
                double x = rawValue * 1000.0 * 6.103515625E-4 / 0.758;
                double y = 0.1727 * x - 34.583;
                return Math.pow(10.0, y / 10.0);
            }
            case 55: {
                double x = rawValue * 6.103515625E-4 / 0.758;
                return x;
            }
            case 56: {
                double x = fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                double y = 46.566 * (x /= 2.0) - 135.54;
                return y;
            }
            case 57: {
                double x = rawValue * 6.103515625E-4 / 0.758;
                return x;
            }
            case 52: {
                double x = rawValue * 6.103515625E-4 / 0.324;
                return x;
            }
            case 58: {
                double x = fox.getLookupTableByName("IHU_VBATT").calculate(rawValue);
                x /= 2.0;
                return x /= 0.2424;
            }
            case 27: {
                return rawValue;
            }
            case 25: {
                return rawValue * 16.0;
            }
            case 29: {
                return rawValue;
            }
            case 28: {
                return rawValue;
            }
        }
        return rawValue;
    }

    private static double calcMemsValue(int value, String name, Spacecraft fox) {
        double volts = fox.getLookupTableByName("IHU_VBATT").calculate(value);
        volts /= 2.0;
        double memsZeroValue = 1.51;
        double result = 0.0;
        if (fox.hasMemsRestValues) {
            int restValue = 0;
            if (name.equalsIgnoreCase("SatelliteXAxisAngularVelocity")) {
                restValue = fox.user_memsRestValueX;
            }
            if (name.equalsIgnoreCase("SatelliteYAxisAngularVelocity")) {
                restValue = fox.user_memsRestValueY;
            }
            if (name.equalsIgnoreCase("SatelliteZAxisAngularVelocity")) {
                restValue = fox.user_memsRestValueZ;
            }
            memsZeroValue = fox.getLookupTableByName("IHU_VBATT").calculate(restValue);
            memsZeroValue /= 2.0;
        }
        result = (volts - memsZeroValue) / 0.0333;
        return result;
    }

    public static String ihuDiagnosticString(int rawValue, boolean shortString, Spacecraft fox) {
        int type = rawValue & 0xFF;
        int value = 0;
        String s = new String();
        switch (type) {
            case 0: {
                value = rawValue >> 8;
                s = "spin1: " + value;
                return s;
            }
            case 1: {
                value = rawValue >> 8;
                s = "spin2: " + value;
                return s;
            }
            case 2: {
                value = rawValue >> 8;
                s = "spin3: " + value;
                return s;
            }
            case 3: {
                value = rawValue >> 8;
                s = "spin4: " + value;
                return s;
            }
            case 4: {
                int a = rawValue >> 8 & 0xFF;
                int b = rawValue >> 16 & 0xFF;
                int c = rawValue >> 24 & 0xFF;
                if (shortString) {
                    return "Last3DL: " + Integer.toHexString(a) + " " + Integer.toHexString(b) + " " + Integer.toHexString(c);
                }
                return "Last 3 states of the DownlinkControl state machine: " + ihuDownlinkStateMachineTask[a] + " " + ihuDownlinkStateMachineTask[b] + " " + ihuDownlinkStateMachineTask[c];
            }
            case 5: {
                int n1 = rawValue >> 8 & 0xF;
                int n2 = rawValue >> 12 & 0xF;
                int n3 = rawValue >> 16 & 0xF;
                int n4 = rawValue >> 20 & 0xF;
                int n5 = rawValue >> 24 & 0xF;
                int n6 = rawValue >> 28 & 0xF;
                if (shortString) {
                    return "Commands: " + Integer.toHexString(n1) + " " + Integer.toHexString(n2) + " " + Integer.toHexString(n3) + " " + Integer.toHexString(n4) + " " + Integer.toHexString(n5) + " " + Integer.toHexString(n6);
                }
                return "Command Ring of last 5 uplinked commands: " + Integer.toHexString(n1) + " " + Integer.toHexString(n2) + " " + Integer.toHexString(n3) + " " + Integer.toHexString(n4) + " " + Integer.toHexString(n5) + " " + Integer.toHexString(n6);
            }
            case 6: {
                value = rawValue >> 8 & 0xFFFFFF;
                if (fox.hasImprovedCommandReceiver) {
                    return ConversionLegacy.icrCommandCountFox1E(value, shortString);
                }
                if (fox.hasImprovedCommandReceiverII) {
                    return ConversionLegacy.icrCommandCount(value, shortString);
                }
                if (shortString) {
                    return "Count: " + value;
                }
                return "Number of commands received since boot: " + value;
            }
            case 7: {
                int writeTimeout = rawValue >> 8 & 0xFF;
                int busBusyTimeout = rawValue >> 16 & 0xFF;
                int readTimeout = rawValue >> 24 & 0xFF;
                if (shortString) {
                    return "I2C1: W " + writeTimeout + " B " + busBusyTimeout + " R " + readTimeout;
                }
                return "I2C1 Errors: Write Timeouts " + writeTimeout + " Busy Timeouts " + busBusyTimeout + " Read Timeouts " + readTimeout;
            }
            case 8: {
                int writeTimeout2 = rawValue >> 8 & 0xFF;
                int busBusyTimeout2 = rawValue >> 16 & 0xFF;
                int readTimeout2 = rawValue >> 24 & 0xFF;
                if (shortString) {
                    return "I2C2: W " + writeTimeout2 + " B " + busBusyTimeout2 + " R " + readTimeout2;
                }
                return "I2C2 Errors: Write Timeouts " + writeTimeout2 + " Busy Timeouts " + busBusyTimeout2 + " Read Timeouts " + readTimeout2;
            }
            case 9: {
                return "XXXX";
            }
            case 10: {
                return "XXXX";
            }
            case 11: {
                value = rawValue >> 8 & 0xFFF;
                if (shortString) {
                    return "Gyro1Z (dps): " + LinePlotPanel.roundToSignificantFigures(ConversionLegacy.calcMemsValue(value, "SatelliteZAxisAngularVelocity", fox), 3);
                }
                return "Gyro1Z (dps): " + LinePlotPanel.roundToSignificantFigures(ConversionLegacy.calcMemsValue(value, "SatelliteZAxisAngularVelocity", fox), 3);
            }
            case 12: {
                value = rawValue >> 8 & 0xFFF;
                double vRef = fox.getLookupTableByName("IHU_VBATT").calculate(value);
                vRef /= 2.0;
                int cameraChecksumErrors = rawValue >> 24 & 0xFF;
                --cameraChecksumErrors;
                if (shortString) {
                    return "Gyro1V (V): " + LinePlotPanel.roundToSignificantFigures(vRef, 3);
                }
                return "Gyro1V (V): " + LinePlotPanel.roundToSignificantFigures(vRef, 3) + " Camera Checksum Errors: " + cameraChecksumErrors;
            }
            case 13: {
                value = rawValue >> 8 & 0xFFF;
                double vRef = fox.getLookupTableByName("IHU_VBATT").calculate(value);
                vRef /= 2.0;
                int hsAudioBufferUnderflows = rawValue >> 24 & 0xFF;
                if (shortString) {
                    return "Gyro2V (V): " + LinePlotPanel.roundToSignificantFigures(vRef, 3);
                }
                return "Gyro2V (V): " + LinePlotPanel.roundToSignificantFigures(vRef, 3) + " HS Audio Buffer Underflows: " + hsAudioBufferUnderflows;
            }
            case 14: {
                int swType = rawValue >> 8 & 0xFF;
                int swMajor = rawValue >> 16 & 0xFF;
                int swMinor = rawValue >> 24 & 0xFF;
                return "IHU SW: " + Character.toString((char)swType) + fox.foxId + "." + Character.toString((char)swMajor) + Character.toString((char)swMinor);
            }
            case 16: {
                int antStatus = rawValue >> 8 & 0xFFFF;
                int bus0 = rawValue >> 24 & 0xF;
                int bus1 = rawValue >> 28 & 0xF;
                return "ISIS Status: " + Integer.toHexString(antStatus) + " " + Integer.toHexString(bus0) + " " + Integer.toHexString(bus1);
            }
            case 15: {
                value = rawValue >> 8 & 0xFFF;
                return "Bus Voltage: " + value + " - " + LinePlotPanel.roundToSignificantFigures(fox.getLookupTableByName("IHU_VBATT").calculate(value), 3) + "V";
            }
            case 17: {
                value = rawValue >> 8 & 0xFFFFFF;
                return "IHU Temp Cal: " + value;
            }
            case 18: {
                int value1 = rawValue >> 8 & 0xFFF;
                double voltageIn = fox.getLookupTableByName("IHU_VBATT").calculate(value1) / 2.0;
                int value2 = rawValue >> 20 & 0xFFF;
                double voltageOut = fox.getLookupTableByName("IHU_VBATT").calculate(value2) / 2.0;
                if (shortString) {
                    return "AS Vin: " + LinePlotPanel.roundToSignificantFigures(voltageIn * 99.0 / 24.0, 3) + " Vout: " + LinePlotPanel.roundToSignificantFigures(voltageOut * 99.0 / 24.0, 3);
                }
                return "Auto Safe Vin: " + LinePlotPanel.roundToSignificantFigures(voltageIn * 99.0 / 24.0, 3) + " Vout: " + LinePlotPanel.roundToSignificantFigures(voltageOut * 99.0 / 24.0, 3);
            }
        }
        return "-----" + type;
    }

    public static String[] icrDiagnosticStringArray(int rawValue, boolean shortString) {
        String[] s = new String[4];
        int i = 0;
        while (i < 4) {
            s[i] = "";
            int value = rawValue & 0x1F;
            int nameSpace = (rawValue >>= 5) & 7;
            s[i] = nameSpace == 0 ? String.valueOf(s[i]) + "-:--" : String.valueOf(nameSpace) + ":" + value;
            rawValue >>= 3;
            ++i;
        }
        return s;
    }

    public static String icrDiagnosticString(int rawValue, boolean shortString) {
        String[] s = ConversionLegacy.icrDiagnosticStringArray(rawValue, shortString);
        String result = "---";
        if (s[0] != null) {
            result = s[0];
        }
        int i = 1;
        while (i < s.length) {
            if (s[i] != null) {
                result = String.valueOf(result) + ", " + s[i];
            }
            ++i;
        }
        return result;
    }

    public static String icrCommandCountFox1E(int rawValue, boolean shortString) {
        String s = new String();
        if ((double)rawValue != 9999.0) {
            int hardwareCmds = rawValue & 0xFF;
            int softwareCmds = rawValue >> 8 & 0xFF;
            s = shortString ? String.valueOf(s) + "hw " + hardwareCmds + " " + "sw " + softwareCmds : String.valueOf(s) + "Number of Hardware Cmds: " + hardwareCmds + " " + " Software Cmds: " + softwareCmds;
        }
        return s;
    }

    public static String icrSwCommandCount(int rawValue, boolean shortString) {
        String s = new String();
        int timeMarker = rawValue & 1;
        int softwareCmds = rawValue >> 1 & 0xFFF;
        s = shortString ? String.valueOf(s) + " rtc:" + timeMarker + " sw:" + softwareCmds : String.valueOf(s) + " Reply Time Checking: " + timeMarker + " SW Cmds: " + softwareCmds;
        return s;
    }

    public static String icrCommandCount(int rawValue, boolean shortString) {
        String s = new String();
        if ((double)rawValue != 9999.0) {
            int hardwareCmds = rawValue & 0xFFF;
            String swCmds = ConversionLegacy.icrSwCommandCount(rawValue >> 12 & 0xFFF, shortString);
            s = shortString ? String.valueOf(s) + "hw:" + hardwareCmds + swCmds : String.valueOf(s) + "HW Cmds: " + hardwareCmds + swCmds;
        }
        return s;
    }

    public static String hardErrorString(int rawValue, boolean shortString) {
        String s = new String();
        if ((double)rawValue != 9999.0) {
            int watchDogReports = rawValue & 0x1FF;
            int errorCode = rawValue >> 9 & 0x1F;
            int mramErrorCount = rawValue >> 14 & 7;
            int nonFatalErrorCount = rawValue >> 17 & 7;
            int taskNumber = rawValue >> 20 & 0xF;
            int alignment = rawValue >> 24 & 0xFF;
            if (shortString) {
                s = String.valueOf(s) + "wd " + Integer.toHexString(watchDogReports) + " " + "ec " + Integer.toHexString(errorCode) + " " + "mr " + Integer.toHexString(mramErrorCount) + " " + "nf " + Integer.toHexString(nonFatalErrorCount) + " " + "tn " + Integer.toHexString(taskNumber) + " " + "al " + Integer.toHexString(alignment);
            } else {
                s = String.valueOf(s) + "Watchdog Reports: " + FoxBitStream.stringBitArray(FoxBitStream.intToBin9(watchDogReports)) + " ";
                s = errorCode < ihuErrorType.length ? String.valueOf(s) + " Error Type: " + ihuErrorType[errorCode] + " " : String.valueOf(s) + " Error Type: " + errorCode;
                s = String.valueOf(s) + " MRAM Error Count: " + Integer.toHexString(mramErrorCount) + " " + " Non Fatal Error Count: " + Integer.toHexString(nonFatalErrorCount) + " " + " Task Number: " + taskNumber + "- ";
                s = taskNumber < ihuTask.length ? String.valueOf(s) + ihuTask[taskNumber] : String.valueOf(s) + "Unknown";
                s = String.valueOf(s) + " Alignment: " + alignment;
            }
        }
        return s;
    }

    public static String[] hardErrorStringArray(int rawValue, boolean shortString) {
        String[] s = new String[6];
        if ((double)rawValue != 9999.0) {
            int watchDogReports = rawValue & 0x1FF;
            int errorCode = rawValue >> 9 & 0x1F;
            int mramErrorCount = rawValue >> 14 & 7;
            int nonFatalErrorCount = rawValue >> 17 & 7;
            int taskNumber = rawValue >> 20 & 0xF;
            int alignment = rawValue >> 24 & 0xFF;
            s[0] = "" + errorCode;
            if (errorCode < ihuErrorType.length) {
                s[0] = String.valueOf(s[0]) + " - " + ihuErrorType[errorCode];
            }
            s[1] = Integer.toHexString(alignment);
            s[2] = FoxBitStream.stringBitArray(FoxBitStream.intToBin9(watchDogReports));
            s[3] = String.valueOf(Integer.toHexString(taskNumber)) + " - ";
            s[3] = taskNumber < ihuTask.length ? String.valueOf(s[3]) + ihuTask[taskNumber] : String.valueOf(s[3]) + "Unknown";
            s[4] = Integer.toHexString(mramErrorCount);
            s[5] = Integer.toHexString(nonFatalErrorCount);
        }
        return s;
    }

    public static String[] isisAntennaStatusArray(int rawValue, boolean shortString) {
        String[] s = new String[16];
        if (rawValue == 9999) {
            int i = 0;
            while (i < s.length) {
                s[i] = "";
                ++i;
            }
            return s;
        }
        int ARM2 = rawValue & 1;
        int A4B = rawValue >> 1 & 1;
        int A4T = rawValue >> 2 & 1;
        int A4S = rawValue >> 3 & 1;
        int INDB = rawValue >> 4 & 1;
        int A3B = rawValue >> 5 & 1;
        int A3T = rawValue >> 6 & 1;
        int A3S = rawValue >> 7 & 1;
        int IG = rawValue >> 8 & 1;
        int A2B = rawValue >> 9 & 1;
        int A2T = rawValue >> 10 & 1;
        int A2S = rawValue >> 11 & 1;
        int zero = rawValue >> 12 & 1;
        int A1B = rawValue >> 13 & 1;
        int A1T = rawValue >> 14 & 1;
        int A1S = rawValue >> 15 & 1;
        if (shortString) {
            s[0] = ARM2 == 1 ? "ARM " : "";
            s[1] = INDB == 1 ? "BURN " : "";
            s[2] = IG == 1 ? "IG " : "";
            s[3] = A1S == 1 ? "N " : "Y ";
            s[4] = A2S == 1 ? "N " : "Y ";
            s[5] = A3S == 1 ? "N " : "Y ";
            s[6] = A4S == 1 ? "N " : "Y ";
        } else {
            s[0] = ARM2 == 1 ? "ARMED" : "NO";
            s[1] = INDB == 1 ? "ACT" : "NONE";
            s[2] = IG == 1 ? "YES" : "NO";
            s[3] = A1B == 1 ? "ACT" : "NOT ACT";
            s[4] = A1T == 1 ? "TIMEOUT" : "---";
            s[5] = A1S == 1 ? "NO" : "YES";
            s[6] = A2B == 1 ? "ACT" : "NOT ACT";
            s[7] = A2T == 1 ? "TIMEOUT" : "--";
            s[8] = A2S == 1 ? "NO" : "YES";
            s[9] = A3B == 1 ? "ACT" : "NOT ACT";
            s[10] = A3T == 1 ? "TIMEOUT" : "--";
            s[11] = A3S == 1 ? "NO" : "YES";
            s[12] = A4B == 1 ? "ACT" : "NOT ACT";
            s[13] = A4T == 1 ? "TIMEOUT" : "--";
            s[14] = A4S == 1 ? "NO" : "YES";
            s[15] = "" + zero;
        }
        return s;
    }

    public static String isisAntennaStatus(int rawValue, boolean shortString) {
        String[] s = ConversionLegacy.isisAntennaStatusArray(rawValue, shortString);
        String result = "---";
        if (s[0] != null) {
            result = s[0];
        }
        int i = 1;
        while (i < s.length) {
            if (s[i] != null) {
                result = String.valueOf(result) + s[i];
            }
            ++i;
        }
        return result;
    }

    public static String softErrorStringFox1A(int rawValue, boolean shortString) {
        String s = new String();
        if ((double)rawValue != 9999.0) {
            int DACoverflows = rawValue & 0xFF;
            int I2CRetries = rawValue >> 8 & 0xFF;
            int SPIRetries = rawValue >> 16 & 0xFF;
            int MramCRCs = rawValue >> 24 & 0xFF;
            s = shortString ? String.valueOf(s) + "dac " + DACoverflows + " i2c " + I2CRetries + " spi " + SPIRetries + " mr " + MramCRCs : String.valueOf(s) + "DAC Overflows: " + DACoverflows + "  I2C Retries: " + I2CRetries + "  SPI Retries: " + SPIRetries + "  MRAM CRCs: " + MramCRCs;
        }
        return s;
    }

    public static String softErrorString84488(int rawValue, boolean shortString) {
        String s = new String();
        if ((double)rawValue != 9999.0) {
            int DACoverflows = rawValue & 0xFF;
            int I2C1Retries = rawValue >> 8 & 0xF;
            int I2C2Retries = rawValue >> 12 & 0xF;
            int SPIRetries = rawValue >> 16 & 0xFF;
            int MramCRCs = rawValue >> 24 & 0xFF;
            s = shortString ? String.valueOf(s) + "dac " + DACoverflows + " i2c1 " + I2C1Retries + " i2c2 " + I2C2Retries + " spi " + SPIRetries + " mr " + MramCRCs : String.valueOf(s) + "DAC Overflows: " + DACoverflows + "  I2C1 Retries: " + I2C1Retries + "  I2C2 Retries: " + I2C2Retries + "  SPI Retries: " + SPIRetries + "  MRAM CRCs: " + MramCRCs;
        }
        return s;
    }

    public static String[] softErrorStringArrayFox1A(int rawValue, boolean shortString) {
        String[] s = new String[4];
        if ((double)rawValue != 9999.0) {
            int DACoverflows = rawValue & 0xFF;
            int I2CRetries = rawValue >> 8 & 0xFF;
            int SPIRetries = rawValue >> 16 & 0xFF;
            int MramCRCs = rawValue >> 24 & 0xFF;
            s[0] = Integer.toString(DACoverflows);
            s[1] = Integer.toString(I2CRetries);
            s[2] = Integer.toString(SPIRetries);
            s[3] = Integer.toString(MramCRCs);
        }
        return s;
    }

    public static String[] softErrorStringArray84488(int rawValue, boolean shortString) {
        String[] s = new String[5];
        if ((double)rawValue != 9999.0) {
            int DACoverflows = rawValue & 0xFF;
            int I2C1Retries = rawValue >> 4 & 0xF;
            int I2C2Retries = rawValue >> 4 & 0xF;
            int SPIRetries = rawValue >> 8 & 0xFF;
            int MramCRCs = rawValue >> 8 & 0xFF;
            s[0] = Integer.toString(DACoverflows);
            s[1] = Integer.toString(I2C1Retries);
            s[2] = Integer.toString(I2C2Retries);
            s[3] = Integer.toString(SPIRetries);
            s[4] = Integer.toString(MramCRCs);
        }
        return s;
    }
}

