/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SortedArrayList<T extends Comparable<T>>
extends ArrayList<T> {
    boolean deleteLock = false;

    public SortedArrayList(int i) {
        super(i);
    }

    public boolean addToEnd(T img) {
        if (img == null) {
            throw new NullPointerException("NULL INSERT ERROR");
        }
        return super.add(img);
    }

    public boolean OLDadd(T img) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (((Comparable)this.get(i)).compareTo(img) == 0) {
                return false;
            }
            if (((Comparable)this.get(i)).compareTo(img) > 0) {
                this.add(i + 1, img);
                return true;
            }
            --i;
        }
        this.add(0, img);
        return true;
    }

    @Override
    public synchronized boolean add(T img) throws NullPointerException {
        if (img == null) {
            return false;
        }
        this.deleteLock = true;
        try {
            int pos = 0;
            try {
                pos = Collections.binarySearch(this, img);
            }
            catch (NullPointerException e) {
                Log.println(">>> Null adding to SortedArrayList:\n" + img + " to list\n" + e.getStackTrace());
                Log.println("RECORDS:" + this.size());
                this.deleteLock = false;
                return false;
            }
            if (pos < 0) {
                this.add(-pos - 1, img);
                return true;
            }
            return false;
        }
        finally {
            this.deleteLock = false;
        }
    }

    @Override
    public synchronized T remove(int i) {
        while (this.deleteLock) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (T)((Comparable)super.remove(i));
    }

    @Override
    public synchronized void trimToSize() {
        while (this.deleteLock) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        super.trimToSize();
    }

    public boolean OLDaddSearchFromStart(T n) {
        int i = 0;
        while (i < this.size()) {
            if (((Comparable)this.get(i)).compareTo(n) < 0) {
                this.add(i, n);
                return true;
            }
            ++i;
        }
        this.add(this.size(), n);
        return true;
    }

    public void addAll(List<T> list) {
        ListIterator<T> i = list.listIterator();
        while (i.hasNext()) {
            this.add((T)((Comparable)i.next()));
        }
    }

    public void addAll(SortedArrayList<T> list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.add((T)((Comparable)i.next()));
        }
    }
}

