/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors.payload;

import common.Spacecraft;
import java.awt.Color;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import spacecraftEditor.listEditors.CsvFileEditPanel;
import spacecraftEditor.listEditors.payload.PayloadLayoutTableModel;
import telemetry.LayoutLoadException;

public class PayloadCsvFileEditPanel
extends CsvFileEditPanel {
    private static final long serialVersionUID = 1L;
    public static final int FIELD_COL = 2;
    public static final int BITS_COL = 3;
    public static final int CONVERSION_COL = 5;
    public static final int LINE_TYPE_COL = 9;
    public static final int MODULE_LINE_COL = 8;
    PayloadLayoutTableModel model;
    JLabel lblNumberOfBits;

    public PayloadCsvFileEditPanel(Spacecraft sat, final PayloadLayoutTableModel model, String titleString, String file) {
        super(sat, model, titleString, file, "csv");
        this.model = model;
        int i = 0;
        while (i < this.csvFileEditorGrid.table.getColumnModel().getColumnCount()) {
            TableColumn column = this.csvFileEditorGrid.table.getColumnModel().getColumn(i);
            column.setCellRenderer(new PayloadTableCellRenderer());
            ++i;
        }
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int rows = model.getRowCount();
                model.setValueAt(rows - 1, 0, 0);
            }
        });
        JPanel bitsPanel = new JPanel();
        this.footerFilePanel.add((Component)bitsPanel, "West");
        bitsPanel.add(new JLabel("Total Bits:"));
        this.lblNumberOfBits = new JLabel("0");
        bitsPanel.add(this.lblNumberOfBits);
    }

    @Override
    protected void load() throws FileNotFoundException, LayoutLoadException {
        super.load();
        this.updateNumberOfBits();
    }

    public void setConversionComboBox() {
        String[] conv = this.sat.getConversionsArray();
        JComboBox<String> comboBoxConversion = new JComboBox<String>(conv);
        TableColumn moduleColumn = this.csvFileEditorGrid.table.getColumnModel().getColumn(5);
        moduleColumn.setCellEditor(new DefaultCellEditor(comboBoxConversion));
    }

    private void updateNumberOfBits() {
        int num = 0;
        int i = 0;
        while (i < this.model.getRowCount()) {
            String value = (String)this.model.getValueAt(i, 3);
            try {
                int b = Integer.parseInt(value);
                num += b;
            }
            catch (NumberFormatException b) {
                // empty catch block
            }
            ++i;
        }
        double n = (double)num / 8.0;
        DecimalFormat fmt = new DecimalFormat("0.##");
        this.lblNumberOfBits.setText(num + "   Bytes: " + fmt.format(n));
    }

    @Override
    protected void updateSpacecraft() {
        this.updateNumberOfBits();
    }

    public class PayloadTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            String value;
            Component cell = super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            if (row > 0 && column == 5) {
                value = (String)PayloadCsvFileEditPanel.this.model.getValueAt(row, column);
                if (value != null) {
                    String[] conversions;
                    String[] stringArray = conversions = value.split("\\|");
                    int n = conversions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String conv = stringArray[n2];
                        if (!PayloadCsvFileEditPanel.this.sat.isValidConversion(conv)) {
                            cell.setForeground(Color.red);
                            return cell;
                        }
                        ++n2;
                    }
                }
                cell.setForeground(Color.black);
            }
            if (row > 0 && column == 2) {
                value = (String)PayloadCsvFileEditPanel.this.model.getValueAt(row, column);
                if (value != null) {
                    int i = 0;
                    while (i < PayloadCsvFileEditPanel.this.model.getRowCount()) {
                        if (i != row && value.equalsIgnoreCase((String)PayloadCsvFileEditPanel.this.model.getValueAt(i, column))) {
                            cell.setForeground(Color.red);
                            return cell;
                        }
                        ++i;
                    }
                }
                if (value != null && (value.equalsIgnoreCase("uptime") || value.equalsIgnoreCase("captureDate") || value.equalsIgnoreCase("id") || value.equalsIgnoreCase("resets") || value.equalsIgnoreCase("type"))) {
                    cell.setForeground(Color.red);
                    return cell;
                }
                cell.setForeground(Color.black);
            }
            if (row > 0) {
                // empty if block
            }
            return cell;
        }
    }
}

