/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.WrapLayout;
import gui.graph.LinePlotPanel;
import gui.tabs.DisplayModule;
import gui.tabs.FoxTelemTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import measure.PassMeasurement;
import measure.RtMeasurement;

public class MyMeasurementsTab
extends FoxTelemTab
implements Runnable,
ItemListener {
    DisplayModule satellite;
    DisplayModule passes;
    Spacecraft sat;
    RtMeasurement rtMeasurement;
    PassMeasurement passMeasurement;

    public MyMeasurementsTab(Spacecraft s) {
        this.sat = s;
        this.setLayout(new BorderLayout(0, 0));
        JPanel topPanel = new JPanel();
        topPanel.setMinimumSize(new Dimension(10, 50));
        this.add((Component)topPanel, "North");
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        JLabel lblId = new JLabel("Measurements captured at Ground Station " + Config.callsign);
        lblId.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        lblId.setForeground(this.textLblColor);
        topPanel.add(lblId);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new WrapLayout(3, 25, 25));
        JScrollPane scrollPane = new JScrollPane(centerPanel, 22, 31);
        this.add((Component)scrollPane, "Center");
        Spacecraft fox = this.sat;
        this.satellite = new DisplayModule(fox, fox.user_display_name, 9, null, 9, DisplayModule.vulcanFontColor);
        centerPanel.add(this.satellite);
        this.satellite.addName(1, "Bit Sig to Noise (-)", "BIT_SNR", 9);
        this.satellite.addName(2, "RF Sig to Noise (db)", "RF_SNR", 9);
        this.satellite.addName(3, "RF Power (dBm)", "RF_POWER", 9);
        this.satellite.addName(4, "Carrier Frequency (Hz)", "CARRIER_FREQ", 9);
        this.satellite.addName(5, "Azimuth (deg)", "AZ", 9);
        this.satellite.addName(6, "Elevation (deg)", "EL", 9);
        this.satellite.addName(7, "RS Errors", "ERRORS", 9);
        this.satellite.addName(8, "RS Erasures", "ERASURES", 9);
        this.passes = this.sat.hasFrameCrc ? new DisplayModule(fox, String.valueOf(fox.user_display_name) + " passes", 10, null, 10, DisplayModule.vulcanFontColor) : new DisplayModule(fox, String.valueOf(fox.user_display_name) + " passes", 9, null, 10, DisplayModule.vulcanFontColor);
        centerPanel.add(this.passes);
        this.passes.addName(1, "AOS", "AOS", 0);
        this.passes.addName(2, "TCA", "TCA", 0);
        this.passes.addName(3, "TCA Freq (Hz)", "TCA_FREQ", 0);
        this.passes.addName(4, "LOS", "LOS", 0);
        this.passes.addName(5, "Start Azimuth", "START_AZIMUTH", 0);
        this.passes.addName(6, "End Azimuth", "END_AZIMUTH", 0);
        this.passes.addName(7, "Max Elevation", "MAX_ELEVATION", 0);
        this.passes.addName(8, "Payloads Decoded", "TOTAL_PAYLOADS", 0);
        if (this.sat.hasFrameCrc) {
            this.passes.addName(9, "CRC Failures", "TOTAL_PAYLOADS", 0);
        }
        JPanel bottomPanel = new JPanel();
        this.add((Component)bottomPanel, "South");
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
    }

    public void showGraphs() {
        if (this.satellite != null) {
            this.satellite.showGraphs();
        }
        if (this.passes != null) {
            this.passes.showGraphs();
        }
    }

    @Override
    public void stopProcessing() {
        this.closeGraphs();
        super.stopProcessing();
    }

    public void openGraphs() {
        if (this.satellite != null) {
            this.satellite.openGraphs(-1);
        }
        if (this.passes != null) {
            this.passes.openGraphs(-2);
        }
    }

    public void closeGraphs() {
        if (this.satellite != null) {
            this.satellite.closeGraphs();
        }
        if (this.passes != null) {
            this.passes.closeGraphs();
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("MyMeasurementsTab");
        this.running = true;
        this.done = false;
        boolean justStarted = true;
        int currentRtFrames = 0;
        int currentPassFrames = 0;
        int frames = 0;
        while (this.running) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: Measurement thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (this.satellite != null && (frames = Config.payloadStore.getNumberOfMeasurements(this.sat.foxId)) != currentRtFrames) {
                currentRtFrames = frames;
                this.rtMeasurement = Config.payloadStore.getLatestMeasurement(this.sat.foxId);
                if (this.rtMeasurement != null) {
                    double snr = LinePlotPanel.roundToSignificantFigures(this.rtMeasurement.getRawValue("BIT_SNR"), 3);
                    this.satellite.updateSingleValue(1, Double.toString(snr));
                    double rfsnr = LinePlotPanel.roundToSignificantFigures(this.rtMeasurement.getRawValue("RF_SNR"), 3);
                    this.satellite.updateSingleValue(2, Double.toString(rfsnr));
                    double power = LinePlotPanel.roundToSignificantFigures(this.rtMeasurement.getRawValue("RF_POWER"), 3);
                    this.satellite.updateSingleValue(3, Double.toString(power));
                    long freq = (long)this.rtMeasurement.getRawValue("CARRIER_FREQ");
                    this.satellite.updateSingleValue(4, Long.toString(freq));
                    int az = (int)this.rtMeasurement.getRawValue("AZ");
                    this.satellite.updateSingleValue(5, Integer.toString(az));
                    int el = (int)this.rtMeasurement.getRawValue("EL");
                    this.satellite.updateSingleValue(6, Integer.toString(el));
                    int err = (int)this.rtMeasurement.getRawValue("ERRORS");
                    this.satellite.updateSingleValue(7, Integer.toString(err));
                    int erase = (int)this.rtMeasurement.getRawValue("ERASURES");
                    this.satellite.updateSingleValue(8, Integer.toString(erase));
                }
                Config.payloadStore.setUpdatedMeasurement(this.sat.foxId, false);
            }
            if (this.passes != null && (frames = Config.payloadStore.getNumberOfPassMeasurements(this.sat.foxId)) != currentPassFrames) {
                currentPassFrames = frames;
                this.passMeasurement = Config.payloadStore.getLatestPassMeasurement(this.sat.foxId);
                if (this.passMeasurement != null) {
                    this.passes.updateSingleValue(1, this.passMeasurement.getStringValue("AOS"));
                    this.passes.updateSingleValue(2, this.passMeasurement.getStringValue("TCA"));
                    this.passes.updateSingleValue(3, this.passMeasurement.getStringValue("TCA_FREQ"));
                    this.passes.updateSingleValue(4, this.passMeasurement.getStringValue("LOS"));
                    this.passes.updateSingleValue(5, this.passMeasurement.getStringValue("START_AZIMUTH"));
                    this.passes.updateSingleValue(6, this.passMeasurement.getStringValue("END_AZIMUTH"));
                    this.passes.updateSingleValue(7, this.passMeasurement.getStringValue("MAX_ELEVATION"));
                    this.passes.updateSingleValue(8, this.passMeasurement.getStringValue("TOTAL_PAYLOADS"));
                }
                Config.payloadStore.setUpdatedPassMeasurement(this.sat.foxId, false);
            }
            if (!justStarted) continue;
            this.openGraphs();
            justStarted = false;
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

