/*
 * Decompiled with CFR 0.152.
 */
package gui.legacyTabs;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import telemetry.legacyPayloads.CameraJpeg;

public class ImagePanel
extends JPanel {
    protected BufferedImage image;

    public ImagePanel() {
    }

    public ImagePanel(String filePath) {
        this.setImage(filePath);
    }

    public void setImage(String filePath) {
        try {
            this.image = ImageIO.read(new File(filePath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setBufferedImage(BufferedImage img) {
        this.image = img;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            BufferedImage display = this.image;
            if (this.getHeight() < this.image.getHeight() || this.getWidth() < this.image.getWidth()) {
                double ratio = (double)this.getHeight() / (double)this.image.getHeight();
                if ((double)this.image.getWidth() * ratio > (double)this.getWidth()) {
                    ratio = (double)this.getWidth() / (double)this.image.getWidth();
                }
                display = CameraJpeg.scale(this.image, ratio);
            }
            g.drawImage(display, 0, 0, null);
        }
    }
}

