/*
 * Decompiled with CFR 0.152.
 */
package gui.graph;

import common.Config;
import common.Spacecraft;
import gui.ProgressPanel;
import gui.graph.GraphFrame;
import gui.graph.MapPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import predict.PositionCalcException;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.conversion.Conversion;
import telemetry.conversion.ConversionStringLookUpTable;
import telemetry.legacyPayloads.RadiationPacket;
import uk.me.g4dpz.satellite.SatPos;

public abstract class GraphCanvas
extends MapPanel {
    Spacecraft fox;
    double[][][] graphData = null;
    double[][][] graphData2 = null;
    String title = "Test Graph";
    GraphFrame graphFrame;
    protected String conversion;
    boolean drawGraph2 = false;
    Color graphAxisColor = Color.BLACK;
    Color graphTextColor = Color.DARK_GRAY;
    int topBorder = Config.graphAxisFontSize * 2;
    int bottomBorder = (int)((double)Config.graphAxisFontSize * 2.5);
    int sideBorder = Config.graphAxisFontSize * 5;
    int sideLabelOffset = (int)((double)Config.graphAxisFontSize * 0.5);
    static int labelWidth = 6 * Config.graphAxisFontSize;
    static int labelHeight = (int)((double)Config.graphAxisFontSize * 1.4);
    protected static int MAX_TICKS = 4096 / labelWidth;
    int freqOffset = 0;
    Graphics2D g2;
    Graphics g;

    GraphCanvas(String t, GraphFrame gf, Spacecraft fox2) {
        this.title = t;
        this.graphFrame = gf;
        this.fox = fox2;
    }

    public void updateGraphData(BitArrayLayout lay, String by) {
        int showDialogThreshold = 999999;
        ProgressPanel fileProgress = null;
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress = new ProgressPanel(Config.mainWindow, "Loading Spacecraft data, please wait ...", false);
            fileProgress.setVisible(true);
        }
        int totalFields = this.graphFrame.fieldName.length;
        if (this.graphFrame.fieldName2 != null) {
            totalFields += this.graphFrame.fieldName2.length;
        }
        boolean reverse = false;
        this.graphData = new double[this.graphFrame.fieldName.length][][];
        int i = 0;
        while (i < this.graphFrame.fieldName.length) {
            if (this.graphFrame.SAMPLES > showDialogThreshold) {
                fileProgress.updateProgress(100 * i / totalFields);
            }
            if (this.graphFrame.showLatest == 0) {
                reverse = true;
            }
            boolean includePositionData = false;
            if (lay.isWOD() || lay.isWODExperiment()) {
                includePositionData = true;
            }
            this.graphData[i] = this.graphFrame.payloadType == -1 ? Config.payloadStore.getMeasurementGraphData(this.graphFrame.fieldName[i], this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, reverse) : (this.graphFrame.payloadType == -2 ? Config.payloadStore.getPassMeasurementGraphData(this.graphFrame.fieldName[i], this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, reverse) : Config.payloadStore.getGraphData(this.graphFrame.fieldName[i], this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, lay.name, includePositionData, reverse));
            if (this.graphFrame.plotType == 2) {
                this.graphData[i] = this.addPositionData(this.graphData[i]);
            }
            ++i;
        }
        this.graphData2 = null;
        if (this.graphFrame.fieldName2 != null && this.graphFrame.fieldName2.length > 0) {
            this.graphData2 = new double[this.graphFrame.fieldName2.length][][];
            i = 0;
            while (i < this.graphFrame.fieldName2.length) {
                if (this.graphFrame.SAMPLES > showDialogThreshold) {
                    fileProgress.updateProgress(100 * i + this.graphFrame.fieldName.length / totalFields);
                }
                this.graphData2[i] = this.graphFrame.payloadType == -1 ? Config.payloadStore.getMeasurementGraphData(this.graphFrame.fieldName2[i], this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, reverse) : (this.graphFrame.payloadType == -2 ? Config.payloadStore.getPassMeasurementGraphData(this.graphFrame.fieldName2[i], this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, reverse) : Config.payloadStore.getGraphData(this.graphFrame.fieldName2[i], this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, lay.name, false, reverse));
                ++i;
            }
            this.graphFrame.conversionType2 = this.graphFrame.layout.getIntConversionByName(this.graphFrame.fieldName2[0]);
            String conversion2name = this.graphFrame.layout.getConversionNameByName(this.graphFrame.fieldName2[0]);
            this.graphFrame.lastConversion2 = this.fox.getConversionByName(Conversion.getLastConversionInPipeline(conversion2name));
        }
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress.updateProgress(100);
        }
        if (this.graphData != null && this.graphData[0] != null) {
            this.repaint();
        }
    }

    private double[][] addPositionData(double[][] coreGraphData) {
        int showDialogThreshold = 9999;
        ProgressPanel fileProgress = null;
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress = new ProgressPanel(this.graphFrame, "Calculating Spacecraft positions, please wait ...", false);
            fileProgress.setVisible(true);
        }
        double[][] newGraphData = new double[5][];
        newGraphData[2] = coreGraphData[2];
        newGraphData[1] = coreGraphData[1];
        newGraphData[0] = coreGraphData[0];
        newGraphData[3] = new double[coreGraphData[2].length];
        newGraphData[4] = new double[coreGraphData[2].length];
        int i = 0;
        while (i < coreGraphData[2].length) {
            if (this.graphFrame.SAMPLES > showDialogThreshold) {
                fileProgress.updateProgress(100 * i / coreGraphData[2].length);
            }
            SatPos pos = null;
            double satLatitude = -997.0;
            double satLongitude = -997.0;
            try {
                pos = this.fox.getSatellitePosition((int)newGraphData[2][i], (long)newGraphData[1][i]);
                if (pos != null) {
                    satLatitude = FramePart.latRadToDeg(pos.getLatitude());
                    satLongitude = FramePart.lonRadToDeg(pos.getLongitude());
                }
            }
            catch (PositionCalcException e) {
                double cfr_ignored_0 = e.errorCode;
            }
            newGraphData[3][i] = satLatitude;
            newGraphData[4][i] = satLongitude;
            ++i;
        }
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress.updateProgress(100);
        }
        return newGraphData;
    }

    public boolean checkDataExists() {
        if (this.graphData == null) {
            return false;
        }
        if (this.graphData[0] == null) {
            return false;
        }
        if (this.graphData[0][0] == null) {
            return false;
        }
        if (this.graphData[0][0].length == 0) {
            return false;
        }
        if (this.graphData[0][2] == null) {
            return false;
        }
        if (this.graphData[0][1] == null) {
            return false;
        }
        this.drawGraph2 = true;
        if (this.graphData2 == null) {
            this.drawGraph2 = false;
        } else if (this.graphData2[0] == null) {
            this.drawGraph2 = false;
        } else if (this.graphData2[0][0] == null) {
            this.drawGraph2 = false;
        } else if (this.graphData2[0][0].length == 0) {
            this.drawGraph2 = false;
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        this.bottomBorder = this.graphFrame.showUTCtime && !this.graphFrame.hideUptime ? (int)((double)Config.graphAxisFontSize * 3.5) : (int)((double)Config.graphAxisFontSize * 2.5);
        this.g2 = (Graphics2D)gr;
        this.g = gr;
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
    }

    protected double[] plotVerticalAxis(int axisPosition, int graphHeight, int graphWidth, double[][][] graphData, boolean showHorizontalLines, String units, int conversionType, Conversion conversion) {
        int graphType = conversionType;
        String lastConv = "";
        if (conversion != null) {
            lastConv = Conversion.getLastConversionInPipeline(conversion.getName());
        }
        this.g2.drawLine(this.sideBorder + axisPosition, this.getHeight() - this.bottomBorder, this.sideBorder + axisPosition, this.topBorder);
        double maxValue = 0.0;
        double minValue = 9.9E100;
        boolean intStep = false;
        int j = 0;
        while (j < graphData.length) {
            int i = 0;
            while (i < graphData[j][0].length) {
                if (conversionType == 24 && graphData[j][0][i] == 9999.0) {
                    graphData[j][0][i] = 0.0;
                }
                if (graphData[j][0][i] >= maxValue) {
                    maxValue = graphData[j][0][i];
                }
                if (graphData[j][0][i] <= minValue) {
                    minValue = graphData[j][0][i];
                }
                ++i;
            }
            ++j;
        }
        if (maxValue == minValue) {
            maxValue = graphType == 1 || lastConv.equalsIgnoreCase("INT") ? (maxValue += 10.0) : (maxValue += 1.0);
        }
        if (conversion != null && conversion instanceof ConversionStringLookUpTable) {
            intStep = true;
            ConversionStringLookUpTable cslt = (ConversionStringLookUpTable)conversion;
            maxValue = cslt.getMaxKey() + 1;
            minValue = cslt.getMinKey();
        }
        if (graphType == 12) {
            maxValue = 8.0;
            minValue = -8.0;
        }
        if (graphType == 27) {
            maxValue = 5.0;
            minValue = 0.0;
        }
        if (graphType == 16 || graphType == 44 || graphType == 17 || graphType == 21) {
            maxValue = 2.0;
            minValue = 0.0;
        }
        if (graphType == 26) {
            maxValue -= (double)this.freqOffset;
            minValue -= (double)this.freqOffset;
        }
        if (this.graphFrame.plotDerivative) {
            if (minValue > 0.0) {
                minValue = maxValue * -0.1;
            }
            if (maxValue < 0.0) {
                maxValue = minValue * -0.1;
            }
        }
        maxValue = maxValue < 0.0 ? (maxValue -= maxValue * 0.2) : (maxValue += maxValue * 0.2);
        minValue = minValue < 0.0 ? (minValue += minValue * 0.2) : (minValue -= minValue * 0.2);
        int numberOfLabels = graphHeight / labelHeight;
        if (graphType == 1 || graphType == 27 || graphType == 16 || graphType == 44 || graphType == 21 || graphType == 17) {
            intStep = true;
        }
        if (Config.displayRawValues) {
            intStep = true;
        }
        double[] labels = GraphCanvas.calcAxisInterval(minValue, maxValue, numberOfLabels, intStep);
        numberOfLabels = labels.length;
        boolean foundZeroPoint = false;
        int zeroPoint = graphHeight + this.topBorder;
        DecimalFormat f1 = new DecimalFormat("0.0");
        DecimalFormat f3 = new DecimalFormat("0.00");
        DecimalFormat f2 = new DecimalFormat("0");
        int fudge = 0;
        if (axisPosition > 0) {
            fudge = this.sideBorder + Config.graphAxisFontSize;
        }
        this.g2.setColor(this.graphTextColor);
        if (Config.displayRawValues) {
            this.g2.drawString("(RAW)", fudge + axisPosition + this.sideLabelOffset, this.topBorder - Config.graphAxisFontSize / 2);
        } else {
            this.g2.drawString("(" + units + ")", fudge + axisPosition + this.sideLabelOffset, this.topBorder - Config.graphAxisFontSize / 2);
        }
        int v = 0;
        while (v < numberOfLabels) {
            int pos = GraphCanvas.getRatioPosition(minValue, maxValue, labels[v], graphHeight);
            pos = graphHeight - pos;
            String s = null;
            s = labels[v] == (double)Math.round(labels[v]) ? f2.format(labels[v]) : (f1.format(labels[v]).equalsIgnoreCase("" + labels[v]) ? f1.format(labels[v]) : f3.format(labels[v]));
            boolean drawLabel = true;
            if (!(v >= numberOfLabels || axisPosition == 0 && (labels[v] == 0.0 || v < numberOfLabels - 1 && labels[v + 1] == 0.0) || v == 0 && pos > graphHeight)) {
                if (!Config.displayRawValues) {
                    if (conversion != null && conversion instanceof ConversionStringLookUpTable) {
                        ConversionStringLookUpTable cslt = (ConversionStringLookUpTable)conversion;
                        s = cslt.calculateString(labels[v] - 1.0);
                        int width = this.g.getFontMetrics().stringWidth(s);
                        if (width > this.sideBorder - this.sideLabelOffset) {
                            int len = s.length() - 1;
                            while (width > this.sideBorder - this.sideLabelOffset) {
                                s = s.substring(0, len--);
                                width = this.g.getFontMetrics().stringWidth(s);
                            }
                        }
                        drawLabel = !s.equalsIgnoreCase("UNK");
                    }
                    if (graphType == 16) {
                        drawLabel = false;
                        if (labels[v] == 1.0) {
                            s = "STWD";
                            drawLabel = true;
                        }
                        if (labels[v] == 2.0) {
                            s = "DEP";
                            drawLabel = true;
                        }
                    }
                    if (graphType == 17) {
                        drawLabel = false;
                        if (labels[v] == 1.0) {
                            s = "OK";
                            drawLabel = true;
                        }
                        if (labels[v] == 2.0) {
                            s = "FAIL";
                            drawLabel = true;
                        }
                    }
                    if (graphType == 27) {
                        drawLabel = false;
                        if (labels[v] == 1.0) {
                            s = RadiationPacket.radPacketStateShort[0];
                            drawLabel = true;
                        }
                        if (labels[v] == 2.0) {
                            s = RadiationPacket.radPacketStateShort[1];
                            drawLabel = true;
                        }
                        if (labels[v] == 3.0) {
                            s = RadiationPacket.radPacketStateShort[2];
                            drawLabel = true;
                        }
                        if (labels[v] == 4.0) {
                            s = RadiationPacket.radPacketStateShort[3];
                            drawLabel = true;
                        }
                        if (labels[v] == 5.0) {
                            s = RadiationPacket.radPacketStateShort[4];
                            drawLabel = true;
                        }
                    }
                    if (graphType == 44) {
                        drawLabel = false;
                        if (labels[v] == 2.0) {
                            s = "Enabled";
                            drawLabel = true;
                        }
                        if (labels[v] == 1.0) {
                            s = "Disabled";
                            drawLabel = true;
                        }
                    }
                    if (graphType == 21) {
                        drawLabel = false;
                        if (labels[v] == 2.0) {
                            s = "TRUE";
                            drawLabel = true;
                        }
                        if (labels[v] == 1.0) {
                            s = "FALSE";
                            drawLabel = true;
                        }
                    }
                }
                if (drawLabel && pos > 0 && pos < graphHeight - Config.graphAxisFontSize / 2) {
                    this.g2.setColor(this.graphTextColor);
                    this.g2.drawString(s, fudge + axisPosition + this.sideLabelOffset, pos + this.topBorder + Config.graphAxisFontSize / 2);
                    this.g2.setColor(this.graphAxisColor);
                    if (showHorizontalLines) {
                        this.g2.setColor(Color.GRAY);
                        this.g2.drawLine(this.sideBorder - 5, pos + this.topBorder, graphWidth + this.sideBorder, pos + this.topBorder);
                        this.g2.setColor(this.graphTextColor);
                    } else {
                        this.g.drawLine(this.sideBorder + axisPosition - 5, pos + this.topBorder, this.sideBorder + axisPosition + 5, pos + this.topBorder);
                    }
                }
            }
            if (!foundZeroPoint && labels[v] >= 0.0) {
                foundZeroPoint = true;
                zeroPoint = v == 0 ? graphHeight + this.topBorder : pos + this.topBorder;
            }
            ++v;
        }
        double[] axisPoint = new double[]{zeroPoint, minValue, maxValue};
        return axisPoint;
    }

    public static double[] calcAxisInterval(double min, double max, int ticks, boolean intStep) {
        double range = max - min;
        if (ticks == 0) {
            ticks = 1;
        }
        double step = 0.0;
        step = GraphCanvas.getStep(range, ticks, intStep);
        ticks = (int)Math.ceil(range / step);
        double startValue = GraphCanvas.roundToSignificantFigures((double)Math.round(min / step) * step, 6);
        if (ticks > MAX_TICKS) {
            ticks = MAX_TICKS;
            step = GraphCanvas.getStep(range, ticks, intStep);
        }
        if (ticks < 0) {
            ticks = 1;
            step = GraphCanvas.getStep(range, ticks, intStep);
        }
        double[] tickList = new double[ticks];
        if (ticks == 1) {
            tickList[0] = startValue;
        } else if (ticks == 2) {
            double midValue = GraphCanvas.roundToSignificantFigures(startValue + step, 6);
            tickList[0] = startValue;
            tickList[1] = midValue;
        } else if (ticks > 0) {
            tickList[0] = startValue;
        }
        int i = 1;
        while (i < ticks) {
            tickList[i] = startValue = GraphCanvas.roundToSignificantFigures(startValue + step, 6);
            ++i;
        }
        return tickList;
    }

    private static double getStep(double range, int ticks, boolean intStep) {
        double step = 0.0;
        if (!intStep && range / (double)ticks <= 0.01) {
            step = 0.01;
        } else if (!intStep && range / (double)ticks <= 0.1) {
            step = 0.1;
        } else if (!intStep && range / (double)ticks <= 0.2) {
            step = 0.2;
        } else if (!intStep && range / (double)ticks <= 0.25) {
            step = 0.25;
        } else if (!intStep && range / (double)ticks <= 0.33) {
            step = 0.33;
        } else if (!intStep && range / (double)ticks <= 0.5) {
            step = 0.5;
        } else if (range / (double)ticks <= 1.0) {
            step = 1.0;
        } else if (range / (double)ticks <= 2.0) {
            step = 2.0;
        } else if (!intStep && range / (double)ticks <= 2.5) {
            step = 2.5;
        } else if (!intStep && range / (double)ticks <= 3.3) {
            step = 3.33;
        } else if (range / (double)ticks <= 5.0) {
            step = 5.0;
        } else if (range / (double)ticks <= 10.0) {
            step = 10.0;
        } else if (range / (double)ticks <= 25.0) {
            step = 25.0;
        } else if (!intStep && range / (double)ticks <= 33.0) {
            step = 33.33;
        } else if (range / (double)ticks <= 50.0) {
            step = 50.0;
        } else if (range / (double)ticks <= 100.0) {
            step = 100.0;
        } else if (range / (double)ticks <= 200.0) {
            step = 200.0;
        } else if (range / (double)ticks <= 250.0) {
            step = 250.0;
        } else if (!intStep && range / (double)ticks <= 333.0) {
            step = 333.33;
        } else if (range / (double)ticks <= 500.0) {
            step = 500.0;
        } else if (range / (double)ticks <= 1000.0) {
            step = 1000.0;
        } else if (range / (double)ticks <= 2000.0) {
            step = 2000.0;
        } else if (range / (double)ticks <= 2500.0) {
            step = 2500.0;
        } else if (!intStep && range / (double)ticks <= 3333.0) {
            step = 3333.33;
        } else if (range / (double)ticks <= 5000.0) {
            step = 5000.0;
        } else if (range / (double)ticks <= 10000.0) {
            step = 10000.0;
        } else if (range / (double)ticks <= 20000.0) {
            step = 20000.0;
        } else if (range / (double)ticks <= 25000.0) {
            step = 25000.0;
        } else if (!intStep && range / (double)ticks <= 33333.0) {
            step = 33333.33;
        } else if (range / (double)ticks <= 50000.0) {
            step = 50000.0;
        } else if (range / (double)ticks <= 100000.0) {
            step = 100000.0;
        } else if (range / (double)ticks <= 250000.0) {
            step = 250000.0;
        } else if (!intStep && range / (double)ticks <= 333333.0) {
            step = 333333.33;
        } else if (range / (double)ticks <= 500000.0) {
            step = 500000.0;
        } else if (range / (double)ticks <= 1000000.0) {
            step = 1000000.0;
        } else if (range / (double)ticks <= 2000000.0) {
            step = 2000000.0;
        } else if (range / (double)ticks <= 2500000.0) {
            step = 2500000.0;
        } else if (!intStep && range / (double)ticks <= 3333333.0) {
            step = 3333333.33;
        } else if (range / (double)ticks <= 5000000.0) {
            step = 5000000.0;
        } else if (range / (double)ticks <= 1.0E7) {
            step = 1.0E7;
        }
        return step;
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public static int getRatioPosition(double min, double max, double value, int dimension) {
        if (max == min) {
            return 0;
        }
        double ratio = (max - value) / (max - min);
        int position = (int)Math.round((double)dimension * ratio);
        return dimension - position;
    }
}

