/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.DesktopApi;
import common.Log;
import common.Spacecraft;
import common.UpdateManager;
import decoder.SourceSoundCardAudio;
import gui.HelpAbout;
import gui.ProgressPanel;
import gui.ServerDownloadDialog;
import gui.SettingsFrame;
import gui.SourceTab;
import gui.SpacecraftFrame;
import gui.SpacecraftTab;
import gui.graph.LinePlotPanel;
import gui.uw.UwExperimentTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.SatPayloadStore;
import telemetry.SortedFramePartArrayList;
import telemetry.uw.UwCanPacket;

public class MainWindow
extends JFrame
implements ActionListener,
ItemListener,
WindowListener,
WindowStateListener {
    static UpdateManager updateManager;
    Thread updateManagerThread;
    public static JFrame frame;
    SourceSoundCardAudio audioSource;
    JMenuItem mntmExit;
    static JMenuItem mntmLoadWavFile;
    static JMenuItem mntmImportStp;
    static JMenuItem mntmGetServerData;
    static JMenuItem mntmLoadIQWavFile;
    static JMenuItem mntmStartDecoder;
    static JMenuItem mntmStopDecoder;
    static JMenuItem[] mntmSat;
    static ArrayList<Spacecraft> sats;
    JFileChooser fc = null;
    FileDialog fd = null;
    JMenu mnSats;
    JMenuBar menuBar;
    JMenuItem mntmSettings;
    static JMenuItem mntmDelete;
    JMenu mnHelp;
    JMenuItem mntmManual;
    JMenuItem mntmLeaderboard;
    JMenuItem mntmSoftware;
    JMenuItem mntmAbout;
    JMenuItem mntmSatAdd;
    JMenuItem mntmSatLoadKeps;
    JMenuItem mntmSatRemove;
    JCheckBoxMenuItem chckbxmntmShowDecoderOptions;
    JCheckBoxMenuItem chckbxmntmShowAudioOptions;
    JCheckBoxMenuItem chckbxmntmShowSatOptions;
    JCheckBoxMenuItem chckbxmntmShowEye;
    JCheckBoxMenuItem chckbxmntmShowPhasor;
    JCheckBoxMenuItem chckbxmntmShowFFT;
    JCheckBoxMenuItem chckbxmntmShowSourceOptions;
    static JPanel bottomPanel;
    static JTabbedPane tabbedPane;
    public static SourceTab inputTab;
    Thread inputTabThread;
    static SpacecraftTab[] spacecraftTab;
    JLabel lblVersion;
    static JLabel lblLogFileDir;
    static JLabel lblAudioMissed;
    static JLabel lblUsbErrors;
    static JLabel lblTotalFrames;
    static JLabel lblTotalDecodes;
    static JLabel lblTotalQueued;
    static JLabel lblLocalQueued;
    private static String TOTAL_RECEIVED_FRAMES;
    private static String TOTAL_DECODES;
    private static String TOTAL_QUEUED;
    private static String LOCAL_QUEUED;
    private static String AUDIO_MISSED;
    private static String USB_ERRORS;
    private static int totalMissed;
    ProgressPanel importProgress;
    public static int usbFatalErrorCount;

    static {
        TOTAL_RECEIVED_FRAMES = "Frames: ";
        TOTAL_DECODES = "Payloads: ";
        TOTAL_QUEUED = "Queue: ";
        LOCAL_QUEUED = "/ ";
        AUDIO_MISSED = "Audio missed: ";
        USB_ERRORS = "SDR Errors: ";
    }

    public MainWindow() {
        frame = this;
        frame.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.initMenu();
        tabbedPane = new JTabbedPane(1);
        tabbedPane.setTabLayoutPolicy(1);
        this.getContentPane().add(tabbedPane);
        inputTab = new SourceTab(this);
        inputTab.setBorder(new EmptyBorder(5, 5, 5, 5));
        tabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>Input</body></html>", inputTab);
        bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        bottomPanel.setLayout(new BorderLayout());
        JPanel rightBottom = new JPanel();
        rightBottom.setLayout(new BoxLayout(rightBottom, 0));
        this.lblVersion = new JLabel("Version " + Config.VERSION);
        this.lblVersion.setFont(new Font("SansSerif", 1, (int)(0.9f * this.lblVersion.getFont().getSize2D())));
        Font footerFont = this.lblVersion.getFont();
        this.lblVersion.setBorder(new EmptyBorder(2, 10, 2, 10));
        bottomPanel.add((Component)this.lblVersion, "West");
        lblLogFileDir = Config.logFileDirectory.equals("") ? new JLabel("Logs: Current Directory") : new JLabel("Logs: " + Config.logFileDirectory);
        lblLogFileDir.setFont(footerFont);
        lblLogFileDir.setBorder(new EmptyBorder(2, 10, 2, 10));
        bottomPanel.add((Component)lblLogFileDir, "Center");
        lblUsbErrors = new JLabel(String.valueOf(USB_ERRORS) + "0 / 0");
        lblUsbErrors.setFont(footerFont);
        lblUsbErrors.setBorder(new EmptyBorder(2, 2, 2, 10));
        lblUsbErrors.setToolTipText("The number of USB fatal errors/errors reading or writing to the SDR Control Interface");
        rightBottom.add(lblUsbErrors);
        usbFatalErrorCount = 0;
        lblAudioMissed = new JLabel(String.valueOf(AUDIO_MISSED) + "0.0% / 0");
        lblAudioMissed.setFont(footerFont);
        lblAudioMissed.setBorder(new EmptyBorder(2, 2, 2, 10));
        lblAudioMissed.setToolTipText("The number of audio buffers missed");
        rightBottom.add(lblAudioMissed);
        lblTotalFrames = new JLabel(TOTAL_RECEIVED_FRAMES);
        lblTotalFrames.setFont(footerFont);
        lblTotalFrames.setBorder(new EmptyBorder(2, 2, 2, 10));
        lblTotalFrames.setToolTipText("Total number of frames received since FoxTelem restart (including duplicates)");
        rightBottom.add(lblTotalFrames);
        lblTotalDecodes = new JLabel(TOTAL_DECODES);
        lblTotalDecodes.setFont(footerFont);
        lblTotalDecodes.setBorder(new EmptyBorder(2, 2, 2, 10));
        lblTotalDecodes.setToolTipText("Total number of unique payloads decoded from all satellites");
        rightBottom.add(lblTotalDecodes);
        lblTotalQueued = new JLabel(TOTAL_QUEUED);
        lblTotalQueued.setFont(footerFont);
        lblTotalQueued.setBorder(new EmptyBorder(2, 2, 2, 2));
        lblTotalQueued.setToolTipText("The number of frames that need to be sent to the Amsat / Local telemetry servers");
        rightBottom.add(lblTotalQueued);
        bottomPanel.add((Component)rightBottom, "East");
        lblLocalQueued = new JLabel("");
        lblLocalQueued.setFont(footerFont);
        lblLocalQueued.setBorder(new EmptyBorder(2, 2, 2, 10));
        lblLocalQueued.setToolTipText("The number of payloads that need to be sent to the Local telemetry server");
        rightBottom.add(lblLocalQueued);
        MainWindow.addHealthTabs();
        this.initialize();
        updateManager = new UpdateManager(false);
        this.updateManagerThread = new Thread(updateManager);
        this.updateManagerThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.updateManagerThread.start();
        this.inputTabThread = new Thread(inputTab);
        this.inputTabThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.inputTabThread.start();
        this.fd = new FileDialog((Frame)frame, "Select Spacecraft file", 0);
        this.fc = new JFileChooser();
        Config.fileProgress.updateProgress(100);
    }

    public static void enableSourceSelection(boolean t) {
        mntmLoadWavFile.setEnabled(t);
        mntmImportStp.setEnabled(t);
        mntmDelete.setEnabled(t);
        mntmGetServerData.setEnabled(t);
    }

    public static void showGraphs() {
        SpacecraftTab[] spacecraftTabArray = spacecraftTab;
        int n = spacecraftTab.length;
        int n2 = 0;
        while (n2 < n) {
            SpacecraftTab tab = spacecraftTabArray[n2];
            tab.showGraphs();
            ++n2;
        }
        frame.toFront();
    }

    public static void refreshTabs(boolean closeGraphs) {
        ProgressPanel fileProgress = new ProgressPanel(Config.mainWindow, "Refreshing tabs, please wait ...", false);
        fileProgress.setVisible(true);
        MainWindow.removeTabs();
        Config.payloadStore.setUpdatedAll();
        MainWindow.addHealthTabs();
        if (Config.logFileDirectory.equals("")) {
            lblLogFileDir.setText("Logs: Current Directory");
        } else {
            lblLogFileDir.setText("Logs: " + Config.logFileDirectory);
        }
        MainWindow.inputTab.audioGraph.updateFont();
        MainWindow.inputTab.eyePanel.updateFont();
        MainWindow.setTotalDecodes();
        fileProgress.updateProgress(100);
    }

    public static void removeTabs() {
        if (spacecraftTab != null) {
            int s = 0;
            while (s < spacecraftTab.length) {
                spacecraftTab[s].stop();
                tabbedPane.remove(spacecraftTab[s]);
                MainWindow.spacecraftTab[s] = null;
                ++s;
            }
        }
        spacecraftTab = null;
    }

    public static void addHealthTabs() {
        sats = Config.satManager.getSpacecraftList();
        spacecraftTab = new SpacecraftTab[sats.size()];
        int s = 0;
        while (s < sats.size()) {
            MainWindow.spacecraftTab[s] = new SpacecraftTab(sats.get(s));
            tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>" + sats.get(s).toString() + "</b></body></html>", spacecraftTab[s]);
            ++s;
        }
    }

    public static void setUsbErrors(int fatalErrors, int errors) {
        usbFatalErrorCount = fatalErrors;
        if (lblUsbErrors != null) {
            lblUsbErrors.setText(String.valueOf(USB_ERRORS) + fatalErrors + " / " + errors);
            if (fatalErrors > 0) {
                lblUsbErrors.setForeground(Color.RED);
            } else {
                lblUsbErrors.setForeground(Color.BLACK);
            }
            lblUsbErrors.invalidate();
            bottomPanel.validate();
        }
    }

    public static void setAudioMissed(int missed) {
        if (lblAudioMissed != null) {
            double miss = (double)missed / 10.0;
            lblAudioMissed.setText(String.valueOf(AUDIO_MISSED) + LinePlotPanel.roundToSignificantFigures(miss, 2) + "% / " + (totalMissed += missed));
            if (missed > 2) {
                lblAudioMissed.setForeground(Color.RED);
            } else {
                lblAudioMissed.setForeground(Color.BLACK);
            }
            lblAudioMissed.invalidate();
            bottomPanel.validate();
        }
    }

    public static void setTotalDecodes() {
        if (lblTotalDecodes != null) {
            int total = 0;
            total = Config.payloadStore.getTotalNumberOfFrames();
            lblTotalDecodes.setText(String.valueOf(TOTAL_DECODES) + total);
            lblTotalFrames.invalidate();
        }
        if (lblTotalFrames != null) {
            lblTotalFrames.setText(String.valueOf(TOTAL_RECEIVED_FRAMES) + Config.totalFrames);
            lblTotalFrames.invalidate();
        }
        bottomPanel.validate();
    }

    public static void setTotalQueued(int total) {
        if (lblTotalQueued != null) {
            lblTotalQueued.setText(String.valueOf(TOTAL_QUEUED) + total);
            lblTotalQueued.invalidate();
            bottomPanel.validate();
        }
    }

    public static void setLocalQueued(int localTotal) {
        if (lblLocalQueued != null) {
            lblLocalQueued.setText(String.valueOf(LOCAL_QUEUED) + localTotal);
            lblLocalQueued.invalidate();
            bottomPanel.validate();
        }
    }

    private void initialize() {
        this.setBounds(Config.windowX, Config.windowY, Config.windowWidth, Config.windowHeight);
        this.setDefaultCloseOperation(0);
        this.setTitle("AMSAT Telemetry Analysis Tool ");
        this.addWindowListener(this);
        this.addWindowStateListener(this);
    }

    private void initMenu() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu mnFile = new JMenu("File");
        this.menuBar.add(mnFile);
        mntmDelete = new JMenuItem("Delete Payload Files");
        mnFile.add(mntmDelete);
        mntmDelete.addActionListener(this);
        mnFile.addSeparator();
        mntmLoadWavFile = new JMenuItem("Load Wav File");
        mnFile.add(mntmLoadWavFile);
        mntmLoadWavFile.addActionListener(this);
        String dir = "stp";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator + dir;
        }
        mntmImportStp = new JMenuItem("Import STP");
        mnFile.add(mntmImportStp);
        File aFile = new File(dir);
        if (aFile.isDirectory()) {
            mntmImportStp.setVisible(true);
            mntmImportStp.addActionListener(this);
        } else {
            mntmImportStp.setVisible(false);
        }
        mntmGetServerData = new JMenuItem("Fetch Server Data");
        mnFile.add(mntmGetServerData);
        mntmGetServerData.addActionListener(this);
        mnFile.addSeparator();
        this.mntmSettings = new JMenuItem("Settings");
        mnFile.add(this.mntmSettings);
        this.mntmSettings.addActionListener(this);
        mnFile.addSeparator();
        this.mntmExit = new JMenuItem("Exit");
        mnFile.add(this.mntmExit);
        this.mntmExit.addActionListener(this);
        JMenu mnDecoder = new JMenu("Decoder");
        this.menuBar.add(mnDecoder);
        mntmStartDecoder = new JMenuItem("Start/Stop");
        mnDecoder.add(mntmStartDecoder);
        mntmStartDecoder.addActionListener(this);
        this.initSatMenu();
        this.chckbxmntmShowAudioOptions = new JCheckBoxMenuItem("Show Audio Options");
        this.chckbxmntmShowAudioOptions.addActionListener(this);
        mnDecoder.add(this.chckbxmntmShowAudioOptions);
        this.chckbxmntmShowAudioOptions.setState(Config.showAudioOptions);
        this.chckbxmntmShowSourceOptions = new JCheckBoxMenuItem("Show Source");
        this.chckbxmntmShowSourceOptions.addActionListener(this);
        mnDecoder.add(this.chckbxmntmShowSourceOptions);
        this.chckbxmntmShowSourceOptions.setState(Config.showSourceOptions);
        this.chckbxmntmShowSatOptions = new JCheckBoxMenuItem("Show Sat Status");
        this.chckbxmntmShowSatOptions.addActionListener(this);
        mnDecoder.add(this.chckbxmntmShowSatOptions);
        this.chckbxmntmShowSatOptions.setState(Config.showSatOptions);
        this.chckbxmntmShowEye = new JCheckBoxMenuItem("Show Eye");
        this.chckbxmntmShowEye.addActionListener(this);
        mnDecoder.add(this.chckbxmntmShowEye);
        this.chckbxmntmShowEye.setState(Config.showEye);
        this.chckbxmntmShowPhasor = new JCheckBoxMenuItem("Show Phasor");
        this.chckbxmntmShowPhasor.addActionListener(this);
        mnDecoder.add(this.chckbxmntmShowPhasor);
        this.chckbxmntmShowPhasor.setState(Config.showPhasor);
        this.chckbxmntmShowFFT = new JCheckBoxMenuItem("Show FFT");
        this.chckbxmntmShowFFT.addActionListener(this);
        mnDecoder.add(this.chckbxmntmShowFFT);
        this.chckbxmntmShowFFT.setState(Config.showFFT);
        this.mnHelp = new JMenu("Help");
        this.menuBar.add(this.mnHelp);
        this.mntmManual = new JMenuItem("Open Manual");
        this.mnHelp.add(this.mntmManual);
        this.mntmManual.addActionListener(this);
        this.mntmLeaderboard = new JMenuItem("View Fox Server Leaderboard");
        this.mnHelp.add(this.mntmLeaderboard);
        this.mntmLeaderboard.addActionListener(this);
        this.mntmAbout = new JMenuItem("About FoxTelem");
        this.mnHelp.add(this.mntmAbout);
        this.mntmAbout.addActionListener(this);
    }

    public void setAudioSource(SourceSoundCardAudio a) {
        this.audioSource = a;
    }

    void initSatMenu() {
        int i;
        if (this.mnHelp != null) {
            this.menuBar.remove(this.mnHelp);
        }
        if (sats != null && this.mnSats != null) {
            i = 0;
            while (i < sats.size()) {
                if (mntmSat[i] != null) {
                    this.mnSats.remove(mntmSat[i]);
                }
                MainWindow.mntmSat[i] = null;
                ++i;
            }
            this.menuBar.remove(this.mnSats);
        }
        this.mnSats = new JMenu("Spacecraft");
        this.menuBar.add(this.mnSats);
        this.mntmSatLoadKeps = new JMenuItem("Update KEPs");
        this.mnSats.add(this.mntmSatLoadKeps);
        this.mntmSatLoadKeps.addActionListener(this);
        this.mnSats.addSeparator();
        this.mntmSatAdd = new JMenuItem("Add");
        this.mnSats.add(this.mntmSatAdd);
        this.mntmSatAdd.addActionListener(this);
        this.mntmSatRemove = new JMenuItem("Remove");
        this.mnSats.add(this.mntmSatRemove);
        this.mntmSatRemove.addActionListener(this);
        this.mnSats.addSeparator();
        sats = Config.satManager.getSpacecraftList();
        mntmSat = new JMenuItem[sats.size()];
        i = 0;
        while (i < sats.size()) {
            MainWindow.mntmSat[i] = new JMenuItem(MainWindow.sats.get((int)i).user_display_name);
            this.mnSats.add(mntmSat[i]);
            mntmSat[i].addActionListener(this);
            ++i;
        }
        if (this.mnHelp != null) {
            this.menuBar.add(this.mnHelp);
        }
    }

    public void shutdownWindow() {
        if (Config.passManager.getState() == 5 || Config.passManager.getState() == 4) {
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(frame, "The pass manager is still processing a satellite pass. If the satellite has\nfaded it waits 2 minutes in case contact is re-established, even when it is at the\nhorizon.  If you exit now the LOS will not be logged and TCA will not be calculated.\nDo you want to exit?", "Exit while pass in progress?", 0, 3, null, options, options[1]);
            if (n != 1) {
                this.shutdown();
            }
        } else {
            this.shutdown();
        }
    }

    private void shutdown() {
        if (Config.satPC != null) {
            Config.satPC.disconnect();
        }
        int s = 0;
        while (s < spacecraftTab.length) {
            spacecraftTab[s].closeGraphs();
            ++s;
        }
        inputTab.shutdown();
        Log.println("Window Closed");
        Log.close();
        this.saveProperties();
        this.dispose();
        System.exit(0);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.shutdownWindow();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.shutdownWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] options;
        int n;
        if (e.getSource() == this.mntmExit) {
            this.windowClosed(null);
        }
        if (e.getSource() == mntmLoadWavFile) {
            inputTab.chooseFile();
        }
        if (e.getSource() == mntmGetServerData) {
            this.replaceServerData();
        }
        if (e.getSource() == mntmLoadIQWavFile) {
            inputTab.chooseIQFile();
        }
        if (e.getSource() == mntmStartDecoder) {
            MainWindow.inputTab.btnStartButton.doClick();
        }
        if (e.getSource() == mntmStopDecoder) {
            MainWindow.inputTab.btnStartButton.doClick();
        }
        if (e.getSource() == this.mntmSettings) {
            SettingsFrame f = new SettingsFrame(this, true);
            f.setVisible(true);
        }
        if (e.getSource() == mntmDelete && (n = JOptionPane.showOptionDialog(frame, "Are you really sure you want to delete the existing log files?\nAll will be removed and any open graphs will be closed.  This will\nalso empty the queue of any raw frames pending upload to the server,\ndelete any stored measurement and delete any camera images.", "Delete Payload Files?", 0, 0, null, options = new Object[]{"Yes", "No"}, options[1])) == 0) {
            ProgressPanel fileProgress = new ProgressPanel(Config.mainWindow, "Clearing saved data, please wait ...", false);
            fileProgress.setVisible(true);
            Config.payloadStore.deleteAll();
            Config.rawFrameQueue.delete();
            Config.rawPayloadQueue.delete();
            Config.totalFrames = 0;
            MainWindow.refreshTabs(true);
            fileProgress.updateProgress(100);
        }
        ArrayList<Spacecraft> sats = Config.satManager.getSpacecraftList();
        int i = 0;
        while (i < sats.size()) {
            if (e.getSource() == mntmSat[i]) {
                SpacecraftFrame f = new SpacecraftFrame(sats.get(i), this, true);
                f.setVisible(true);
            }
            ++i;
        }
        if (e.getSource() == this.mntmSatLoadKeps) {
            Config.satManager.fetchTLEFile();
        }
        if (e.getSource() == this.mntmSatAdd) {
            this.addSpacecraft(false);
        }
        if (e.getSource() == this.mntmSatRemove) {
            this.addSpacecraft(true);
        }
        if (e.getSource() == this.chckbxmntmShowAudioOptions) {
            Config.showAudioOptions = this.chckbxmntmShowAudioOptions.getState();
            inputTab.showAudioOptions(Config.showAudioOptions);
            Config.save();
        }
        if (e.getSource() == this.chckbxmntmShowSourceOptions) {
            Config.showSourceOptions = this.chckbxmntmShowSourceOptions.getState();
            inputTab.showSourceOptions(Config.showSourceOptions);
            Config.save();
        }
        if (e.getSource() == this.chckbxmntmShowSatOptions) {
            Config.showSatOptions = this.chckbxmntmShowSatOptions.getState();
            inputTab.showSatOptions(Config.showSatOptions);
            Config.save();
        }
        if (e.getSource() == this.chckbxmntmShowEye) {
            Config.showEye = this.chckbxmntmShowEye.getState();
            inputTab.showEye(Config.showEye);
            Config.save();
        }
        if (e.getSource() == this.chckbxmntmShowPhasor) {
            Config.showPhasor = this.chckbxmntmShowPhasor.getState();
            inputTab.showPhasor(Config.showPhasor);
            Config.save();
        }
        if (e.getSource() == this.chckbxmntmShowFFT) {
            Config.showFFT = this.chckbxmntmShowFFT.getState();
            inputTab.showFFT(Config.showFFT);
            Config.save();
        }
        if (e.getSource() == this.mntmManual) {
            try {
                DesktopApi.browse(new URI("foxtelem_manual.pdf"));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == this.mntmLeaderboard) {
            try {
                DesktopApi.browse(new URI("https://www.amsat.org/tlm/"));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == this.mntmSoftware) {
            try {
                DesktopApi.browse(new URI("https://www.g0kla.com/foxtelem/"));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == this.mntmAbout) {
            HelpAbout help = new HelpAbout(this, true);
            help.setVisible(true);
        }
    }

    private void downloadServerData(String dir) {
        String file = "FOXDB.tar.gz";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            file = String.valueOf(Config.logFileDirectory) + File.separator + "FOXDB.tar.gz";
        }
        ProgressPanel fileProgress = new ProgressPanel(this, "Downloading " + dir + " data, please wait ...", false);
        fileProgress.setVisible(true);
        String urlString = String.valueOf(Config.webSiteUrl) + "/" + dir + "/FOXDB.tar.gz";
        Log.println("Downloading: " + urlString);
        try {
            URL website = new URL(urlString);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(file);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
        }
        catch (FileNotFoundException e) {
            fileProgress.updateProgress(100);
            Log.errorDialog("ERROR", "File not downloaded successfully from: " + urlString + "\nCheck that the internet connection is working to the site.  Check the download destination is valid\n\n" + e);
            e.printStackTrace(Log.getWriter());
            return;
        }
        catch (MalformedURLException e) {
            fileProgress.updateProgress(100);
            Log.errorDialog("ERROR", "ERROR can't access the server data.  Is the URL correct?  Tried downloading from: " + urlString + "\n\n" + e);
            e.printStackTrace(Log.getWriter());
            return;
        }
        catch (IOException e) {
            fileProgress.updateProgress(100);
            Log.errorDialog("ERROR", "ERROR reading from the server or writing to the file on disk.\nCheck the local disk is writable for:\n" + file + "\n" + "and this server URL is correct:\n" + urlString + "\n\n" + e);
            e.printStackTrace(Log.getWriter());
            return;
        }
        fileProgress.updateProgress(100);
        File archive = new File(file);
        if (archive.length() != 0L) {
            ProgressPanel decompressProgress = new ProgressPanel(this, "decompressing " + dir + " data ...", false);
            decompressProgress.setVisible(true);
            File destination = new File(Config.logFileDirectory);
            Archiver archiver = ArchiverFactory.createArchiver("tar", "gz");
            try {
                archiver.extract(archive, destination);
            }
            catch (IOException e) {
                decompressProgress.updateProgress(100);
                Log.errorDialog("ERROR", "ERROR could not uncompress the server data for " + dir + "\n" + "Check if the download URL is correct.\n\n" + e);
                e.printStackTrace(Log.getWriter());
                return;
            }
            catch (IllegalArgumentException e) {
                decompressProgress.updateProgress(100);
                Log.errorDialog("ERROR", "ERROR could not uncompress the server data for " + dir + "\n" + "The compression program could not process the file.  Perhaps the filename is invalid?\n\n" + e);
                e.printStackTrace(Log.getWriter());
                return;
            }
            decompressProgress.updateProgress(100);
        }
    }

    private String getFoxServerDir(int id) {
        if (id == 1) {
            return "ao85";
        }
        if (id == 2) {
            return "radfxsat";
        }
        if (id == 3) {
            return "fox1c";
        }
        if (id == 4) {
            return "fox1d";
        }
        if (id == 5) {
            return "fox1e";
        }
        if (id == 6) {
            return "husky";
        }
        Spacecraft sat = Config.satManager.getSpacecraft(id);
        return String.valueOf(sat.series) + "-" + sat.foxId;
    }

    private void replaceServerData() {
        if (Config.logFileDirectory.equalsIgnoreCase("")) {
            Log.errorDialog("CAN'T EXTRACT SERVER DATA INTO CURRENT DIRECTORY", "You can not replace the log files in the current directory.  Pick another directory from the settings menu\n");
            return;
        }
        if (Config.satManager.spacecraftList.size() > 1) {
            ServerDownloadDialog downloadDialog = new ServerDownloadDialog(this, false);
            downloadDialog.setVisible(true);
        } else {
            this.downloadServerData(Config.satManager.spacecraftList);
        }
    }

    public void downloadServerData(ArrayList<Spacecraft> sats) {
        String message = "Do you want to download server data to REPLACE your existing data?\nTHIS WILL OVERWRITE YOUR EXISTING LOG FILES. Switch to a new directory if you have live data received from FOX\nTo import into into a different set of log files select NO, then choose a new log file directory from the settings menu";
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(frame, message, "Do you want to continue?", 0, 0, null, options, options[1]);
        if (n == 1) {
            return;
        }
        ProgressPanel fileProgress = new ProgressPanel(this, "Deleting existing data, please wait ...", false);
        fileProgress.setVisible(true);
        fileProgress.updateProgress(100);
        for (Spacecraft sat : sats) {
            Config.payloadStore.delete(sat);
            String dir = this.getFoxServerDir(sat.foxId);
            if (dir == null) continue;
            this.downloadServerData(dir);
        }
        Config.save();
        Config.initPayloadStore();
        Config.fileProgress.updateProgress(100);
        for (Spacecraft sat : sats) {
            if (sat.hasMesatCamera()) {
                Log.println("Attempting to recover images from MESAT1 Can Packets ..");
                ProgressPanel mesatProgress = new ProgressPanel(this, "Processing camera can packets, please wait ...", false);
                mesatProgress.setVisible(true);
                Config.payloadStore.mesatImageStore.rebuildFromCanPackets(sat.foxId);
                mesatProgress.updateProgress(100);
            }
            if (!sat.hasCanBus) continue;
            ProgressPanel splitProgress = new ProgressPanel(this, "Splitting can packets, please wait ...", false);
            splitProgress.setVisible(true);
            try {
                SortedFramePartArrayList canPackets = Config.payloadStore.getFrameParts(sat.foxId, 0, 0L, 99999999, true, "canpacket");
                for (FramePart p : canPackets) {
                    if (p.getType() != 14 && (p.getType() < 1400 || p.getType() >= 1500)) continue;
                    int ihuPacketId = p.fieldValue[0] + 256 * p.fieldValue[1] + 65536 * p.fieldValue[2] + 0x1000000 * p.fieldValue[3];
                    int length = UwCanPacket.getLengthfromRawID(ihuPacketId);
                    int canId = UwCanPacket.getIdfromRawID(ihuPacketId);
                    if (!UwExperimentTab.inCanIds(canId)) continue;
                    byte[] data = new byte[4 + length];
                    int i = 0;
                    while (i < data.length) {
                        data[i] = (byte)p.fieldValue[i];
                        ++i;
                    }
                    BitArrayLayout canLayout = Config.satManager.getLayoutByCanId(sat.foxId, canId);
                    if (canLayout == null) continue;
                    UwCanPacket newPacket = new UwCanPacket(sat.foxId, p.resets, p.uptime, p.getCaptureDate(), data, canLayout);
                    if (p.getType() > 1400) {
                        newPacket.setType(1700 + (p.getType() - 1400));
                    }
                    Config.payloadStore.add(sat.foxId, p.uptime, p.resets, newPacket);
                }
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not split the can packets\n" + e);
            }
            splitProgress.updateProgress(100);
        }
        ProgressPanel queueStatus = new ProgressPanel(this, "Post processing can packets. Remaining:", false);
        queueStatus.setVisible(true);
        while (Config.payloadStore.hasQueuedFrames()) {
            queueStatus.updateProgress(Config.payloadStore.getQueuedFramesSize());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        queueStatus.updateProgress(100);
        Config.initSequence();
        Config.initServerQueue();
        MainWindow.refreshTabs(true);
        Config.fileProgress.updateProgress(100);
    }

    private void addSpacecraft(boolean remove) {
        File file = null;
        File destinationDir = null;
        File dir = null;
        if (remove) {
            dir = new File(Config.spacecraftDir);
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                dir = new File(String.valueOf(Config.logFileDirectory) + "/spacecraft");
            }
        } else {
            dir = new File(Config.spacecraftDir);
            destinationDir = !Config.logFileDirectory.equalsIgnoreCase("") ? new File(String.valueOf(Config.logFileDirectory) + "/spacecraft") : dir;
        }
        if (Config.useNativeFileChooser && !Config.isLinuxOs()) {
            if (remove) {
                this.fd.setFile("*.dat");
                this.fd.setTitle("Select spacecraft DAT file to remove");
            } else {
                this.fd.setFile("*.MASTER");
                this.fd.setTitle("Select spacecraft MASTER file to install");
            }
            if (dir != null) {
                this.fd.setDirectory(dir.getAbsolutePath());
            }
            this.fd.setVisible(true);
            String filename = this.fd.getFile();
            String dirname = this.fd.getDirectory();
            if (filename == null) {
                Log.println("You cancelled the choice");
                file = null;
            } else {
                Log.println("File: " + filename);
                Log.println("DIR: " + dirname);
                file = new File(String.valueOf(dirname) + filename);
            }
        } else {
            FileNameExtensionFilter filter;
            this.fc.setPreferredSize(new Dimension(Config.windowFcWidth, Config.windowFcHeight));
            if (remove) {
                this.fc.setDialogTitle("Select spacecraft DAT file to remove");
                filter = new FileNameExtensionFilter("Spacecraft files", "dat");
                this.fc.setFileFilter(filter);
                this.fc.setApproveButtonText("Remove");
            } else {
                this.fc.setDialogTitle("Select spacecraft MASTER file to install");
                filter = new FileNameExtensionFilter("Spacecraft files", "MASTER");
                this.fc.setFileFilter(filter);
                this.fc.setApproveButtonText("Add");
            }
            if (dir != null) {
                this.fc.setCurrentDirectory(dir);
            }
            int returnVal = this.fc.showOpenDialog(this);
            Config.windowFcHeight = this.fc.getHeight();
            Config.windowFcWidth = this.fc.getWidth();
            if (returnVal == 0) {
                file = this.fc.getSelectedFile();
                Log.println("File: " + file.getName());
                Log.println("DIR: " + file.getPath());
            } else {
                file = null;
            }
        }
        Config.save();
        if (file != null) {
            int satsLoaded = Config.satManager.getSpacecraftList().size();
            boolean refresh = false;
            if (remove) {
                int n = Log.optionYNdialog("Delete the spacecraft config file?", String.valueOf(file.getName()) + "\n\nYou will be able to install the spacecraft again if you want. Local settings such\n" + "as frequency ranges will be lost.  Stored telemetry will not be removed.  Delete for now?\n\n");
                if (n == 1) {
                    refresh = false;
                } else {
                    try {
                        SatPayloadStore.remove(file.getAbsolutePath());
                        refresh = true;
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR removing File", "\nCould not remove the spacecraft file\n" + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                    }
                }
            } else {
                String targetName = file.getName().replace(".MASTER", ".dat");
                File targetFile = new File(String.valueOf(destinationDir.getPath()) + File.separator + targetName);
                boolean copy = true;
                Log.println("Installing " + file.getAbsolutePath() + " as " + targetFile.getAbsolutePath());
                if (targetFile.exists()) {
                    int n = Log.optionYNdialog("Overwrite Existing spacecraft config file?", String.valueOf(targetFile.getName()) + "\n\nThis spacecraft is already installed.  Overwrite it and reset to default settings?\n\n");
                    if (n == 1) {
                        copy = false;
                    } else {
                        copy = true;
                        try {
                            SatPayloadStore.remove(targetFile.getAbsolutePath());
                            refresh = true;
                        }
                        catch (IOException e) {
                            Log.errorDialog("ERROR removing existing File", "\nCould not overwrite the existing spacecraft file\n" + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                            copy = false;
                        }
                    }
                }
                if (copy) {
                    try {
                        try {
                            Spacecraft satellite = new Spacecraft(Config.satManager, file, targetFile);
                            satellite.save();
                        }
                        catch (LayoutLoadException e) {
                            Log.errorDialog("Layout Issue", "Could not fully parse the spacecraft file.  It may not be installed\n" + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                        }
                        refresh = true;
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR Copy File", "Could not copy the spacecraft file\n" + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                    }
                }
            }
            if (refresh) {
                Config.initSatelliteManager();
                Config.initPayloadStore();
                Config.initPassManager();
                Config.initSequence();
                Config.initServerQueue();
                if (satsLoaded != Config.satManager.getSpacecraftList().size()) {
                    Config.mainWindow.initSatMenu();
                    MainWindow.refreshTabs(false);
                }
                Config.fileProgress.updateProgress(100);
            }
        }
    }

    public void saveProperties() {
        Config.windowHeight = this.getHeight();
        Config.windowWidth = this.getWidth();
        Config.windowX = this.getX();
        Config.windowY = this.getY();
        SpacecraftTab[] spacecraftTabArray = spacecraftTab;
        int n = spacecraftTab.length;
        int n2 = 0;
        while (n2 < n) {
            SpacecraftTab tab = spacecraftTabArray[n2];
            tab.closeGraphs();
            ++n2;
        }
        Config.save();
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        if (e.getNewState() == 208) {
            Log.println("LOST FOCUS");
        }
        if (e.getNewState() == 205) {
            Log.println("ACTIVATED");
        }
        if (e.getNewState() == 207) {
            Log.println("GOT FOCUS");
        }
    }
}

