/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.EyeData;
import decoder.FoxBPSK.FoxBPSKCostasDecoder;
import decoder.FoxBPSK.FoxBPSKDecoder;
import decoder.FoxBPSK.FoxBPSKDotProdDecoder;
import gui.graph.GraphCanvas;
import gui.graph.LinePlotPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EyePanel
extends JPanel
implements Runnable {
    boolean done = false;
    boolean running = true;
    Decoder decoder;
    int zeroValue;
    int[][] buffer;
    public double avgHigh;
    public double avgLow;
    public double sdHigh;
    public double sdLow;
    private double bitSNR;
    private int errors;
    private int erasures;
    private int clockOffset;
    EyeData eyeData;
    JLabel title = new JLabel("Eye Diagram");
    Color GRAPH_COLOR;
    int border = 5;
    public static int NUMBER_OF_BITS = 50;
    public static int SAMPLES = 120;

    public EyePanel() {
        this.title.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        this.add(this.title);
        this.GRAPH_COLOR = Color.BLUE;
    }

    private void init() {
        SAMPLES = this.decoder.telemFormat.isFSK() && this.decoder.telemFormat.getInt("bps") == 9600 ? 5 : (this.decoder.telemFormat.isBPSK() ? 8 : this.decoder.getBucketSize() / 2);
        this.buffer = new int[NUMBER_OF_BITS][];
        int i = 0;
        while (i < NUMBER_OF_BITS) {
            this.buffer[i] = new int[SAMPLES];
            ++i;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("EyePanel");
        this.done = false;
        this.running = true;
        Log.println("STARTING EYE PANEL THREAD");
        int[][] data = null;
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: Eye Diagram thread interrupted");
            }
            if (this.decoder != null) {
                this.eyeData = this.decoder.getEyeData();
                this.zeroValue = this.decoder.getZeroValue();
                if (this.eyeData != null) {
                    data = this.eyeData.getData();
                    this.avgHigh = this.eyeData.getAvg(0);
                    this.avgLow = this.eyeData.getAvg(1);
                    this.sdHigh = this.eyeData.getStandardDeviation(0);
                    this.sdLow = this.eyeData.getStandardDeviation(1);
                    this.bitSNR = this.eyeData.bitSNR;
                    this.errors = this.eyeData.lastErrorsCount;
                    this.erasures = this.eyeData.lastErasureCount;
                    this.clockOffset = this.eyeData.clockOffset;
                }
            }
            if (this.decoder != null && data != null) {
                this.init();
                int a = 0;
                int b = 0;
                try {
                    if (NUMBER_OF_BITS > data.length) {
                        NUMBER_OF_BITS = data.length;
                    }
                    int i = 0;
                    while (i < NUMBER_OF_BITS) {
                        int j = 0;
                        while (j < this.decoder.getBucketSize()) {
                            if (data != null && a < NUMBER_OF_BITS && b < SAMPLES) {
                                this.buffer[a][b++] = data[i][j];
                            }
                            j += this.decoder.getBucketSize() / SAMPLES;
                        }
                        b = 0;
                        ++a;
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            this.repaint();
        }
        Log.println("ENDING EYE PANEL THREAD");
    }

    public void updateFont() {
        this.title.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
    }

    public void startProcessing(Decoder decoder1) {
        this.decoder = decoder1;
        this.running = true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int graphHeight = this.getHeight() - this.border;
        int graphWidth = this.getWidth() - this.border * 2;
        g2.drawLine(0, graphHeight - this.border, graphWidth + this.border * 2, graphHeight - this.border);
        g2.drawLine(this.border * 2, this.getHeight() - this.border, this.border * 2, this.border * 4);
        g2.drawLine(graphWidth, this.getHeight() - this.border, graphWidth, this.border * 4);
        int lastx = this.border * 2 + 1;
        int lasty = graphHeight / 2;
        int x = this.border * 2 + 1;
        g2.setColor(this.GRAPH_COLOR);
        int maxValue = 21333;
        int minValue = -21333;
        if (this.decoder instanceof FoxBPSKDecoder || this.decoder instanceof FoxBPSKCostasDecoder || this.decoder instanceof FoxBPSKDotProdDecoder) {
            maxValue = 48000;
            minValue = -48000;
        }
        if (this.buffer != null && this.buffer[NUMBER_OF_BITS - 1] != null) {
            try {
                int i = 0;
                while (i < NUMBER_OF_BITS) {
                    int j = 0;
                    while (j < SAMPLES) {
                        x = this.border * 2 + j * (graphWidth - this.border * 2) / (SAMPLES - 1);
                        double y = GraphCanvas.getRatioPosition(minValue, maxValue, (double)this.buffer[i][j] * 0.5, graphHeight);
                        if (j == 0) {
                            lastx = x;
                            lasty = (int)y;
                        }
                        g2.drawLine(lastx, lasty, x, (int)y);
                        lastx = x;
                        lasty = (int)y;
                        ++j;
                    }
                    ++i;
                }
            }
            catch (NullPointerException i) {
            }
            catch (ArrayIndexOutOfBoundsException i) {
                // empty catch block
            }
        }
        g2.setColor(Color.GRAY);
        double h = graphHeight / 2 + graphHeight / 3 * this.zeroValue / 32000 + this.border;
        g2.drawLine(0, (int)h, graphWidth, (int)h);
        g2.setColor(Config.AMSAT_RED);
        int width = 30;
        double low = GraphCanvas.getRatioPosition(minValue, maxValue, this.avgLow * 0.5, graphHeight);
        g2.drawLine(graphWidth / 2 - width + this.border * 2, (int)low, graphWidth / 2 + width + this.border * 2, (int)low);
        double high = GraphCanvas.getRatioPosition(minValue, maxValue, this.avgHigh * 0.5, graphHeight);
        g2.drawLine(graphWidth / 2 - width + this.border * 2, (int)high, graphWidth / 2 + width + this.border * 2, (int)high);
        g2.drawLine(graphWidth / 2 + this.border * 2, (int)high, graphWidth / 2 + this.border * 2, (int)low);
        double r = LinePlotPanel.roundToSignificantFigures(this.bitSNR, 2);
        String s = String.valueOf(Double.toString(r));
        g.drawString(s, graphWidth / 2 - 25 + this.border * 2, (int)(low + high) / 2 + 5);
        g.drawString("SNR", graphWidth / 2 + 10 + this.border * 2, (int)(low + high) / 2 + 5);
        g2.setColor(Color.GRAY);
        if (Config.debugValues) {
            g.drawString("Clk Offset  " + this.clockOffset, 10 + this.border, 40);
        }
        g.drawString("Errors  " + this.errors, graphWidth / 2 - 70 + this.border, graphHeight - 10);
        g.drawString("Erasures  " + this.erasures, graphWidth / 2 - 0 + this.border, graphHeight - 10);
    }
}

