/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.NamingThreadFactory;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager {
    private int THREAD_POOL_SIZE = 2;
    private HashMap<ScheduledFuture<?>, ThreadType> mTasks = new HashMap();
    private ScheduledExecutorService mExecutor;

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.mExecutor;
    }

    public ScheduledFuture<?> scheduleFixedRate(ThreadType type, Runnable command, long period, TimeUnit unit) throws RejectedExecutionException {
        if (this.mExecutor == null) {
            this.mExecutor = Executors.newScheduledThreadPool(this.THREAD_POOL_SIZE, new NamingThreadFactory("FoxTelem_airspy_fixedRate"));
        }
        ScheduledFuture<?> task = this.mExecutor.scheduleAtFixedRate(command, 0L, period, unit);
        this.mTasks.put(task, type);
        return task;
    }

    public void scheduleOnce(Runnable command, long delay, TimeUnit unit) throws RejectedExecutionException {
        if (this.mExecutor == null) {
            this.mExecutor = Executors.newScheduledThreadPool(this.THREAD_POOL_SIZE, new NamingThreadFactory("FoxTelem_airspy_once"));
        }
        this.mExecutor.schedule(command, delay, unit);
    }

    public boolean cancel(ScheduledFuture<?> task) {
        boolean success = task.cancel(true);
        this.mTasks.remove(task);
        return success;
    }

    public int getTaskCount(ThreadType type) {
        int count = 0;
        for (ThreadType current : this.mTasks.values()) {
            if (current != type) continue;
            ++count;
        }
        return count;
    }

    public static enum ThreadType {
        AUDIO_PROCESSING,
        AUDIO_RECORDING,
        BASEBAND_RECORDING,
        SOURCE_SAMPLE_PROCESSING,
        DECIMATION,
        DECODER;

    }
}

